/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.annotation.UnsupportedAppUsage;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class PreferenceGroupAdapter
extends BaseAdapter
implements Preference.OnPreferenceChangeInternalListener {
    private static final String TAG = "PreferenceGroupAdapter";
    private PreferenceGroup mPreferenceGroup;
    private List<Preference> mPreferenceList;
    private ArrayList<PreferenceLayout> mPreferenceLayouts;
    private PreferenceLayout mTempPreferenceLayout = new PreferenceLayout();
    private boolean mHasReturnedViewTypeCount = false;
    private volatile boolean mIsSyncing = false;
    private Handler mHandler = new Handler();
    private Runnable mSyncRunnable = new Runnable(){

        @Override
        public void run() {
            PreferenceGroupAdapter.this.syncMyPreferences();
        }
    };
    private int mHighlightedPosition = -1;
    private Drawable mHighlightedDrawable;
    private static ViewGroup.LayoutParams sWrapperLayoutParams = new ViewGroup.LayoutParams(-1, -2);

    public PreferenceGroupAdapter(PreferenceGroup preferenceGroup) {
        this.mPreferenceGroup = preferenceGroup;
        this.mPreferenceGroup.setOnPreferenceChangeInternalListener(this);
        this.mPreferenceList = new ArrayList<Preference>();
        this.mPreferenceLayouts = new ArrayList();
        this.syncMyPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncMyPreferences() {
        PreferenceGroupAdapter preferenceGroupAdapter = this;
        synchronized (preferenceGroupAdapter) {
            if (this.mIsSyncing) {
                return;
            }
            this.mIsSyncing = true;
        }
        ArrayList<Preference> newPreferenceList = new ArrayList<Preference>(this.mPreferenceList.size());
        this.flattenPreferenceGroup(newPreferenceList, this.mPreferenceGroup);
        this.mPreferenceList = newPreferenceList;
        this.notifyDataSetChanged();
        PreferenceGroupAdapter preferenceGroupAdapter2 = this;
        synchronized (preferenceGroupAdapter2) {
            this.mIsSyncing = false;
            this.notifyAll();
        }
    }

    private void flattenPreferenceGroup(List<Preference> preferences, PreferenceGroup group) {
        group.sortPreferences();
        int groupSize = group.getPreferenceCount();
        for (int i = 0; i < groupSize; ++i) {
            PreferenceGroup preferenceAsGroup;
            Preference preference = group.getPreference(i);
            preferences.add(preference);
            if (!this.mHasReturnedViewTypeCount && preference.isRecycleEnabled()) {
                this.addPreferenceClassName(preference);
            }
            if (preference instanceof PreferenceGroup && (preferenceAsGroup = (PreferenceGroup)preference).isOnSameScreenAsChildren()) {
                this.flattenPreferenceGroup(preferences, preferenceAsGroup);
            }
            preference.setOnPreferenceChangeInternalListener(this);
        }
    }

    private PreferenceLayout createPreferenceLayout(Preference preference, PreferenceLayout in) {
        PreferenceLayout pl = in != null ? in : new PreferenceLayout();
        pl.name = preference.getClass().getName();
        pl.resId = preference.getLayoutResource();
        pl.widgetResId = preference.getWidgetLayoutResource();
        return pl;
    }

    private void addPreferenceClassName(Preference preference) {
        PreferenceLayout pl = this.createPreferenceLayout(preference, null);
        int insertPos = Collections.binarySearch(this.mPreferenceLayouts, pl);
        if (insertPos < 0) {
            insertPos = insertPos * -1 - 1;
            this.mPreferenceLayouts.add(insertPos, pl);
        }
    }

    @Override
    public int getCount() {
        return this.mPreferenceList.size();
    }

    @Override
    @UnsupportedAppUsage
    public Preference getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mPreferenceList.get(position);
    }

    @Override
    public long getItemId(int position) {
        if (position < 0 || position >= this.getCount()) {
            return Long.MIN_VALUE;
        }
        return this.getItem(position).getId();
    }

    public void setHighlighted(int position) {
        this.mHighlightedPosition = position;
    }

    public void setHighlightedDrawable(Drawable drawable2) {
        this.mHighlightedDrawable = drawable2;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        Preference preference = this.getItem(position);
        this.mTempPreferenceLayout = this.createPreferenceLayout(preference, this.mTempPreferenceLayout);
        if (Collections.binarySearch(this.mPreferenceLayouts, this.mTempPreferenceLayout) < 0 || this.getItemViewType(position) == this.getHighlightItemViewType()) {
            convertView = null;
        }
        View result = preference.getView(convertView, parent);
        if (position == this.mHighlightedPosition && this.mHighlightedDrawable != null) {
            FrameLayout wrapper = new FrameLayout(parent.getContext());
            wrapper.setLayoutParams(sWrapperLayoutParams);
            wrapper.setBackgroundDrawable(this.mHighlightedDrawable);
            wrapper.addView(result);
            result = wrapper;
        }
        return result;
    }

    @Override
    public boolean isEnabled(int position) {
        if (position < 0 || position >= this.getCount()) {
            return true;
        }
        return this.getItem(position).isSelectable();
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public void onPreferenceChange(Preference preference) {
        this.notifyDataSetChanged();
    }

    @Override
    public void onPreferenceHierarchyChange(Preference preference) {
        this.mHandler.removeCallbacks(this.mSyncRunnable);
        this.mHandler.post(this.mSyncRunnable);
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    private int getHighlightItemViewType() {
        return this.getViewTypeCount() - 1;
    }

    @Override
    public int getItemViewType(int position) {
        Preference preference;
        if (position == this.mHighlightedPosition) {
            return this.getHighlightItemViewType();
        }
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        if (!(preference = this.getItem(position)).isRecycleEnabled()) {
            return -1;
        }
        this.mTempPreferenceLayout = this.createPreferenceLayout(preference, this.mTempPreferenceLayout);
        int viewType = Collections.binarySearch(this.mPreferenceLayouts, this.mTempPreferenceLayout);
        if (viewType < 0) {
            return -1;
        }
        return viewType;
    }

    @Override
    public int getViewTypeCount() {
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        return Math.max(1, this.mPreferenceLayouts.size()) + 1;
    }

    private static class PreferenceLayout
    implements Comparable<PreferenceLayout> {
        private int resId;
        private int widgetResId;
        private String name;

        private PreferenceLayout() {
        }

        @Override
        public int compareTo(PreferenceLayout other) {
            int compareNames = this.name.compareTo(other.name);
            if (compareNames == 0) {
                if (this.resId == other.resId) {
                    if (this.widgetResId == other.widgetResId) {
                        return 0;
                    }
                    return this.widgetResId - other.widgetResId;
                }
                return this.resId - other.resId;
            }
            return compareNames;
        }
    }
}

