/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.SystemProperties_Delegate;
import android.util.Log;
import android.util.MutableInt;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import libcore.util.HexEncoding;

@SystemApi
public class SystemProperties {
    private static final String TAG = "SystemProperties";
    private static final boolean TRACK_KEY_ACCESS = false;
    @UnsupportedAppUsage
    public static final int PROP_NAME_MAX = Integer.MAX_VALUE;
    public static final int PROP_VALUE_MAX = 91;
    @UnsupportedAppUsage
    @GuardedBy(value={"sChangeCallbacks"})
    private static final ArrayList<Runnable> sChangeCallbacks = new ArrayList();
    @GuardedBy(value={"sRoReads"})
    private static final HashMap<String, MutableInt> sRoReads = null;

    private static void onKeyAccess(String key) {
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    private static String native_get(String string2) {
        return SystemProperties_Delegate.native_get(string2);
    }

    @LayoutlibDelegate
    private static String native_get(String string2, String string3) {
        return SystemProperties_Delegate.native_get(string2, string3);
    }

    @LayoutlibDelegate
    private static int native_get_int(String string2, int n) {
        return SystemProperties_Delegate.native_get_int(string2, n);
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    private static long native_get_long(String string2, long l) {
        return SystemProperties_Delegate.native_get_long(string2, l);
    }

    @LayoutlibDelegate
    private static boolean native_get_boolean(String string2, boolean bl) {
        return SystemProperties_Delegate.native_get_boolean(string2, bl);
    }

    @LayoutlibDelegate
    private static void native_set(String string2, String string3) {
        SystemProperties_Delegate.native_set(string2, string3);
    }

    @LayoutlibDelegate
    private static void native_add_change_callback() {
        SystemProperties_Delegate.native_add_change_callback();
    }

    @LayoutlibDelegate
    private static void native_report_sysprop_change() {
        SystemProperties_Delegate.native_report_sysprop_change();
    }

    @SystemApi
    public static String get(String key) {
        return SystemProperties.native_get(key);
    }

    @SystemApi
    public static String get(String key, String def) {
        return SystemProperties.native_get(key, def);
    }

    @SystemApi
    public static int getInt(String key, int def) {
        return SystemProperties.native_get_int(key, def);
    }

    @SystemApi
    public static long getLong(String key, long def) {
        return SystemProperties.native_get_long(key, def);
    }

    @SystemApi
    public static boolean getBoolean(String key, boolean def) {
        return SystemProperties.native_get_boolean(key, def);
    }

    @UnsupportedAppUsage
    public static void set(String key, String val) {
        if (val != null && !val.startsWith("ro.") && val.length() > 91) {
            throw new IllegalArgumentException("value of system property '" + key + "' is longer than " + 91 + " characters: " + val);
        }
        SystemProperties.native_set(key, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void addChangeCallback(Runnable callback) {
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.size() == 0) {
                SystemProperties.native_add_change_callback();
            }
            sChangeCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callChangeCallbacks() {
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.size() == 0) {
                return;
            }
            ArrayList<Runnable> callbacks = new ArrayList<Runnable>(sChangeCallbacks);
            long token = Binder.clearCallingIdentity();
            try {
                for (int i = 0; i < callbacks.size(); ++i) {
                    try {
                        callbacks.get(i).run();
                        continue;
                    }
                    catch (Throwable t) {
                        Log.wtf(TAG, "Exception in SystemProperties change callback", t);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    @UnsupportedAppUsage
    public static void reportSyspropChanged() {
        SystemProperties.native_report_sysprop_change();
    }

    public static String digestOf(String ... keys) {
        Arrays.sort(keys);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            for (String key : keys) {
                String item = key + "=" + SystemProperties.get(key) + "\n";
                digest.update(item.getBytes(StandardCharsets.UTF_8));
            }
            return HexEncoding.encodeToString(digest.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @UnsupportedAppUsage
    private SystemProperties() {
    }
}

