/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.os.HwBlob;
import android.os.IHwBinder;
import android.os.NativeHandle;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.util.NativeAllocationRegistry;

@SystemApi
public class HwParcel {
    private static final String TAG = "HwParcel";
    public static final int STATUS_SUCCESS = 0;
    private static final NativeAllocationRegistry sNativeRegistry;
    private long mNativeContext;

    @UnsupportedAppUsage
    private HwParcel(boolean allocate) {
        this.native_setup(allocate);
        sNativeRegistry.registerNativeAllocation(this, this.mNativeContext);
    }

    public HwParcel() {
        this.native_setup(true);
        sNativeRegistry.registerNativeAllocation(this, this.mNativeContext);
    }

    public void writeInterfaceToken(String string2) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInterfaceToken(Ljava/lang/String;)V", true, this);
    }

    public void writeBool(boolean bl) {
        OverrideMethod.invokeV("android.os.HwParcel#writeBool(Z)V", true, this);
    }

    public void writeInt8(byte by) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInt8(B)V", true, this);
    }

    public void writeInt16(short s) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInt16(S)V", true, this);
    }

    public void writeInt32(int n) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInt32(I)V", true, this);
    }

    public void writeInt64(long l) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInt64(J)V", true, this);
    }

    public void writeFloat(float f) {
        OverrideMethod.invokeV("android.os.HwParcel#writeFloat(F)V", true, this);
    }

    public void writeDouble(double d) {
        OverrideMethod.invokeV("android.os.HwParcel#writeDouble(D)V", true, this);
    }

    public void writeString(String string2) {
        OverrideMethod.invokeV("android.os.HwParcel#writeString(Ljava/lang/String;)V", true, this);
    }

    public void writeNativeHandle(NativeHandle nativeHandle) {
        OverrideMethod.invokeV("android.os.HwParcel#writeNativeHandle(Landroid/os/NativeHandle;)V", true, this);
    }

    private void writeBoolVector(boolean[] blArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeBoolVector([Z)V", true, this);
    }

    private void writeInt8Vector(byte[] byArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInt8Vector([B)V", true, this);
    }

    private void writeInt16Vector(short[] sArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInt16Vector([S)V", true, this);
    }

    private void writeInt32Vector(int[] nArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInt32Vector([I)V", true, this);
    }

    private void writeInt64Vector(long[] lArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeInt64Vector([J)V", true, this);
    }

    private void writeFloatVector(float[] fArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeFloatVector([F)V", true, this);
    }

    private void writeDoubleVector(double[] dArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeDoubleVector([D)V", true, this);
    }

    private void writeStringVector(String[] stringArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeStringVector([Ljava/lang/String;)V", true, this);
    }

    private void writeNativeHandleVector(NativeHandle[] nativeHandleArray) {
        OverrideMethod.invokeV("android.os.HwParcel#writeNativeHandleVector([Landroid/os/NativeHandle;)V", true, this);
    }

    public void writeBoolVector(ArrayList<Boolean> val) {
        int n = val.size();
        boolean[] array2 = new boolean[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeBoolVector(array2);
    }

    public void writeInt8Vector(ArrayList<Byte> val) {
        int n = val.size();
        byte[] array2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeInt8Vector(array2);
    }

    public void writeInt16Vector(ArrayList<Short> val) {
        int n = val.size();
        short[] array2 = new short[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeInt16Vector(array2);
    }

    public void writeInt32Vector(ArrayList<Integer> val) {
        int n = val.size();
        int[] array2 = new int[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeInt32Vector(array2);
    }

    public void writeInt64Vector(ArrayList<Long> val) {
        int n = val.size();
        long[] array2 = new long[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeInt64Vector(array2);
    }

    public void writeFloatVector(ArrayList<Float> val) {
        int n = val.size();
        float[] array2 = new float[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i).floatValue();
        }
        this.writeFloatVector(array2);
    }

    public void writeDoubleVector(ArrayList<Double> val) {
        int n = val.size();
        double[] array2 = new double[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeDoubleVector(array2);
    }

    public void writeStringVector(ArrayList<String> val) {
        this.writeStringVector(val.toArray(new String[val.size()]));
    }

    public void writeNativeHandleVector(ArrayList<NativeHandle> val) {
        this.writeNativeHandleVector(val.toArray(new NativeHandle[val.size()]));
    }

    public void writeStrongBinder(IHwBinder iHwBinder) {
        OverrideMethod.invokeV("android.os.HwParcel#writeStrongBinder(Landroid/os/IHwBinder;)V", true, this);
    }

    public void enforceInterface(String string2) {
        OverrideMethod.invokeV("android.os.HwParcel#enforceInterface(Ljava/lang/String;)V", true, this);
    }

    public boolean readBool() {
        return OverrideMethod.invokeI("android.os.HwParcel#readBool()Z", true, this) != 0;
    }

    public byte readInt8() {
        return (byte)OverrideMethod.invokeI("android.os.HwParcel#readInt8()B", true, this);
    }

    public short readInt16() {
        return (short)OverrideMethod.invokeI("android.os.HwParcel#readInt16()S", true, this);
    }

    public int readInt32() {
        return OverrideMethod.invokeI("android.os.HwParcel#readInt32()I", true, this);
    }

    public long readInt64() {
        return OverrideMethod.invokeL("android.os.HwParcel#readInt64()J", true, this);
    }

    public float readFloat() {
        return OverrideMethod.invokeF("android.os.HwParcel#readFloat()F", true, this);
    }

    public double readDouble() {
        return OverrideMethod.invokeD("android.os.HwParcel#readDouble()D", true, this);
    }

    public String readString() {
        return (String)OverrideMethod.invokeA("android.os.HwParcel#readString()Ljava/lang/String;", true, this);
    }

    public NativeHandle readNativeHandle() {
        return (NativeHandle)OverrideMethod.invokeA("android.os.HwParcel#readNativeHandle()Landroid/os/NativeHandle;", true, this);
    }

    public NativeHandle readEmbeddedNativeHandle(long l, long l2) {
        return (NativeHandle)OverrideMethod.invokeA("android.os.HwParcel#readEmbeddedNativeHandle(JJ)Landroid/os/NativeHandle;", true, this);
    }

    private boolean[] readBoolVectorAsArray() {
        return (boolean[])OverrideMethod.invokeA("android.os.HwParcel#readBoolVectorAsArray()[Z", true, this);
    }

    private byte[] readInt8VectorAsArray() {
        return (byte[])OverrideMethod.invokeA("android.os.HwParcel#readInt8VectorAsArray()[B", true, this);
    }

    private short[] readInt16VectorAsArray() {
        return (short[])OverrideMethod.invokeA("android.os.HwParcel#readInt16VectorAsArray()[S", true, this);
    }

    private int[] readInt32VectorAsArray() {
        return (int[])OverrideMethod.invokeA("android.os.HwParcel#readInt32VectorAsArray()[I", true, this);
    }

    private long[] readInt64VectorAsArray() {
        return (long[])OverrideMethod.invokeA("android.os.HwParcel#readInt64VectorAsArray()[J", true, this);
    }

    private float[] readFloatVectorAsArray() {
        return (float[])OverrideMethod.invokeA("android.os.HwParcel#readFloatVectorAsArray()[F", true, this);
    }

    private double[] readDoubleVectorAsArray() {
        return (double[])OverrideMethod.invokeA("android.os.HwParcel#readDoubleVectorAsArray()[D", true, this);
    }

    private String[] readStringVectorAsArray() {
        return (String[])OverrideMethod.invokeA("android.os.HwParcel#readStringVectorAsArray()[Ljava/lang/String;", true, this);
    }

    private NativeHandle[] readNativeHandleAsArray() {
        return (NativeHandle[])OverrideMethod.invokeA("android.os.HwParcel#readNativeHandleAsArray()[Landroid/os/NativeHandle;", true, this);
    }

    public ArrayList<Boolean> readBoolVector() {
        Boolean[] array2 = HwBlob.wrapArray(this.readBoolVectorAsArray());
        return new ArrayList<Boolean>(Arrays.asList(array2));
    }

    public ArrayList<Byte> readInt8Vector() {
        Byte[] array2 = HwBlob.wrapArray(this.readInt8VectorAsArray());
        return new ArrayList<Byte>(Arrays.asList(array2));
    }

    public ArrayList<Short> readInt16Vector() {
        Short[] array2 = HwBlob.wrapArray(this.readInt16VectorAsArray());
        return new ArrayList<Short>(Arrays.asList(array2));
    }

    public ArrayList<Integer> readInt32Vector() {
        Integer[] array2 = HwBlob.wrapArray(this.readInt32VectorAsArray());
        return new ArrayList<Integer>(Arrays.asList(array2));
    }

    public ArrayList<Long> readInt64Vector() {
        Long[] array2 = HwBlob.wrapArray(this.readInt64VectorAsArray());
        return new ArrayList<Long>(Arrays.asList(array2));
    }

    public ArrayList<Float> readFloatVector() {
        Float[] array2 = HwBlob.wrapArray(this.readFloatVectorAsArray());
        return new ArrayList<Float>(Arrays.asList(array2));
    }

    public ArrayList<Double> readDoubleVector() {
        Double[] array2 = HwBlob.wrapArray(this.readDoubleVectorAsArray());
        return new ArrayList<Double>(Arrays.asList(array2));
    }

    public ArrayList<String> readStringVector() {
        return new ArrayList<String>(Arrays.asList(this.readStringVectorAsArray()));
    }

    public ArrayList<NativeHandle> readNativeHandleVector() {
        return new ArrayList<NativeHandle>(Arrays.asList(this.readNativeHandleAsArray()));
    }

    public IHwBinder readStrongBinder() {
        return (IHwBinder)OverrideMethod.invokeA("android.os.HwParcel#readStrongBinder()Landroid/os/IHwBinder;", true, this);
    }

    public HwBlob readBuffer(long l) {
        return (HwBlob)OverrideMethod.invokeA("android.os.HwParcel#readBuffer(J)Landroid/os/HwBlob;", true, this);
    }

    public HwBlob readEmbeddedBuffer(long l, long l2, long l3, boolean bl) {
        return (HwBlob)OverrideMethod.invokeA("android.os.HwParcel#readEmbeddedBuffer(JJJZ)Landroid/os/HwBlob;", true, this);
    }

    public void writeBuffer(HwBlob hwBlob) {
        OverrideMethod.invokeV("android.os.HwParcel#writeBuffer(Landroid/os/HwBlob;)V", true, this);
    }

    public void writeStatus(int n) {
        OverrideMethod.invokeV("android.os.HwParcel#writeStatus(I)V", true, this);
    }

    public void verifySuccess() {
        OverrideMethod.invokeV("android.os.HwParcel#verifySuccess()V", true, this);
    }

    public void releaseTemporaryStorage() {
        OverrideMethod.invokeV("android.os.HwParcel#releaseTemporaryStorage()V", true, this);
    }

    public void release() {
        OverrideMethod.invokeV("android.os.HwParcel#release()V", true, this);
    }

    public void send() {
        OverrideMethod.invokeV("android.os.HwParcel#send()V", true, this);
    }

    private static long native_init() {
        return OverrideMethod.invokeL("android.os.HwParcel#native_init()J", true, null);
    }

    private void native_setup(boolean bl) {
        OverrideMethod.invokeV("android.os.HwParcel#native_setup(Z)V", true, this);
    }

    static {
        long freeFunction = HwParcel.native_init();
        sNativeRegistry = new NativeAllocationRegistry(HwParcel.class.getClassLoader(), freeFunction, 128L);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

