/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Handler_Delegate;
import android.os.IMessenger;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.os.ThreadLocalWorkSource;
import android.util.Log;
import android.util.Printer;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class Handler {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    private static final String TAG = "Handler";
    private static Handler MAIN_THREAD_HANDLER = null;
    @UnsupportedAppUsage
    final Looper mLooper;
    final MessageQueue mQueue;
    @UnsupportedAppUsage
    final Callback mCallback;
    final boolean mAsynchronous;
    @UnsupportedAppUsage
    IMessenger mMessenger;

    public void handleMessage(Message msg) {
    }

    public void dispatchMessage(Message msg) {
        if (msg.callback != null) {
            Handler.handleCallback(msg);
        } else {
            if (this.mCallback != null && this.mCallback.handleMessage(msg)) {
                return;
            }
            this.handleMessage(msg);
        }
    }

    public Handler() {
        this(null, false);
    }

    public Handler(Callback callback) {
        this(callback, false);
    }

    public Handler(Looper looper) {
        this(looper, null, false);
    }

    public Handler(Looper looper, Callback callback) {
        this(looper, callback, false);
    }

    @UnsupportedAppUsage
    public Handler(boolean async) {
        this(null, async);
    }

    public Handler(Callback callback, boolean async) {
        this.mLooper = Looper.myLooper();
        if (this.mLooper == null) {
            throw new RuntimeException("Can't create handler inside thread " + Thread.currentThread() + " that has not called Looper.prepare()");
        }
        this.mQueue = this.mLooper.mQueue;
        this.mCallback = callback;
        this.mAsynchronous = async;
    }

    @UnsupportedAppUsage
    public Handler(Looper looper, Callback callback, boolean async) {
        this.mLooper = looper;
        this.mQueue = looper.mQueue;
        this.mCallback = callback;
        this.mAsynchronous = async;
    }

    public static Handler createAsync(Looper looper) {
        if (looper == null) {
            throw new NullPointerException("looper must not be null");
        }
        return new Handler(looper, null, true);
    }

    public static Handler createAsync(Looper looper, Callback callback) {
        if (looper == null) {
            throw new NullPointerException("looper must not be null");
        }
        if (callback == null) {
            throw new NullPointerException("callback must not be null");
        }
        return new Handler(looper, callback, true);
    }

    @UnsupportedAppUsage
    public static Handler getMain() {
        if (MAIN_THREAD_HANDLER == null) {
            MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper());
        }
        return MAIN_THREAD_HANDLER;
    }

    public static Handler mainIfNull(Handler handler) {
        return handler == null ? Handler.getMain() : handler;
    }

    public String getTraceName(Message message) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(": ");
        if (message.callback != null) {
            sb.append(message.callback.getClass().getName());
        } else {
            sb.append("#").append(message.what);
        }
        return sb.toString();
    }

    public String getMessageName(Message message) {
        if (message.callback != null) {
            return message.callback.getClass().getName();
        }
        return "0x" + Integer.toHexString(message.what);
    }

    public Message obtainMessage() {
        return Message.obtain(this);
    }

    public Message obtainMessage(int what) {
        return Message.obtain(this, what);
    }

    public Message obtainMessage(int what, Object obj) {
        return Message.obtain(this, what, obj);
    }

    public Message obtainMessage(int what, int arg1, int arg2) {
        return Message.obtain(this, what, arg1, arg2);
    }

    public Message obtainMessage(int what, int arg1, int arg2, Object obj) {
        return Message.obtain(this, what, arg1, arg2, obj);
    }

    public boolean post(Runnable r) {
        return this.sendMessageDelayed(Handler.getPostMessage(r), 0L);
    }

    public boolean postAtTime(Runnable r, long uptimeMillis) {
        return this.sendMessageAtTime(Handler.getPostMessage(r), uptimeMillis);
    }

    public boolean postAtTime(Runnable r, Object token, long uptimeMillis) {
        return this.sendMessageAtTime(Handler.getPostMessage(r, token), uptimeMillis);
    }

    public boolean postDelayed(Runnable r, long delayMillis) {
        return this.sendMessageDelayed(Handler.getPostMessage(r), delayMillis);
    }

    public boolean postDelayed(Runnable r, int what, long delayMillis) {
        return this.sendMessageDelayed(Handler.getPostMessage(r).setWhat(what), delayMillis);
    }

    public boolean postDelayed(Runnable r, Object token, long delayMillis) {
        return this.sendMessageDelayed(Handler.getPostMessage(r, token), delayMillis);
    }

    public boolean postAtFrontOfQueue(Runnable r) {
        return this.sendMessageAtFrontOfQueue(Handler.getPostMessage(r));
    }

    public boolean runWithScissors(Runnable r, long timeout) {
        if (r == null) {
            throw new IllegalArgumentException("runnable must not be null");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        if (Looper.myLooper() == this.mLooper) {
            r.run();
            return true;
        }
        BlockingRunnable br = new BlockingRunnable(r);
        return br.postAndWait(this, timeout);
    }

    public void removeCallbacks(Runnable r) {
        this.mQueue.removeMessages(this, r, null);
    }

    public void removeCallbacks(Runnable r, Object token) {
        this.mQueue.removeMessages(this, r, token);
    }

    public boolean sendMessage(Message msg) {
        return this.sendMessageDelayed(msg, 0L);
    }

    public boolean sendEmptyMessage(int what) {
        return this.sendEmptyMessageDelayed(what, 0L);
    }

    public boolean sendEmptyMessageDelayed(int what, long delayMillis) {
        Message msg = Message.obtain();
        msg.what = what;
        return this.sendMessageDelayed(msg, delayMillis);
    }

    public boolean sendEmptyMessageAtTime(int what, long uptimeMillis) {
        Message msg = Message.obtain();
        msg.what = what;
        return this.sendMessageAtTime(msg, uptimeMillis);
    }

    public boolean sendMessageDelayed(Message msg, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        return this.sendMessageAtTime(msg, SystemClock.uptimeMillis() + delayMillis);
    }

    public boolean sendMessageAtTime_Original(Message msg, long uptimeMillis) {
        MessageQueue queue = this.mQueue;
        if (queue == null) {
            RuntimeException e = new RuntimeException(this + " sendMessageAtTime() called with no mQueue");
            Log.w("Looper", e.getMessage(), e);
            return false;
        }
        return this.enqueueMessage(queue, msg, uptimeMillis);
    }

    @LayoutlibDelegate
    public boolean sendMessageAtTime(Message message, long l) {
        return Handler_Delegate.sendMessageAtTime(this, message, l);
    }

    public boolean sendMessageAtFrontOfQueue(Message msg) {
        MessageQueue queue = this.mQueue;
        if (queue == null) {
            RuntimeException e = new RuntimeException(this + " sendMessageAtTime() called with no mQueue");
            Log.w("Looper", e.getMessage(), e);
            return false;
        }
        return this.enqueueMessage(queue, msg, 0L);
    }

    public boolean executeOrSendMessage(Message msg) {
        if (this.mLooper == Looper.myLooper()) {
            this.dispatchMessage(msg);
            return true;
        }
        return this.sendMessage(msg);
    }

    private boolean enqueueMessage(MessageQueue queue, Message msg, long uptimeMillis) {
        msg.target = this;
        msg.workSourceUid = ThreadLocalWorkSource.getUid();
        if (this.mAsynchronous) {
            msg.setAsynchronous(true);
        }
        return queue.enqueueMessage(msg, uptimeMillis);
    }

    public void removeMessages(int what) {
        this.mQueue.removeMessages(this, what, null);
    }

    public void removeMessages(int what, Object object) {
        this.mQueue.removeMessages(this, what, object);
    }

    public void removeCallbacksAndMessages(Object token) {
        this.mQueue.removeCallbacksAndMessages(this, token);
    }

    public boolean hasMessages(int what) {
        return this.mQueue.hasMessages(this, what, null);
    }

    public boolean hasMessagesOrCallbacks() {
        return this.mQueue.hasMessages(this);
    }

    public boolean hasMessages(int what, Object object) {
        return this.mQueue.hasMessages(this, what, object);
    }

    public boolean hasCallbacks(Runnable r) {
        return this.mQueue.hasMessages(this, r, null);
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    public void dump(Printer pw, String prefix) {
        pw.println(prefix + this + " @ " + SystemClock.uptimeMillis());
        if (this.mLooper == null) {
            pw.println(prefix + "looper uninitialized");
        } else {
            this.mLooper.dump(pw, prefix + "  ");
        }
    }

    public void dumpMine(Printer pw, String prefix) {
        pw.println(prefix + this + " @ " + SystemClock.uptimeMillis());
        if (this.mLooper == null) {
            pw.println(prefix + "looper uninitialized");
        } else {
            this.mLooper.dump(pw, prefix + "  ", this);
        }
    }

    public String toString() {
        return "Handler (" + this.getClass().getName() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    IMessenger getIMessenger() {
        MessageQueue messageQueue = this.mQueue;
        synchronized (messageQueue) {
            if (this.mMessenger != null) {
                return this.mMessenger;
            }
            this.mMessenger = new MessengerImpl();
            return this.mMessenger;
        }
    }

    private static Message getPostMessage(Runnable r) {
        Message m = Message.obtain();
        m.callback = r;
        return m;
    }

    @UnsupportedAppUsage
    private static Message getPostMessage(Runnable r, Object token) {
        Message m = Message.obtain();
        m.obj = token;
        m.callback = r;
        return m;
    }

    private static void handleCallback(Message message) {
        message.callback.run();
    }

    private static class BlockingRunnable
    implements Runnable {
        private final Runnable mTask;
        private boolean mDone;

        public BlockingRunnable(Runnable task) {
            this.mTask = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.mTask.run();
            }
            finally {
                BlockingRunnable blockingRunnable = this;
                synchronized (blockingRunnable) {
                    this.mDone = true;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean postAndWait(Handler handler, long timeout) {
            if (!handler.post(this)) {
                return false;
            }
            BlockingRunnable blockingRunnable = this;
            synchronized (blockingRunnable) {
                if (timeout > 0L) {
                    long expirationTime = SystemClock.uptimeMillis() + timeout;
                    while (!this.mDone) {
                        long delay = expirationTime - SystemClock.uptimeMillis();
                        if (delay <= 0L) {
                            return false;
                        }
                        try {
                            this.wait(delay);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    while (!this.mDone) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            return true;
        }
    }

    private class MessengerImpl
    extends IMessenger.Stub {
        private MessengerImpl() {
        }

        @Override
        public void send(Message msg) {
            msg.sendingUid = Binder.getCallingUid();
            Handler.this.sendMessage(msg);
        }
    }

    public static interface Callback {
        public boolean handleMessage(Message var1);
    }
}

