/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.OsConstants;
import android.util.Pair;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;

public class LinkAddress
implements Parcelable {
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private InetAddress address;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int prefixLength;
    private int flags;
    private int scope;
    public static final Parcelable.Creator<LinkAddress> CREATOR = new Parcelable.Creator<LinkAddress>(){

        @Override
        public LinkAddress createFromParcel(Parcel in) {
            InetAddress address = null;
            try {
                address = InetAddress.getByAddress(in.createByteArray());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            int prefixLength = in.readInt();
            int flags = in.readInt();
            int scope = in.readInt();
            return new LinkAddress(address, prefixLength, flags, scope);
        }

        public LinkAddress[] newArray(int size) {
            return new LinkAddress[size];
        }
    };

    private static int scopeForUnicastAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress()) {
            return OsConstants.RT_SCOPE_HOST;
        }
        if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) {
            return OsConstants.RT_SCOPE_LINK;
        }
        if (!(addr instanceof Inet4Address) && addr.isSiteLocalAddress()) {
            return OsConstants.RT_SCOPE_SITE;
        }
        return OsConstants.RT_SCOPE_UNIVERSE;
    }

    private boolean isIpv6ULA() {
        if (this.isIpv6()) {
            byte[] bytes = this.address.getAddress();
            return (bytes[0] & 0xFFFFFFFE) == -4;
        }
        return false;
    }

    @SystemApi
    public boolean isIpv6() {
        return this.address instanceof Inet6Address;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean isIPv6() {
        return this.isIpv6();
    }

    @SystemApi
    public boolean isIpv4() {
        return this.address instanceof Inet4Address;
    }

    private void init(InetAddress address, int prefixLength, int flags, int scope) {
        if (address == null || address.isMulticastAddress() || prefixLength < 0 || address instanceof Inet4Address && prefixLength > 32 || prefixLength > 128) {
            throw new IllegalArgumentException("Bad LinkAddress params " + address + "/" + prefixLength);
        }
        this.address = address;
        this.prefixLength = prefixLength;
        this.flags = flags;
        this.scope = scope;
    }

    @SystemApi
    public LinkAddress(InetAddress address, int prefixLength, int flags, int scope) {
        this.init(address, prefixLength, flags, scope);
    }

    @SystemApi
    public LinkAddress(InetAddress address, int prefixLength) {
        this(address, prefixLength, 0, 0);
        this.scope = LinkAddress.scopeForUnicastAddress(address);
    }

    public LinkAddress(InterfaceAddress interfaceAddress) {
        this(interfaceAddress.getAddress(), interfaceAddress.getNetworkPrefixLength());
    }

    @SystemApi
    public LinkAddress(String address) {
        this(address, 0, 0);
        this.scope = LinkAddress.scopeForUnicastAddress(this.address);
    }

    @SystemApi
    public LinkAddress(String address, int flags, int scope) {
        Pair<InetAddress, Integer> ipAndMask = NetworkUtils.parseIpAndMask(address);
        this.init((InetAddress)ipAndMask.first, (Integer)ipAndMask.second, flags, scope);
    }

    public String toString() {
        return this.address.getHostAddress() + "/" + this.prefixLength;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LinkAddress)) {
            return false;
        }
        LinkAddress linkAddress = (LinkAddress)obj;
        return this.address.equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength && this.flags == linkAddress.flags && this.scope == linkAddress.scope;
    }

    public int hashCode() {
        return this.address.hashCode() + 11 * this.prefixLength + 19 * this.flags + 43 * this.scope;
    }

    @SystemApi
    public boolean isSameAddressAs(LinkAddress other) {
        if (other == null) {
            return false;
        }
        return this.address.equals(other.address) && this.prefixLength == other.prefixLength;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    @UnsupportedAppUsage
    public int getNetworkPrefixLength() {
        return this.getPrefixLength();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getScope() {
        return this.scope;
    }

    @SystemApi
    public boolean isGlobalPreferred() {
        return this.scope == OsConstants.RT_SCOPE_UNIVERSE && !this.isIpv6ULA() && (long)(this.flags & (OsConstants.IFA_F_DADFAILED | OsConstants.IFA_F_DEPRECATED)) == 0L && ((long)(this.flags & OsConstants.IFA_F_TENTATIVE) == 0L || (long)(this.flags & OsConstants.IFA_F_OPTIMISTIC) != 0L);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.address.getAddress());
        dest.writeInt(this.prefixLength);
        dest.writeInt(this.flags);
        dest.writeInt(this.scope);
    }
}

