/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.annotation.UnsupportedAppUsage;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.media.MediaDescription;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.VolumeProvider;
import android.media.session.ISession;
import android.media.session.ISessionCallback;
import android.media.session.ISessionController;
import android.media.session.ISessionControllerCallback;
import android.media.session.MediaController;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.ViewConfiguration;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;

public class MediaSession {
    static final String TAG = "MediaSession";
    @Deprecated
    public static final int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    @Deprecated
    public static final int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;
    public static final int FLAG_EXCLUSIVE_GLOBAL_PRIORITY = 65536;
    public static final int INVALID_UID = -1;
    public static final int INVALID_PID = -1;
    private final Object mLock = new Object();
    private final int mMaxBitmapSize;
    private final Token mSessionToken;
    private final MediaController mController;
    private final ISession mBinder;
    private final CallbackStub mCbStub;
    @UnsupportedAppUsage
    private CallbackMessageHandler mCallback;
    private VolumeProvider mVolumeProvider;
    private PlaybackState mPlaybackState;
    private boolean mActive = false;

    public MediaSession(Context context, String tag) {
        this(context, tag, null);
    }

    public MediaSession(Context context, String tag, Bundle sessionInfo) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (TextUtils.isEmpty(tag)) {
            throw new IllegalArgumentException("tag cannot be null or empty");
        }
        if (MediaSession.hasCustomParcelable(sessionInfo)) {
            throw new IllegalArgumentException("sessionInfo shouldn't contain any custom parcelables");
        }
        this.mMaxBitmapSize = context.getResources().getDimensionPixelSize(17105061);
        this.mCbStub = new CallbackStub(this);
        MediaSessionManager manager = (MediaSessionManager)context.getSystemService("media_session");
        try {
            this.mBinder = manager.createSession(this.mCbStub, tag, sessionInfo);
            this.mSessionToken = new Token(this.mBinder.getController());
            this.mController = new MediaController(context, this.mSessionToken);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Remote error creating session.", e);
        }
    }

    public void setCallback(Callback callback) {
        this.setCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            CallbackMessageHandler msgHandler;
            if (this.mCallback != null) {
                this.mCallback.mCallback.mSession = null;
                this.mCallback.removeCallbacksAndMessages(null);
            }
            if (callback == null) {
                this.mCallback = null;
                return;
            }
            if (handler == null) {
                handler = new Handler();
            }
            callback.mSession = this;
            this.mCallback = msgHandler = new CallbackMessageHandler(handler.getLooper(), callback);
        }
    }

    public void setSessionActivity(PendingIntent pi) {
        try {
            this.mBinder.setLaunchPendingIntent(pi);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setLaunchPendingIntent.", e);
        }
    }

    public void setMediaButtonReceiver(PendingIntent mbr) {
        try {
            this.mBinder.setMediaButtonReceiver(mbr);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setMediaButtonReceiver.", e);
        }
    }

    public void setFlags(int flags) {
        try {
            this.mBinder.setFlags(flags);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setFlags.", e);
        }
    }

    public void setPlaybackToLocal(AudioAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null for local playback.");
        }
        try {
            this.mBinder.setPlaybackToLocal(attributes);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setPlaybackToLocal.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackToRemote(VolumeProvider volumeProvider) {
        if (volumeProvider == null) {
            throw new IllegalArgumentException("volumeProvider may not be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mVolumeProvider = volumeProvider;
        }
        volumeProvider.setCallback(new VolumeProvider.Callback(){

            @Override
            public void onVolumeChanged(VolumeProvider volumeProvider) {
                MediaSession.this.notifyRemoteVolumeChanged(volumeProvider);
            }
        });
        try {
            this.mBinder.setPlaybackToRemote(volumeProvider.getVolumeControl(), volumeProvider.getMaxVolume());
            this.mBinder.setCurrentVolume(volumeProvider.getCurrentVolume());
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setPlaybackToRemote.", e);
        }
    }

    public void setActive(boolean active) {
        if (this.mActive == active) {
            return;
        }
        try {
            this.mBinder.setActive(active);
            this.mActive = active;
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failure in setActive.", e);
        }
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void sendSessionEvent(String event, Bundle extras) {
        if (TextUtils.isEmpty(event)) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        try {
            this.mBinder.sendEvent(event, extras);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Error sending event", e);
        }
    }

    public void release() {
        try {
            this.mBinder.destroySession();
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Error releasing session: ", e);
        }
    }

    public Token getSessionToken() {
        return this.mSessionToken;
    }

    public MediaController getController() {
        return this.mController;
    }

    public void setPlaybackState(PlaybackState state) {
        this.mPlaybackState = state;
        try {
            this.mBinder.setPlaybackState(state);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Dead object in setPlaybackState.", e);
        }
    }

    public void setMetadata(MediaMetadata metadata) {
        long duration = -1L;
        int fields = 0;
        MediaDescription description = null;
        if (metadata != null) {
            if ((metadata = new MediaMetadata.Builder(metadata, this.mMaxBitmapSize).build()).containsKey("android.media.metadata.DURATION")) {
                duration = metadata.getLong("android.media.metadata.DURATION");
            }
            fields = metadata.size();
            description = metadata.getDescription();
        }
        String metadataDescription = "size=" + fields + ", description=" + description;
        try {
            this.mBinder.setMetadata(metadata, duration, metadataDescription);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Dead object in setPlaybackState.", e);
        }
    }

    public void setQueue(List<QueueItem> queue) {
        try {
            this.mBinder.setQueue(queue == null ? null : new ParceledListSlice<QueueItem>(queue));
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setQueue.", e);
        }
    }

    public void setQueueTitle(CharSequence title) {
        try {
            this.mBinder.setQueueTitle(title);
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setQueueTitle.", e);
        }
    }

    public void setRatingType(int type) {
        try {
            this.mBinder.setRatingType(type);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in setRatingType.", e);
        }
    }

    public void setExtras(Bundle extras) {
        try {
            this.mBinder.setExtras(extras);
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setExtras.", e);
        }
    }

    public MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
        if (this.mCallback == null || this.mCallback.mCurrentControllerInfo == null) {
            throw new IllegalStateException("This should be called inside of MediaSession.Callback methods");
        }
        return this.mCallback.mCurrentControllerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoteVolumeChanged(VolumeProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            if (provider == null || provider != this.mVolumeProvider) {
                Log.w(TAG, "Received update from stale volume provider");
                return;
            }
        }
        try {
            this.mBinder.setCurrentVolume(provider.getCurrentVolume());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in notifyVolumeChanged", e);
        }
    }

    @UnsupportedAppUsage
    public String getCallingPackage() {
        if (this.mCallback != null && this.mCallback.mCurrentControllerInfo != null) {
            return this.mCallback.mCurrentControllerInfo.getPackageName();
        }
        return null;
    }

    public static boolean isActiveState(int state) {
        switch (state) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasCustomParcelable(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.writeBundle(bundle);
            parcel.setDataPosition(0);
            Bundle out = parcel.readBundle(null);
            out.size();
        }
        catch (BadParcelableException e) {
            Log.d(TAG, "Custom parcelable in bundle.", e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
            }
        }
        return false;
    }

    void dispatchPrepare(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 3, null, null);
    }

    void dispatchPrepareFromMediaId(MediaSessionManager.RemoteUserInfo caller, String mediaId, Bundle extras) {
        this.postToCallback(caller, 4, mediaId, extras);
    }

    void dispatchPrepareFromSearch(MediaSessionManager.RemoteUserInfo caller, String query, Bundle extras) {
        this.postToCallback(caller, 5, query, extras);
    }

    void dispatchPrepareFromUri(MediaSessionManager.RemoteUserInfo caller, Uri uri, Bundle extras) {
        this.postToCallback(caller, 6, uri, extras);
    }

    void dispatchPlay(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 7, null, null);
    }

    void dispatchPlayFromMediaId(MediaSessionManager.RemoteUserInfo caller, String mediaId, Bundle extras) {
        this.postToCallback(caller, 8, mediaId, extras);
    }

    void dispatchPlayFromSearch(MediaSessionManager.RemoteUserInfo caller, String query, Bundle extras) {
        this.postToCallback(caller, 9, query, extras);
    }

    void dispatchPlayFromUri(MediaSessionManager.RemoteUserInfo caller, Uri uri, Bundle extras) {
        this.postToCallback(caller, 10, uri, extras);
    }

    void dispatchSkipToItem(MediaSessionManager.RemoteUserInfo caller, long id2) {
        this.postToCallback(caller, 11, id2, null);
    }

    void dispatchPause(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 12, null, null);
    }

    void dispatchStop(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 13, null, null);
    }

    void dispatchNext(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 14, null, null);
    }

    void dispatchPrevious(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 15, null, null);
    }

    void dispatchFastForward(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 16, null, null);
    }

    void dispatchRewind(MediaSessionManager.RemoteUserInfo caller) {
        this.postToCallback(caller, 17, null, null);
    }

    void dispatchSeekTo(MediaSessionManager.RemoteUserInfo caller, long pos) {
        this.postToCallback(caller, 18, pos, null);
    }

    void dispatchRate(MediaSessionManager.RemoteUserInfo caller, Rating rating) {
        this.postToCallback(caller, 19, rating, null);
    }

    void dispatchSetPlaybackSpeed(MediaSessionManager.RemoteUserInfo caller, float speed) {
        this.postToCallback(caller, 20, Float.valueOf(speed), null);
    }

    void dispatchCustomAction(MediaSessionManager.RemoteUserInfo caller, String action, Bundle args) {
        this.postToCallback(caller, 21, action, args);
    }

    void dispatchMediaButton(MediaSessionManager.RemoteUserInfo caller, Intent mediaButtonIntent) {
        this.postToCallback(caller, 2, mediaButtonIntent, null);
    }

    void dispatchMediaButtonDelayed(MediaSessionManager.RemoteUserInfo info, Intent mediaButtonIntent, long delay) {
        this.postToCallbackDelayed(info, 24, mediaButtonIntent, null, delay);
    }

    void dispatchAdjustVolume(MediaSessionManager.RemoteUserInfo caller, int direction) {
        this.postToCallback(caller, 22, direction, null);
    }

    void dispatchSetVolumeTo(MediaSessionManager.RemoteUserInfo caller, int volume) {
        this.postToCallback(caller, 23, volume, null);
    }

    void dispatchCommand(MediaSessionManager.RemoteUserInfo caller, String command, Bundle args, ResultReceiver resultCb) {
        Command cmd = new Command(command, args, resultCb);
        this.postToCallback(caller, 1, cmd, null);
    }

    void postToCallback(MediaSessionManager.RemoteUserInfo caller, int what, Object obj, Bundle data) {
        this.postToCallbackDelayed(caller, what, obj, data, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postToCallbackDelayed(MediaSessionManager.RemoteUserInfo caller, int what, Object obj, Bundle data, long delay) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback != null) {
                this.mCallback.post(caller, what, obj, data, delay);
            }
        }
    }

    private class CallbackMessageHandler
    extends Handler {
        private static final int MSG_COMMAND = 1;
        private static final int MSG_MEDIA_BUTTON = 2;
        private static final int MSG_PREPARE = 3;
        private static final int MSG_PREPARE_MEDIA_ID = 4;
        private static final int MSG_PREPARE_SEARCH = 5;
        private static final int MSG_PREPARE_URI = 6;
        private static final int MSG_PLAY = 7;
        private static final int MSG_PLAY_MEDIA_ID = 8;
        private static final int MSG_PLAY_SEARCH = 9;
        private static final int MSG_PLAY_URI = 10;
        private static final int MSG_SKIP_TO_ITEM = 11;
        private static final int MSG_PAUSE = 12;
        private static final int MSG_STOP = 13;
        private static final int MSG_NEXT = 14;
        private static final int MSG_PREVIOUS = 15;
        private static final int MSG_FAST_FORWARD = 16;
        private static final int MSG_REWIND = 17;
        private static final int MSG_SEEK_TO = 18;
        private static final int MSG_RATE = 19;
        private static final int MSG_SET_PLAYBACK_SPEED = 20;
        private static final int MSG_CUSTOM_ACTION = 21;
        private static final int MSG_ADJUST_VOLUME = 22;
        private static final int MSG_SET_VOLUME = 23;
        private static final int MSG_PLAY_PAUSE_KEY_DOUBLE_TAP_TIMEOUT = 24;
        private Callback mCallback;
        private MediaSessionManager.RemoteUserInfo mCurrentControllerInfo;

        CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper);
            this.mCallback = callback;
            this.mCallback.mHandler = this;
        }

        void post(MediaSessionManager.RemoteUserInfo caller, int what, Object obj, Bundle data, long delayMs) {
            Pair<MediaSessionManager.RemoteUserInfo, Object> objWithCaller = Pair.create(caller, obj);
            Message msg = this.obtainMessage(what, objWithCaller);
            msg.setAsynchronous(true);
            msg.setData(data);
            if (delayMs > 0L) {
                this.sendMessageDelayed(msg, delayMs);
            } else {
                this.sendMessage(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            this.mCurrentControllerInfo = (MediaSessionManager.RemoteUserInfo)((Pair)msg.obj).first;
            Object obj = ((Pair)msg.obj).second;
            switch (msg.what) {
                case 1: {
                    Command cmd = (Command)obj;
                    this.mCallback.onCommand(cmd.command, cmd.extras, cmd.stub);
                    break;
                }
                case 2: {
                    this.mCallback.onMediaButtonEvent((Intent)obj);
                    break;
                }
                case 3: {
                    this.mCallback.onPrepare();
                    break;
                }
                case 4: {
                    this.mCallback.onPrepareFromMediaId((String)obj, msg.getData());
                    break;
                }
                case 5: {
                    this.mCallback.onPrepareFromSearch((String)obj, msg.getData());
                    break;
                }
                case 6: {
                    this.mCallback.onPrepareFromUri((Uri)obj, msg.getData());
                    break;
                }
                case 7: {
                    this.mCallback.onPlay();
                    break;
                }
                case 8: {
                    this.mCallback.onPlayFromMediaId((String)obj, msg.getData());
                    break;
                }
                case 9: {
                    this.mCallback.onPlayFromSearch((String)obj, msg.getData());
                    break;
                }
                case 10: {
                    this.mCallback.onPlayFromUri((Uri)obj, msg.getData());
                    break;
                }
                case 11: {
                    this.mCallback.onSkipToQueueItem((Long)obj);
                    break;
                }
                case 12: {
                    this.mCallback.onPause();
                    break;
                }
                case 13: {
                    this.mCallback.onStop();
                    break;
                }
                case 14: {
                    this.mCallback.onSkipToNext();
                    break;
                }
                case 15: {
                    this.mCallback.onSkipToPrevious();
                    break;
                }
                case 16: {
                    this.mCallback.onFastForward();
                    break;
                }
                case 17: {
                    this.mCallback.onRewind();
                    break;
                }
                case 18: {
                    this.mCallback.onSeekTo((Long)obj);
                    break;
                }
                case 19: {
                    this.mCallback.onSetRating((Rating)obj);
                    break;
                }
                case 20: {
                    this.mCallback.onSetPlaybackSpeed(((Float)obj).floatValue());
                    break;
                }
                case 21: {
                    this.mCallback.onCustomAction((String)obj, msg.getData());
                    break;
                }
                case 22: {
                    VolumeProvider vp;
                    Object object = MediaSession.this.mLock;
                    synchronized (object) {
                        vp = MediaSession.this.mVolumeProvider;
                    }
                    if (vp == null) break;
                    vp.onAdjustVolume((Integer)obj);
                    break;
                }
                case 23: {
                    VolumeProvider vp;
                    Object object = MediaSession.this.mLock;
                    synchronized (object) {
                        vp = MediaSession.this.mVolumeProvider;
                    }
                    if (vp == null) break;
                    vp.onSetVolumeTo((Integer)obj);
                    break;
                }
                case 24: {
                    this.mCallback.handleMediaPlayPauseKeySingleTapIfPending();
                }
            }
            this.mCurrentControllerInfo = null;
        }
    }

    private static class Command {
        public final String command;
        public final Bundle extras;
        public final ResultReceiver stub;

        Command(String command, Bundle extras, ResultReceiver stub) {
            this.command = command;
            this.extras = extras;
            this.stub = stub;
        }
    }

    public static class QueueItem
    implements Parcelable {
        public static final int UNKNOWN_ID = -1;
        private final MediaDescription mDescription;
        @UnsupportedAppUsage
        private final long mId;
        public static final Parcelable.Creator<QueueItem> CREATOR = new Parcelable.Creator<QueueItem>(){

            @Override
            public QueueItem createFromParcel(Parcel p) {
                return new QueueItem(p);
            }

            public QueueItem[] newArray(int size) {
                return new QueueItem[size];
            }
        };

        public QueueItem(MediaDescription description, long id2) {
            if (description == null) {
                throw new IllegalArgumentException("Description cannot be null.");
            }
            if (id2 == -1L) {
                throw new IllegalArgumentException("Id cannot be QueueItem.UNKNOWN_ID");
            }
            this.mDescription = description;
            this.mId = id2;
        }

        private QueueItem(Parcel in) {
            this.mDescription = MediaDescription.CREATOR.createFromParcel(in);
            this.mId = in.readLong();
        }

        public MediaDescription getDescription() {
            return this.mDescription;
        }

        public long getQueueId() {
            return this.mId;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mDescription.writeToParcel(dest, flags);
            dest.writeLong(this.mId);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "MediaSession.QueueItem {Description=" + this.mDescription + ", Id=" + this.mId + " }";
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof QueueItem)) {
                return false;
            }
            QueueItem item = (QueueItem)o;
            if (this.mId != item.mId) {
                return false;
            }
            return Objects.equals(this.mDescription, item.mDescription);
        }
    }

    public static class CallbackStub
    extends ISessionCallback.Stub {
        private WeakReference<MediaSession> mMediaSession;

        public CallbackStub(MediaSession session) {
            this.mMediaSession = new WeakReference<MediaSession>(session);
        }

        private static MediaSessionManager.RemoteUserInfo createRemoteUserInfo(String packageName, int pid, int uid) {
            return new MediaSessionManager.RemoteUserInfo(packageName, pid, uid);
        }

        @Override
        public void onCommand(String packageName, int pid, int uid, ISessionControllerCallback caller, String command, Bundle args, ResultReceiver cb) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchCommand(CallbackStub.createRemoteUserInfo(packageName, pid, uid), command, args, cb);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaButton(String packageName, int pid, int uid, Intent mediaButtonIntent, int sequenceNumber, ResultReceiver cb) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            try {
                if (session != null) {
                    session.dispatchMediaButton(CallbackStub.createRemoteUserInfo(packageName, pid, uid), mediaButtonIntent);
                }
            }
            finally {
                if (cb != null) {
                    cb.send(sequenceNumber, null);
                }
            }
        }

        @Override
        public void onMediaButtonFromController(String packageName, int pid, int uid, ISessionControllerCallback caller, Intent mediaButtonIntent) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchMediaButton(CallbackStub.createRemoteUserInfo(packageName, pid, uid), mediaButtonIntent);
            }
        }

        @Override
        public void onPrepare(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepare(CallbackStub.createRemoteUserInfo(packageName, pid, uid));
            }
        }

        @Override
        public void onPrepareFromMediaId(String packageName, int pid, int uid, ISessionControllerCallback caller, String mediaId, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromMediaId(CallbackStub.createRemoteUserInfo(packageName, pid, uid), mediaId, extras);
            }
        }

        @Override
        public void onPrepareFromSearch(String packageName, int pid, int uid, ISessionControllerCallback caller, String query, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromSearch(CallbackStub.createRemoteUserInfo(packageName, pid, uid), query, extras);
            }
        }

        @Override
        public void onPrepareFromUri(String packageName, int pid, int uid, ISessionControllerCallback caller, Uri uri, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromUri(CallbackStub.createRemoteUserInfo(packageName, pid, uid), uri, extras);
            }
        }

        @Override
        public void onPlay(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlay(CallbackStub.createRemoteUserInfo(packageName, pid, uid));
            }
        }

        @Override
        public void onPlayFromMediaId(String packageName, int pid, int uid, ISessionControllerCallback caller, String mediaId, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromMediaId(CallbackStub.createRemoteUserInfo(packageName, pid, uid), mediaId, extras);
            }
        }

        @Override
        public void onPlayFromSearch(String packageName, int pid, int uid, ISessionControllerCallback caller, String query, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromSearch(CallbackStub.createRemoteUserInfo(packageName, pid, uid), query, extras);
            }
        }

        @Override
        public void onPlayFromUri(String packageName, int pid, int uid, ISessionControllerCallback caller, Uri uri, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromUri(CallbackStub.createRemoteUserInfo(packageName, pid, uid), uri, extras);
            }
        }

        @Override
        public void onSkipToTrack(String packageName, int pid, int uid, ISessionControllerCallback caller, long id2) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSkipToItem(CallbackStub.createRemoteUserInfo(packageName, pid, uid), id2);
            }
        }

        @Override
        public void onPause(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPause(CallbackStub.createRemoteUserInfo(packageName, pid, uid));
            }
        }

        @Override
        public void onStop(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchStop(CallbackStub.createRemoteUserInfo(packageName, pid, uid));
            }
        }

        @Override
        public void onNext(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchNext(CallbackStub.createRemoteUserInfo(packageName, pid, uid));
            }
        }

        @Override
        public void onPrevious(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrevious(CallbackStub.createRemoteUserInfo(packageName, pid, uid));
            }
        }

        @Override
        public void onFastForward(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchFastForward(CallbackStub.createRemoteUserInfo(packageName, pid, uid));
            }
        }

        @Override
        public void onRewind(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchRewind(CallbackStub.createRemoteUserInfo(packageName, pid, uid));
            }
        }

        @Override
        public void onSeekTo(String packageName, int pid, int uid, ISessionControllerCallback caller, long pos) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSeekTo(CallbackStub.createRemoteUserInfo(packageName, pid, uid), pos);
            }
        }

        @Override
        public void onRate(String packageName, int pid, int uid, ISessionControllerCallback caller, Rating rating) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchRate(CallbackStub.createRemoteUserInfo(packageName, pid, uid), rating);
            }
        }

        @Override
        public void onSetPlaybackSpeed(String packageName, int pid, int uid, ISessionControllerCallback caller, float speed) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSetPlaybackSpeed(CallbackStub.createRemoteUserInfo(packageName, pid, uid), speed);
            }
        }

        @Override
        public void onCustomAction(String packageName, int pid, int uid, ISessionControllerCallback caller, String action, Bundle args) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchCustomAction(CallbackStub.createRemoteUserInfo(packageName, pid, uid), action, args);
            }
        }

        @Override
        public void onAdjustVolume(String packageName, int pid, int uid, ISessionControllerCallback caller, int direction) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchAdjustVolume(CallbackStub.createRemoteUserInfo(packageName, pid, uid), direction);
            }
        }

        @Override
        public void onSetVolumeTo(String packageName, int pid, int uid, ISessionControllerCallback caller, int value) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSetVolumeTo(CallbackStub.createRemoteUserInfo(packageName, pid, uid), value);
            }
        }
    }

    public static abstract class Callback {
        private MediaSession mSession;
        private CallbackMessageHandler mHandler;
        private boolean mMediaPlayPauseKeyPending;

        public void onCommand(String command, Bundle args, ResultReceiver cb) {
        }

        public boolean onMediaButtonEvent(Intent mediaButtonIntent) {
            KeyEvent ke;
            if (this.mSession != null && this.mHandler != null && "android.intent.action.MEDIA_BUTTON".equals(mediaButtonIntent.getAction()) && (ke = (KeyEvent)mediaButtonIntent.getParcelableExtra("android.intent.extra.KEY_EVENT")) != null && ke.getAction() == 0) {
                PlaybackState state = this.mSession.mPlaybackState;
                long validActions = state == null ? 0L : state.getActions();
                switch (ke.getKeyCode()) {
                    case 79: 
                    case 85: {
                        if (ke.getRepeatCount() > 0) {
                            this.handleMediaPlayPauseKeySingleTapIfPending();
                        } else if (this.mMediaPlayPauseKeyPending) {
                            this.mHandler.removeMessages(24);
                            this.mMediaPlayPauseKeyPending = false;
                            if ((validActions & 0x20L) != 0L) {
                                this.onSkipToNext();
                            }
                        } else {
                            this.mMediaPlayPauseKeyPending = true;
                            this.mSession.dispatchMediaButtonDelayed(this.mSession.getCurrentControllerInfo(), mediaButtonIntent, ViewConfiguration.getDoubleTapTimeout());
                        }
                        return true;
                    }
                }
                this.handleMediaPlayPauseKeySingleTapIfPending();
                switch (ke.getKeyCode()) {
                    case 126: {
                        if ((validActions & 4L) == 0L) break;
                        this.onPlay();
                        return true;
                    }
                    case 127: {
                        if ((validActions & 2L) == 0L) break;
                        this.onPause();
                        return true;
                    }
                    case 87: {
                        if ((validActions & 0x20L) == 0L) break;
                        this.onSkipToNext();
                        return true;
                    }
                    case 88: {
                        if ((validActions & 0x10L) == 0L) break;
                        this.onSkipToPrevious();
                        return true;
                    }
                    case 86: {
                        if ((validActions & 1L) == 0L) break;
                        this.onStop();
                        return true;
                    }
                    case 90: {
                        if ((validActions & 0x40L) == 0L) break;
                        this.onFastForward();
                        return true;
                    }
                    case 89: {
                        if ((validActions & 8L) == 0L) break;
                        this.onRewind();
                        return true;
                    }
                }
            }
            return false;
        }

        private void handleMediaPlayPauseKeySingleTapIfPending() {
            boolean canPause;
            if (!this.mMediaPlayPauseKeyPending) {
                return;
            }
            this.mMediaPlayPauseKeyPending = false;
            this.mHandler.removeMessages(24);
            PlaybackState state = this.mSession.mPlaybackState;
            long validActions = state == null ? 0L : state.getActions();
            boolean isPlaying = state != null && state.getState() == 3;
            boolean canPlay = (validActions & 0x204L) != 0L;
            boolean bl = canPause = (validActions & 0x202L) != 0L;
            if (isPlaying && canPause) {
                this.onPause();
            } else if (!isPlaying && canPlay) {
                this.onPlay();
            }
        }

        public void onPrepare() {
        }

        public void onPrepareFromMediaId(String mediaId, Bundle extras) {
        }

        public void onPrepareFromSearch(String query, Bundle extras) {
        }

        public void onPrepareFromUri(Uri uri, Bundle extras) {
        }

        public void onPlay() {
        }

        public void onPlayFromSearch(String query, Bundle extras) {
        }

        public void onPlayFromMediaId(String mediaId, Bundle extras) {
        }

        public void onPlayFromUri(Uri uri, Bundle extras) {
        }

        public void onSkipToQueueItem(long id2) {
        }

        public void onPause() {
        }

        public void onSkipToNext() {
        }

        public void onSkipToPrevious() {
        }

        public void onFastForward() {
        }

        public void onRewind() {
        }

        public void onStop() {
        }

        public void onSeekTo(long pos) {
        }

        public void onSetRating(Rating rating) {
        }

        public void onSetPlaybackSpeed(float speed) {
        }

        public void onCustomAction(String action, Bundle extras) {
        }
    }

    public static class Token
    implements Parcelable {
        private final int mUid;
        private final ISessionController mBinder;
        public static final Parcelable.Creator<Token> CREATOR = new Parcelable.Creator<Token>(){

            @Override
            public Token createFromParcel(Parcel in) {
                return new Token(in);
            }

            public Token[] newArray(int size) {
                return new Token[size];
            }
        };

        public Token(ISessionController binder) {
            this.mUid = Process.myUid();
            this.mBinder = binder;
        }

        Token(Parcel in) {
            this.mUid = in.readInt();
            this.mBinder = ISessionController.Stub.asInterface(in.readStrongBinder());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mUid);
            dest.writeStrongBinder(this.mBinder.asBinder());
        }

        public int hashCode() {
            int prime = 31;
            int result = this.mUid;
            result = 31 * result + (this.mBinder == null ? 0 : this.mBinder.asBinder().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Token other = (Token)obj;
            if (this.mUid != other.mUid) {
                return false;
            }
            if (this.mBinder == null || other.mBinder == null) {
                return this.mBinder == other.mBinder;
            }
            return Objects.equals(this.mBinder.asBinder(), other.mBinder.asBinder());
        }

        public int getUid() {
            return this.mUid;
        }

        public ISessionController getBinder() {
            return this.mBinder;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionFlags {
    }
}

