/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.Image;
import android.media.ImageWriter;
import android.util.Size;
import java.nio.ByteBuffer;
import libcore.io.Memory;

class ImageUtils {
    ImageUtils() {
    }

    public static int getNumPlanesForFormat(int format) {
        switch (format) {
            case 17: 
            case 35: 
            case 842094169: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 20: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 256: 
            case 257: 
            case 4098: 
            case 538982489: 
            case 540422489: 
            case 1144402265: 
            case 1212500294: 
            case 1768253795: {
                return 1;
            }
            case 34: {
                return 0;
            }
        }
        throw new UnsupportedOperationException(String.format("Invalid format specified %d", format));
    }

    public static void imageCopy(Image src, Image dst) {
        Size dstSize;
        if (src == null || dst == null) {
            throw new IllegalArgumentException("Images should be non-null");
        }
        if (src.getFormat() != dst.getFormat()) {
            throw new IllegalArgumentException("Src and dst images should have the same format");
        }
        if (src.getFormat() == 34 || dst.getFormat() == 34) {
            throw new IllegalArgumentException("PRIVATE format images are not copyable");
        }
        if (src.getFormat() == 36) {
            throw new IllegalArgumentException("Copy of RAW_OPAQUE format has not been implemented");
        }
        if (src.getFormat() == 4098) {
            throw new IllegalArgumentException("Copy of RAW_DEPTH format has not been implemented");
        }
        if (!(dst.getOwner() instanceof ImageWriter)) {
            throw new IllegalArgumentException("Destination image is not from ImageWriter. Only the images from ImageWriter are writable");
        }
        Size srcSize = new Size(src.getWidth(), src.getHeight());
        if (!srcSize.equals(dstSize = new Size(dst.getWidth(), dst.getHeight()))) {
            throw new IllegalArgumentException("source image size " + srcSize + " is different with destination image size " + dstSize);
        }
        Image.Plane[] srcPlanes = src.getPlanes();
        Image.Plane[] dstPlanes = dst.getPlanes();
        ByteBuffer srcBuffer = null;
        ByteBuffer dstBuffer = null;
        for (int i = 0; i < srcPlanes.length; ++i) {
            int srcRowStride = srcPlanes[i].getRowStride();
            int dstRowStride = dstPlanes[i].getRowStride();
            srcBuffer = srcPlanes[i].getBuffer();
            dstBuffer = dstPlanes[i].getBuffer();
            if (!srcBuffer.isDirect() || !dstBuffer.isDirect()) {
                throw new IllegalArgumentException("Source and destination ByteBuffers must be direct byteBuffer!");
            }
            if (srcPlanes[i].getPixelStride() != dstPlanes[i].getPixelStride()) {
                throw new IllegalArgumentException("Source plane image pixel stride " + srcPlanes[i].getPixelStride() + " must be same as destination image pixel stride " + dstPlanes[i].getPixelStride());
            }
            int srcPos = srcBuffer.position();
            srcBuffer.rewind();
            dstBuffer.rewind();
            if (srcRowStride == dstRowStride) {
                dstBuffer.put(srcBuffer);
            } else {
                int srcOffset = srcBuffer.position();
                int dstOffset = dstBuffer.position();
                Size effectivePlaneSize = ImageUtils.getEffectivePlaneSizeForImage(src, i);
                int srcByteCount = effectivePlaneSize.getWidth() * srcPlanes[i].getPixelStride();
                for (int row = 0; row < effectivePlaneSize.getHeight(); ++row) {
                    int remainingBytes;
                    if (row == effectivePlaneSize.getHeight() - 1 && srcByteCount > (remainingBytes = srcBuffer.remaining() - srcOffset)) {
                        srcByteCount = remainingBytes;
                    }
                    ImageUtils.directByteBufferCopy(srcBuffer, srcOffset, dstBuffer, dstOffset, srcByteCount);
                    srcOffset += srcRowStride;
                    dstOffset += dstRowStride;
                }
            }
            srcBuffer.position(srcPos);
            dstBuffer.rewind();
        }
    }

    public static int getEstimatedNativeAllocBytes(int width, int height, int format, int numImages) {
        double estimatedBytePerPixel;
        switch (format) {
            case 256: 
            case 257: 
            case 1212500294: 
            case 1768253795: {
                estimatedBytePerPixel = 0.3;
                break;
            }
            case 538982489: {
                estimatedBytePerPixel = 1.0;
                break;
            }
            case 37: {
                estimatedBytePerPixel = 1.25;
                break;
            }
            case 17: 
            case 34: 
            case 35: 
            case 38: 
            case 842094169: {
                estimatedBytePerPixel = 1.5;
                break;
            }
            case 4: 
            case 16: 
            case 20: 
            case 32: 
            case 36: 
            case 4098: 
            case 540422489: 
            case 1144402265: {
                estimatedBytePerPixel = 2.0;
                break;
            }
            case 3: {
                estimatedBytePerPixel = 3.0;
                break;
            }
            case 1: 
            case 2: {
                estimatedBytePerPixel = 4.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Invalid format specified %d", format));
            }
        }
        return (int)((double)(width * height) * estimatedBytePerPixel * (double)numImages);
    }

    private static Size getEffectivePlaneSizeForImage(Image image, int planeIdx) {
        switch (image.getFormat()) {
            case 17: 
            case 35: 
            case 842094169: {
                if (planeIdx == 0) {
                    return new Size(image.getWidth(), image.getHeight());
                }
                return new Size(image.getWidth() / 2, image.getHeight() / 2);
            }
            case 16: {
                if (planeIdx == 0) {
                    return new Size(image.getWidth(), image.getHeight());
                }
                return new Size(image.getWidth(), image.getHeight() / 2);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 20: 
            case 32: 
            case 37: 
            case 38: 
            case 256: 
            case 4098: 
            case 538982489: 
            case 540422489: 
            case 1212500294: {
                return new Size(image.getWidth(), image.getHeight());
            }
            case 34: {
                return new Size(0, 0);
            }
        }
        throw new UnsupportedOperationException(String.format("Invalid image format %d", image.getFormat()));
    }

    private static void directByteBufferCopy(ByteBuffer srcBuffer, int srcOffset, ByteBuffer dstBuffer, int dstOffset, int srcByteCount) {
        Memory.memmove(dstBuffer, dstOffset, srcBuffer, srcOffset, srcByteCount);
    }
}

