/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.text.BaseLineBreaker;
import android.graphics.text.GreedyLineBreaker;
import android.graphics.text.LineWidth;
import android.graphics.text.MeasuredText_Delegate;
import android.graphics.text.OptimizingLineBreaker;
import android.graphics.text.Primitive;
import android.graphics.text.TabStops;
import android.icu.text.BreakIterator;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;
import libcore.util.NativeAllocationRegistry_Delegate;

public class LineBreaker_Delegate {
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_NEWLINE = '\n';
    private static final char CHAR_ZWSP = '\u200b';
    private static final DelegateManager<Builder> sBuilderManager = new DelegateManager<Builder>(Builder.class);
    private static long sFinalizer = -1L;
    private static final DelegateManager<Result> sResultManager = new DelegateManager<Result>(Result.class);
    private static long sResultFinalizer = -1L;

    @LayoutlibDelegate
    static long nInit(int breakStrategy, int hyphenationFrequency, boolean isJustified, int[] indents) {
        Builder builder = new Builder();
        builder.mBreakStrategy = breakStrategy;
        return sBuilderManager.addNewDelegate(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetReleaseFunc() {
        Class<MeasuredText_Delegate> clazz = MeasuredText_Delegate.class;
        synchronized (MeasuredText_Delegate.class) {
            if (sFinalizer == -1L) {
                sFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sBuilderManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFinalizer;
        }
    }

    @LayoutlibDelegate
    static long nComputeLineBreaks(long nativePtr, char[] text, long measuredTextPtr, int length, float firstWidth, int firstWidthLineCount, float restWidth, float[] variableTabStops, float defaultTabStop, int indentsOffset) {
        int loc;
        Builder builder = sBuilderManager.getDelegate(nativePtr);
        if (builder == null) {
            return 0L;
        }
        builder.mText = text;
        builder.mWidths = new float[length];
        builder.mLineWidth = new LineWidth(firstWidth, firstWidthLineCount, restWidth);
        builder.mTabStopCalculator = new TabStops(variableTabStops, defaultTabStop);
        MeasuredText_Delegate.computeRuns(measuredTextPtr, builder);
        BreakIterator it = BreakIterator.getLineInstance();
        it.setText(new Segment(builder.mText, 0, length));
        ArrayList<Integer> breaks = new ArrayList<Integer>((int)Math.ceil((double)length / 5.0));
        it.first();
        while ((loc = it.next()) != -1) {
            breaks.add(loc);
        }
        List<Primitive> primitives = LineBreaker_Delegate.computePrimitives(builder.mText, builder.mWidths, length, breaks);
        switch (builder.mBreakStrategy) {
            case 0: {
                builder.mLineBreaker = new GreedyLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
                break;
            }
            case 1: 
            case 2: {
                builder.mLineBreaker = new OptimizingLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
                break;
            }
            default: {
                assert (false) : "Unknown break strategy: " + Builder.access$000(builder);
                builder.mLineBreaker = new GreedyLineBreaker(primitives, builder.mLineWidth, builder.mTabStopCalculator);
            }
        }
        Result result = new Result(builder.mLineBreaker.computeBreaks());
        return sResultManager.addNewDelegate(result);
    }

    @LayoutlibDelegate
    static int nGetLineCount(long ptr) {
        Result result = sResultManager.getDelegate(ptr);
        return result.mResult.mLineBreakOffset.size();
    }

    @LayoutlibDelegate
    static int nGetLineBreakOffset(long ptr, int idx) {
        Result result = sResultManager.getDelegate(ptr);
        return result.mResult.mLineBreakOffset.get(idx);
    }

    @LayoutlibDelegate
    static float nGetLineWidth(long ptr, int idx) {
        Result result = sResultManager.getDelegate(ptr);
        return result.mResult.mLineWidths.get(idx).floatValue();
    }

    @LayoutlibDelegate
    static float nGetLineAscent(long ptr, int idx) {
        Result result = sResultManager.getDelegate(ptr);
        return result.mResult.mLineAscents.get(idx).floatValue();
    }

    @LayoutlibDelegate
    static float nGetLineDescent(long ptr, int idx) {
        Result result = sResultManager.getDelegate(ptr);
        return result.mResult.mLineDescents.get(idx).floatValue();
    }

    @LayoutlibDelegate
    static int nGetLineFlag(long ptr, int idx) {
        Result result = sResultManager.getDelegate(ptr);
        return result.mResult.mLineFlags.get(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetReleaseResultFunc() {
        Class<MeasuredText_Delegate> clazz = MeasuredText_Delegate.class;
        synchronized (MeasuredText_Delegate.class) {
            if (sResultFinalizer == -1L) {
                sResultFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sBuilderManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResultFinalizer;
        }
    }

    private static List<Primitive> computePrimitives(char[] text, float[] widths, int length, List<Integer> breaks) {
        ArrayList<Primitive> primitives = new ArrayList<Primitive>((int)Math.ceil((double)length * 1.833));
        int breaksSize = breaks.size();
        int breakIndex = 0;
        for (int i = 0; i < length; ++i) {
            char c = text[i];
            if (c == ' ' || c == '\u200b') {
                primitives.add(Primitive.PrimitiveType.GLUE.getNewPrimitive(i, widths[i]));
                continue;
            }
            if (c == '\t') {
                primitives.add(Primitive.PrimitiveType.VARIABLE.getNewPrimitive(i));
                continue;
            }
            if (c == '\n') continue;
            while (breakIndex < breaksSize && breaks.get(breakIndex) < i) {
                ++breakIndex;
            }
            if (widths[i] != 0.0f) {
                Primitive p = breakIndex < breaksSize && breaks.get(breakIndex) == i ? Primitive.PrimitiveType.PENALTY.getNewPrimitive(i, 0.0f, 0.0f) : Primitive.PrimitiveType.WORD_BREAK.getNewPrimitive(i, 0.0f);
                primitives.add(p);
            }
            primitives.add(Primitive.PrimitiveType.BOX.getNewPrimitive(i, widths[i]));
        }
        primitives.add(Primitive.PrimitiveType.PENALTY.getNewPrimitive(length, 0.0f, -1.0E7f));
        return primitives;
    }

    public static class Result {
        final BaseLineBreaker.Result mResult;

        public Result(BaseLineBreaker.Result result) {
            this.mResult = result;
        }
    }

    public static abstract class Run {
        int mStart;
        int mEnd;

        Run(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
        }

        abstract void addTo(Builder var1);
    }

    public static class Builder {
        char[] mText;
        float[] mWidths;
        private BaseLineBreaker mLineBreaker;
        private int mBreakStrategy;
        private LineWidth mLineWidth;
        private TabStops mTabStopCalculator;
    }
}

