/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.fonts.FontFileUtil;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.graphics.fonts.Font_Builder_Delegate;
import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.util.TypedValue;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Objects;
import libcore.util.NativeAllocationRegistry;

public class Font {
    private static final String TAG = "Font";
    private static final int NOT_SPECIFIED = -1;
    private static final int STYLE_ITALIC = 1;
    private static final int STYLE_NORMAL = 0;
    private final long mNativePtr;
    private final ByteBuffer mBuffer;
    private final File mFile;
    private final FontStyle mFontStyle;
    private final int mTtcIndex;
    private final FontVariationAxis[] mAxes;
    private final String mLocaleList;

    private Font(long nativePtr, ByteBuffer buffer, File file, FontStyle fontStyle, int ttcIndex, FontVariationAxis[] axes, String localeList) {
        this.mBuffer = buffer;
        this.mFile = file;
        this.mFontStyle = fontStyle;
        this.mNativePtr = nativePtr;
        this.mTtcIndex = ttcIndex;
        this.mAxes = axes;
        this.mLocaleList = localeList;
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public File getFile() {
        return this.mFile;
    }

    public FontStyle getStyle() {
        return this.mFontStyle;
    }

    public int getTtcIndex() {
        return this.mTtcIndex;
    }

    public FontVariationAxis[] getAxes() {
        return this.mAxes == null ? null : (FontVariationAxis[])this.mAxes.clone();
    }

    public LocaleList getLocaleList() {
        return LocaleList.forLanguageTags(this.mLocaleList);
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Font)) {
            return false;
        }
        Font f = (Font)o;
        return this.mFontStyle.equals(f.mFontStyle) && f.mTtcIndex == this.mTtcIndex && Arrays.equals(f.mAxes, this.mAxes) && f.mBuffer.equals(this.mBuffer);
    }

    public int hashCode() {
        return Objects.hash(this.mFontStyle, this.mTtcIndex, Arrays.hashCode(this.mAxes), this.mBuffer);
    }

    public String toString() {
        return "Font {path=" + this.mFile + ", style=" + this.mFontStyle + ", ttcIndex=" + this.mTtcIndex + ", axes=" + FontVariationAxis.toFontVariationSettings(this.mAxes) + ", localeList=" + this.mLocaleList + ", buffer=" + this.mBuffer + "}";
    }

    public static class Builder {
        private static final NativeAllocationRegistry sAssetByteBufferRegistry = NativeAllocationRegistry.createMalloced(ByteBuffer.class.getClassLoader(), Builder.nGetReleaseNativeAssetFunc());
        private static final NativeAllocationRegistry sFontRegistry = NativeAllocationRegistry.createMalloced(Font.class.getClassLoader(), Builder.nGetReleaseNativeFont());
        private ByteBuffer mBuffer;
        private File mFile;
        private String mLocaleList = "";
        private int mWeight = -1;
        private int mItalic = -1;
        private int mTtcIndex = 0;
        private FontVariationAxis[] mAxes = null;
        private IOException mException;

        public Builder(ByteBuffer buffer) {
            Preconditions.checkNotNull(buffer, "buffer can not be null");
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("Only direct buffer can be used as the source of font data.");
            }
            this.mBuffer = buffer;
        }

        public Builder(ByteBuffer buffer, File path, String localeList) {
            this(buffer);
            this.mFile = path;
            this.mLocaleList = localeList;
        }

        public Builder(File path) {
            Preconditions.checkNotNull(path, "path can not be null");
            try (FileInputStream fis = new FileInputStream(path);){
                FileChannel fc = fis.getChannel();
                this.mBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            }
            catch (IOException e) {
                this.mException = e;
            }
            this.mFile = path;
        }

        public Builder(ParcelFileDescriptor fd) {
            this(fd, 0L, -1L);
        }

        public Builder(ParcelFileDescriptor fd, long offset, long size) {
            try (FileInputStream fis = new FileInputStream(fd.getFileDescriptor());){
                FileChannel fc = fis.getChannel();
                size = size == -1L ? fc.size() - offset : size;
                this.mBuffer = fc.map(FileChannel.MapMode.READ_ONLY, offset, size);
            }
            catch (IOException e) {
                this.mException = e;
            }
        }

        public Builder(AssetManager am, String path) {
            this(am, path, true, 0);
        }

        public Builder(AssetManager am, String path, boolean isAsset, int cookie) {
            long nativeAsset = Builder.nGetNativeAsset(am, path, isAsset, cookie);
            if (nativeAsset == 0L) {
                this.mException = new FileNotFoundException("Unable to open " + path);
                return;
            }
            ByteBuffer b = Builder.nGetAssetBuffer(nativeAsset);
            sAssetByteBufferRegistry.registerNativeAllocation(b, nativeAsset);
            if (b == null) {
                this.mException = new FileNotFoundException(path + " not found");
                return;
            }
            this.mBuffer = b;
        }

        public Builder(Resources res, int resId) {
            TypedValue value = new TypedValue();
            res.getValue(resId, value, true);
            if (value.string == null) {
                this.mException = new FileNotFoundException(resId + " not found");
                return;
            }
            String str = value.string.toString();
            if (str.toLowerCase().endsWith(".xml")) {
                this.mException = new FileNotFoundException(resId + " must be font file.");
                return;
            }
            long nativeAsset = Builder.nGetNativeAsset(res.getAssets(), str, false, value.assetCookie);
            if (nativeAsset == 0L) {
                this.mException = new FileNotFoundException("Unable to open " + str);
                return;
            }
            ByteBuffer b = Builder.nGetAssetBuffer(nativeAsset);
            sAssetByteBufferRegistry.registerNativeAllocation(b, nativeAsset);
            if (b == null) {
                this.mException = new FileNotFoundException(str + " not found");
                return;
            }
            this.mBuffer = b;
        }

        public Builder setWeight(int weight) {
            Preconditions.checkArgument(1 <= weight && weight <= 1000);
            this.mWeight = weight;
            return this;
        }

        public Builder setSlant(int slant) {
            this.mItalic = slant == 0 ? 0 : 1;
            return this;
        }

        public Builder setTtcIndex(int ttcIndex) {
            this.mTtcIndex = ttcIndex;
            return this;
        }

        public Builder setFontVariationSettings(String variationSettings) {
            this.mAxes = FontVariationAxis.fromFontVariationSettings(variationSettings);
            return this;
        }

        public Builder setFontVariationSettings(FontVariationAxis[] axes) {
            this.mAxes = axes == null ? null : (FontVariationAxis[])axes.clone();
            return this;
        }

        public Font build() throws IOException {
            if (this.mException != null) {
                throw new IOException("Failed to read font contents", this.mException);
            }
            if (this.mWeight == -1 || this.mItalic == -1) {
                int packed = FontFileUtil.analyzeStyle(this.mBuffer, this.mTtcIndex, this.mAxes);
                if (FontFileUtil.isSuccess(packed)) {
                    if (this.mWeight == -1) {
                        this.mWeight = FontFileUtil.unpackWeight(packed);
                    }
                    if (this.mItalic == -1) {
                        this.mItalic = FontFileUtil.unpackItalic(packed) ? 1 : 0;
                    }
                } else {
                    this.mWeight = 400;
                    this.mItalic = 0;
                }
            }
            this.mWeight = Math.max(1, Math.min(1000, this.mWeight));
            boolean italic = this.mItalic == 1;
            int slant = this.mItalic == 1 ? 1 : 0;
            long builderPtr = Builder.nInitBuilder();
            if (this.mAxes != null) {
                for (FontVariationAxis axis : this.mAxes) {
                    Builder.nAddAxis(builderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
                }
            }
            ByteBuffer readonlyBuffer = this.mBuffer.asReadOnlyBuffer();
            String filePath = this.mFile == null ? "" : this.mFile.getAbsolutePath();
            long ptr = Builder.nBuild(builderPtr, readonlyBuffer, filePath, this.mWeight, italic, this.mTtcIndex);
            Font font = new Font(ptr, readonlyBuffer, this.mFile, new FontStyle(this.mWeight, slant), this.mTtcIndex, this.mAxes, this.mLocaleList);
            sFontRegistry.registerNativeAllocation(font, ptr);
            return font;
        }

        @LayoutlibDelegate
        private static long nGetNativeAsset(AssetManager assetManager, String string2, boolean bl, int n) {
            return Font_Builder_Delegate.nGetNativeAsset(assetManager, string2, bl, n);
        }

        @LayoutlibDelegate
        private static ByteBuffer nGetAssetBuffer(long l) {
            return Font_Builder_Delegate.nGetAssetBuffer(l);
        }

        @LayoutlibDelegate
        @CriticalNative
        private static long nGetReleaseNativeAssetFunc() {
            return Font_Builder_Delegate.nGetReleaseNativeAssetFunc();
        }

        @LayoutlibDelegate
        private static long nInitBuilder() {
            return Font_Builder_Delegate.nInitBuilder();
        }

        @LayoutlibDelegate
        @CriticalNative
        private static void nAddAxis(long l, int n, float f) {
            Font_Builder_Delegate.nAddAxis(l, n, f);
        }

        @LayoutlibDelegate
        private static long nBuild(long l, ByteBuffer byteBuffer, String string2, int n, boolean bl, int n2) {
            return Font_Builder_Delegate.nBuild(l, byteBuffer, string2, n, bl, n2);
        }

        @LayoutlibDelegate
        @CriticalNative
        private static long nGetReleaseNativeFont() {
            return Font_Builder_Delegate.nGetReleaseNativeFont();
        }
    }
}

