/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.annotation.UnsupportedAppUsage;
import android.content.res.ColorStateList;
import android.content.res.ComplexColor;
import android.content.res.GradientColor;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable_Delegate;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.IntProperty;
import android.util.Log;
import android.util.PathParser;
import android.util.Property;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMRuntime;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawable
extends Drawable {
    private static final String LOGTAG = VectorDrawable.class.getSimpleName();
    private static final String SHAPE_CLIP_PATH = "clip-path";
    private static final String SHAPE_GROUP = "group";
    private static final String SHAPE_PATH = "path";
    private static final String SHAPE_VECTOR = "vector";
    public VectorDrawableState mVectorState;
    @UnsupportedAppUsage
    private PorterDuffColorFilter mTintFilter;
    private BlendModeColorFilter mBlendModeColorFilter;
    private ColorFilter mColorFilter;
    private boolean mMutated;
    private int mTargetDensity;
    private int mDpiScaledWidth = 0;
    private int mDpiScaledHeight = 0;
    private Insets mDpiScaledInsets = Insets.NONE;
    private boolean mDpiScaledDirty = true;
    private final Rect mTmpBounds = new Rect();

    public VectorDrawable() {
        this(new VectorDrawableState(null), null);
    }

    private VectorDrawable(VectorDrawableState state, Resources res) {
        this.mVectorState = state;
        this.updateLocalState(res);
    }

    private void updateLocalState(Resources res) {
        int density = Drawable.resolveDensity(res, this.mVectorState.mDensity);
        if (this.mTargetDensity != density) {
            this.mTargetDensity = density;
            this.mDpiScaledDirty = true;
        }
        this.updateColorFilters(this.mVectorState.mBlendMode, this.mVectorState.mTint);
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mVectorState = new VectorDrawableState(this.mVectorState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @UnsupportedAppUsage
    Object getTargetByName(String name) {
        return this.mVectorState.mVGTargetsMap.get(name);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mVectorState;
    }

    @Override
    public void draw(Canvas canvas) {
        int deltaInBytes;
        this.copyBounds(this.mTmpBounds);
        if (this.mTmpBounds.width() <= 0 || this.mTmpBounds.height() <= 0) {
            return;
        }
        ColorFilter colorFilter = this.mColorFilter == null ? this.mBlendModeColorFilter : this.mColorFilter;
        long colorFilterNativeInstance = colorFilter == null ? 0L : colorFilter.getNativeInstance();
        boolean canReuseCache = this.mVectorState.canReuseCache();
        int pixelCount = VectorDrawable.nDraw(this.mVectorState.getNativeRenderer(), canvas.getNativeCanvasWrapper(), colorFilterNativeInstance, this.mTmpBounds, this.needMirroring(), canReuseCache);
        if (pixelCount == 0) {
            return;
        }
        if (canvas.isHardwareAccelerated()) {
            deltaInBytes = (pixelCount - this.mVectorState.mLastHWCachePixelCount) * 4;
            this.mVectorState.mLastHWCachePixelCount = pixelCount;
        } else {
            deltaInBytes = (pixelCount - this.mVectorState.mLastSWCachePixelCount) * 4;
            this.mVectorState.mLastSWCachePixelCount = pixelCount;
        }
        if (deltaInBytes > 0) {
            VMRuntime.getRuntime().registerNativeAllocation(deltaInBytes);
        } else if (deltaInBytes < 0) {
            VMRuntime.getRuntime().registerNativeFree(-deltaInBytes);
        }
    }

    @Override
    public int getAlpha() {
        return (int)(this.mVectorState.getAlpha() * 255.0f);
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.mVectorState.setAlpha((float)alpha / 255.0f)) {
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    @Override
    public void setTintList(ColorStateList tint) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTint != tint) {
            state.mTint = tint;
            this.updateColorFilters(this.mVectorState.mBlendMode, tint);
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintBlendMode(BlendMode blendMode) {
        VectorDrawableState state = this.mVectorState;
        if (state.mBlendMode != blendMode) {
            state.mBlendMode = blendMode;
            this.updateColorFilters(state.mBlendMode, state.mTint);
            this.invalidateSelf();
        }
    }

    @Override
    public boolean isStateful() {
        return super.isStateful() || this.mVectorState != null && this.mVectorState.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mVectorState != null && this.mVectorState.hasFocusStateSpecified();
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        VectorDrawableState state;
        boolean changed = false;
        if (this.isStateful()) {
            this.mutate();
        }
        if ((state = this.mVectorState).onStateChange(stateSet)) {
            changed = true;
            state.mCacheDirty = true;
        }
        if (state.mTint != null && state.mBlendMode != null) {
            BlendMode blendMode = state.mBlendMode;
            ColorStateList tint = state.mTint;
            this.updateColorFilters(blendMode, tint);
            changed = true;
        }
        return changed;
    }

    private void updateColorFilters(BlendMode blendMode, ColorStateList tint) {
        PorterDuff.Mode mode = BlendMode.blendModeToPorterDuffMode(blendMode);
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, mode);
        this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, tint, blendMode);
    }

    @Override
    public int getOpacity() {
        return this.getAlpha() == 0 ? -2 : -3;
    }

    @Override
    public int getIntrinsicWidth() {
        if (this.mDpiScaledDirty) {
            this.computeVectorSize();
        }
        return this.mDpiScaledWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        if (this.mDpiScaledDirty) {
            this.computeVectorSize();
        }
        return this.mDpiScaledHeight;
    }

    @Override
    public Insets getOpticalInsets() {
        if (this.mDpiScaledDirty) {
            this.computeVectorSize();
        }
        return this.mDpiScaledInsets;
    }

    void computeVectorSize() {
        Insets opticalInsets = this.mVectorState.mOpticalInsets;
        int targetDensity = this.mTargetDensity;
        int sourceDensity = this.mVectorState.mDensity;
        if (targetDensity != sourceDensity) {
            this.mDpiScaledWidth = Drawable.scaleFromDensity(this.mVectorState.mBaseWidth, sourceDensity, targetDensity, true);
            this.mDpiScaledHeight = Drawable.scaleFromDensity(this.mVectorState.mBaseHeight, sourceDensity, targetDensity, true);
            int left = Drawable.scaleFromDensity(opticalInsets.left, sourceDensity, targetDensity, false);
            int right = Drawable.scaleFromDensity(opticalInsets.right, sourceDensity, targetDensity, false);
            int top = Drawable.scaleFromDensity(opticalInsets.top, sourceDensity, targetDensity, false);
            int bottom = Drawable.scaleFromDensity(opticalInsets.bottom, sourceDensity, targetDensity, false);
            this.mDpiScaledInsets = Insets.of(left, top, right, bottom);
        } else {
            this.mDpiScaledWidth = this.mVectorState.mBaseWidth;
            this.mDpiScaledHeight = this.mVectorState.mBaseHeight;
            this.mDpiScaledInsets = opticalInsets;
        }
        this.mDpiScaledDirty = false;
    }

    @Override
    public boolean canApplyTheme() {
        return this.mVectorState != null && this.mVectorState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        VectorDrawableState state = this.mVectorState;
        if (state == null) {
            return;
        }
        boolean changedDensity = this.mVectorState.setDensity(Drawable.resolveDensity(t.getResources(), 0));
        this.mDpiScaledDirty |= changedDensity;
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.VectorDrawable);
            try {
                state.mCacheDirty = true;
                this.updateStateFromTypedArray(a);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
            finally {
                a.recycle();
            }
            this.mDpiScaledDirty = true;
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        if (this.mVectorState != null && this.mVectorState.canApplyTheme()) {
            this.mVectorState.applyTheme(t);
        }
        this.updateLocalState(t.getResources());
    }

    public float getPixelSize() {
        if (this.mVectorState == null || this.mVectorState.mBaseWidth == 0 || this.mVectorState.mBaseHeight == 0 || this.mVectorState.mViewportHeight == 0.0f || this.mVectorState.mViewportWidth == 0.0f) {
            return 1.0f;
        }
        float intrinsicWidth = this.mVectorState.mBaseWidth;
        float intrinsicHeight = this.mVectorState.mBaseHeight;
        float viewportWidth = this.mVectorState.mViewportWidth;
        float viewportHeight = this.mVectorState.mViewportHeight;
        float scaleX = viewportWidth / intrinsicWidth;
        float scaleY = viewportHeight / intrinsicHeight;
        return Math.min(scaleX, scaleY);
    }

    public static VectorDrawable create(Resources resources, int rid) {
        try {
            int type;
            XmlResourceParser parser = resources.getXml(rid);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            VectorDrawable drawable2 = new VectorDrawable();
            drawable2.inflate(resources, parser, attrs);
            return drawable2;
        }
        catch (XmlPullParserException e) {
            Log.e(LOGTAG, "parser error", e);
        }
        catch (IOException e) {
            Log.e(LOGTAG, "parser error", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        try {
            Trace.traceBegin(8192L, "VectorDrawable#inflate");
            if (this.mVectorState.mRootGroup != null || this.mVectorState.mNativeTree != null) {
                if (this.mVectorState.mRootGroup != null) {
                    VMRuntime.getRuntime().registerNativeFree(this.mVectorState.mRootGroup.getNativeSize());
                    this.mVectorState.mRootGroup.setTree(null);
                }
                this.mVectorState.mRootGroup = new VGroup();
                if (this.mVectorState.mNativeTree != null) {
                    VMRuntime.getRuntime().registerNativeFree(316);
                    this.mVectorState.mNativeTree.release();
                }
                this.mVectorState.createNativeTree(this.mVectorState.mRootGroup);
            }
            VectorDrawableState state = this.mVectorState;
            state.setDensity(Drawable.resolveDensity(r, 0));
            TypedArray a = VectorDrawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
            this.mDpiScaledDirty = true;
            state.mCacheDirty = true;
            this.inflateChildElements(r, parser, attrs, theme);
            state.onTreeConstructionFinished();
            this.updateLocalState(r);
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private void updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        ColorStateList tint;
        VectorDrawableState state = this.mVectorState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        int tintMode = a.getInt(6, -1);
        if (tintMode != -1) {
            state.mBlendMode = Drawable.parseBlendMode(tintMode, BlendMode.SRC_IN);
        }
        if ((tint = a.getColorStateList(1)) != null) {
            state.mTint = tint;
        }
        state.mAutoMirrored = a.getBoolean(5, state.mAutoMirrored);
        float viewportWidth = a.getFloat(7, state.mViewportWidth);
        float viewportHeight = a.getFloat(8, state.mViewportHeight);
        state.setViewportSize(viewportWidth, viewportHeight);
        if (state.mViewportWidth <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportWidth > 0");
        }
        if (state.mViewportHeight <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportHeight > 0");
        }
        state.mBaseWidth = a.getDimensionPixelSize(3, state.mBaseWidth);
        state.mBaseHeight = a.getDimensionPixelSize(2, state.mBaseHeight);
        if (state.mBaseWidth <= 0) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires width > 0");
        }
        if (state.mBaseHeight <= 0) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires height > 0");
        }
        int insetLeft = a.getDimensionPixelOffset(9, state.mOpticalInsets.left);
        int insetTop = a.getDimensionPixelOffset(10, state.mOpticalInsets.top);
        int insetRight = a.getDimensionPixelOffset(11, state.mOpticalInsets.right);
        int insetBottom = a.getDimensionPixelOffset(12, state.mOpticalInsets.bottom);
        state.mOpticalInsets = Insets.of(insetLeft, insetTop, insetRight, insetBottom);
        float alphaInFloat = a.getFloat(4, state.getAlpha());
        state.setAlpha(alphaInFloat);
        String name = a.getString(0);
        if (name != null) {
            state.mRootName = name;
            state.mVGTargetsMap.put(name, state);
        }
    }

    private void inflateChildElements(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VectorDrawableState state = this.mVectorState;
        boolean noPathTag = true;
        Stack<VGroup> groupStack = new Stack<VGroup>();
        groupStack.push(state.mRootGroup);
        int eventType = parser.getEventType();
        int innerDepth = parser.getDepth() + 1;
        while (eventType != 1 && (parser.getDepth() >= innerDepth || eventType != 3)) {
            String tagName;
            if (eventType == 2) {
                VPath path;
                tagName = parser.getName();
                VGroup currentGroup = (VGroup)groupStack.peek();
                if (SHAPE_PATH.equals(tagName)) {
                    path = new VFullPath();
                    ((VFullPath)path).inflate(res, attrs, theme);
                    currentGroup.addChild(path);
                    if (path.getPathName() != null) {
                        state.mVGTargetsMap.put(path.getPathName(), path);
                    }
                    noPathTag = false;
                    state.mChangingConfigurations |= ((VFullPath)path).mChangingConfigurations;
                } else if (SHAPE_CLIP_PATH.equals(tagName)) {
                    path = new VClipPath();
                    ((VClipPath)path).inflate(res, attrs, theme);
                    currentGroup.addChild(path);
                    if (path.getPathName() != null) {
                        state.mVGTargetsMap.put(path.getPathName(), path);
                    }
                    state.mChangingConfigurations |= ((VClipPath)path).mChangingConfigurations;
                } else if (SHAPE_GROUP.equals(tagName)) {
                    VGroup newChildGroup = new VGroup();
                    newChildGroup.inflate(res, attrs, theme);
                    currentGroup.addChild(newChildGroup);
                    groupStack.push(newChildGroup);
                    if (newChildGroup.getGroupName() != null) {
                        state.mVGTargetsMap.put(newChildGroup.getGroupName(), newChildGroup);
                    }
                    state.mChangingConfigurations |= newChildGroup.mChangingConfigurations;
                }
            } else if (eventType == 3 && SHAPE_GROUP.equals(tagName = parser.getName())) {
                groupStack.pop();
            }
            eventType = parser.next();
        }
        if (noPathTag) {
            StringBuffer tag = new StringBuffer();
            if (tag.length() > 0) {
                tag.append(" or ");
            }
            tag.append(SHAPE_PATH);
            throw new XmlPullParserException("no " + tag + " defined");
        }
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mVectorState.getChangingConfigurations();
    }

    @UnsupportedAppUsage
    void setAllowCaching(boolean allowCaching) {
        VectorDrawable.nSetAllowCaching(this.mVectorState.getNativeRenderer(), allowCaching);
    }

    private boolean needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        if (this.mVectorState.mAutoMirrored != mirrored) {
            this.mVectorState.mAutoMirrored = mirrored;
            this.invalidateSelf();
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mVectorState.mAutoMirrored;
    }

    public long getNativeTree() {
        return this.mVectorState.getNativeRenderer();
    }

    public void setAntiAlias(boolean aa) {
        VectorDrawable.nSetAntiAlias(this.mVectorState.mNativeTree.get(), aa);
    }

    @LayoutlibDelegate
    private static int nDraw(long l, long l2, long l3, Rect rect, boolean bl, boolean bl2) {
        return VectorDrawable_Delegate.nDraw(l, l2, l3, rect, bl, bl2);
    }

    @LayoutlibDelegate
    private static boolean nGetFullPathProperties(long l, byte[] byArray, int n) {
        return VectorDrawable_Delegate.nGetFullPathProperties(l, byArray, n);
    }

    @LayoutlibDelegate
    private static void nSetName(long l, String string2) {
        VectorDrawable_Delegate.nSetName(l, string2);
    }

    @LayoutlibDelegate
    private static boolean nGetGroupProperties(long l, float[] fArray, int n) {
        return VectorDrawable_Delegate.nGetGroupProperties(l, fArray, n);
    }

    @LayoutlibDelegate
    private static void nSetPathString(long l, String string2, int n) {
        VectorDrawable_Delegate.nSetPathString(l, string2, n);
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateTree(long l) {
        return VectorDrawable_Delegate.nCreateTree(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateTreeFromCopy(long l, long l2) {
        return VectorDrawable_Delegate.nCreateTreeFromCopy(l, l2);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetRendererViewportSize(long l, float f, float f2) {
        VectorDrawable_Delegate.nSetRendererViewportSize(l, f, f2);
    }

    @LayoutlibDelegate
    @FastNative
    private static boolean nSetRootAlpha(long l, float f) {
        return VectorDrawable_Delegate.nSetRootAlpha(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetRootAlpha(long l) {
        return VectorDrawable_Delegate.nGetRootAlpha(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetAntiAlias(long l, boolean bl) {
        VectorDrawable_Delegate.nSetAntiAlias(l, bl);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetAllowCaching(long l, boolean bl) {
        VectorDrawable_Delegate.nSetAllowCaching(l, bl);
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateFullPath() {
        return VectorDrawable_Delegate.nCreateFullPath();
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateFullPath(long l) {
        return VectorDrawable_Delegate.nCreateFullPath(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nUpdateFullPathProperties(long l, float f, int n, float f2, int n2, float f3, float f4, float f5, float f6, float f7, int n3, int n4, int n5) {
        VectorDrawable_Delegate.nUpdateFullPathProperties(l, f, n, f2, n2, f3, f4, f5, f6, f7, n3, n4, n5);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nUpdateFullPathFillGradient(long l, long l2) {
        VectorDrawable_Delegate.nUpdateFullPathFillGradient(l, l2);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nUpdateFullPathStrokeGradient(long l, long l2) {
        VectorDrawable_Delegate.nUpdateFullPathStrokeGradient(l, l2);
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateClipPath() {
        return VectorDrawable_Delegate.nCreateClipPath();
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateClipPath(long l) {
        return VectorDrawable_Delegate.nCreateClipPath(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateGroup() {
        return VectorDrawable_Delegate.nCreateGroup();
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateGroup(long l) {
        return VectorDrawable_Delegate.nCreateGroup(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nUpdateGroupProperties(long l, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        VectorDrawable_Delegate.nUpdateGroupProperties(l, f, f2, f3, f4, f5, f6, f7);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nAddChild(long l, long l2) {
        VectorDrawable_Delegate.nAddChild(l, l2);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetRotation(long l) {
        return VectorDrawable_Delegate.nGetRotation(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetRotation(long l, float f) {
        VectorDrawable_Delegate.nSetRotation(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetPivotX(long l) {
        return VectorDrawable_Delegate.nGetPivotX(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetPivotX(long l, float f) {
        VectorDrawable_Delegate.nSetPivotX(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetPivotY(long l) {
        return VectorDrawable_Delegate.nGetPivotY(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetPivotY(long l, float f) {
        VectorDrawable_Delegate.nSetPivotY(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetScaleX(long l) {
        return VectorDrawable_Delegate.nGetScaleX(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetScaleX(long l, float f) {
        VectorDrawable_Delegate.nSetScaleX(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetScaleY(long l) {
        return VectorDrawable_Delegate.nGetScaleY(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetScaleY(long l, float f) {
        VectorDrawable_Delegate.nSetScaleY(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetTranslateX(long l) {
        return VectorDrawable_Delegate.nGetTranslateX(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetTranslateX(long l, float f) {
        VectorDrawable_Delegate.nSetTranslateX(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetTranslateY(long l) {
        return VectorDrawable_Delegate.nGetTranslateY(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetTranslateY(long l, float f) {
        VectorDrawable_Delegate.nSetTranslateY(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetPathData(long l, long l2) {
        VectorDrawable_Delegate.nSetPathData(l, l2);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetStrokeWidth(long l) {
        return VectorDrawable_Delegate.nGetStrokeWidth(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetStrokeWidth(long l, float f) {
        VectorDrawable_Delegate.nSetStrokeWidth(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static int nGetStrokeColor(long l) {
        return VectorDrawable_Delegate.nGetStrokeColor(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetStrokeColor(long l, int n) {
        VectorDrawable_Delegate.nSetStrokeColor(l, n);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetStrokeAlpha(long l) {
        return VectorDrawable_Delegate.nGetStrokeAlpha(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetStrokeAlpha(long l, float f) {
        VectorDrawable_Delegate.nSetStrokeAlpha(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static int nGetFillColor(long l) {
        return VectorDrawable_Delegate.nGetFillColor(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetFillColor(long l, int n) {
        VectorDrawable_Delegate.nSetFillColor(l, n);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetFillAlpha(long l) {
        return VectorDrawable_Delegate.nGetFillAlpha(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetFillAlpha(long l, float f) {
        VectorDrawable_Delegate.nSetFillAlpha(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetTrimPathStart(long l) {
        return VectorDrawable_Delegate.nGetTrimPathStart(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetTrimPathStart(long l, float f) {
        VectorDrawable_Delegate.nSetTrimPathStart(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetTrimPathEnd(long l) {
        return VectorDrawable_Delegate.nGetTrimPathEnd(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetTrimPathEnd(long l, float f) {
        VectorDrawable_Delegate.nSetTrimPathEnd(l, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetTrimPathOffset(long l) {
        return VectorDrawable_Delegate.nGetTrimPathOffset(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetTrimPathOffset(long l, float f) {
        VectorDrawable_Delegate.nSetTrimPathOffset(l, f);
    }

    static abstract class VObject {
        VirtualRefBasePtr mTreePtr = null;

        VObject() {
        }

        boolean isTreeValid() {
            return this.mTreePtr != null && this.mTreePtr.get() != 0L;
        }

        void setTree(VirtualRefBasePtr ptr) {
            this.mTreePtr = ptr;
        }

        abstract long getNativePtr();

        abstract void inflate(Resources var1, AttributeSet var2, Resources.Theme var3);

        abstract boolean canApplyTheme();

        abstract void applyTheme(Resources.Theme var1);

        abstract boolean onStateChange(int[] var1);

        abstract boolean isStateful();

        abstract boolean hasFocusStateSpecified();

        abstract int getNativeSize();

        abstract Property getProperty(String var1);
    }

    static class VFullPath
    extends VPath {
        private static final int STROKE_WIDTH_INDEX = 0;
        private static final int STROKE_COLOR_INDEX = 1;
        private static final int STROKE_ALPHA_INDEX = 2;
        private static final int FILL_COLOR_INDEX = 3;
        private static final int FILL_ALPHA_INDEX = 4;
        private static final int TRIM_PATH_START_INDEX = 5;
        private static final int TRIM_PATH_END_INDEX = 6;
        private static final int TRIM_PATH_OFFSET_INDEX = 7;
        private static final int STROKE_LINE_CAP_INDEX = 8;
        private static final int STROKE_LINE_JOIN_INDEX = 9;
        private static final int STROKE_MITER_LIMIT_INDEX = 10;
        private static final int FILL_TYPE_INDEX = 11;
        private static final int TOTAL_PROPERTY_COUNT = 12;
        private static final int NATIVE_ALLOCATION_SIZE = 264;
        private static final HashMap<String, Integer> sPropertyIndexMap = new HashMap<String, Integer>(){
            {
                this.put("strokeWidth", 0);
                this.put("strokeColor", 1);
                this.put("strokeAlpha", 2);
                this.put("fillColor", 3);
                this.put("fillAlpha", 4);
                this.put("trimPathStart", 5);
                this.put("trimPathEnd", 6);
                this.put("trimPathOffset", 7);
            }
        };
        private static final Property<VFullPath, Float> STROKE_WIDTH = new FloatProperty<VFullPath>("strokeWidth"){

            @Override
            public void setValue(VFullPath object, float value) {
                object.setStrokeWidth(value);
            }

            @Override
            public Float get(VFullPath object) {
                return Float.valueOf(object.getStrokeWidth());
            }
        };
        private static final Property<VFullPath, Integer> STROKE_COLOR = new IntProperty<VFullPath>("strokeColor"){

            @Override
            public void setValue(VFullPath object, int value) {
                object.setStrokeColor(value);
            }

            @Override
            public Integer get(VFullPath object) {
                return object.getStrokeColor();
            }
        };
        private static final Property<VFullPath, Float> STROKE_ALPHA = new FloatProperty<VFullPath>("strokeAlpha"){

            @Override
            public void setValue(VFullPath object, float value) {
                object.setStrokeAlpha(value);
            }

            @Override
            public Float get(VFullPath object) {
                return Float.valueOf(object.getStrokeAlpha());
            }
        };
        private static final Property<VFullPath, Integer> FILL_COLOR = new IntProperty<VFullPath>("fillColor"){

            @Override
            public void setValue(VFullPath object, int value) {
                object.setFillColor(value);
            }

            @Override
            public Integer get(VFullPath object) {
                return object.getFillColor();
            }
        };
        private static final Property<VFullPath, Float> FILL_ALPHA = new FloatProperty<VFullPath>("fillAlpha"){

            @Override
            public void setValue(VFullPath object, float value) {
                object.setFillAlpha(value);
            }

            @Override
            public Float get(VFullPath object) {
                return Float.valueOf(object.getFillAlpha());
            }
        };
        private static final Property<VFullPath, Float> TRIM_PATH_START = new FloatProperty<VFullPath>("trimPathStart"){

            @Override
            public void setValue(VFullPath object, float value) {
                object.setTrimPathStart(value);
            }

            @Override
            public Float get(VFullPath object) {
                return Float.valueOf(object.getTrimPathStart());
            }
        };
        private static final Property<VFullPath, Float> TRIM_PATH_END = new FloatProperty<VFullPath>("trimPathEnd"){

            @Override
            public void setValue(VFullPath object, float value) {
                object.setTrimPathEnd(value);
            }

            @Override
            public Float get(VFullPath object) {
                return Float.valueOf(object.getTrimPathEnd());
            }
        };
        private static final Property<VFullPath, Float> TRIM_PATH_OFFSET = new FloatProperty<VFullPath>("trimPathOffset"){

            @Override
            public void setValue(VFullPath object, float value) {
                object.setTrimPathOffset(value);
            }

            @Override
            public Float get(VFullPath object) {
                return Float.valueOf(object.getTrimPathOffset());
            }
        };
        private static final HashMap<String, Property> sPropertyMap = new HashMap<String, Property>(){
            {
                this.put("strokeWidth", STROKE_WIDTH);
                this.put("strokeColor", STROKE_COLOR);
                this.put("strokeAlpha", STROKE_ALPHA);
                this.put("fillColor", FILL_COLOR);
                this.put("fillAlpha", FILL_ALPHA);
                this.put("trimPathStart", TRIM_PATH_START);
                this.put("trimPathEnd", TRIM_PATH_END);
                this.put("trimPathOffset", TRIM_PATH_OFFSET);
            }
        };
        private byte[] mPropertyData;
        private int[] mThemeAttrs;
        ComplexColor mStrokeColors = null;
        ComplexColor mFillColors = null;
        private final long mNativePtr;

        public VFullPath() {
            this.mNativePtr = VectorDrawable.nCreateFullPath();
        }

        public VFullPath(VFullPath copy) {
            super(copy);
            this.mNativePtr = VectorDrawable.nCreateFullPath(copy.mNativePtr);
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mStrokeColors = copy.mStrokeColors;
            this.mFillColors = copy.mFillColors;
        }

        @Override
        Property getProperty(String propertyName) {
            Property p = super.getProperty(propertyName);
            if (p != null) {
                return p;
            }
            if (sPropertyMap.containsKey(propertyName)) {
                return sPropertyMap.get(propertyName);
            }
            return null;
        }

        int getPropertyIndex(String propertyName) {
            if (!sPropertyIndexMap.containsKey(propertyName)) {
                return -1;
            }
            return sPropertyIndexMap.get(propertyName);
        }

        @Override
        public boolean onStateChange(int[] stateSet) {
            boolean changed = false;
            if (this.mStrokeColors != null && this.mStrokeColors instanceof ColorStateList) {
                int newStrokeColor;
                int oldStrokeColor = this.getStrokeColor();
                changed |= oldStrokeColor != (newStrokeColor = ((ColorStateList)this.mStrokeColors).getColorForState(stateSet, oldStrokeColor));
                if (oldStrokeColor != newStrokeColor) {
                    VectorDrawable.nSetStrokeColor(this.mNativePtr, newStrokeColor);
                }
            }
            if (this.mFillColors != null && this.mFillColors instanceof ColorStateList) {
                int newFillColor;
                int oldFillColor = this.getFillColor();
                changed |= oldFillColor != (newFillColor = ((ColorStateList)this.mFillColors).getColorForState(stateSet, oldFillColor));
                if (oldFillColor != newFillColor) {
                    VectorDrawable.nSetFillColor(this.mNativePtr, newFillColor);
                }
            }
            return changed;
        }

        @Override
        public boolean isStateful() {
            return this.mStrokeColors != null || this.mFillColors != null;
        }

        @Override
        public boolean hasFocusStateSpecified() {
            return this.mStrokeColors != null && this.mStrokeColors instanceof ColorStateList && ((ColorStateList)this.mStrokeColors).hasFocusStateSpecified() && this.mFillColors != null && this.mFillColors instanceof ColorStateList && ((ColorStateList)this.mFillColors).hasFocusStateSpecified();
        }

        @Override
        int getNativeSize() {
            return 264;
        }

        @Override
        public long getNativePtr() {
            return this.mNativePtr;
        }

        @Override
        public void inflate(Resources r, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawablePath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private void updateStateFromTypedArray(TypedArray a) {
            ComplexColor strokeColors;
            ComplexColor fillColors;
            String pathString;
            boolean success;
            int byteCount = 48;
            if (this.mPropertyData == null) {
                this.mPropertyData = new byte[byteCount];
            }
            if (!(success = VectorDrawable.nGetFullPathProperties(this.mNativePtr, this.mPropertyData, byteCount))) {
                throw new RuntimeException("Error: inconsistent property count");
            }
            ByteBuffer properties = ByteBuffer.wrap(this.mPropertyData);
            properties.order(ByteOrder.nativeOrder());
            float strokeWidth = properties.getFloat(0);
            int strokeColor = properties.getInt(4);
            float strokeAlpha = properties.getFloat(8);
            int fillColor = properties.getInt(12);
            float fillAlpha = properties.getFloat(16);
            float trimPathStart = properties.getFloat(20);
            float trimPathEnd = properties.getFloat(24);
            float trimPathOffset = properties.getFloat(28);
            int strokeLineCap = properties.getInt(32);
            int strokeLineJoin = properties.getInt(36);
            float strokeMiterLimit = properties.getFloat(40);
            int fillType = properties.getInt(44);
            Shader fillGradient = null;
            Shader strokeGradient = null;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            this.mThemeAttrs = a.extractThemeAttrs();
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
                VectorDrawable.nSetName(this.mNativePtr, this.mPathName);
            }
            if ((pathString = a.getString(2)) != null) {
                this.mPathData = new PathParser.PathData(pathString);
                VectorDrawable.nSetPathString(this.mNativePtr, pathString, pathString.length());
            }
            if ((fillColors = a.getComplexColor(1)) != null) {
                if (fillColors instanceof GradientColor) {
                    this.mFillColors = fillColors;
                    fillGradient = ((GradientColor)fillColors).getShader();
                } else {
                    this.mFillColors = fillColors.isStateful() || fillColors.canApplyTheme() ? fillColors : null;
                }
                fillColor = fillColors.getDefaultColor();
            }
            if ((strokeColors = a.getComplexColor(3)) != null) {
                if (strokeColors instanceof GradientColor) {
                    this.mStrokeColors = strokeColors;
                    strokeGradient = ((GradientColor)strokeColors).getShader();
                } else {
                    this.mStrokeColors = strokeColors.isStateful() || strokeColors.canApplyTheme() ? strokeColors : null;
                }
                strokeColor = strokeColors.getDefaultColor();
            }
            VectorDrawable.nUpdateFullPathFillGradient(this.mNativePtr, fillGradient != null ? fillGradient.getNativeInstance() : 0L);
            VectorDrawable.nUpdateFullPathStrokeGradient(this.mNativePtr, strokeGradient != null ? strokeGradient.getNativeInstance() : 0L);
            fillAlpha = a.getFloat(12, fillAlpha);
            strokeLineCap = a.getInt(8, strokeLineCap);
            strokeLineJoin = a.getInt(9, strokeLineJoin);
            strokeMiterLimit = a.getFloat(10, strokeMiterLimit);
            strokeAlpha = a.getFloat(11, strokeAlpha);
            strokeWidth = a.getFloat(4, strokeWidth);
            trimPathEnd = a.getFloat(6, trimPathEnd);
            trimPathOffset = a.getFloat(7, trimPathOffset);
            trimPathStart = a.getFloat(5, trimPathStart);
            fillType = a.getInt(13, fillType);
            VectorDrawable.nUpdateFullPathProperties(this.mNativePtr, strokeWidth, strokeColor, strokeAlpha, fillColor, fillAlpha, trimPathStart, trimPathEnd, trimPathOffset, strokeMiterLimit, strokeLineCap, strokeLineJoin, fillType);
        }

        @Override
        public boolean canApplyTheme() {
            if (this.mThemeAttrs != null) {
                return true;
            }
            boolean fillCanApplyTheme = this.canComplexColorApplyTheme(this.mFillColors);
            boolean strokeCanApplyTheme = this.canComplexColorApplyTheme(this.mStrokeColors);
            return fillCanApplyTheme || strokeCanApplyTheme;
        }

        @Override
        public void applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawablePath);
                this.updateStateFromTypedArray(a);
                a.recycle();
            }
            boolean fillCanApplyTheme = this.canComplexColorApplyTheme(this.mFillColors);
            boolean strokeCanApplyTheme = this.canComplexColorApplyTheme(this.mStrokeColors);
            if (fillCanApplyTheme) {
                this.mFillColors = this.mFillColors.obtainForTheme(t);
                if (this.mFillColors instanceof GradientColor) {
                    VectorDrawable.nUpdateFullPathFillGradient(this.mNativePtr, ((GradientColor)this.mFillColors).getShader().getNativeInstance());
                } else if (this.mFillColors instanceof ColorStateList) {
                    VectorDrawable.nSetFillColor(this.mNativePtr, this.mFillColors.getDefaultColor());
                }
            }
            if (strokeCanApplyTheme) {
                this.mStrokeColors = this.mStrokeColors.obtainForTheme(t);
                if (this.mStrokeColors instanceof GradientColor) {
                    VectorDrawable.nUpdateFullPathStrokeGradient(this.mNativePtr, ((GradientColor)this.mStrokeColors).getShader().getNativeInstance());
                } else if (this.mStrokeColors instanceof ColorStateList) {
                    VectorDrawable.nSetStrokeColor(this.mNativePtr, this.mStrokeColors.getDefaultColor());
                }
            }
        }

        private boolean canComplexColorApplyTheme(ComplexColor complexColor) {
            return complexColor != null && complexColor.canApplyTheme();
        }

        int getStrokeColor() {
            return this.isTreeValid() ? VectorDrawable.nGetStrokeColor(this.mNativePtr) : 0;
        }

        void setStrokeColor(int strokeColor) {
            this.mStrokeColors = null;
            if (this.isTreeValid()) {
                VectorDrawable.nSetStrokeColor(this.mNativePtr, strokeColor);
            }
        }

        float getStrokeWidth() {
            return this.isTreeValid() ? VectorDrawable.nGetStrokeWidth(this.mNativePtr) : 0.0f;
        }

        void setStrokeWidth(float strokeWidth) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetStrokeWidth(this.mNativePtr, strokeWidth);
            }
        }

        float getStrokeAlpha() {
            return this.isTreeValid() ? VectorDrawable.nGetStrokeAlpha(this.mNativePtr) : 0.0f;
        }

        void setStrokeAlpha(float strokeAlpha) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetStrokeAlpha(this.mNativePtr, strokeAlpha);
            }
        }

        int getFillColor() {
            return this.isTreeValid() ? VectorDrawable.nGetFillColor(this.mNativePtr) : 0;
        }

        void setFillColor(int fillColor) {
            this.mFillColors = null;
            if (this.isTreeValid()) {
                VectorDrawable.nSetFillColor(this.mNativePtr, fillColor);
            }
        }

        float getFillAlpha() {
            return this.isTreeValid() ? VectorDrawable.nGetFillAlpha(this.mNativePtr) : 0.0f;
        }

        void setFillAlpha(float fillAlpha) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetFillAlpha(this.mNativePtr, fillAlpha);
            }
        }

        float getTrimPathStart() {
            return this.isTreeValid() ? VectorDrawable.nGetTrimPathStart(this.mNativePtr) : 0.0f;
        }

        void setTrimPathStart(float trimPathStart) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTrimPathStart(this.mNativePtr, trimPathStart);
            }
        }

        float getTrimPathEnd() {
            return this.isTreeValid() ? VectorDrawable.nGetTrimPathEnd(this.mNativePtr) : 0.0f;
        }

        void setTrimPathEnd(float trimPathEnd) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTrimPathEnd(this.mNativePtr, trimPathEnd);
            }
        }

        float getTrimPathOffset() {
            return this.isTreeValid() ? VectorDrawable.nGetTrimPathOffset(this.mNativePtr) : 0.0f;
        }

        void setTrimPathOffset(float trimPathOffset) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTrimPathOffset(this.mNativePtr, trimPathOffset);
            }
        }
    }

    private static class VClipPath
    extends VPath {
        private final long mNativePtr;
        private static final int NATIVE_ALLOCATION_SIZE = 120;

        public VClipPath() {
            this.mNativePtr = VectorDrawable.nCreateClipPath();
        }

        public VClipPath(VClipPath copy) {
            super(copy);
            this.mNativePtr = VectorDrawable.nCreateClipPath(copy.mNativePtr);
        }

        @Override
        public long getNativePtr() {
            return this.mNativePtr;
        }

        @Override
        public void inflate(Resources r, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawableClipPath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        @Override
        public boolean canApplyTheme() {
            return false;
        }

        @Override
        public void applyTheme(Resources.Theme theme) {
        }

        @Override
        public boolean onStateChange(int[] stateSet) {
            return false;
        }

        @Override
        public boolean isStateful() {
            return false;
        }

        @Override
        public boolean hasFocusStateSpecified() {
            return false;
        }

        @Override
        int getNativeSize() {
            return 120;
        }

        private void updateStateFromTypedArray(TypedArray a) {
            String pathDataString;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
                VectorDrawable.nSetName(this.mNativePtr, this.mPathName);
            }
            if ((pathDataString = a.getString(1)) != null) {
                this.mPathData = new PathParser.PathData(pathDataString);
                VectorDrawable.nSetPathString(this.mNativePtr, pathDataString, pathDataString.length());
            }
        }
    }

    static abstract class VPath
    extends VObject {
        protected PathParser.PathData mPathData = null;
        String mPathName;
        int mChangingConfigurations;
        private static final Property<VPath, PathParser.PathData> PATH_DATA = new Property<VPath, PathParser.PathData>(PathParser.PathData.class, "pathData"){

            @Override
            public void set(VPath object, PathParser.PathData data) {
                object.setPathData(data);
            }

            @Override
            public PathParser.PathData get(VPath object) {
                return object.getPathData();
            }
        };

        @Override
        Property getProperty(String propertyName) {
            if (PATH_DATA.getName().equals(propertyName)) {
                return PATH_DATA;
            }
            return null;
        }

        public VPath() {
        }

        public VPath(VPath copy) {
            this.mPathName = copy.mPathName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mPathData = copy.mPathData == null ? null : new PathParser.PathData(copy.mPathData);
        }

        public String getPathName() {
            return this.mPathName;
        }

        public PathParser.PathData getPathData() {
            return this.mPathData;
        }

        public void setPathData(PathParser.PathData pathData) {
            this.mPathData.setPathData(pathData);
            if (this.isTreeValid()) {
                VectorDrawable.nSetPathData(this.getNativePtr(), this.mPathData.getNativePtr());
            }
        }
    }

    static class VGroup
    extends VObject {
        private static final int ROTATION_INDEX = 0;
        private static final int PIVOT_X_INDEX = 1;
        private static final int PIVOT_Y_INDEX = 2;
        private static final int SCALE_X_INDEX = 3;
        private static final int SCALE_Y_INDEX = 4;
        private static final int TRANSLATE_X_INDEX = 5;
        private static final int TRANSLATE_Y_INDEX = 6;
        private static final int TRANSFORM_PROPERTY_COUNT = 7;
        private static final int NATIVE_ALLOCATION_SIZE = 100;
        private static final HashMap<String, Integer> sPropertyIndexMap = new HashMap<String, Integer>(){
            {
                this.put("translateX", 5);
                this.put("translateY", 6);
                this.put("scaleX", 3);
                this.put("scaleY", 4);
                this.put("pivotX", 1);
                this.put("pivotY", 2);
                this.put("rotation", 0);
            }
        };
        private static final Property<VGroup, Float> TRANSLATE_X = new FloatProperty<VGroup>("translateX"){

            @Override
            public void setValue(VGroup object, float value) {
                object.setTranslateX(value);
            }

            @Override
            public Float get(VGroup object) {
                return Float.valueOf(object.getTranslateX());
            }
        };
        private static final Property<VGroup, Float> TRANSLATE_Y = new FloatProperty<VGroup>("translateY"){

            @Override
            public void setValue(VGroup object, float value) {
                object.setTranslateY(value);
            }

            @Override
            public Float get(VGroup object) {
                return Float.valueOf(object.getTranslateY());
            }
        };
        private static final Property<VGroup, Float> SCALE_X = new FloatProperty<VGroup>("scaleX"){

            @Override
            public void setValue(VGroup object, float value) {
                object.setScaleX(value);
            }

            @Override
            public Float get(VGroup object) {
                return Float.valueOf(object.getScaleX());
            }
        };
        private static final Property<VGroup, Float> SCALE_Y = new FloatProperty<VGroup>("scaleY"){

            @Override
            public void setValue(VGroup object, float value) {
                object.setScaleY(value);
            }

            @Override
            public Float get(VGroup object) {
                return Float.valueOf(object.getScaleY());
            }
        };
        private static final Property<VGroup, Float> PIVOT_X = new FloatProperty<VGroup>("pivotX"){

            @Override
            public void setValue(VGroup object, float value) {
                object.setPivotX(value);
            }

            @Override
            public Float get(VGroup object) {
                return Float.valueOf(object.getPivotX());
            }
        };
        private static final Property<VGroup, Float> PIVOT_Y = new FloatProperty<VGroup>("pivotY"){

            @Override
            public void setValue(VGroup object, float value) {
                object.setPivotY(value);
            }

            @Override
            public Float get(VGroup object) {
                return Float.valueOf(object.getPivotY());
            }
        };
        private static final Property<VGroup, Float> ROTATION = new FloatProperty<VGroup>("rotation"){

            @Override
            public void setValue(VGroup object, float value) {
                object.setRotation(value);
            }

            @Override
            public Float get(VGroup object) {
                return Float.valueOf(object.getRotation());
            }
        };
        private static final HashMap<String, Property> sPropertyMap = new HashMap<String, Property>(){
            {
                this.put("translateX", TRANSLATE_X);
                this.put("translateY", TRANSLATE_Y);
                this.put("scaleX", SCALE_X);
                this.put("scaleY", SCALE_Y);
                this.put("pivotX", PIVOT_X);
                this.put("pivotY", PIVOT_Y);
                this.put("rotation", ROTATION);
            }
        };
        private float[] mTransform;
        private final ArrayList<VObject> mChildren = new ArrayList();
        private boolean mIsStateful;
        private int mChangingConfigurations;
        private int[] mThemeAttrs;
        private String mGroupName = null;
        private final long mNativePtr;

        static int getPropertyIndex(String propertyName) {
            if (sPropertyIndexMap.containsKey(propertyName)) {
                return sPropertyIndexMap.get(propertyName);
            }
            return -1;
        }

        public VGroup(VGroup copy, ArrayMap<String, Object> targetsMap) {
            this.mIsStateful = copy.mIsStateful;
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mGroupName = copy.mGroupName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            if (this.mGroupName != null) {
                targetsMap.put(this.mGroupName, this);
            }
            this.mNativePtr = VectorDrawable.nCreateGroup(copy.mNativePtr);
            ArrayList<VObject> children = copy.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                VPath newPath;
                VObject copyChild = children.get(i);
                if (copyChild instanceof VGroup) {
                    VGroup copyGroup = (VGroup)copyChild;
                    this.addChild(new VGroup(copyGroup, targetsMap));
                    continue;
                }
                if (copyChild instanceof VFullPath) {
                    newPath = new VFullPath((VFullPath)copyChild);
                } else if (copyChild instanceof VClipPath) {
                    newPath = new VClipPath((VClipPath)copyChild);
                } else {
                    throw new IllegalStateException("Unknown object in the tree!");
                }
                this.addChild(newPath);
                if (newPath.mPathName == null) continue;
                targetsMap.put(newPath.mPathName, newPath);
            }
        }

        public VGroup() {
            this.mNativePtr = VectorDrawable.nCreateGroup();
        }

        @Override
        Property getProperty(String propertyName) {
            if (sPropertyMap.containsKey(propertyName)) {
                return sPropertyMap.get(propertyName);
            }
            return null;
        }

        public String getGroupName() {
            return this.mGroupName;
        }

        public void addChild(VObject child) {
            VectorDrawable.nAddChild(this.mNativePtr, child.getNativePtr());
            this.mChildren.add(child);
            this.mIsStateful |= child.isStateful();
        }

        @Override
        public void setTree(VirtualRefBasePtr treeRoot) {
            super.setTree(treeRoot);
            for (int i = 0; i < this.mChildren.size(); ++i) {
                this.mChildren.get(i).setTree(treeRoot);
            }
        }

        @Override
        public long getNativePtr() {
            return this.mNativePtr;
        }

        @Override
        public void inflate(Resources res, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(res, theme, attrs, R.styleable.VectorDrawableGroup);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        void updateStateFromTypedArray(TypedArray a) {
            boolean success;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            this.mThemeAttrs = a.extractThemeAttrs();
            if (this.mTransform == null) {
                this.mTransform = new float[7];
            }
            if (!(success = VectorDrawable.nGetGroupProperties(this.mNativePtr, this.mTransform, 7))) {
                throw new RuntimeException("Error: inconsistent property count");
            }
            float rotate = a.getFloat(5, this.mTransform[0]);
            float pivotX = a.getFloat(1, this.mTransform[1]);
            float pivotY = a.getFloat(2, this.mTransform[2]);
            float scaleX = a.getFloat(3, this.mTransform[3]);
            float scaleY = a.getFloat(4, this.mTransform[4]);
            float translateX = a.getFloat(6, this.mTransform[5]);
            float translateY = a.getFloat(7, this.mTransform[6]);
            String groupName = a.getString(0);
            if (groupName != null) {
                this.mGroupName = groupName;
                VectorDrawable.nSetName(this.mNativePtr, this.mGroupName);
            }
            VectorDrawable.nUpdateGroupProperties(this.mNativePtr, rotate, pivotX, pivotY, scaleX, scaleY, translateX, translateY);
        }

        @Override
        public boolean onStateChange(int[] stateSet) {
            boolean changed = false;
            ArrayList<VObject> children = this.mChildren;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                VObject child = children.get(i);
                if (!child.isStateful()) continue;
                changed |= child.onStateChange(stateSet);
            }
            return changed;
        }

        @Override
        public boolean isStateful() {
            return this.mIsStateful;
        }

        @Override
        public boolean hasFocusStateSpecified() {
            boolean result = false;
            ArrayList<VObject> children = this.mChildren;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                VObject child = children.get(i);
                if (!child.isStateful()) continue;
                result |= child.hasFocusStateSpecified();
            }
            return result;
        }

        @Override
        int getNativeSize() {
            int size = 100;
            for (int i = 0; i < this.mChildren.size(); ++i) {
                size += this.mChildren.get(i).getNativeSize();
            }
            return size;
        }

        @Override
        public boolean canApplyTheme() {
            if (this.mThemeAttrs != null) {
                return true;
            }
            ArrayList<VObject> children = this.mChildren;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                VObject child = children.get(i);
                if (!child.canApplyTheme()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawableGroup);
                this.updateStateFromTypedArray(a);
                a.recycle();
            }
            ArrayList<VObject> children = this.mChildren;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                VObject child = children.get(i);
                if (!child.canApplyTheme()) continue;
                child.applyTheme(t);
                this.mIsStateful |= child.isStateful();
            }
        }

        public float getRotation() {
            return this.isTreeValid() ? VectorDrawable.nGetRotation(this.mNativePtr) : 0.0f;
        }

        @UnsupportedAppUsage
        public void setRotation(float rotation) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetRotation(this.mNativePtr, rotation);
            }
        }

        public float getPivotX() {
            return this.isTreeValid() ? VectorDrawable.nGetPivotX(this.mNativePtr) : 0.0f;
        }

        @UnsupportedAppUsage
        public void setPivotX(float pivotX) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetPivotX(this.mNativePtr, pivotX);
            }
        }

        public float getPivotY() {
            return this.isTreeValid() ? VectorDrawable.nGetPivotY(this.mNativePtr) : 0.0f;
        }

        @UnsupportedAppUsage
        public void setPivotY(float pivotY) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetPivotY(this.mNativePtr, pivotY);
            }
        }

        public float getScaleX() {
            return this.isTreeValid() ? VectorDrawable.nGetScaleX(this.mNativePtr) : 0.0f;
        }

        public void setScaleX(float scaleX) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetScaleX(this.mNativePtr, scaleX);
            }
        }

        public float getScaleY() {
            return this.isTreeValid() ? VectorDrawable.nGetScaleY(this.mNativePtr) : 0.0f;
        }

        public void setScaleY(float scaleY) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetScaleY(this.mNativePtr, scaleY);
            }
        }

        public float getTranslateX() {
            return this.isTreeValid() ? VectorDrawable.nGetTranslateX(this.mNativePtr) : 0.0f;
        }

        @UnsupportedAppUsage
        public void setTranslateX(float translateX) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTranslateX(this.mNativePtr, translateX);
            }
        }

        public float getTranslateY() {
            return this.isTreeValid() ? VectorDrawable.nGetTranslateY(this.mNativePtr) : 0.0f;
        }

        @UnsupportedAppUsage
        public void setTranslateY(float translateY) {
            if (this.isTreeValid()) {
                VectorDrawable.nSetTranslateY(this.mNativePtr, translateY);
            }
        }
    }

    static class VectorDrawableState
    extends Drawable.ConstantState {
        int[] mThemeAttrs;
        int mChangingConfigurations;
        ColorStateList mTint = null;
        BlendMode mBlendMode = Drawable.DEFAULT_BLEND_MODE;
        boolean mAutoMirrored;
        int mBaseWidth = 0;
        int mBaseHeight = 0;
        float mViewportWidth = 0.0f;
        float mViewportHeight = 0.0f;
        Insets mOpticalInsets = Insets.NONE;
        String mRootName = null;
        VGroup mRootGroup;
        VirtualRefBasePtr mNativeTree = null;
        int mDensity = 160;
        final ArrayMap<String, Object> mVGTargetsMap = new ArrayMap();
        int[] mCachedThemeAttrs;
        ColorStateList mCachedTint;
        BlendMode mCachedBlendMode;
        boolean mCachedAutoMirrored;
        boolean mCacheDirty;
        int mLastSWCachePixelCount = 0;
        int mLastHWCachePixelCount = 0;
        static final Property<VectorDrawableState, Float> ALPHA = new FloatProperty<VectorDrawableState>("alpha"){

            @Override
            public void setValue(VectorDrawableState state, float value) {
                state.setAlpha(value);
            }

            @Override
            public Float get(VectorDrawableState state) {
                return Float.valueOf(state.getAlpha());
            }
        };
        private int mAllocationOfAllNodes = 0;
        private static final int NATIVE_ALLOCATION_SIZE = 316;

        Property getProperty(String propertyName) {
            if (ALPHA.getName().equals(propertyName)) {
                return ALPHA;
            }
            return null;
        }

        public VectorDrawableState(VectorDrawableState copy) {
            if (copy != null) {
                this.mThemeAttrs = copy.mThemeAttrs;
                this.mChangingConfigurations = copy.mChangingConfigurations;
                this.mTint = copy.mTint;
                this.mBlendMode = copy.mBlendMode;
                this.mAutoMirrored = copy.mAutoMirrored;
                this.mRootGroup = new VGroup(copy.mRootGroup, this.mVGTargetsMap);
                this.createNativeTreeFromCopy(copy, this.mRootGroup);
                this.mBaseWidth = copy.mBaseWidth;
                this.mBaseHeight = copy.mBaseHeight;
                this.setViewportSize(copy.mViewportWidth, copy.mViewportHeight);
                this.mOpticalInsets = copy.mOpticalInsets;
                this.mRootName = copy.mRootName;
                this.mDensity = copy.mDensity;
                if (copy.mRootName != null) {
                    this.mVGTargetsMap.put(copy.mRootName, this);
                }
            } else {
                this.mRootGroup = new VGroup();
                this.createNativeTree(this.mRootGroup);
            }
            this.onTreeConstructionFinished();
        }

        private void createNativeTree(VGroup rootGroup) {
            this.mNativeTree = new VirtualRefBasePtr(VectorDrawable.nCreateTree(rootGroup.mNativePtr));
            VMRuntime.getRuntime().registerNativeAllocation(316);
        }

        private void createNativeTreeFromCopy(VectorDrawableState copy, VGroup rootGroup) {
            this.mNativeTree = new VirtualRefBasePtr(VectorDrawable.nCreateTreeFromCopy(copy.mNativeTree.get(), rootGroup.mNativePtr));
            VMRuntime.getRuntime().registerNativeAllocation(316);
        }

        void onTreeConstructionFinished() {
            this.mRootGroup.setTree(this.mNativeTree);
            this.mAllocationOfAllNodes = this.mRootGroup.getNativeSize();
            VMRuntime.getRuntime().registerNativeAllocation(this.mAllocationOfAllNodes);
        }

        long getNativeRenderer() {
            if (this.mNativeTree == null) {
                return 0L;
            }
            return this.mNativeTree.get();
        }

        public boolean canReuseCache() {
            if (!this.mCacheDirty && this.mCachedThemeAttrs == this.mThemeAttrs && this.mCachedTint == this.mTint && this.mCachedBlendMode == this.mBlendMode && this.mCachedAutoMirrored == this.mAutoMirrored) {
                return true;
            }
            this.updateCacheStates();
            return false;
        }

        public void updateCacheStates() {
            this.mCachedThemeAttrs = this.mThemeAttrs;
            this.mCachedTint = this.mTint;
            this.mCachedBlendMode = this.mBlendMode;
            this.mCachedAutoMirrored = this.mAutoMirrored;
            this.mCacheDirty = false;
        }

        public void applyTheme(Resources.Theme t) {
            this.mRootGroup.applyTheme(t);
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mRootGroup != null && this.mRootGroup.canApplyTheme() || this.mTint != null && this.mTint.canApplyTheme() || super.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new VectorDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new VectorDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }

        public boolean isStateful() {
            return this.mTint != null && this.mTint.isStateful() || this.mRootGroup != null && this.mRootGroup.isStateful();
        }

        public boolean hasFocusStateSpecified() {
            return this.mTint != null && this.mTint.hasFocusStateSpecified() || this.mRootGroup != null && this.mRootGroup.hasFocusStateSpecified();
        }

        void setViewportSize(float viewportWidth, float viewportHeight) {
            this.mViewportWidth = viewportWidth;
            this.mViewportHeight = viewportHeight;
            VectorDrawable.nSetRendererViewportSize(this.getNativeRenderer(), viewportWidth, viewportHeight);
        }

        public boolean setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.applyDensityScaling(sourceDensity, targetDensity);
                return true;
            }
            return false;
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            this.mBaseWidth = Drawable.scaleFromDensity(this.mBaseWidth, sourceDensity, targetDensity, true);
            this.mBaseHeight = Drawable.scaleFromDensity(this.mBaseHeight, sourceDensity, targetDensity, true);
            int insetLeft = Drawable.scaleFromDensity(this.mOpticalInsets.left, sourceDensity, targetDensity, false);
            int insetTop = Drawable.scaleFromDensity(this.mOpticalInsets.top, sourceDensity, targetDensity, false);
            int insetRight = Drawable.scaleFromDensity(this.mOpticalInsets.right, sourceDensity, targetDensity, false);
            int insetBottom = Drawable.scaleFromDensity(this.mOpticalInsets.bottom, sourceDensity, targetDensity, false);
            this.mOpticalInsets = Insets.of(insetLeft, insetTop, insetRight, insetBottom);
        }

        public boolean onStateChange(int[] stateSet) {
            return this.mRootGroup.onStateChange(stateSet);
        }

        public void finalize() throws Throwable {
            super.finalize();
            int bitmapCacheSize = this.mLastHWCachePixelCount * 4 + this.mLastSWCachePixelCount * 4;
            VMRuntime.getRuntime().registerNativeFree(316 + this.mAllocationOfAllNodes + bitmapCacheSize);
        }

        public boolean setAlpha(float alpha) {
            return VectorDrawable.nSetRootAlpha(this.mNativeTree.get(), alpha);
        }

        public float getAlpha() {
            return VectorDrawable.nGetRootAlpha(this.mNativeTree.get());
        }
    }
}

