/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderNode_Delegate;
import android.view.NativeVectorDrawableAnimator;
import android.view.RenderNodeAnimator;
import com.android.internal.util.ArrayUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

public class RenderNode {
    public final long mNativeRenderNode;
    private final AnimationHost mAnimationHost;
    private RecordingCanvas mCurrentRecordingCanvas;
    private CompositePositionUpdateListener mCompositePositionUpdateListener;
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_BACKGROUND = 1;

    public RenderNode(String name) {
        this(name, null);
    }

    private RenderNode(String name, AnimationHost animationHost) {
        this.mNativeRenderNode = RenderNode.nCreate(name);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeRenderNode);
        this.mAnimationHost = animationHost;
    }

    private RenderNode(long nativePtr) {
        this.mNativeRenderNode = nativePtr;
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeRenderNode);
        this.mAnimationHost = null;
    }

    public static RenderNode create(String name, AnimationHost animationHost) {
        return new RenderNode(name, animationHost);
    }

    public static RenderNode adopt(long nativePtr) {
        return new RenderNode(nativePtr);
    }

    public void addPositionUpdateListener(PositionUpdateListener listener) {
        CompositePositionUpdateListener comp = this.mCompositePositionUpdateListener;
        comp = comp == null ? new CompositePositionUpdateListener(listener) : comp.with(listener);
        this.mCompositePositionUpdateListener = comp;
        RenderNode.nRequestPositionUpdates(this.mNativeRenderNode, comp);
    }

    public void removePositionUpdateListener(PositionUpdateListener listener) {
        CompositePositionUpdateListener comp = this.mCompositePositionUpdateListener;
        if (comp != null) {
            this.mCompositePositionUpdateListener = comp = comp.without(listener);
            RenderNode.nRequestPositionUpdates(this.mNativeRenderNode, comp);
        }
    }

    public RecordingCanvas beginRecording(int width, int height) {
        if (this.mCurrentRecordingCanvas != null) {
            throw new IllegalStateException("Recording currently in progress - missing #endRecording() call?");
        }
        this.mCurrentRecordingCanvas = RecordingCanvas.obtain(this, width, height);
        return this.mCurrentRecordingCanvas;
    }

    public RecordingCanvas beginRecording() {
        return this.beginRecording(RenderNode.nGetWidth(this.mNativeRenderNode), RenderNode.nGetHeight(this.mNativeRenderNode));
    }

    public void endRecording() {
        if (this.mCurrentRecordingCanvas == null) {
            throw new IllegalStateException("No recording in progress, forgot to call #beginRecording()?");
        }
        RecordingCanvas canvas = this.mCurrentRecordingCanvas;
        this.mCurrentRecordingCanvas = null;
        long displayList = canvas.finishRecording();
        RenderNode.nSetDisplayList(this.mNativeRenderNode, displayList);
        canvas.recycle();
    }

    @Deprecated
    public RecordingCanvas start(int width, int height) {
        return this.beginRecording(width, height);
    }

    @Deprecated
    public void end(RecordingCanvas canvas) {
        if (canvas != this.mCurrentRecordingCanvas) {
            throw new IllegalArgumentException("Wrong canvas");
        }
        this.endRecording();
    }

    public void discardDisplayList() {
        RenderNode.nSetDisplayList(this.mNativeRenderNode, 0L);
    }

    public boolean hasDisplayList() {
        return RenderNode.nIsValid(this.mNativeRenderNode);
    }

    public boolean hasIdentityMatrix() {
        return RenderNode.nHasIdentityMatrix(this.mNativeRenderNode);
    }

    public void getMatrix_Original(Matrix outMatrix) {
        RenderNode.nGetTransformMatrix(this.mNativeRenderNode, outMatrix.native_instance);
    }

    @LayoutlibDelegate
    public void getMatrix(Matrix matrix) {
        RenderNode_Delegate.getMatrix(this, matrix);
    }

    public void getInverseMatrix(Matrix outMatrix) {
        RenderNode.nGetInverseTransformMatrix(this.mNativeRenderNode, outMatrix.native_instance);
    }

    @Deprecated
    public boolean setLayerType(int layerType) {
        return RenderNode.nSetLayerType(this.mNativeRenderNode, layerType);
    }

    @Deprecated
    public boolean setLayerPaint(Paint paint) {
        return RenderNode.nSetLayerPaint(this.mNativeRenderNode, paint != null ? paint.getNativeInstance() : 0L);
    }

    public boolean setUseCompositingLayer(boolean forceToLayer, Paint paint) {
        boolean didChange = RenderNode.nSetLayerType(this.mNativeRenderNode, forceToLayer ? 2 : 0);
        return didChange |= RenderNode.nSetLayerPaint(this.mNativeRenderNode, paint != null ? paint.getNativeInstance() : 0L);
    }

    public boolean getUseCompositingLayer() {
        return RenderNode.nGetLayerType(this.mNativeRenderNode) != 0;
    }

    public boolean setClipRect(Rect rect) {
        if (rect == null) {
            return RenderNode.nSetClipBoundsEmpty(this.mNativeRenderNode);
        }
        return RenderNode.nSetClipBounds(this.mNativeRenderNode, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean setClipToBounds(boolean clipToBounds) {
        return RenderNode.nSetClipToBounds(this.mNativeRenderNode, clipToBounds);
    }

    public boolean getClipToBounds() {
        return RenderNode.nGetClipToBounds(this.mNativeRenderNode);
    }

    public boolean setProjectBackwards(boolean shouldProject) {
        return RenderNode.nSetProjectBackwards(this.mNativeRenderNode, shouldProject);
    }

    public boolean setProjectionReceiver(boolean shouldRecieve) {
        return RenderNode.nSetProjectionReceiver(this.mNativeRenderNode, shouldRecieve);
    }

    public boolean setOutline(Outline outline) {
        if (outline == null) {
            return RenderNode.nSetOutlineNone(this.mNativeRenderNode);
        }
        switch (outline.mMode) {
            case 0: {
                return RenderNode.nSetOutlineEmpty(this.mNativeRenderNode);
            }
            case 1: {
                return RenderNode.nSetOutlineRoundRect(this.mNativeRenderNode, outline.mRect.left, outline.mRect.top, outline.mRect.right, outline.mRect.bottom, outline.mRadius, outline.mAlpha);
            }
            case 2: {
                return RenderNode.nSetOutlineConvexPath(this.mNativeRenderNode, outline.mPath.mNativePath, outline.mAlpha);
            }
        }
        throw new IllegalArgumentException("Unrecognized outline?");
    }

    public boolean hasShadow() {
        return RenderNode.nHasShadow(this.mNativeRenderNode);
    }

    public boolean setSpotShadowColor(int color2) {
        return RenderNode.nSetSpotShadowColor(this.mNativeRenderNode, color2);
    }

    public int getSpotShadowColor() {
        return RenderNode.nGetSpotShadowColor(this.mNativeRenderNode);
    }

    public boolean setAmbientShadowColor(int color2) {
        return RenderNode.nSetAmbientShadowColor(this.mNativeRenderNode, color2);
    }

    public int getAmbientShadowColor() {
        return RenderNode.nGetAmbientShadowColor(this.mNativeRenderNode);
    }

    public boolean setClipToOutline(boolean clipToOutline) {
        return RenderNode.nSetClipToOutline(this.mNativeRenderNode, clipToOutline);
    }

    public boolean getClipToOutline() {
        return RenderNode.nGetClipToOutline(this.mNativeRenderNode);
    }

    public boolean setRevealClip(boolean shouldClip, float x, float y, float radius) {
        return RenderNode.nSetRevealClip(this.mNativeRenderNode, shouldClip, x, y, radius);
    }

    public boolean setStaticMatrix(Matrix matrix) {
        return RenderNode.nSetStaticMatrix(this.mNativeRenderNode, matrix.native_instance);
    }

    public boolean setAnimationMatrix(Matrix matrix) {
        return RenderNode.nSetAnimationMatrix(this.mNativeRenderNode, matrix != null ? matrix.native_instance : 0L);
    }

    public Matrix getAnimationMatrix() {
        Matrix output = new Matrix();
        if (RenderNode.nGetAnimationMatrix(this.mNativeRenderNode, output.native_instance)) {
            return output;
        }
        return null;
    }

    public boolean setAlpha(float alpha) {
        return RenderNode.nSetAlpha(this.mNativeRenderNode, alpha);
    }

    public float getAlpha() {
        return RenderNode.nGetAlpha(this.mNativeRenderNode);
    }

    public boolean setHasOverlappingRendering(boolean hasOverlappingRendering) {
        return RenderNode.nSetHasOverlappingRendering(this.mNativeRenderNode, hasOverlappingRendering);
    }

    public void setUsageHint(int usageHint) {
        RenderNode.nSetUsageHint(this.mNativeRenderNode, usageHint);
    }

    public boolean hasOverlappingRendering() {
        return RenderNode.nHasOverlappingRendering(this.mNativeRenderNode);
    }

    public boolean setElevation(float lift) {
        return RenderNode.nSetElevation(this.mNativeRenderNode, lift);
    }

    public float getElevation() {
        return RenderNode.nGetElevation(this.mNativeRenderNode);
    }

    public boolean setTranslationX(float translationX) {
        return RenderNode.nSetTranslationX(this.mNativeRenderNode, translationX);
    }

    public float getTranslationX() {
        return RenderNode.nGetTranslationX(this.mNativeRenderNode);
    }

    public boolean setTranslationY(float translationY) {
        return RenderNode.nSetTranslationY(this.mNativeRenderNode, translationY);
    }

    public float getTranslationY() {
        return RenderNode.nGetTranslationY(this.mNativeRenderNode);
    }

    public boolean setTranslationZ(float translationZ) {
        return RenderNode.nSetTranslationZ(this.mNativeRenderNode, translationZ);
    }

    public float getTranslationZ() {
        return RenderNode.nGetTranslationZ(this.mNativeRenderNode);
    }

    public boolean setRotationZ(float rotation) {
        return RenderNode.nSetRotation(this.mNativeRenderNode, rotation);
    }

    public float getRotationZ() {
        return RenderNode.nGetRotation(this.mNativeRenderNode);
    }

    public boolean setRotationX(float rotationX) {
        return RenderNode.nSetRotationX(this.mNativeRenderNode, rotationX);
    }

    public float getRotationX() {
        return RenderNode.nGetRotationX(this.mNativeRenderNode);
    }

    public boolean setRotationY(float rotationY) {
        return RenderNode.nSetRotationY(this.mNativeRenderNode, rotationY);
    }

    public float getRotationY() {
        return RenderNode.nGetRotationY(this.mNativeRenderNode);
    }

    public boolean setScaleX(float scaleX) {
        return RenderNode.nSetScaleX(this.mNativeRenderNode, scaleX);
    }

    public float getScaleX() {
        return RenderNode.nGetScaleX(this.mNativeRenderNode);
    }

    public boolean setScaleY(float scaleY) {
        return RenderNode.nSetScaleY(this.mNativeRenderNode, scaleY);
    }

    public float getScaleY() {
        return RenderNode.nGetScaleY(this.mNativeRenderNode);
    }

    public boolean setPivotX(float pivotX) {
        return RenderNode.nSetPivotX(this.mNativeRenderNode, pivotX);
    }

    public float getPivotX() {
        return RenderNode.nGetPivotX(this.mNativeRenderNode);
    }

    public boolean setPivotY(float pivotY) {
        return RenderNode.nSetPivotY(this.mNativeRenderNode, pivotY);
    }

    public float getPivotY() {
        return RenderNode.nGetPivotY(this.mNativeRenderNode);
    }

    public boolean isPivotExplicitlySet() {
        return RenderNode.nIsPivotExplicitlySet(this.mNativeRenderNode);
    }

    public boolean resetPivot() {
        return RenderNode.nResetPivot(this.mNativeRenderNode);
    }

    public boolean setCameraDistance(float distance) {
        if (!Float.isFinite(distance) || distance < 0.0f) {
            throw new IllegalArgumentException("distance must be finite & positive, given=" + distance);
        }
        return RenderNode.nSetCameraDistance(this.mNativeRenderNode, -distance);
    }

    public float getCameraDistance() {
        return -RenderNode.nGetCameraDistance(this.mNativeRenderNode);
    }

    public boolean setLeft(int left) {
        return RenderNode.nSetLeft(this.mNativeRenderNode, left);
    }

    public boolean setTop(int top) {
        return RenderNode.nSetTop(this.mNativeRenderNode, top);
    }

    public boolean setRight(int right) {
        return RenderNode.nSetRight(this.mNativeRenderNode, right);
    }

    public boolean setBottom(int bottom) {
        return RenderNode.nSetBottom(this.mNativeRenderNode, bottom);
    }

    public int getLeft() {
        return RenderNode.nGetLeft(this.mNativeRenderNode);
    }

    public int getTop() {
        return RenderNode.nGetTop(this.mNativeRenderNode);
    }

    public int getRight() {
        return RenderNode.nGetRight(this.mNativeRenderNode);
    }

    public int getBottom() {
        return RenderNode.nGetBottom(this.mNativeRenderNode);
    }

    public int getWidth() {
        return RenderNode.nGetWidth(this.mNativeRenderNode);
    }

    public int getHeight() {
        return RenderNode.nGetHeight(this.mNativeRenderNode);
    }

    public boolean setLeftTopRightBottom(int left, int top, int right, int bottom) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, left, top, right, bottom);
    }

    public boolean setPosition(int left, int top, int right, int bottom) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, left, top, right, bottom);
    }

    public boolean setPosition(Rect position) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, position.left, position.top, position.right, position.bottom);
    }

    public boolean offsetLeftAndRight(int offset) {
        return RenderNode.nOffsetLeftAndRight(this.mNativeRenderNode, offset);
    }

    public boolean offsetTopAndBottom(int offset) {
        return RenderNode.nOffsetTopAndBottom(this.mNativeRenderNode, offset);
    }

    public void output() {
        RenderNode.nOutput(this.mNativeRenderNode);
    }

    public long computeApproximateMemoryUsage() {
        return RenderNode.nGetDebugSize(this.mNativeRenderNode);
    }

    public boolean setForceDarkAllowed(boolean allow) {
        return RenderNode.nSetAllowForceDark(this.mNativeRenderNode, allow);
    }

    public boolean isForceDarkAllowed() {
        return RenderNode.nGetAllowForceDark(this.mNativeRenderNode);
    }

    public long getUniqueId() {
        return RenderNode.nGetUniqueId(this.mNativeRenderNode);
    }

    public void addAnimator(RenderNodeAnimator animator2) {
        if (!this.isAttached()) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        RenderNode.nAddAnimator(this.mNativeRenderNode, animator2.getNativeAnimator());
        this.mAnimationHost.registerAnimatingRenderNode(this);
    }

    public boolean isAttached() {
        return this.mAnimationHost != null && this.mAnimationHost.isAttached();
    }

    public void registerVectorDrawableAnimator(NativeVectorDrawableAnimator animatorSet) {
        if (!this.isAttached()) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        this.mAnimationHost.registerVectorDrawableAnimator(animatorSet);
    }

    public void endAllAnimators() {
        RenderNode.nEndAllAnimators(this.mNativeRenderNode);
    }

    @LayoutlibDelegate
    private static long nCreate(String string2) {
        return RenderNode_Delegate.nCreate(string2);
    }

    @LayoutlibDelegate
    private static long nGetNativeFinalizer() {
        return RenderNode_Delegate.nGetNativeFinalizer();
    }

    private static void nOutput(long l) {
        OverrideMethod.invokeV("android.graphics.RenderNode#nOutput(J)V", true, null);
    }

    private static int nGetDebugSize(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetDebugSize(J)I", true, null);
    }

    private static void nRequestPositionUpdates(long l, PositionUpdateListener positionUpdateListener) {
        OverrideMethod.invokeV("android.graphics.RenderNode#nRequestPositionUpdates(JLandroid/graphics/RenderNode$PositionUpdateListener;)V", true, null);
    }

    private static void nAddAnimator(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.RenderNode#nAddAnimator(JJ)V", true, null);
    }

    private static void nEndAllAnimators(long l) {
        OverrideMethod.invokeV("android.graphics.RenderNode#nEndAllAnimators(J)V", true, null);
    }

    @FastNative
    private static void nSetDisplayList(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.RenderNode#nSetDisplayList(JJ)V", true, null);
    }

    @CriticalNative
    private static boolean nIsValid(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nIsValid(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static void nGetTransformMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.RenderNode#nGetTransformMatrix(JJ)V", true, null);
    }

    @CriticalNative
    private static void nGetInverseTransformMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.graphics.RenderNode#nGetInverseTransformMatrix(JJ)V", true, null);
    }

    @CriticalNative
    private static boolean nHasIdentityMatrix(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nHasIdentityMatrix(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nOffsetTopAndBottom(long l, int n) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nOffsetTopAndBottom(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nOffsetLeftAndRight(long l, int n) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nOffsetLeftAndRight(JI)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetLeftTopRightBottom(long l, int n, int n2, int n3, int n4) {
        return RenderNode_Delegate.nSetLeftTopRightBottom(l, n, n2, n3, n4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetLeft(long l, int n) {
        return RenderNode_Delegate.nSetLeft(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetTop(long l, int n) {
        return RenderNode_Delegate.nSetTop(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetRight(long l, int n) {
        return RenderNode_Delegate.nSetRight(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetBottom(long l, int n) {
        return RenderNode_Delegate.nSetBottom(l, n);
    }

    @CriticalNative
    private static int nGetLeft(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetLeft(J)I", true, null);
    }

    @CriticalNative
    private static int nGetTop(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetTop(J)I", true, null);
    }

    @CriticalNative
    private static int nGetRight(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetRight(J)I", true, null);
    }

    @CriticalNative
    private static int nGetBottom(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetBottom(J)I", true, null);
    }

    @CriticalNative
    private static boolean nSetCameraDistance(long l, float f) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetCameraDistance(JF)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetPivotY(long l, float f) {
        return RenderNode_Delegate.nSetPivotY(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetPivotX(long l, float f) {
        return RenderNode_Delegate.nSetPivotX(l, f);
    }

    @CriticalNative
    private static boolean nResetPivot(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nResetPivot(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetLayerType(long l, int n) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetLayerType(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static int nGetLayerType(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetLayerType(J)I", true, null);
    }

    @CriticalNative
    private static boolean nSetLayerPaint(long l, long l2) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetLayerPaint(JJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetClipToBounds(long l, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetClipToBounds(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nGetClipToBounds(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetClipToBounds(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetClipBounds(long l, int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetClipBounds(JIIII)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetClipBoundsEmpty(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetClipBoundsEmpty(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetProjectBackwards(long l, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetProjectBackwards(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetProjectionReceiver(long l, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetProjectionReceiver(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetOutlineRoundRect(long l, int n, int n2, int n3, int n4, float f, float f2) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetOutlineRoundRect(JIIIIFF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetOutlineConvexPath(long l, long l2, float f) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetOutlineConvexPath(JJF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetOutlineEmpty(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetOutlineEmpty(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetOutlineNone(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetOutlineNone(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nHasShadow(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nHasShadow(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetSpotShadowColor(long l, int n) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetSpotShadowColor(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetAmbientShadowColor(long l, int n) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetAmbientShadowColor(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static int nGetSpotShadowColor(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetSpotShadowColor(J)I", true, null);
    }

    @CriticalNative
    private static int nGetAmbientShadowColor(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetAmbientShadowColor(J)I", true, null);
    }

    @CriticalNative
    private static boolean nSetClipToOutline(long l, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetClipToOutline(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetRevealClip(long l, boolean bl, float f, float f2, float f3) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetRevealClip(JZFFF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetAlpha(long l, float f) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetAlpha(JF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetHasOverlappingRendering(long l, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetHasOverlappingRendering(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static void nSetUsageHint(long l, int n) {
        OverrideMethod.invokeV("android.graphics.RenderNode#nSetUsageHint(JI)V", true, null);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetElevation(long l, float f) {
        return RenderNode_Delegate.nSetElevation(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetTranslationX(long l, float f) {
        return RenderNode_Delegate.nSetTranslationX(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetTranslationY(long l, float f) {
        return RenderNode_Delegate.nSetTranslationY(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetTranslationZ(long l, float f) {
        return RenderNode_Delegate.nSetTranslationZ(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetRotation(long l, float f) {
        return RenderNode_Delegate.nSetRotation(l, f);
    }

    @CriticalNative
    private static boolean nSetRotationX(long l, float f) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetRotationX(JF)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetRotationY(long l, float f) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetRotationY(JF)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetScaleX(long l, float f) {
        return RenderNode_Delegate.nSetScaleX(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nSetScaleY(long l, float f) {
        return RenderNode_Delegate.nSetScaleY(l, f);
    }

    @CriticalNative
    private static boolean nSetStaticMatrix(long l, long l2) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetStaticMatrix(JJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nSetAnimationMatrix(long l, long l2) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetAnimationMatrix(JJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nHasOverlappingRendering(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nHasOverlappingRendering(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nGetAnimationMatrix(long l, long l2) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetAnimationMatrix(JJ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nGetClipToOutline(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetClipToOutline(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static float nGetAlpha(long l) {
        return OverrideMethod.invokeF("android.graphics.RenderNode#nGetAlpha(J)F", true, null);
    }

    @CriticalNative
    private static float nGetCameraDistance(long l) {
        return OverrideMethod.invokeF("android.graphics.RenderNode#nGetCameraDistance(J)F", true, null);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetScaleX(long l) {
        return RenderNode_Delegate.nGetScaleX(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetScaleY(long l) {
        return RenderNode_Delegate.nGetScaleY(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetElevation(long l) {
        return RenderNode_Delegate.nGetElevation(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTranslationX(long l) {
        return RenderNode_Delegate.nGetTranslationX(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTranslationY(long l) {
        return RenderNode_Delegate.nGetTranslationY(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTranslationZ(long l) {
        return RenderNode_Delegate.nGetTranslationZ(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetRotation(long l) {
        return RenderNode_Delegate.nGetRotation(l);
    }

    @CriticalNative
    private static float nGetRotationX(long l) {
        return OverrideMethod.invokeF("android.graphics.RenderNode#nGetRotationX(J)F", true, null);
    }

    @CriticalNative
    private static float nGetRotationY(long l) {
        return OverrideMethod.invokeF("android.graphics.RenderNode#nGetRotationY(J)F", true, null);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nIsPivotExplicitlySet(long l) {
        return RenderNode_Delegate.nIsPivotExplicitlySet(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetPivotX(long l) {
        return RenderNode_Delegate.nGetPivotX(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetPivotY(long l) {
        return RenderNode_Delegate.nGetPivotY(l);
    }

    @CriticalNative
    private static int nGetWidth(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetWidth(J)I", true, null);
    }

    @CriticalNative
    private static int nGetHeight(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetHeight(J)I", true, null);
    }

    @CriticalNative
    private static boolean nSetAllowForceDark(long l, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nSetAllowForceDark(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static boolean nGetAllowForceDark(long l) {
        return OverrideMethod.invokeI("android.graphics.RenderNode#nGetAllowForceDark(J)Z", true, null) != 0;
    }

    @CriticalNative
    private static long nGetUniqueId(long l) {
        return OverrideMethod.invokeL("android.graphics.RenderNode#nGetUniqueId(J)J", true, null);
    }

    static /* synthetic */ long access$000() {
        return RenderNode.nGetNativeFinalizer();
    }

    public static interface AnimationHost {
        public void registerAnimatingRenderNode(RenderNode var1);

        public void registerVectorDrawableAnimator(NativeVectorDrawableAnimator var1);

        public boolean isAttached();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsageHint {
    }

    private static class CompositePositionUpdateListener
    implements PositionUpdateListener {
        private final PositionUpdateListener[] mListeners;
        private static final PositionUpdateListener[] sEmpty = new PositionUpdateListener[0];

        CompositePositionUpdateListener(PositionUpdateListener ... listeners) {
            this.mListeners = listeners != null ? listeners : sEmpty;
        }

        public CompositePositionUpdateListener with(PositionUpdateListener listener) {
            return new CompositePositionUpdateListener(ArrayUtils.appendElement(PositionUpdateListener.class, this.mListeners, listener));
        }

        public CompositePositionUpdateListener without(PositionUpdateListener listener) {
            return new CompositePositionUpdateListener(ArrayUtils.removeElement(PositionUpdateListener.class, this.mListeners, listener));
        }

        @Override
        public void positionChanged(long frameNumber, int left, int top, int right, int bottom) {
            for (PositionUpdateListener pul : this.mListeners) {
                pul.positionChanged(frameNumber, left, top, right, bottom);
            }
        }

        @Override
        public void positionLost(long frameNumber) {
            for (PositionUpdateListener pul : this.mListeners) {
                pul.positionLost(frameNumber);
            }
        }
    }

    public static interface PositionUpdateListener {
        public void positionChanged(long var1, int var3, int var4, int var5, int var6);

        public void positionLost(long var1);
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(RenderNode.class.getClassLoader(), RenderNode.access$000());

        private NoImagePreloadHolder() {
        }
    }
}

