/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.UnsupportedAppUsage;
import android.graphics.BlendMode;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorSpace;
import android.graphics.MaskFilter;
import android.graphics.Paint_Delegate;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.fonts.FontVariationAxis;
import android.os.LocaleList;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import libcore.util.NativeAllocationRegistry;

public class Paint {
    @UnsupportedAppUsage
    private long mNativePaint;
    private long mNativeShader;
    private long mNativeColorFilter;
    private long mColor;
    private ColorFilter mColorFilter;
    private MaskFilter mMaskFilter;
    private PathEffect mPathEffect;
    private Shader mShader;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private Typeface mTypeface;
    private Xfermode mXfermode;
    private boolean mHasCompatScaling;
    private float mCompatScaling;
    private float mInvCompatScaling;
    private LocaleList mLocales;
    private String mFontFeatureSettings;
    private String mFontVariationSettings;
    private float mShadowLayerRadius;
    private float mShadowLayerDx;
    private float mShadowLayerDy;
    private long mShadowLayerColor;
    private static final Object sCacheLock = new Object();
    @GuardedBy(value={"sCacheLock"})
    private static final HashMap<String, Integer> sMinikinLocaleListIdCache = new HashMap();
    public int mBidiFlags = 2;
    static final Style[] sStyleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
    static final Cap[] sCapArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
    static final Join[] sJoinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
    static final Align[] sAlignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
    public static final int ANTI_ALIAS_FLAG = 1;
    public static final int FILTER_BITMAP_FLAG = 2;
    public static final int DITHER_FLAG = 4;
    public static final int UNDERLINE_TEXT_FLAG = 8;
    public static final int STRIKE_THRU_TEXT_FLAG = 16;
    public static final int FAKE_BOLD_TEXT_FLAG = 32;
    public static final int LINEAR_TEXT_FLAG = 64;
    public static final int SUBPIXEL_TEXT_FLAG = 128;
    public static final int DEV_KERN_TEXT_FLAG = 256;
    public static final int LCD_RENDER_TEXT_FLAG = 512;
    public static final int EMBEDDED_BITMAP_TEXT_FLAG = 1024;
    public static final int AUTO_HINTING_TEXT_FLAG = 2048;
    public static final int VERTICAL_TEXT_FLAG = 4096;
    static final int HIDDEN_DEFAULT_PAINT_FLAGS = 1282;
    public static final int HINTING_OFF = 0;
    public static final int HINTING_ON = 1;
    public static final int BIDI_LTR = 0;
    public static final int BIDI_RTL = 1;
    public static final int BIDI_DEFAULT_LTR = 2;
    public static final int BIDI_DEFAULT_RTL = 3;
    public static final int BIDI_FORCE_LTR = 4;
    public static final int BIDI_FORCE_RTL = 5;
    private static final int BIDI_MAX_FLAG_VALUE = 5;
    private static final int BIDI_FLAG_MASK = 7;
    public static final int DIRECTION_LTR = 0;
    public static final int DIRECTION_RTL = 1;
    public static final int CURSOR_AFTER = 0;
    public static final int CURSOR_AT_OR_AFTER = 1;
    public static final int CURSOR_BEFORE = 2;
    public static final int CURSOR_AT_OR_BEFORE = 3;
    public static final int CURSOR_AT = 4;
    private static final int CURSOR_OPT_MAX_VALUE = 4;
    public static final int START_HYPHEN_EDIT_NO_EDIT = 0;
    public static final int START_HYPHEN_EDIT_INSERT_HYPHEN = 1;
    public static final int START_HYPHEN_EDIT_INSERT_ZWJ = 2;
    public static final int END_HYPHEN_EDIT_NO_EDIT = 0;
    public static final int END_HYPHEN_EDIT_REPLACE_WITH_HYPHEN = 1;
    public static final int END_HYPHEN_EDIT_INSERT_HYPHEN = 2;
    public static final int END_HYPHEN_EDIT_INSERT_ARMENIAN_HYPHEN = 3;
    public static final int END_HYPHEN_EDIT_INSERT_MAQAF = 4;
    public static final int END_HYPHEN_EDIT_INSERT_UCAS_HYPHEN = 5;
    public static final int END_HYPHEN_EDIT_INSERT_ZWJ_AND_HYPHEN = 6;

    public Paint() {
        this(0);
    }

    public Paint(int flags) {
        this.mNativePaint = Paint.nInit();
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativePaint);
        this.setFlags(flags | 0x502);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
        this.setTextLocales(LocaleList.getAdjustedDefault());
        this.mColor = Color.pack(-16777216);
    }

    public Paint(Paint paint) {
        this.mNativePaint = Paint.nInitWithPaint(paint.getNativeInstance());
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativePaint);
        this.setClassVariablesFrom(paint);
    }

    public void reset() {
        Paint.nReset(this.mNativePaint);
        this.setFlags(1282);
        this.mColor = Color.pack(-16777216);
        this.mColorFilter = null;
        this.mMaskFilter = null;
        this.mPathEffect = null;
        this.mShader = null;
        this.mNativeShader = 0L;
        this.mTypeface = null;
        this.mXfermode = null;
        this.mHasCompatScaling = false;
        this.mCompatScaling = 1.0f;
        this.mInvCompatScaling = 1.0f;
        this.mBidiFlags = 2;
        this.setTextLocales(LocaleList.getAdjustedDefault());
        this.setElegantTextHeight(false);
        this.mFontFeatureSettings = null;
        this.mFontVariationSettings = null;
        this.mShadowLayerRadius = 0.0f;
        this.mShadowLayerDx = 0.0f;
        this.mShadowLayerDy = 0.0f;
        this.mShadowLayerColor = Color.pack(0);
    }

    public void set(Paint src) {
        if (this != src) {
            Paint.nSet(this.mNativePaint, src.mNativePaint);
            this.setClassVariablesFrom(src);
        }
    }

    private void setClassVariablesFrom(Paint paint) {
        this.mColor = paint.mColor;
        this.mColorFilter = paint.mColorFilter;
        this.mMaskFilter = paint.mMaskFilter;
        this.mPathEffect = paint.mPathEffect;
        this.mShader = paint.mShader;
        this.mNativeShader = paint.mNativeShader;
        this.mTypeface = paint.mTypeface;
        this.mXfermode = paint.mXfermode;
        this.mHasCompatScaling = paint.mHasCompatScaling;
        this.mCompatScaling = paint.mCompatScaling;
        this.mInvCompatScaling = paint.mInvCompatScaling;
        this.mBidiFlags = paint.mBidiFlags;
        this.mLocales = paint.mLocales;
        this.mFontFeatureSettings = paint.mFontFeatureSettings;
        this.mFontVariationSettings = paint.mFontVariationSettings;
        this.mShadowLayerRadius = paint.mShadowLayerRadius;
        this.mShadowLayerDx = paint.mShadowLayerDx;
        this.mShadowLayerDy = paint.mShadowLayerDy;
        this.mShadowLayerColor = paint.mShadowLayerColor;
    }

    @UnsupportedAppUsage
    public void setCompatibilityScaling(float factor) {
        if ((double)factor == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
        } else {
            this.mHasCompatScaling = true;
            this.mCompatScaling = factor;
            this.mInvCompatScaling = 1.0f / factor;
        }
    }

    @UnsupportedAppUsage
    public long getNativeInstance() {
        long newNativeColorFilter;
        long newNativeShader;
        long l = newNativeShader = this.mShader == null ? 0L : this.mShader.getNativeInstance();
        if (newNativeShader != this.mNativeShader) {
            this.mNativeShader = newNativeShader;
            Paint.nSetShader(this.mNativePaint, this.mNativeShader);
        }
        long l2 = newNativeColorFilter = this.mColorFilter == null ? 0L : this.mColorFilter.getNativeInstance();
        if (newNativeColorFilter != this.mNativeColorFilter) {
            this.mNativeColorFilter = newNativeColorFilter;
            Paint.nSetColorFilter(this.mNativePaint, this.mNativeColorFilter);
        }
        return this.mNativePaint;
    }

    public int getBidiFlags() {
        return this.mBidiFlags;
    }

    public void setBidiFlags(int flags) {
        if ((flags &= 7) > 5) {
            throw new IllegalArgumentException("unknown bidi flag: " + flags);
        }
        this.mBidiFlags = flags;
    }

    public int getFlags() {
        return Paint.nGetFlags(this.mNativePaint);
    }

    public void setFlags(int flags) {
        Paint.nSetFlags(this.mNativePaint, flags);
    }

    public int getHinting() {
        return Paint.nGetHinting(this.mNativePaint);
    }

    public void setHinting(int mode) {
        Paint.nSetHinting(this.mNativePaint, mode);
    }

    public boolean isAntiAlias() {
        return (this.getFlags() & 1) != 0;
    }

    public void setAntiAlias(boolean aa) {
        Paint.nSetAntiAlias(this.mNativePaint, aa);
    }

    public boolean isDither() {
        return (this.getFlags() & 4) != 0;
    }

    public void setDither(boolean dither) {
        Paint.nSetDither(this.mNativePaint, dither);
    }

    public boolean isLinearText() {
        return (this.getFlags() & 0x40) != 0;
    }

    public void setLinearText(boolean linearText) {
        Paint.nSetLinearText(this.mNativePaint, linearText);
    }

    public boolean isSubpixelText() {
        return (this.getFlags() & 0x80) != 0;
    }

    public void setSubpixelText(boolean subpixelText) {
        Paint.nSetSubpixelText(this.mNativePaint, subpixelText);
    }

    public boolean isUnderlineText() {
        return (this.getFlags() & 8) != 0;
    }

    public float getUnderlinePosition() {
        return Paint.nGetUnderlinePosition(this.mNativePaint);
    }

    public float getUnderlineThickness() {
        return Paint.nGetUnderlineThickness(this.mNativePaint);
    }

    public void setUnderlineText(boolean underlineText) {
        Paint.nSetUnderlineText(this.mNativePaint, underlineText);
    }

    public boolean isStrikeThruText() {
        return (this.getFlags() & 0x10) != 0;
    }

    public float getStrikeThruPosition() {
        return Paint.nGetStrikeThruPosition(this.mNativePaint);
    }

    public float getStrikeThruThickness() {
        return Paint.nGetStrikeThruThickness(this.mNativePaint);
    }

    public void setStrikeThruText(boolean strikeThruText) {
        Paint.nSetStrikeThruText(this.mNativePaint, strikeThruText);
    }

    public boolean isFakeBoldText() {
        return (this.getFlags() & 0x20) != 0;
    }

    public void setFakeBoldText(boolean fakeBoldText) {
        Paint.nSetFakeBoldText(this.mNativePaint, fakeBoldText);
    }

    public boolean isFilterBitmap() {
        return (this.getFlags() & 2) != 0;
    }

    public void setFilterBitmap(boolean filter) {
        Paint.nSetFilterBitmap(this.mNativePaint, filter);
    }

    public Style getStyle() {
        return sStyleArray[Paint.nGetStyle(this.mNativePaint)];
    }

    public void setStyle(Style style2) {
        Paint.nSetStyle(this.mNativePaint, style2.nativeInt);
    }

    public int getColor() {
        return Color.toArgb(this.mColor);
    }

    public long getColorLong() {
        return this.mColor;
    }

    public void setColor(int color2) {
        Paint.nSetColor(this.mNativePaint, color2);
        this.mColor = Color.pack(color2);
    }

    public void setColor(long color2) {
        ColorSpace cs = Color.colorSpace(color2);
        Paint.nSetColor(this.mNativePaint, cs.getNativeInstance(), color2);
        this.mColor = color2;
    }

    public int getAlpha() {
        return Math.round(Color.alpha(this.mColor) * 255.0f);
    }

    public void setAlpha(int a) {
        ColorSpace cs = Color.colorSpace(this.mColor);
        float r = Color.red(this.mColor);
        float g = Color.green(this.mColor);
        float b = Color.blue(this.mColor);
        this.mColor = Color.pack(r, g, b, (float)a * 0.003921569f, cs);
        Paint.nSetAlpha(this.mNativePaint, a);
    }

    public void setARGB(int a, int r, int g, int b) {
        this.setColor(a << 24 | r << 16 | g << 8 | b);
    }

    public float getStrokeWidth() {
        return Paint.nGetStrokeWidth(this.mNativePaint);
    }

    public void setStrokeWidth(float width) {
        Paint.nSetStrokeWidth(this.mNativePaint, width);
    }

    public float getStrokeMiter() {
        return Paint.nGetStrokeMiter(this.mNativePaint);
    }

    public void setStrokeMiter(float miter) {
        Paint.nSetStrokeMiter(this.mNativePaint, miter);
    }

    public Cap getStrokeCap() {
        return sCapArray[Paint.nGetStrokeCap(this.mNativePaint)];
    }

    public void setStrokeCap(Cap cap) {
        Paint.nSetStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    public Join getStrokeJoin() {
        return sJoinArray[Paint.nGetStrokeJoin(this.mNativePaint)];
    }

    public void setStrokeJoin(Join join) {
        Paint.nSetStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    public boolean getFillPath(Path src, Path dst) {
        return Paint.nGetFillPath(this.mNativePaint, src.readOnlyNI(), dst.mutateNI());
    }

    public Shader getShader() {
        return this.mShader;
    }

    public Shader setShader(Shader shader) {
        if (this.mShader != shader) {
            this.mNativeShader = -1L;
            Paint.nSetShader(this.mNativePaint, 0L);
        }
        this.mShader = shader;
        return shader;
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public ColorFilter setColorFilter(ColorFilter filter) {
        if (this.mColorFilter != filter) {
            this.mNativeColorFilter = -1L;
        }
        this.mColorFilter = filter;
        return filter;
    }

    public Xfermode getXfermode() {
        return this.mXfermode;
    }

    public BlendMode getBlendMode() {
        if (this.mXfermode == null) {
            return null;
        }
        return BlendMode.fromValue(this.mXfermode.porterDuffMode);
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        return this.installXfermode(xfermode);
    }

    private Xfermode installXfermode(Xfermode xfermode) {
        int curMode;
        int newMode = xfermode != null ? xfermode.porterDuffMode : Xfermode.DEFAULT;
        int n = curMode = this.mXfermode != null ? this.mXfermode.porterDuffMode : Xfermode.DEFAULT;
        if (newMode != curMode) {
            Paint.nSetXfermode(this.mNativePaint, newMode);
        }
        this.mXfermode = xfermode;
        return xfermode;
    }

    public void setBlendMode(BlendMode blendmode) {
        this.installXfermode(blendmode != null ? blendmode.getXfermode() : null);
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    public PathEffect setPathEffect(PathEffect effect) {
        long effectNative = 0L;
        if (effect != null) {
            effectNative = effect.native_instance;
        }
        Paint.nSetPathEffect(this.mNativePaint, effectNative);
        this.mPathEffect = effect;
        return effect;
    }

    public MaskFilter getMaskFilter() {
        return this.mMaskFilter;
    }

    public MaskFilter setMaskFilter(MaskFilter maskfilter) {
        long maskfilterNative = 0L;
        if (maskfilter != null) {
            maskfilterNative = maskfilter.native_instance;
        }
        Paint.nSetMaskFilter(this.mNativePaint, maskfilterNative);
        this.mMaskFilter = maskfilter;
        return maskfilter;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public Typeface setTypeface(Typeface typeface) {
        long typefaceNative = typeface == null ? 0L : typeface.native_instance;
        Paint.nSetTypeface(this.mNativePaint, typefaceNative);
        this.mTypeface = typeface;
        return typeface;
    }

    @Deprecated
    public Rasterizer getRasterizer() {
        return null;
    }

    @Deprecated
    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        return rasterizer;
    }

    public void setShadowLayer(float radius, float dx, float dy, int shadowColor) {
        this.setShadowLayer(radius, dx, dy, Color.pack(shadowColor));
    }

    public void setShadowLayer(float radius, float dx, float dy, long shadowColor) {
        ColorSpace cs = Color.colorSpace(shadowColor);
        Paint.nSetShadowLayer(this.mNativePaint, radius, dx, dy, cs.getNativeInstance(), shadowColor);
        this.mShadowLayerRadius = radius;
        this.mShadowLayerDx = dx;
        this.mShadowLayerDy = dy;
        this.mShadowLayerColor = shadowColor;
    }

    public void clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    public boolean hasShadowLayer() {
        return Paint.nHasShadowLayer(this.mNativePaint);
    }

    public float getShadowLayerRadius() {
        return this.mShadowLayerRadius;
    }

    public float getShadowLayerDx() {
        return this.mShadowLayerDx;
    }

    public float getShadowLayerDy() {
        return this.mShadowLayerDy;
    }

    public int getShadowLayerColor() {
        return Color.toArgb(this.mShadowLayerColor);
    }

    public long getShadowLayerColorLong() {
        return this.mShadowLayerColor;
    }

    public Align getTextAlign() {
        return sAlignArray[Paint.nGetTextAlign(this.mNativePaint)];
    }

    public void setTextAlign(Align align) {
        Paint.nSetTextAlign(this.mNativePaint, align.nativeInt);
    }

    public Locale getTextLocale() {
        return this.mLocales.get(0);
    }

    public LocaleList getTextLocales() {
        return this.mLocales;
    }

    public void setTextLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        if (this.mLocales != null && this.mLocales.size() == 1 && locale.equals(this.mLocales.get(0))) {
            return;
        }
        this.mLocales = new LocaleList(locale);
        this.syncTextLocalesWithMinikin();
    }

    public void setTextLocales(LocaleList locales) {
        if (locales == null || locales.isEmpty()) {
            throw new IllegalArgumentException("locales cannot be null or empty");
        }
        if (locales.equals(this.mLocales)) {
            return;
        }
        this.mLocales = locales;
        this.syncTextLocalesWithMinikin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncTextLocalesWithMinikin() {
        Integer minikinLocaleListId;
        String languageTags = this.mLocales.toLanguageTags();
        Object object = sCacheLock;
        synchronized (object) {
            minikinLocaleListId = sMinikinLocaleListIdCache.get(languageTags);
            if (minikinLocaleListId == null) {
                int newID = Paint.nSetTextLocales(this.mNativePaint, languageTags);
                sMinikinLocaleListIdCache.put(languageTags, newID);
                return;
            }
        }
        Paint.nSetTextLocalesByMinikinLocaleListId(this.mNativePaint, minikinLocaleListId);
    }

    public boolean isElegantTextHeight() {
        return Paint.nIsElegantTextHeight(this.mNativePaint);
    }

    public void setElegantTextHeight(boolean elegant) {
        Paint.nSetElegantTextHeight(this.mNativePaint, elegant);
    }

    public float getTextSize() {
        return Paint.nGetTextSize(this.mNativePaint);
    }

    public void setTextSize(float textSize) {
        Paint.nSetTextSize(this.mNativePaint, textSize);
    }

    public float getTextScaleX() {
        return Paint.nGetTextScaleX(this.mNativePaint);
    }

    public void setTextScaleX(float scaleX) {
        Paint.nSetTextScaleX(this.mNativePaint, scaleX);
    }

    public float getTextSkewX() {
        return Paint.nGetTextSkewX(this.mNativePaint);
    }

    public void setTextSkewX(float skewX) {
        Paint.nSetTextSkewX(this.mNativePaint, skewX);
    }

    public float getLetterSpacing() {
        return Paint.nGetLetterSpacing(this.mNativePaint);
    }

    public void setLetterSpacing(float letterSpacing) {
        Paint.nSetLetterSpacing(this.mNativePaint, letterSpacing);
    }

    public float getWordSpacing() {
        return Paint.nGetWordSpacing(this.mNativePaint);
    }

    public void setWordSpacing(float wordSpacing) {
        Paint.nSetWordSpacing(this.mNativePaint, wordSpacing);
    }

    public String getFontFeatureSettings() {
        return this.mFontFeatureSettings;
    }

    public void setFontFeatureSettings(String settings) {
        if (settings != null && settings.equals("")) {
            settings = null;
        }
        if (settings == null && this.mFontFeatureSettings == null || settings != null && settings.equals(this.mFontFeatureSettings)) {
            return;
        }
        this.mFontFeatureSettings = settings;
        Paint.nSetFontFeatureSettings(this.mNativePaint, settings);
    }

    public String getFontVariationSettings() {
        return this.mFontVariationSettings;
    }

    public boolean setFontVariationSettings(String fontVariationSettings) {
        String settings = TextUtils.nullIfEmpty(fontVariationSettings);
        if (settings == this.mFontVariationSettings || settings != null && settings.equals(this.mFontVariationSettings)) {
            return true;
        }
        if (settings == null || settings.length() == 0) {
            this.mFontVariationSettings = null;
            this.setTypeface(Typeface.createFromTypefaceWithVariation(this.mTypeface, Collections.emptyList()));
            return true;
        }
        Typeface targetTypeface = this.mTypeface == null ? Typeface.DEFAULT : this.mTypeface;
        FontVariationAxis[] axes = FontVariationAxis.fromFontVariationSettings(settings);
        ArrayList<FontVariationAxis> filteredAxes = new ArrayList<FontVariationAxis>();
        for (FontVariationAxis axis : axes) {
            if (!targetTypeface.isSupportedAxes(axis.getOpenTypeTagValue())) continue;
            filteredAxes.add(axis);
        }
        if (filteredAxes.isEmpty()) {
            return false;
        }
        this.mFontVariationSettings = settings;
        this.setTypeface(Typeface.createFromTypefaceWithVariation(targetTypeface, filteredAxes));
        return true;
    }

    public int getStartHyphenEdit() {
        return Paint.nGetStartHyphenEdit(this.mNativePaint);
    }

    public int getEndHyphenEdit() {
        return Paint.nGetEndHyphenEdit(this.mNativePaint);
    }

    public void setStartHyphenEdit(int startHyphen) {
        Paint.nSetStartHyphenEdit(this.mNativePaint, startHyphen);
    }

    public void setEndHyphenEdit(int endHyphen) {
        Paint.nSetEndHyphenEdit(this.mNativePaint, endHyphen);
    }

    public float ascent() {
        return Paint.nAscent(this.mNativePaint);
    }

    public float descent() {
        return Paint.nDescent(this.mNativePaint);
    }

    public float getFontMetrics(FontMetrics metrics) {
        return Paint.nGetFontMetrics(this.mNativePaint, metrics);
    }

    public FontMetrics getFontMetrics() {
        FontMetrics fm = new FontMetrics();
        this.getFontMetrics(fm);
        return fm;
    }

    public int getFontMetricsInt(FontMetricsInt fmi) {
        return Paint.nGetFontMetricsInt(this.mNativePaint, fmi);
    }

    public FontMetricsInt getFontMetricsInt() {
        FontMetricsInt fm = new FontMetricsInt();
        this.getFontMetricsInt(fm);
        return fm;
    }

    public float getFontSpacing() {
        return this.getFontMetrics(null);
    }

    public float measureText(char[] text, int index, int count) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(Paint.nGetTextAdvances(this.mNativePaint, text, index, count, index, count, this.mBidiFlags, null, 0));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = Paint.nGetTextAdvances(this.mNativePaint, text, index, count, index, count, this.mBidiFlags, null, 0);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    public float measureText(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(Paint.nGetTextAdvances(this.mNativePaint, text, start, end, start, end, this.mBidiFlags, null, 0));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = Paint.nGetTextAdvances(this.mNativePaint, text, start, end, start, end, this.mBidiFlags, null, 0);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    public float measureText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        return this.measureText(text, 0, text.length());
    }

    public float measureText(CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(text.toString(), start, end);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(char[] text, int index, int count, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (index < 0 || text.length - index < Math.abs(count)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nBreakText(this.mNativePaint, text, index, count, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.nBreakText(this.mNativePaint, text, index, count, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    public int breakText(CharSequence text, int start, int end, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (start == 0 && text instanceof String && end == text.length()) {
            return this.breakText((String)text, measureForwards, maxWidth, measuredWidth);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = measureForwards ? this.breakText(buf, 0, end - start, maxWidth, measuredWidth) : this.breakText(buf, 0, -(end - start), maxWidth, measuredWidth);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (text.length() == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nBreakText(this.mNativePaint, text, measureForwards, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.nBreakText(this.mNativePaint, text, measureForwards, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    public int getTextWidths(char[] text, int index, int count, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length || count > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            Paint.nGetTextAdvances(this.mNativePaint, text, index, count, index, count, this.mBidiFlags, widths, 0);
            return count;
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        Paint.nGetTextAdvances(this.mNativePaint, text, index, count, index, count, this.mBidiFlags, widths, 0);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < count) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return count;
    }

    public int getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(text.toString(), start, end, widths);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getTextWidths(String text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            Paint.nGetTextAdvances(this.mNativePaint, text, start, end, start, end, this.mBidiFlags, widths, 0);
            return end - start;
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        Paint.nGetTextAdvances(this.mNativePaint, text, start, end, start, end, this.mBidiFlags, widths, 0);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < end - start) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return end - start;
    }

    public int getTextWidths(String text, float[] widths) {
        return this.getTextWidths(text, 0, text.length(), widths);
    }

    public float getTextRunAdvances(char[] chars, int index, int count, int contextIndex, int contextCount, boolean isRtl, float[] advances, int advancesIndex) {
        if (chars == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count | contextIndex | contextCount | advancesIndex | index - contextIndex | contextCount - count | contextIndex + contextCount - (index + count) | chars.length - (contextIndex + contextCount) | (advances == null ? 0 : advances.length - (advancesIndex + count))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (chars.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.nGetTextAdvances(this.mNativePaint, chars, index, count, contextIndex, contextCount, isRtl ? 5 : 4, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float res = Paint.nGetTextAdvances(this.mNativePaint, chars, index, count, contextIndex, contextCount, isRtl ? 5 : 4, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + count;
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return res * this.mInvCompatScaling;
    }

    public int getTextRunCursor(char[] text, int contextStart, int contextLength, boolean isRtl, int offset, int cursorOpt) {
        int contextEnd = contextStart + contextLength;
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.nGetTextRunCursor(this.mNativePaint, text, contextStart, contextLength, isRtl ? 1 : 0, offset, cursorOpt);
    }

    public int getTextRunCursor(CharSequence text, int contextStart, int contextEnd, boolean isRtl, int offset, int cursorOpt) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunCursor(text.toString(), contextStart, contextEnd, isRtl, offset, cursorOpt);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunCursor(contextStart, contextEnd, isRtl, offset, cursorOpt, this);
        }
        int contextLen = contextEnd - contextStart;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int relPos = this.getTextRunCursor(buf, 0, contextLen, isRtl, offset - contextStart, cursorOpt);
        TemporaryBuffer.recycle(buf);
        return relPos == -1 ? -1 : relPos + contextStart;
    }

    public int getTextRunCursor(String text, int contextStart, int contextEnd, boolean isRtl, int offset, int cursorOpt) {
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length() - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.nGetTextRunCursor(this.mNativePaint, text, contextStart, contextEnd, isRtl ? 1 : 0, offset, cursorOpt);
    }

    public void getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Paint.nGetTextPath(this.mNativePaint, this.mBidiFlags, text, index, count, x, y, path.mutateNI());
    }

    public void getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Paint.nGetTextPath(this.mNativePaint, this.mBidiFlags, text, start, end, x, y, path.mutateNI());
    }

    public void getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nGetStringBounds(this.mNativePaint, text, start, end, this.mBidiFlags, bounds);
    }

    public void getTextBounds(CharSequence text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        this.getTextBounds(buf, 0, end - start, bounds);
        TemporaryBuffer.recycle(buf);
    }

    public void getTextBounds(char[] text, int index, int count, Rect bounds) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nGetCharArrayBounds(this.mNativePaint, text, index, count, this.mBidiFlags, bounds);
    }

    public boolean hasGlyph(String string2) {
        return Paint.nHasGlyph(this.mNativePaint, this.mBidiFlags, string2);
    }

    public float getRunAdvance(char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | offset | end | contextEnd | start - contextStart | offset - start | end - offset | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return 0.0f;
        }
        return Paint.nGetRunAdvance(this.mNativePaint, text, start, end, contextStart, contextEnd, isRtl, offset);
    }

    public float getRunAdvance(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | offset | end | contextEnd | start - contextStart | offset - start | end - offset | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return 0.0f;
        }
        char[] buf = TemporaryBuffer.obtain(contextEnd - contextStart);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        float result = this.getRunAdvance(buf, start - contextStart, end - contextStart, 0, contextEnd - contextStart, isRtl, offset - contextStart);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public int getOffsetForAdvance(char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | end | contextEnd | start - contextStart | end - start | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return Paint.nGetOffsetForAdvance(this.mNativePaint, text, start, end, contextStart, contextEnd, isRtl, advance);
    }

    public int getOffsetForAdvance(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((contextStart | start | end | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] buf = TemporaryBuffer.obtain(contextEnd - contextStart);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int result = this.getOffsetForAdvance(buf, start - contextStart, end - contextStart, 0, contextEnd - contextStart, isRtl, advance) + contextStart;
        TemporaryBuffer.recycle(buf);
        return result;
    }

    public boolean equalsForTextMeasurement(Paint other) {
        return Paint.nEqualsForTextMeasurement(this.mNativePaint, other.mNativePaint);
    }

    @LayoutlibDelegate
    private static long nGetNativeFinalizer() {
        return Paint_Delegate.nGetNativeFinalizer();
    }

    @LayoutlibDelegate
    private static long nInit() {
        return Paint_Delegate.nInit();
    }

    @LayoutlibDelegate
    private static long nInitWithPaint(long l) {
        return Paint_Delegate.nInitWithPaint(l);
    }

    @LayoutlibDelegate
    private static int nBreakText(long l, char[] cArray, int n, int n2, float f, int n3, float[] fArray) {
        return Paint_Delegate.nBreakText(l, cArray, n, n2, f, n3, fArray);
    }

    @LayoutlibDelegate
    private static int nBreakText(long l, String string2, boolean bl, float f, int n, float[] fArray) {
        return Paint_Delegate.nBreakText(l, string2, bl, f, n, fArray);
    }

    @LayoutlibDelegate
    private static float nGetTextAdvances(long l, char[] cArray, int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        return Paint_Delegate.nGetTextAdvances(l, cArray, n, n2, n3, n4, n5, fArray, n6);
    }

    @LayoutlibDelegate
    private static float nGetTextAdvances(long l, String string2, int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        return Paint_Delegate.nGetTextAdvances(l, string2, n, n2, n3, n4, n5, fArray, n6);
    }

    @LayoutlibDelegate
    private int nGetTextRunCursor(long l, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return Paint_Delegate.nGetTextRunCursor(this, l, cArray, n, n2, n3, n4, n5);
    }

    @LayoutlibDelegate
    private int nGetTextRunCursor(long l, String string2, int n, int n2, int n3, int n4, int n5) {
        return Paint_Delegate.nGetTextRunCursor(this, l, string2, n, n2, n3, n4, n5);
    }

    @LayoutlibDelegate
    private static void nGetTextPath(long l, int n, char[] cArray, int n2, int n3, float f, float f2, long l2) {
        Paint_Delegate.nGetTextPath(l, n, cArray, n2, n3, f, f2, l2);
    }

    @LayoutlibDelegate
    private static void nGetTextPath(long l, int n, String string2, int n2, int n3, float f, float f2, long l2) {
        Paint_Delegate.nGetTextPath(l, n, string2, n2, n3, f, f2, l2);
    }

    @LayoutlibDelegate
    private static void nGetStringBounds(long l, String string2, int n, int n2, int n3, Rect rect) {
        Paint_Delegate.nGetStringBounds(l, string2, n, n2, n3, rect);
    }

    @LayoutlibDelegate
    private static void nGetCharArrayBounds(long l, char[] cArray, int n, int n2, int n3, Rect rect) {
        Paint_Delegate.nGetCharArrayBounds(l, cArray, n, n2, n3, rect);
    }

    @LayoutlibDelegate
    private static boolean nHasGlyph(long l, int n, String string2) {
        return Paint_Delegate.nHasGlyph(l, n, string2);
    }

    @LayoutlibDelegate
    private static float nGetRunAdvance(long l, char[] cArray, int n, int n2, int n3, int n4, boolean bl, int n5) {
        return Paint_Delegate.nGetRunAdvance(l, cArray, n, n2, n3, n4, bl, n5);
    }

    @LayoutlibDelegate
    private static int nGetOffsetForAdvance(long l, char[] cArray, int n, int n2, int n3, int n4, boolean bl, float f) {
        return Paint_Delegate.nGetOffsetForAdvance(l, cArray, n, n2, n3, n4, bl, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static int nSetTextLocales(long l, String string2) {
        return Paint_Delegate.nSetTextLocales(l, string2);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetFontFeatureSettings(long l, String string2) {
        Paint_Delegate.nSetFontFeatureSettings(l, string2);
    }

    @LayoutlibDelegate
    @FastNative
    private static float nGetFontMetrics(long l, FontMetrics fontMetrics) {
        return Paint_Delegate.nGetFontMetrics(l, fontMetrics);
    }

    @LayoutlibDelegate
    @FastNative
    private static int nGetFontMetricsInt(long l, FontMetricsInt fontMetricsInt) {
        return Paint_Delegate.nGetFontMetricsInt(l, fontMetricsInt);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nReset(long l) {
        Paint_Delegate.nReset(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSet(long l, long l2) {
        Paint_Delegate.nSet(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetStyle(long l) {
        return Paint_Delegate.nGetStyle(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetStyle(long l, int n) {
        Paint_Delegate.nSetStyle(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetStrokeCap(long l) {
        return Paint_Delegate.nGetStrokeCap(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetStrokeCap(long l, int n) {
        Paint_Delegate.nSetStrokeCap(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetStrokeJoin(long l) {
        return Paint_Delegate.nGetStrokeJoin(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetStrokeJoin(long l, int n) {
        Paint_Delegate.nSetStrokeJoin(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nGetFillPath(long l, long l2, long l3) {
        return Paint_Delegate.nGetFillPath(l, l2, l3);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nSetShader(long l, long l2) {
        return Paint_Delegate.nSetShader(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nSetColorFilter(long l, long l2) {
        return Paint_Delegate.nSetColorFilter(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetXfermode(long l, int n) {
        Paint_Delegate.nSetXfermode(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nSetPathEffect(long l, long l2) {
        return Paint_Delegate.nSetPathEffect(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nSetMaskFilter(long l, long l2) {
        return Paint_Delegate.nSetMaskFilter(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetTypeface(long l, long l2) {
        Paint_Delegate.nSetTypeface(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetTextAlign(long l) {
        return Paint_Delegate.nGetTextAlign(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetTextAlign(long l, int n) {
        Paint_Delegate.nSetTextAlign(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetTextLocalesByMinikinLocaleListId(long l, int n) {
        Paint_Delegate.nSetTextLocalesByMinikinLocaleListId(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetShadowLayer(long l, float f, float f2, float f3, long l2, long l3) {
        Paint_Delegate.nSetShadowLayer(l, f, f2, f3, l2, l3);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nHasShadowLayer(long l) {
        return Paint_Delegate.nHasShadowLayer(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetLetterSpacing(long l) {
        return Paint_Delegate.nGetLetterSpacing(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetLetterSpacing(long l, float f) {
        Paint_Delegate.nSetLetterSpacing(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetWordSpacing(long l) {
        return Paint_Delegate.nGetWordSpacing(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetWordSpacing(long l, float f) {
        Paint_Delegate.nSetWordSpacing(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetStartHyphenEdit(long l) {
        return Paint_Delegate.nGetStartHyphenEdit(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetEndHyphenEdit(long l) {
        return Paint_Delegate.nGetEndHyphenEdit(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetStartHyphenEdit(long l, int n) {
        Paint_Delegate.nSetStartHyphenEdit(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetEndHyphenEdit(long l, int n) {
        Paint_Delegate.nSetEndHyphenEdit(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetStrokeMiter(long l, float f) {
        Paint_Delegate.nSetStrokeMiter(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetStrokeMiter(long l) {
        return Paint_Delegate.nGetStrokeMiter(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetStrokeWidth(long l, float f) {
        Paint_Delegate.nSetStrokeWidth(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetStrokeWidth(long l) {
        return Paint_Delegate.nGetStrokeWidth(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetAlpha(long l, int n) {
        Paint_Delegate.nSetAlpha(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetDither(long l, boolean bl) {
        Paint_Delegate.nSetDither(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetFlags(long l) {
        return Paint_Delegate.nGetFlags(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetFlags(long l, int n) {
        Paint_Delegate.nSetFlags(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetHinting(long l) {
        return Paint_Delegate.nGetHinting(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetHinting(long l, int n) {
        Paint_Delegate.nSetHinting(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetAntiAlias(long l, boolean bl) {
        Paint_Delegate.nSetAntiAlias(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetLinearText(long l, boolean bl) {
        Paint_Delegate.nSetLinearText(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetSubpixelText(long l, boolean bl) {
        Paint_Delegate.nSetSubpixelText(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetUnderlineText(long l, boolean bl) {
        Paint_Delegate.nSetUnderlineText(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetFakeBoldText(long l, boolean bl) {
        Paint_Delegate.nSetFakeBoldText(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetFilterBitmap(long l, boolean bl) {
        Paint_Delegate.nSetFilterBitmap(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetColor(long l, long l2, long l3) {
        Paint_Delegate.nSetColor(l, l2, l3);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetColor(long l, int n) {
        Paint_Delegate.nSetColor(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetStrikeThruText(long l, boolean bl) {
        Paint_Delegate.nSetStrikeThruText(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nIsElegantTextHeight(long l) {
        return Paint_Delegate.nIsElegantTextHeight(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetElegantTextHeight(long l, boolean bl) {
        Paint_Delegate.nSetElegantTextHeight(l, bl);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTextSize(long l) {
        return Paint_Delegate.nGetTextSize(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTextScaleX(long l) {
        return Paint_Delegate.nGetTextScaleX(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetTextScaleX(long l, float f) {
        Paint_Delegate.nSetTextScaleX(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetTextSkewX(long l) {
        return Paint_Delegate.nGetTextSkewX(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetTextSkewX(long l, float f) {
        Paint_Delegate.nSetTextSkewX(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nAscent(long l) {
        return Paint_Delegate.nAscent(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nDescent(long l) {
        return Paint_Delegate.nDescent(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetUnderlinePosition(long l) {
        return Paint_Delegate.nGetUnderlinePosition(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetUnderlineThickness(long l) {
        return Paint_Delegate.nGetUnderlineThickness(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetStrikeThruPosition(long l) {
        return Paint_Delegate.nGetStrikeThruPosition(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static float nGetStrikeThruThickness(long l) {
        return Paint_Delegate.nGetStrikeThruThickness(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetTextSize(long l, float f) {
        Paint_Delegate.nSetTextSize(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nEqualsForTextMeasurement(long l, long l2) {
        return Paint_Delegate.nEqualsForTextMeasurement(l, l2);
    }

    static /* synthetic */ long access$000() {
        return Paint.nGetNativeFinalizer();
    }

    public static class FontMetricsInt {
        public int top;
        public int ascent;
        public int descent;
        public int bottom;
        public int leading;

        public String toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }
    }

    public static class FontMetrics {
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;
    }

    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        final int nativeInt;

        private Align(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Join {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        final int nativeInt;

        private Join(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Cap {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        final int nativeInt;

        private Cap(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum Style {
        FILL(0),
        STROKE(1),
        FILL_AND_STROKE(2);

        final int nativeInt;

        private Style(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EndHyphenEdit {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartHyphenEdit {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CursorOption {
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Paint.class.getClassLoader(), Paint.access$000());

        private NoImagePreloadHolder() {
        }
    }
}

