/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.UnsupportedAppUsage;
import android.content.pm.ComponentInfo;
import android.content.pm.SuspendDialogInfo;
import android.os.BaseBundle;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;

public class PackageUserState {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "PackageUserState";
    public long ceDataInode;
    public boolean installed;
    public boolean stopped;
    public boolean notLaunched;
    public boolean hidden;
    public int distractionFlags;
    public boolean suspended;
    public String suspendingPackage;
    public SuspendDialogInfo dialogInfo;
    public PersistableBundle suspendedAppExtras;
    public PersistableBundle suspendedLauncherExtras;
    public boolean instantApp;
    public boolean virtualPreload;
    public int enabled;
    public String lastDisableAppCaller;
    public int domainVerificationStatus;
    public int appLinkGeneration;
    public int categoryHint = -1;
    public int installReason;
    public String harmfulAppWarning;
    public ArraySet<String> disabledComponents;
    public ArraySet<String> enabledComponents;
    public String[] overlayPaths;

    @UnsupportedAppUsage
    public PackageUserState() {
        this.installed = true;
        this.hidden = false;
        this.suspended = false;
        this.enabled = 0;
        this.domainVerificationStatus = 0;
        this.installReason = 0;
    }

    @VisibleForTesting
    public PackageUserState(PackageUserState o) {
        this.ceDataInode = o.ceDataInode;
        this.installed = o.installed;
        this.stopped = o.stopped;
        this.notLaunched = o.notLaunched;
        this.hidden = o.hidden;
        this.distractionFlags = o.distractionFlags;
        this.suspended = o.suspended;
        this.suspendingPackage = o.suspendingPackage;
        this.dialogInfo = o.dialogInfo;
        this.suspendedAppExtras = o.suspendedAppExtras;
        this.suspendedLauncherExtras = o.suspendedLauncherExtras;
        this.instantApp = o.instantApp;
        this.virtualPreload = o.virtualPreload;
        this.enabled = o.enabled;
        this.lastDisableAppCaller = o.lastDisableAppCaller;
        this.domainVerificationStatus = o.domainVerificationStatus;
        this.appLinkGeneration = o.appLinkGeneration;
        this.categoryHint = o.categoryHint;
        this.installReason = o.installReason;
        this.disabledComponents = ArrayUtils.cloneOrNull(o.disabledComponents);
        this.enabledComponents = ArrayUtils.cloneOrNull(o.enabledComponents);
        this.overlayPaths = o.overlayPaths == null ? null : Arrays.copyOf(o.overlayPaths, o.overlayPaths.length);
        this.harmfulAppWarning = o.harmfulAppWarning;
    }

    public boolean isAvailable(int flags) {
        boolean matchAnyUser = (flags & 0x400000) != 0;
        boolean matchUninstalled = (flags & 0x2000) != 0;
        return matchAnyUser || this.installed && (!this.hidden || matchUninstalled);
    }

    public boolean isMatch(ComponentInfo componentInfo, int flags) {
        boolean matchUninstalled;
        boolean isSystemApp = componentInfo.applicationInfo.isSystemApp();
        boolean bl = matchUninstalled = (flags & 0x402000) != 0;
        if (!(this.isAvailable(flags) || isSystemApp && matchUninstalled)) {
            return this.reportIfDebug(false, flags);
        }
        if (!this.isEnabled(componentInfo, flags)) {
            return this.reportIfDebug(false, flags);
        }
        if ((flags & 0x100000) != 0 && !isSystemApp) {
            return this.reportIfDebug(false, flags);
        }
        boolean matchesUnaware = (flags & 0x40000) != 0 && !componentInfo.directBootAware;
        boolean matchesAware = (flags & 0x80000) != 0 && componentInfo.directBootAware;
        return this.reportIfDebug(matchesUnaware || matchesAware, flags);
    }

    private boolean reportIfDebug(boolean result, int flags) {
        return result;
    }

    public boolean isEnabled(ComponentInfo componentInfo, int flags) {
        if ((flags & 0x200) != 0) {
            return true;
        }
        switch (this.enabled) {
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                if ((flags & 0x8000) == 0) {
                    return false;
                }
            }
            case 0: {
                if (componentInfo.applicationInfo.enabled) break;
                return false;
            }
        }
        if (ArrayUtils.contains(this.enabledComponents, componentInfo.name)) {
            return true;
        }
        if (ArrayUtils.contains(this.disabledComponents, componentInfo.name)) {
            return false;
        }
        return componentInfo.enabled;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof PackageUserState)) {
            return false;
        }
        PackageUserState oldState = (PackageUserState)obj;
        if (this.ceDataInode != oldState.ceDataInode) {
            return false;
        }
        if (this.installed != oldState.installed) {
            return false;
        }
        if (this.stopped != oldState.stopped) {
            return false;
        }
        if (this.notLaunched != oldState.notLaunched) {
            return false;
        }
        if (this.hidden != oldState.hidden) {
            return false;
        }
        if (this.distractionFlags != oldState.distractionFlags) {
            return false;
        }
        if (this.suspended != oldState.suspended) {
            return false;
        }
        if (this.suspended) {
            if (this.suspendingPackage == null || !this.suspendingPackage.equals(oldState.suspendingPackage)) {
                return false;
            }
            if (!Objects.equals(this.dialogInfo, oldState.dialogInfo)) {
                return false;
            }
            if (!BaseBundle.kindofEquals(this.suspendedAppExtras, oldState.suspendedAppExtras)) {
                return false;
            }
            if (!BaseBundle.kindofEquals(this.suspendedLauncherExtras, oldState.suspendedLauncherExtras)) {
                return false;
            }
        }
        if (this.instantApp != oldState.instantApp) {
            return false;
        }
        if (this.virtualPreload != oldState.virtualPreload) {
            return false;
        }
        if (this.enabled != oldState.enabled) {
            return false;
        }
        if (this.lastDisableAppCaller == null && oldState.lastDisableAppCaller != null || this.lastDisableAppCaller != null && !this.lastDisableAppCaller.equals(oldState.lastDisableAppCaller)) {
            return false;
        }
        if (this.domainVerificationStatus != oldState.domainVerificationStatus) {
            return false;
        }
        if (this.appLinkGeneration != oldState.appLinkGeneration) {
            return false;
        }
        if (this.categoryHint != oldState.categoryHint) {
            return false;
        }
        if (this.installReason != oldState.installReason) {
            return false;
        }
        if (this.disabledComponents == null && oldState.disabledComponents != null || this.disabledComponents != null && oldState.disabledComponents == null) {
            return false;
        }
        if (this.disabledComponents != null) {
            if (this.disabledComponents.size() != oldState.disabledComponents.size()) {
                return false;
            }
            for (i = this.disabledComponents.size() - 1; i >= 0; --i) {
                if (oldState.disabledComponents.contains(this.disabledComponents.valueAt(i))) continue;
                return false;
            }
        }
        if (this.enabledComponents == null && oldState.enabledComponents != null || this.enabledComponents != null && oldState.enabledComponents == null) {
            return false;
        }
        if (this.enabledComponents != null) {
            if (this.enabledComponents.size() != oldState.enabledComponents.size()) {
                return false;
            }
            for (i = this.enabledComponents.size() - 1; i >= 0; --i) {
                if (oldState.enabledComponents.contains(this.enabledComponents.valueAt(i))) continue;
                return false;
            }
        }
        return (this.harmfulAppWarning != null || oldState.harmfulAppWarning == null) && (this.harmfulAppWarning == null || this.harmfulAppWarning.equals(oldState.harmfulAppWarning));
    }
}

