/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.UnsupportedAppUsage;
import android.content.ISyncContext;
import android.content.SyncResult;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;

public class SyncContext {
    private ISyncContext mSyncContext;
    private long mLastHeartbeatSendTime;
    private static final long HEARTBEAT_SEND_INTERVAL_IN_MS = 1000L;

    @UnsupportedAppUsage
    public SyncContext(ISyncContext syncContextInterface) {
        this.mSyncContext = syncContextInterface;
        this.mLastHeartbeatSendTime = 0L;
    }

    @UnsupportedAppUsage
    public void setStatusText(String message) {
        this.updateHeartbeat();
    }

    private void updateHeartbeat() {
        long now = SystemClock.elapsedRealtime();
        if (now < this.mLastHeartbeatSendTime + 1000L) {
            return;
        }
        try {
            this.mLastHeartbeatSendTime = now;
            if (this.mSyncContext != null) {
                this.mSyncContext.sendHeartbeat();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onFinished(SyncResult result) {
        try {
            if (this.mSyncContext != null) {
                this.mSyncContext.onFinished(result);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public IBinder getSyncContextBinder() {
        return this.mSyncContext == null ? null : this.mSyncContext.asBinder();
    }
}

