/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.Process;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PermissionChecker {
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_DENIED = -1;
    public static final int PERMISSION_DENIED_APP_OP = -2;

    private PermissionChecker() {
    }

    public static int checkPermission(Context context, String permission2, int pid, int uid, String packageName) {
        if (context.checkPermission(permission2, pid, uid) == -1) {
            return -1;
        }
        AppOpsManager appOpsManager = context.getSystemService(AppOpsManager.class);
        String op = AppOpsManager.permissionToOp(permission2);
        if (op == null) {
            return 0;
        }
        if (packageName == null) {
            String[] packageNames = context.getPackageManager().getPackagesForUid(uid);
            if (packageNames == null || packageNames.length <= 0) {
                return -1;
            }
            packageName = packageNames[0];
        }
        if (appOpsManager.noteProxyOpNoThrow(op, packageName, uid) != 0) {
            return -2;
        }
        return 0;
    }

    public static int checkSelfPermission(Context context, String permission2) {
        return PermissionChecker.checkPermission(context, permission2, Process.myPid(), Process.myUid(), context.getPackageName());
    }

    public static int checkCallingPermission(Context context, String permission2, String packageName) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return -1;
        }
        return PermissionChecker.checkPermission(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    public static int checkCallingOrSelfPermission(Context context, String permission2) {
        String packageName = Binder.getCallingPid() == Process.myPid() ? context.getPackageName() : null;
        return PermissionChecker.checkPermission(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionResult {
    }
}

