/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.app.ActivityThread;
import android.app.role.IRoleController;
import android.app.role.RoleManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.infra.AbstractMultiplePendingRequestsRemoteService;
import com.android.internal.infra.AbstractRemoteService;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class RoleControllerManager {
    private static final String LOG_TAG = RoleControllerManager.class.getSimpleName();
    private static volatile ComponentName sRemoteServiceComponentName;
    private static final Object sRemoteServicesLock;
    @GuardedBy(value={"sRemoteServicesLock"})
    private static final SparseArray<RemoteService> sRemoteServices;
    private final RemoteService mRemoteService;

    public static void initializeRemoteServiceComponentName(Context context) {
        sRemoteServiceComponentName = RoleControllerManager.getRemoteServiceComponentName(context);
    }

    public static RoleControllerManager createWithInitializedRemoteServiceComponentName(Handler handler, Context context) {
        return new RoleControllerManager(sRemoteServiceComponentName, handler, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoleControllerManager(ComponentName remoteServiceComponentName, Handler handler, Context context) {
        Object object = sRemoteServicesLock;
        synchronized (object) {
            int userId = context.getUserId();
            RemoteService remoteService = sRemoteServices.get(userId);
            if (remoteService == null) {
                remoteService = new RemoteService(ActivityThread.currentApplication(), remoteServiceComponentName, handler, userId);
                sRemoteServices.put(userId, remoteService);
            }
            this.mRemoteService = remoteService;
        }
    }

    public RoleControllerManager(Context context) {
        this(RoleControllerManager.getRemoteServiceComponentName(context), context.getMainThreadHandler(), context);
    }

    private static ComponentName getRemoteServiceComponentName(Context context) {
        Intent intent = new Intent("android.app.role.RoleControllerService");
        PackageManager packageManager = context.getPackageManager();
        intent.setPackage(packageManager.getPermissionControllerPackageName());
        ResolveInfo resolveInfo = packageManager.resolveService(intent, 0);
        return resolveInfo.getComponentInfo().getComponentName();
    }

    public void grantDefaultRoles(Executor executor, Consumer<Boolean> callback) {
        this.mRemoteService.scheduleRequest(new GrantDefaultRolesRequest(this.mRemoteService, executor, callback));
    }

    public void onAddRoleHolder(String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        this.mRemoteService.scheduleRequest(new OnAddRoleHolderRequest(this.mRemoteService, roleName, packageName, flags, callback));
    }

    public void onRemoveRoleHolder(String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        this.mRemoteService.scheduleRequest(new OnRemoveRoleHolderRequest(this.mRemoteService, roleName, packageName, flags, callback));
    }

    public void onClearRoleHolders(String roleName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        this.mRemoteService.scheduleRequest(new OnClearRoleHoldersRequest(this.mRemoteService, roleName, flags, callback));
    }

    public void isApplicationQualifiedForRole(String roleName, String packageName, Executor executor, Consumer<Boolean> callback) {
        this.mRemoteService.scheduleRequest(new IsApplicationQualifiedForRoleRequest(this.mRemoteService, roleName, packageName, executor, callback));
    }

    public void isRoleVisible(String roleName, Executor executor, Consumer<Boolean> callback) {
        this.mRemoteService.scheduleRequest(new IsRoleVisibleRequest(this.mRemoteService, roleName, executor, callback));
    }

    static {
        sRemoteServicesLock = new Object();
        sRemoteServices = new SparseArray();
    }

    private static class IsRoleVisibleRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IRoleController> {
        private final String mRoleName;
        private final Executor mExecutor;
        private final Consumer<Boolean> mCallback;
        private final RemoteCallback mRemoteCallback;

        private IsRoleVisibleRequest(RemoteService service, String roleName, Executor executor, Consumer<Boolean> callback) {
            super(service);
            this.mRoleName = roleName;
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> this.mExecutor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    boolean visible = result != null;
                    this.mCallback.accept(visible);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            }));
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mExecutor.execute(() -> this.mCallback.accept(false));
        }

        @Override
        public void run() {
            try {
                ((IRoleController)((RemoteService)this.getService()).getServiceInterface()).isRoleVisible(this.mRoleName, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Error calling isRoleVisible()", e);
            }
        }
    }

    private static class IsApplicationQualifiedForRoleRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IRoleController> {
        private final String mRoleName;
        private final String mPackageName;
        private final Executor mExecutor;
        private final Consumer<Boolean> mCallback;
        private final RemoteCallback mRemoteCallback;

        private IsApplicationQualifiedForRoleRequest(RemoteService service, String roleName, String packageName, Executor executor, Consumer<Boolean> callback) {
            super(service);
            this.mRoleName = roleName;
            this.mPackageName = packageName;
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> this.mExecutor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    boolean qualified = result != null;
                    this.mCallback.accept(qualified);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            }));
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mExecutor.execute(() -> this.mCallback.accept(false));
        }

        @Override
        public void run() {
            try {
                ((IRoleController)((RemoteService)this.getService()).getServiceInterface()).isApplicationQualifiedForRole(this.mRoleName, this.mPackageName, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Error calling isApplicationQualifiedForRole()", e);
            }
        }
    }

    private static class OnClearRoleHoldersRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IRoleController> {
        private final String mRoleName;
        @RoleManager.ManageHoldersFlags
        private final int mFlags;
        private final RemoteCallback mCallback;
        private final RemoteCallback mRemoteCallback;

        private OnClearRoleHoldersRequest(RemoteService service, String roleName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
            super(service);
            this.mRoleName = roleName;
            this.mFlags = flags;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mCallback.sendResult(result);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            });
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mCallback.sendResult(null);
        }

        @Override
        public void run() {
            try {
                ((IRoleController)((RemoteService)this.getService()).getServiceInterface()).onClearRoleHolders(this.mRoleName, this.mFlags, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Error calling onClearRoleHolders()", e);
            }
        }
    }

    private static class OnRemoveRoleHolderRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IRoleController> {
        private final String mRoleName;
        private final String mPackageName;
        @RoleManager.ManageHoldersFlags
        private final int mFlags;
        private final RemoteCallback mCallback;
        private final RemoteCallback mRemoteCallback;

        private OnRemoveRoleHolderRequest(RemoteService service, String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
            super(service);
            this.mRoleName = roleName;
            this.mPackageName = packageName;
            this.mFlags = flags;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mCallback.sendResult(result);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            });
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mCallback.sendResult(null);
        }

        @Override
        public void run() {
            try {
                ((IRoleController)((RemoteService)this.getService()).getServiceInterface()).onRemoveRoleHolder(this.mRoleName, this.mPackageName, this.mFlags, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Error calling onRemoveRoleHolder()", e);
            }
        }
    }

    private static class OnAddRoleHolderRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IRoleController> {
        private final String mRoleName;
        private final String mPackageName;
        @RoleManager.ManageHoldersFlags
        private final int mFlags;
        private final RemoteCallback mCallback;
        private final RemoteCallback mRemoteCallback;

        private OnAddRoleHolderRequest(RemoteService service, String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
            super(service);
            this.mRoleName = roleName;
            this.mPackageName = packageName;
            this.mFlags = flags;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mCallback.sendResult(result);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            });
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mCallback.sendResult(null);
        }

        @Override
        public void run() {
            try {
                ((IRoleController)((RemoteService)this.getService()).getServiceInterface()).onAddRoleHolder(this.mRoleName, this.mPackageName, this.mFlags, this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Error calling onAddRoleHolder()", e);
            }
        }
    }

    private static class GrantDefaultRolesRequest
    extends AbstractRemoteService.PendingRequest<RemoteService, IRoleController> {
        private final Executor mExecutor;
        private final Consumer<Boolean> mCallback;
        private final RemoteCallback mRemoteCallback;

        private GrantDefaultRolesRequest(RemoteService service, Executor executor, Consumer<Boolean> callback) {
            super(service);
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mRemoteCallback = new RemoteCallback(result -> this.mExecutor.execute(() -> {
                long token = Binder.clearCallingIdentity();
                try {
                    boolean successful = result != null;
                    this.mCallback.accept(successful);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                    this.finish();
                }
            }));
        }

        @Override
        protected void onTimeout(RemoteService remoteService) {
            this.mExecutor.execute(() -> this.mCallback.accept(false));
        }

        @Override
        public void run() {
            try {
                ((IRoleController)((RemoteService)this.getService()).getServiceInterface()).grantDefaultRoles(this.mRemoteCallback);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "Error calling grantDefaultRoles()", e);
            }
        }

        @Override
        protected void onFailed() {
            this.mRemoteCallback.sendResult(null);
        }
    }

    private static class RemoteService
    extends AbstractMultiplePendingRequestsRemoteService<RemoteService, IRoleController> {
        private static final long UNBIND_DELAY_MILLIS = 15000L;
        private static final long REQUEST_TIMEOUT_MILLIS = 15000L;

        RemoteService(Context context, ComponentName componentName, Handler handler, int userId) {
            super(context, "android.app.role.RoleControllerService", componentName, userId, service -> Log.e(LOG_TAG, "RemoteService " + service + " died"), handler, 0, false, 1);
        }

        public Handler getHandler() {
            return this.mHandler;
        }

        @Override
        protected IRoleController getServiceInterface(IBinder binder) {
            return IRoleController.Stub.asInterface(binder);
        }

        @Override
        protected long getTimeoutIdleBindMillis() {
            return 15000L;
        }

        @Override
        protected long getRemoteRequestMillis() {
            return 15000L;
        }

        @Override
        public void scheduleRequest(AbstractRemoteService.BasePendingRequest<RemoteService, IRoleController> pendingRequest) {
            super.scheduleRequest(pendingRequest);
        }

        @Override
        public void scheduleAsyncRequest(AbstractRemoteService.AsyncRequest<IRoleController> request) {
            super.scheduleAsyncRequest(request);
        }
    }
}

