/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.annotation.UnsupportedAppUsage;
import android.app.ActivityManager;
import android.app.IUiAutomationConnection;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import android.view.Display;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;

public class UiAutomation {
    private static final String LOG_TAG = UiAutomation.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int CONNECTION_ID_UNDEFINED = -1;
    private static final long CONNECT_TIMEOUT_MILLIS = 5000L;
    public static final int ROTATION_UNFREEZE = -2;
    public static final int ROTATION_FREEZE_CURRENT = -1;
    public static final int ROTATION_FREEZE_0 = 0;
    public static final int ROTATION_FREEZE_90 = 1;
    public static final int ROTATION_FREEZE_180 = 2;
    public static final int ROTATION_FREEZE_270 = 3;
    public static final int FLAG_DONT_SUPPRESS_ACCESSIBILITY_SERVICES = 1;
    private final Object mLock = new Object();
    private final ArrayList<AccessibilityEvent> mEventQueue = new ArrayList();
    private final Handler mLocalCallbackHandler;
    private final IUiAutomationConnection mUiAutomationConnection;
    private HandlerThread mRemoteCallbackThread;
    private IAccessibilityServiceClient mClient;
    private int mConnectionId = -1;
    private OnAccessibilityEventListener mOnAccessibilityEventListener;
    private boolean mWaitingForEventDelivery;
    private long mLastEventTimeMillis;
    private boolean mIsConnecting;
    private boolean mIsDestroyed;
    private int mFlags;

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public UiAutomation(Looper looper, IUiAutomationConnection connection) {
        if (looper == null) {
            throw new IllegalArgumentException("Looper cannot be null!");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null!");
        }
        this.mLocalCallbackHandler = new Handler(looper);
        this.mUiAutomationConnection = connection;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void connect() {
        this.connect(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int flags) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfConnectedLocked();
            if (this.mIsConnecting) {
                return;
            }
            this.mIsConnecting = true;
            this.mRemoteCallbackThread = new HandlerThread("UiAutomation");
            this.mRemoteCallbackThread.start();
            this.mClient = new IAccessibilityServiceClientImpl(this.mRemoteCallbackThread.getLooper());
        }
        try {
            this.mUiAutomationConnection.connect(this.mClient, flags);
            this.mFlags = flags;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while connecting UiAutomation", re);
        }
        object = this.mLock;
        synchronized (object) {
            block18: {
                long startTimeMillis = SystemClock.uptimeMillis();
                block13: while (true) {
                    while (true) {
                        if (this.isConnectedLocked()) {
                            break block18;
                        }
                        long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                        long remainingTimeMillis = 5000L - elapsedTimeMillis;
                        if (remainingTimeMillis <= 0L) {
                            throw new RuntimeException("Error while connecting UiAutomation");
                        }
                        try {
                            this.mLock.wait(remainingTimeMillis);
                            continue block13;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.mIsConnecting = false;
                }
            }
        }
    }

    public int getFlags() {
        return this.mFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsConnecting) {
                throw new IllegalStateException("Cannot call disconnect() while connecting!");
            }
            this.throwIfNotConnectedLocked();
            this.mConnectionId = -1;
        }
        try {
            this.mUiAutomationConnection.disconnect();
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while disconnecting UiAutomation", re);
        }
        finally {
            this.mRemoteCallbackThread.quit();
            this.mRemoteCallbackThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionId() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            return this.mConnectionId;
        }
    }

    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnAccessibilityEventListener(OnAccessibilityEventListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnAccessibilityEventListener = listener;
        }
    }

    public void destroy() {
        this.disconnect();
        this.mIsDestroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adoptShellPermissionIdentity() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.adoptShellPermissionIdentity(Process.myUid(), null);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing adopting shell permission identity!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adoptShellPermissionIdentity(String ... permissions) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.adoptShellPermissionIdentity(Process.myUid(), permissions);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing adopting shell permission identity!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropShellPermissionIdentity() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.dropShellPermissionIdentity();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing dropping shell permission identity!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performGlobalAction(int action) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.performGlobalAction(action);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling performGlobalAction", re);
            }
        }
        return false;
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, focus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityServiceInfo getServiceInfo() {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.getServiceInfo();
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while getting AccessibilityServiceInfo", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceInfo(AccessibilityServiceInfo info) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance().clearCache();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                connection.setServiceInfo(info);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityWindowInfo> getWindows() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getWindows(connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo getRootInActiveWindow() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean injectInputEvent(InputEvent event, boolean sync) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.injectInputEvent(event, sync);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while injecting input event!", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncInputTransactions() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.syncInputTransactions();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while syncing input transactions!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        switch (rotation) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                try {
                    this.mUiAutomationConnection.setRotation(rotation);
                    return true;
                }
                catch (RemoteException re) {
                    Log.e(LOG_TAG, "Error while setting rotation!", re);
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid rotation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessibilityEvent executeAndWaitForEvent(Runnable command, AccessibilityEventFilter filter, long timeoutMillis) throws TimeoutException {
        block24: {
            var5_4 = this.mLock;
            synchronized (var5_4) {
                this.throwIfNotConnectedLocked();
                this.mEventQueue.clear();
                this.mWaitingForEventDelivery = true;
            }
            executionStartTimeMillis = SystemClock.uptimeMillis();
            command.run();
            receivedEvents = new ArrayList<AccessibilityEvent>();
            try {
                startTimeMillis = SystemClock.uptimeMillis();
lbl11:
                // 2 sources

                while (true) {
                    localEvents = new ArrayList<AccessibilityEvent>();
                    var13_9 = this.mLock;
                    synchronized (var13_9) {
                        localEvents.addAll(this.mEventQueue);
                        this.mEventQueue.clear();
                    }
lbl18:
                    // 3 sources

                    while (!localEvents.isEmpty()) {
                        event = (AccessibilityEvent)localEvents.remove(0);
                        if (event.getEventTime() < executionStartTimeMillis) continue;
                        if (filter.accept(event)) {
                            var14_14 = event;
                            size = receivedEvents.size();
                            i = 0;
                            break block24;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl57
                    break;
                }
            }
            catch (Throwable var24_18) {
                size = receivedEvents.size();
                i = 0;
                while (true) {
                    if (i >= size) {
                        var26_21 = this.mLock;
                        synchronized (var26_21) {
                            this.mWaitingForEventDelivery = false;
                            this.mEventQueue.clear();
                            this.mLock.notifyAll();
                            throw var24_18;
                        }
                    }
                    ((AccessibilityEvent)receivedEvents.get(i)).recycle();
                    ++i;
                }
            }
        }
        while (true) {
            if (i >= size) {
                var16_17 = this.mLock;
                synchronized (var16_17) {
                    this.mWaitingForEventDelivery = false;
                    this.mEventQueue.clear();
                    this.mLock.notifyAll();
                    return var14_14;
                }
            }
            ((AccessibilityEvent)receivedEvents.get(i)).recycle();
            ++i;
        }
lbl-1000:
        // 1 sources

        {
            receivedEvents.add(event);
            ** GOTO lbl18
lbl57:
            // 1 sources

            elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
            remainingTimeMillis = timeoutMillis - elapsedTimeMillis;
            if (remainingTimeMillis <= 0L) {
                throw new TimeoutException("Expected event not received within: " + timeoutMillis + " ms among: " + receivedEvents);
            }
            var17_10 = this.mLock;
            synchronized (var17_10) {
                if (this.mEventQueue.isEmpty()) {
                    try {
                        this.mLock.wait(remainingTimeMillis);
                    }
                    catch (InterruptedException var22_13) {
                        // empty catch block
                    }
                }
            }
            ** continue;
        }
    }

    public void waitForIdle(long idleTimeoutMillis, long globalTimeoutMillis) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            long startTimeMillis = SystemClock.uptimeMillis();
            if (this.mLastEventTimeMillis <= 0L) {
                this.mLastEventTimeMillis = startTimeMillis;
            }
            while (true) {
                long currentTimeMillis;
                long elapsedGlobalTimeMillis;
                long remainingGlobalTimeMillis;
                if ((remainingGlobalTimeMillis = globalTimeoutMillis - (elapsedGlobalTimeMillis = (currentTimeMillis = SystemClock.uptimeMillis()) - startTimeMillis)) <= 0L) {
                    throw new TimeoutException("No idle state with idle timeout: " + idleTimeoutMillis + " within global timeout: " + globalTimeoutMillis);
                }
                long elapsedIdleTimeMillis = currentTimeMillis - this.mLastEventTimeMillis;
                long remainingIdleTimeMillis = idleTimeoutMillis - elapsedIdleTimeMillis;
                if (remainingIdleTimeMillis <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(remainingIdleTimeMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap takeScreenshot() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        Display display = DisplayManagerGlobal.getInstance().getRealDisplay(0);
        Point displaySize = new Point();
        display.getRealSize(displaySize);
        int rotation = display.getRotation();
        Bitmap screenShot = null;
        try {
            screenShot = this.mUiAutomationConnection.takeScreenshot(new Rect(0, 0, displaySize.x, displaySize.y), rotation);
            if (screenShot == null) {
                return null;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while taking screnshot!", re);
            return null;
        }
        screenShot.setHasAlpha(false);
        return screenShot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunAsMonkey(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            ActivityManager.getService().setUserIsMonkey(enable);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while setting run as monkey!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.clearWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window content frame stats!", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowContentFrameStats getWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window content frame stats!", re);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.clearWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window animation frame stats!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window animation frame stats!", re);
            return null;
        }
    }

    public void grantRuntimePermission(String packageName, String permission2) {
        this.grantRuntimePermissionAsUser(packageName, permission2, Process.myUserHandle());
    }

    @Deprecated
    public boolean grantRuntimePermission(String packageName, String permission2, UserHandle userHandle) {
        this.grantRuntimePermissionAsUser(packageName, permission2, userHandle);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantRuntimePermissionAsUser(String packageName, String permission2, UserHandle userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.grantRuntimePermission(packageName, permission2, userHandle.getIdentifier());
        }
        catch (Exception e) {
            throw new SecurityException("Error granting runtime permission", e);
        }
    }

    public void revokeRuntimePermission(String packageName, String permission2) {
        this.revokeRuntimePermissionAsUser(packageName, permission2, Process.myUserHandle());
    }

    @Deprecated
    public boolean revokeRuntimePermission(String packageName, String permission2, UserHandle userHandle) {
        this.revokeRuntimePermissionAsUser(packageName, permission2, userHandle);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeRuntimePermissionAsUser(String packageName, String permission2, UserHandle userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.revokeRuntimePermission(packageName, permission2, userHandle.getIdentifier());
        }
        catch (Exception e) {
            throw new SecurityException("Error granting runtime permission", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ParcelFileDescriptor executeShellCommand(String command) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        this.warnIfBetterCommand(command);
        ParcelFileDescriptor source = null;
        ParcelFileDescriptor sink = null;
        try {
            ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
            source = pipe[0];
            sink = pipe[1];
            this.mUiAutomationConnection.executeShellCommand(command, sink, null);
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error executing shell command!", ioe);
            IoUtils.closeQuietly(sink);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing shell command!", re);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(sink);
        }
        IoUtils.closeQuietly(sink);
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ParcelFileDescriptor[] executeShellCommandRw(String command) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        this.warnIfBetterCommand(command);
        ParcelFileDescriptor source_read = null;
        ParcelFileDescriptor sink_read = null;
        ParcelFileDescriptor source_write = null;
        ParcelFileDescriptor sink_write = null;
        try {
            ParcelFileDescriptor[] pipe_read = ParcelFileDescriptor.createPipe();
            source_read = pipe_read[0];
            sink_read = pipe_read[1];
            ParcelFileDescriptor[] pipe_write = ParcelFileDescriptor.createPipe();
            source_write = pipe_write[0];
            sink_write = pipe_write[1];
            this.mUiAutomationConnection.executeShellCommand(command, sink_read, source_write);
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error executing shell command!", ioe);
            IoUtils.closeQuietly(sink_read);
            IoUtils.closeQuietly(source_write);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing shell command!", re);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink_read);
                    IoUtils.closeQuietly(source_write);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(sink_read);
            IoUtils.closeQuietly(source_write);
        }
        IoUtils.closeQuietly(sink_read);
        IoUtils.closeQuietly(source_write);
        ParcelFileDescriptor[] result = new ParcelFileDescriptor[]{source_read, sink_write};
        return result;
    }

    private boolean isConnectedLocked() {
        return this.mConnectionId != -1;
    }

    private void throwIfConnectedLocked() {
        if (this.mConnectionId != -1) {
            throw new IllegalStateException("UiAutomation not connected!");
        }
    }

    private void throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("UiAutomation not connected!");
        }
    }

    private void warnIfBetterCommand(String cmd) {
        if (cmd.startsWith("pm grant ")) {
            Log.w(LOG_TAG, "UiAutomation.grantRuntimePermission() is more robust and should be used instead of 'pm grant'");
        } else if (cmd.startsWith("pm revoke ")) {
            Log.w(LOG_TAG, "UiAutomation.revokeRuntimePermission() is more robust and should be used instead of 'pm revoke'");
        }
    }

    private class IAccessibilityServiceClientImpl
    extends AccessibilityService.IAccessibilityServiceClientWrapper {
        public IAccessibilityServiceClientImpl(Looper looper) {
            super(null, looper, new AccessibilityService.Callbacks(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void init(int connectionId, IBinder windowToken) {
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        UiAutomation.this.mConnectionId = connectionId;
                        UiAutomation.this.mLock.notifyAll();
                    }
                }

                @Override
                public void onServiceConnected() {
                }

                @Override
                public void onInterrupt() {
                }

                @Override
                public boolean onGesture(int gestureId) {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAccessibilityEvent(AccessibilityEvent event) {
                    OnAccessibilityEventListener listener;
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        UiAutomation.this.mLastEventTimeMillis = event.getEventTime();
                        if (UiAutomation.this.mWaitingForEventDelivery) {
                            UiAutomation.this.mEventQueue.add(AccessibilityEvent.obtain(event));
                        }
                        UiAutomation.this.mLock.notifyAll();
                        listener = UiAutomation.this.mOnAccessibilityEventListener;
                    }
                    if (listener != null) {
                        UiAutomation.this.mLocalCallbackHandler.sendMessage(PooledLambda.obtainMessage(OnAccessibilityEventListener::onAccessibilityEvent, listener, AccessibilityEvent.obtain(event)));
                    }
                }

                @Override
                public boolean onKeyEvent(KeyEvent event) {
                    return false;
                }

                @Override
                public void onMagnificationChanged(int displayId, Region region, float scale, float centerX, float centerY) {
                }

                @Override
                public void onSoftKeyboardShowModeChanged(int showMode) {
                }

                @Override
                public void onPerformGestureResult(int sequence, boolean completedSuccessfully) {
                }

                @Override
                public void onFingerprintCapturingGesturesChanged(boolean active) {
                }

                @Override
                public void onFingerprintGesture(int gesture) {
                }

                @Override
                public void onAccessibilityButtonClicked() {
                }

                @Override
                public void onAccessibilityButtonAvailabilityChanged(boolean available) {
                }
            });
        }
    }

    public static interface AccessibilityEventFilter {
        public boolean accept(AccessibilityEvent var1);
    }

    public static interface OnAccessibilityEventListener {
        public void onAccessibilityEvent(AccessibilityEvent var1);
    }
}

