/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.app.Notification;
import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.service.notification.NotificationListenerService;
import android.text.TextUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

public class NotificationChannel
implements Parcelable {
    public static final String DEFAULT_CHANNEL_ID = "miscellaneous";
    private static final int MAX_TEXT_LENGTH = 1000;
    private static final String TAG_CHANNEL = "channel";
    private static final String ATT_NAME = "name";
    private static final String ATT_DESC = "desc";
    private static final String ATT_ID = "id";
    private static final String ATT_DELETED = "deleted";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_VISIBILITY = "visibility";
    private static final String ATT_IMPORTANCE = "importance";
    private static final String ATT_LIGHTS = "lights";
    private static final String ATT_LIGHT_COLOR = "light_color";
    private static final String ATT_VIBRATION = "vibration";
    private static final String ATT_VIBRATION_ENABLED = "vibration_enabled";
    private static final String ATT_SOUND = "sound";
    private static final String ATT_USAGE = "usage";
    private static final String ATT_FLAGS = "flags";
    private static final String ATT_CONTENT_TYPE = "content_type";
    private static final String ATT_SHOW_BADGE = "show_badge";
    private static final String ATT_USER_LOCKED = "locked";
    private static final String ATT_FG_SERVICE_SHOWN = "fgservice";
    private static final String ATT_GROUP = "group";
    private static final String ATT_BLOCKABLE_SYSTEM = "blockable_system";
    private static final String ATT_ALLOW_BUBBLE = "can_bubble";
    private static final String DELIMITER = ",";
    public static final int USER_LOCKED_PRIORITY = 1;
    public static final int USER_LOCKED_VISIBILITY = 2;
    public static final int USER_LOCKED_IMPORTANCE = 4;
    public static final int USER_LOCKED_LIGHTS = 8;
    public static final int USER_LOCKED_VIBRATION = 16;
    public static final int USER_LOCKED_SOUND = 32;
    public static final int USER_LOCKED_SHOW_BADGE = 128;
    public static final int USER_LOCKED_ALLOW_BUBBLE = 256;
    public static final int[] LOCKABLE_FIELDS = new int[]{1, 2, 4, 8, 16, 32, 128, 256};
    private static final int DEFAULT_LIGHT_COLOR = 0;
    private static final int DEFAULT_VISIBILITY = -1000;
    private static final int DEFAULT_IMPORTANCE = -1000;
    private static final boolean DEFAULT_DELETED = false;
    private static final boolean DEFAULT_SHOW_BADGE = true;
    private static final boolean DEFAULT_ALLOW_BUBBLE = true;
    @UnsupportedAppUsage
    private final String mId;
    private String mName;
    private String mDesc;
    private int mImportance = -1000;
    private boolean mBypassDnd;
    private int mLockscreenVisibility = -1000;
    private Uri mSound = Settings.System.DEFAULT_NOTIFICATION_URI;
    private boolean mLights;
    private int mLightColor = 0;
    private long[] mVibration;
    private int mUserLockedFields;
    private boolean mFgServiceShown;
    private boolean mVibrationEnabled;
    private boolean mShowBadge = true;
    private boolean mDeleted = false;
    private String mGroup;
    private AudioAttributes mAudioAttributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
    private boolean mBlockableSystem = false;
    private boolean mAllowBubbles = true;
    private boolean mImportanceLockedByOEM;
    private boolean mImportanceLockedDefaultApp;
    public static final Parcelable.Creator<NotificationChannel> CREATOR = new Parcelable.Creator<NotificationChannel>(){

        @Override
        public NotificationChannel createFromParcel(Parcel in) {
            return new NotificationChannel(in);
        }

        public NotificationChannel[] newArray(int size) {
            return new NotificationChannel[size];
        }
    };

    public NotificationChannel(String id2, CharSequence name, int importance) {
        this.mId = this.getTrimmedString(id2);
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
        this.mImportance = importance;
    }

    protected NotificationChannel(Parcel in) {
        this.mId = in.readByte() != 0 ? in.readString() : null;
        this.mName = in.readByte() != 0 ? in.readString() : null;
        this.mDesc = in.readByte() != 0 ? in.readString() : null;
        this.mImportance = in.readInt();
        this.mBypassDnd = in.readByte() != 0;
        this.mLockscreenVisibility = in.readInt();
        this.mSound = in.readByte() != 0 ? Uri.CREATOR.createFromParcel(in) : null;
        this.mLights = in.readByte() != 0;
        this.mVibration = in.createLongArray();
        this.mUserLockedFields = in.readInt();
        this.mFgServiceShown = in.readByte() != 0;
        this.mVibrationEnabled = in.readByte() != 0;
        this.mShowBadge = in.readByte() != 0;
        this.mDeleted = in.readByte() != 0;
        this.mGroup = in.readByte() != 0 ? in.readString() : null;
        this.mAudioAttributes = in.readInt() > 0 ? AudioAttributes.CREATOR.createFromParcel(in) : null;
        this.mLightColor = in.readInt();
        this.mBlockableSystem = in.readBoolean();
        this.mAllowBubbles = in.readBoolean();
        this.mImportanceLockedByOEM = in.readBoolean();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mId != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mId);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mName != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mName);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mDesc != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mDesc);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeInt(this.mImportance);
        dest.writeByte(this.mBypassDnd ? (byte)1 : 0);
        dest.writeInt(this.mLockscreenVisibility);
        if (this.mSound != null) {
            dest.writeByte((byte)1);
            this.mSound.writeToParcel(dest, 0);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeByte(this.mLights ? (byte)1 : 0);
        dest.writeLongArray(this.mVibration);
        dest.writeInt(this.mUserLockedFields);
        dest.writeByte(this.mFgServiceShown ? (byte)1 : 0);
        dest.writeByte(this.mVibrationEnabled ? (byte)1 : 0);
        dest.writeByte(this.mShowBadge ? (byte)1 : 0);
        dest.writeByte(this.mDeleted ? (byte)1 : 0);
        if (this.mGroup != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mGroup);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mAudioAttributes != null) {
            dest.writeInt(1);
            this.mAudioAttributes.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mLightColor);
        dest.writeBoolean(this.mBlockableSystem);
        dest.writeBoolean(this.mAllowBubbles);
        dest.writeBoolean(this.mImportanceLockedByOEM);
    }

    public void lockFields(int field) {
        this.mUserLockedFields |= field;
    }

    public void unlockFields(int field) {
        this.mUserLockedFields &= ~field;
    }

    public void setFgServiceShown(boolean shown) {
        this.mFgServiceShown = shown;
    }

    public void setDeleted(boolean deleted) {
        this.mDeleted = deleted;
    }

    @UnsupportedAppUsage
    public void setBlockableSystem(boolean blockableSystem) {
        this.mBlockableSystem = blockableSystem;
    }

    public void setName(CharSequence name) {
        this.mName = name != null ? this.getTrimmedString(name.toString()) : null;
    }

    public void setDescription(String description) {
        this.mDesc = this.getTrimmedString(description);
    }

    private String getTrimmedString(String input) {
        if (input != null && input.length() > 1000) {
            return input.substring(0, 1000);
        }
        return input;
    }

    public void setGroup(String groupId) {
        this.mGroup = groupId;
    }

    public void setShowBadge(boolean showBadge) {
        this.mShowBadge = showBadge;
    }

    public void setSound(Uri sound, AudioAttributes audioAttributes) {
        this.mSound = sound;
        this.mAudioAttributes = audioAttributes;
    }

    public void enableLights(boolean lights) {
        this.mLights = lights;
    }

    public void setLightColor(int argb) {
        this.mLightColor = argb;
    }

    public void enableVibration(boolean vibration) {
        this.mVibrationEnabled = vibration;
    }

    public void setVibrationPattern(long[] vibrationPattern) {
        this.mVibrationEnabled = vibrationPattern != null && vibrationPattern.length > 0;
        this.mVibration = vibrationPattern;
    }

    public void setImportance(int importance) {
        this.mImportance = importance;
    }

    public void setBypassDnd(boolean bypassDnd) {
        this.mBypassDnd = bypassDnd;
    }

    public void setLockscreenVisibility(int lockscreenVisibility) {
        this.mLockscreenVisibility = lockscreenVisibility;
    }

    public void setAllowBubbles(boolean allowBubbles) {
        this.mAllowBubbles = allowBubbles;
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDesc;
    }

    public int getImportance() {
        return this.mImportance;
    }

    public boolean canBypassDnd() {
        return this.mBypassDnd;
    }

    public Uri getSound() {
        return this.mSound;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    public boolean shouldShowLights() {
        return this.mLights;
    }

    public int getLightColor() {
        return this.mLightColor;
    }

    public boolean shouldVibrate() {
        return this.mVibrationEnabled;
    }

    public long[] getVibrationPattern() {
        return this.mVibration;
    }

    public int getLockscreenVisibility() {
        return this.mLockscreenVisibility;
    }

    public boolean canShowBadge() {
        return this.mShowBadge;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public boolean canBubble() {
        return this.mAllowBubbles;
    }

    @SystemApi
    public boolean isDeleted() {
        return this.mDeleted;
    }

    @SystemApi
    public int getUserLockedFields() {
        return this.mUserLockedFields;
    }

    public boolean isFgServiceShown() {
        return this.mFgServiceShown;
    }

    public boolean isBlockableSystem() {
        return this.mBlockableSystem;
    }

    public void setImportanceLockedByOEM(boolean locked) {
        this.mImportanceLockedByOEM = locked;
    }

    public void setImportanceLockedByCriticalDeviceFunction(boolean locked) {
        this.mImportanceLockedDefaultApp = locked;
    }

    public boolean isImportanceLockedByOEM() {
        return this.mImportanceLockedByOEM;
    }

    public boolean isImportanceLockedByCriticalDeviceFunction() {
        return this.mImportanceLockedDefaultApp;
    }

    public boolean hasUserSetImportance() {
        return (this.mUserLockedFields & 4) != 0;
    }

    public void populateFromXmlForRestore(XmlPullParser parser, Context context) {
        this.populateFromXml(parser, true, context);
    }

    @SystemApi
    public void populateFromXml(XmlPullParser parser) {
        this.populateFromXml(parser, false, null);
    }

    private void populateFromXml(XmlPullParser parser, boolean forRestore, Context context) {
        Preconditions.checkArgument(!forRestore || context != null, "forRestore is true but got null context");
        this.setDescription(parser.getAttributeValue(null, ATT_DESC));
        this.setBypassDnd(0 != NotificationChannel.safeInt(parser, ATT_PRIORITY, 0));
        this.setLockscreenVisibility(NotificationChannel.safeInt(parser, ATT_VISIBILITY, -1000));
        Uri sound = NotificationChannel.safeUri(parser, ATT_SOUND);
        this.setSound(forRestore ? this.restoreSoundUri(context, sound) : sound, NotificationChannel.safeAudioAttributes(parser));
        this.enableLights(NotificationChannel.safeBool(parser, ATT_LIGHTS, false));
        this.setLightColor(NotificationChannel.safeInt(parser, ATT_LIGHT_COLOR, 0));
        this.setVibrationPattern(NotificationChannel.safeLongArray(parser, ATT_VIBRATION, null));
        this.enableVibration(NotificationChannel.safeBool(parser, ATT_VIBRATION_ENABLED, false));
        this.setShowBadge(NotificationChannel.safeBool(parser, ATT_SHOW_BADGE, false));
        this.setDeleted(NotificationChannel.safeBool(parser, ATT_DELETED, false));
        this.setGroup(parser.getAttributeValue(null, ATT_GROUP));
        this.lockFields(NotificationChannel.safeInt(parser, ATT_USER_LOCKED, 0));
        this.setFgServiceShown(NotificationChannel.safeBool(parser, ATT_FG_SERVICE_SHOWN, false));
        this.setBlockableSystem(NotificationChannel.safeBool(parser, ATT_BLOCKABLE_SYSTEM, false));
        this.setAllowBubbles(NotificationChannel.safeBool(parser, ATT_ALLOW_BUBBLE, true));
    }

    private Uri restoreSoundUri(Context context, Uri uri) {
        if (uri == null || Uri.EMPTY.equals(uri)) {
            return null;
        }
        ContentResolver contentResolver = context.getContentResolver();
        Uri canonicalizedUri = contentResolver.canonicalize(uri);
        if (canonicalizedUri == null) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        return contentResolver.uncanonicalize(canonicalizedUri);
    }

    @SystemApi
    public void writeXml(XmlSerializer out) throws IOException {
        this.writeXml(out, false, null);
    }

    public void writeXmlForBackup(XmlSerializer out, Context context) throws IOException {
        this.writeXml(out, true, context);
    }

    private Uri getSoundForBackup(Context context) {
        Uri sound = this.getSound();
        if (sound == null || Uri.EMPTY.equals(sound)) {
            return null;
        }
        Uri canonicalSound = context.getContentResolver().canonicalize(sound);
        if (canonicalSound == null) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        return canonicalSound;
    }

    private void writeXml(XmlSerializer out, boolean forBackup, Context context) throws IOException {
        Uri sound;
        Preconditions.checkArgument(!forBackup || context != null, "forBackup is true but got null context");
        out.startTag(null, TAG_CHANNEL);
        out.attribute(null, ATT_ID, this.getId());
        if (this.getName() != null) {
            out.attribute(null, ATT_NAME, this.getName().toString());
        }
        if (this.getDescription() != null) {
            out.attribute(null, ATT_DESC, this.getDescription());
        }
        if (this.getImportance() != -1000) {
            out.attribute(null, ATT_IMPORTANCE, Integer.toString(this.getImportance()));
        }
        if (this.canBypassDnd()) {
            out.attribute(null, ATT_PRIORITY, Integer.toString(2));
        }
        if (this.getLockscreenVisibility() != -1000) {
            out.attribute(null, ATT_VISIBILITY, Integer.toString(this.getLockscreenVisibility()));
        }
        Uri uri = sound = forBackup ? this.getSoundForBackup(context) : this.getSound();
        if (sound != null) {
            out.attribute(null, ATT_SOUND, sound.toString());
        }
        if (this.getAudioAttributes() != null) {
            out.attribute(null, ATT_USAGE, Integer.toString(this.getAudioAttributes().getUsage()));
            out.attribute(null, ATT_CONTENT_TYPE, Integer.toString(this.getAudioAttributes().getContentType()));
            out.attribute(null, ATT_FLAGS, Integer.toString(this.getAudioAttributes().getFlags()));
        }
        if (this.shouldShowLights()) {
            out.attribute(null, ATT_LIGHTS, Boolean.toString(this.shouldShowLights()));
        }
        if (this.getLightColor() != 0) {
            out.attribute(null, ATT_LIGHT_COLOR, Integer.toString(this.getLightColor()));
        }
        if (this.shouldVibrate()) {
            out.attribute(null, ATT_VIBRATION_ENABLED, Boolean.toString(this.shouldVibrate()));
        }
        if (this.getVibrationPattern() != null) {
            out.attribute(null, ATT_VIBRATION, NotificationChannel.longArrayToString(this.getVibrationPattern()));
        }
        if (this.getUserLockedFields() != 0) {
            out.attribute(null, ATT_USER_LOCKED, Integer.toString(this.getUserLockedFields()));
        }
        if (this.isFgServiceShown()) {
            out.attribute(null, ATT_FG_SERVICE_SHOWN, Boolean.toString(this.isFgServiceShown()));
        }
        if (this.canShowBadge()) {
            out.attribute(null, ATT_SHOW_BADGE, Boolean.toString(this.canShowBadge()));
        }
        if (this.isDeleted()) {
            out.attribute(null, ATT_DELETED, Boolean.toString(this.isDeleted()));
        }
        if (this.getGroup() != null) {
            out.attribute(null, ATT_GROUP, this.getGroup());
        }
        if (this.isBlockableSystem()) {
            out.attribute(null, ATT_BLOCKABLE_SYSTEM, Boolean.toString(this.isBlockableSystem()));
        }
        if (!this.canBubble()) {
            out.attribute(null, ATT_ALLOW_BUBBLE, Boolean.toString(this.canBubble()));
        }
        out.endTag(null, TAG_CHANNEL);
    }

    @SystemApi
    public JSONObject toJson() throws JSONException {
        JSONObject record = new JSONObject();
        record.put(ATT_ID, this.getId());
        record.put(ATT_NAME, this.getName());
        record.put(ATT_DESC, this.getDescription());
        if (this.getImportance() != -1000) {
            record.put(ATT_IMPORTANCE, NotificationListenerService.Ranking.importanceToString(this.getImportance()));
        }
        if (this.canBypassDnd()) {
            record.put(ATT_PRIORITY, 2);
        }
        if (this.getLockscreenVisibility() != -1000) {
            record.put(ATT_VISIBILITY, Notification.visibilityToString(this.getLockscreenVisibility()));
        }
        if (this.getSound() != null) {
            record.put(ATT_SOUND, this.getSound().toString());
        }
        if (this.getAudioAttributes() != null) {
            record.put(ATT_USAGE, Integer.toString(this.getAudioAttributes().getUsage()));
            record.put(ATT_CONTENT_TYPE, Integer.toString(this.getAudioAttributes().getContentType()));
            record.put(ATT_FLAGS, Integer.toString(this.getAudioAttributes().getFlags()));
        }
        record.put(ATT_LIGHTS, Boolean.toString(this.shouldShowLights()));
        record.put(ATT_LIGHT_COLOR, Integer.toString(this.getLightColor()));
        record.put(ATT_VIBRATION_ENABLED, Boolean.toString(this.shouldVibrate()));
        record.put(ATT_USER_LOCKED, Integer.toString(this.getUserLockedFields()));
        record.put(ATT_FG_SERVICE_SHOWN, Boolean.toString(this.isFgServiceShown()));
        record.put(ATT_VIBRATION, NotificationChannel.longArrayToString(this.getVibrationPattern()));
        record.put(ATT_SHOW_BADGE, Boolean.toString(this.canShowBadge()));
        record.put(ATT_DELETED, Boolean.toString(this.isDeleted()));
        record.put(ATT_GROUP, this.getGroup());
        record.put(ATT_BLOCKABLE_SYSTEM, this.isBlockableSystem());
        record.put(ATT_ALLOW_BUBBLE, this.canBubble());
        return record;
    }

    private static AudioAttributes safeAudioAttributes(XmlPullParser parser) {
        int usage = NotificationChannel.safeInt(parser, ATT_USAGE, 5);
        int contentType = NotificationChannel.safeInt(parser, ATT_CONTENT_TYPE, 4);
        int flags = NotificationChannel.safeInt(parser, ATT_FLAGS, 0);
        return new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).setFlags(flags).build();
    }

    private static Uri safeUri(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        return val == null ? null : Uri.parse(val);
    }

    private static int safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return NotificationChannel.tryParseInt(val, defValue);
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static boolean safeBool(XmlPullParser parser, String att, boolean defValue) {
        String value = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static long[] safeLongArray(XmlPullParser parser, String att, long[] defValue) {
        String attributeValue = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(attributeValue)) {
            return defValue;
        }
        String[] values = attributeValue.split(DELIMITER);
        long[] longValues = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                longValues[i] = Long.parseLong(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                longValues[i] = 0L;
            }
        }
        return longValues;
    }

    private static String longArrayToString(long[] values) {
        StringBuffer sb = new StringBuffer();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length - 1; ++i) {
                sb.append(values[i]).append(DELIMITER);
            }
            sb.append(values[values.length - 1]);
        }
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannel that = (NotificationChannel)o;
        return this.getImportance() == that.getImportance() && this.mBypassDnd == that.mBypassDnd && this.getLockscreenVisibility() == that.getLockscreenVisibility() && this.mLights == that.mLights && this.getLightColor() == that.getLightColor() && this.getUserLockedFields() == that.getUserLockedFields() && this.isFgServiceShown() == that.isFgServiceShown() && this.mVibrationEnabled == that.mVibrationEnabled && this.mShowBadge == that.mShowBadge && this.isDeleted() == that.isDeleted() && this.isBlockableSystem() == that.isBlockableSystem() && this.mAllowBubbles == that.mAllowBubbles && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.mDesc, that.mDesc) && Objects.equals(this.getSound(), that.getSound()) && Arrays.equals(this.mVibration, that.mVibration) && Objects.equals(this.getGroup(), that.getGroup()) && Objects.equals(this.getAudioAttributes(), that.getAudioAttributes()) && this.mImportanceLockedByOEM == that.mImportanceLockedByOEM && this.mImportanceLockedDefaultApp == that.mImportanceLockedDefaultApp;
    }

    public int hashCode() {
        int result = Objects.hash(this.getId(), this.getName(), this.mDesc, this.getImportance(), this.mBypassDnd, this.getLockscreenVisibility(), this.getSound(), this.mLights, this.getLightColor(), this.getUserLockedFields(), this.isFgServiceShown(), this.mVibrationEnabled, this.mShowBadge, this.isDeleted(), this.getGroup(), this.getAudioAttributes(), this.isBlockableSystem(), this.mAllowBubbles, this.mImportanceLockedByOEM, this.mImportanceLockedDefaultApp);
        result = 31 * result + Arrays.hashCode(this.mVibration);
        return result;
    }

    public void dump(PrintWriter pw, String prefix, boolean redacted) {
        String redactedName = redacted ? TextUtils.trimToLengthWithEllipsis(this.mName, 3) : this.mName;
        String output = "NotificationChannel{mId='" + this.mId + '\'' + ", mName=" + redactedName + ", mDescription=" + (!TextUtils.isEmpty(this.mDesc) ? "hasDescription " : "") + ", mImportance=" + this.mImportance + ", mBypassDnd=" + this.mBypassDnd + ", mLockscreenVisibility=" + this.mLockscreenVisibility + ", mSound=" + this.mSound + ", mLights=" + this.mLights + ", mLightColor=" + this.mLightColor + ", mVibration=" + Arrays.toString(this.mVibration) + ", mUserLockedFields=" + Integer.toHexString(this.mUserLockedFields) + ", mFgServiceShown=" + this.mFgServiceShown + ", mVibrationEnabled=" + this.mVibrationEnabled + ", mShowBadge=" + this.mShowBadge + ", mDeleted=" + this.mDeleted + ", mGroup='" + this.mGroup + '\'' + ", mAudioAttributes=" + this.mAudioAttributes + ", mBlockableSystem=" + this.mBlockableSystem + ", mAllowBubbles=" + this.mAllowBubbles + ", mImportanceLockedByOEM=" + this.mImportanceLockedByOEM + ", mImportanceLockedDefaultApp=" + this.mImportanceLockedDefaultApp + '}';
        pw.println(prefix + output);
    }

    public String toString() {
        return "NotificationChannel{mId='" + this.mId + '\'' + ", mName=" + this.mName + ", mDescription=" + (!TextUtils.isEmpty(this.mDesc) ? "hasDescription " : "") + ", mImportance=" + this.mImportance + ", mBypassDnd=" + this.mBypassDnd + ", mLockscreenVisibility=" + this.mLockscreenVisibility + ", mSound=" + this.mSound + ", mLights=" + this.mLights + ", mLightColor=" + this.mLightColor + ", mVibration=" + Arrays.toString(this.mVibration) + ", mUserLockedFields=" + Integer.toHexString(this.mUserLockedFields) + ", mFgServiceShown=" + this.mFgServiceShown + ", mVibrationEnabled=" + this.mVibrationEnabled + ", mShowBadge=" + this.mShowBadge + ", mDeleted=" + this.mDeleted + ", mGroup='" + this.mGroup + '\'' + ", mAudioAttributes=" + this.mAudioAttributes + ", mBlockableSystem=" + this.mBlockableSystem + ", mAllowBubbles=" + this.mAllowBubbles + ", mImportanceLockedByOEM=" + this.mImportanceLockedByOEM + ", mImportanceLockedDefaultApp=" + this.mImportanceLockedDefaultApp + '}';
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mId);
        proto.write(1138166333442L, this.mName);
        proto.write(1138166333443L, this.mDesc);
        proto.write(1120986464260L, this.mImportance);
        proto.write(1133871366149L, this.mBypassDnd);
        proto.write(1120986464262L, this.mLockscreenVisibility);
        if (this.mSound != null) {
            proto.write(1138166333447L, this.mSound.toString());
        }
        proto.write(0x10800000008L, this.mLights);
        proto.write(1120986464265L, this.mLightColor);
        if (this.mVibration != null) {
            for (long v : this.mVibration) {
                proto.write(2211908157450L, v);
            }
        }
        proto.write(1120986464267L, this.mUserLockedFields);
        proto.write(1133871366162L, this.mFgServiceShown);
        proto.write(1133871366156L, this.mVibrationEnabled);
        proto.write(1133871366157L, this.mShowBadge);
        proto.write(1133871366158L, this.mDeleted);
        proto.write(1138166333455L, this.mGroup);
        if (this.mAudioAttributes != null) {
            this.mAudioAttributes.writeToProto(proto, 0x10B00000010L);
        }
        proto.write(0x10800000011L, this.mBlockableSystem);
        proto.write(1133871366163L, this.mAllowBubbles);
        proto.end(token);
    }
}

