/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.projectView.Form;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormMoveProvider
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.projectView.FormMoveProvider");

    public boolean canMove(DataContext dataContext) {
        Form[] forms = (Form[])Form.DATA_KEY.getData(dataContext);
        return forms != null && forms.length > 0;
    }

    public boolean isValidTarget(PsiElement psiElement, PsiElement[] sources) {
        return MoveFilesOrDirectoriesHandler.isValidTarget((PsiElement)psiElement);
    }

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        return false;
    }

    public void collectFilesOrDirsFromContext(DataContext dataContext, Set<PsiElement> filesOrDirs) {
        Form[] forms = (Form[])Form.DATA_KEY.getData(dataContext);
        LOG.assertTrue(forms != null);
        PsiClass[] classesToMove = new PsiClass[forms.length];
        PsiFile[] filesToMove = new PsiFile[forms.length];
        for (int i = 0; i < forms.length; ++i) {
            PsiFile containingFile;
            classesToMove[i] = forms[i].getClassToBind();
            if (classesToMove[i] != null && (containingFile = classesToMove[i].getContainingFile()) != null) {
                filesOrDirs.add((PsiElement)containingFile);
            }
            filesToMove[i] = forms[i].getFormFiles()[0];
            if (filesToMove[i] == null) continue;
            filesOrDirs.add((PsiElement)filesToMove[i]);
        }
    }

    public boolean isMoveRedundant(PsiElement source, PsiElement target) {
        VirtualFile virtualFile;
        if (source instanceof PsiFile && source.getParent() == target && (virtualFile = ((PsiFile)source).getVirtualFile()) != null && virtualFile.getFileType() instanceof GuiFormFileType) {
            return true;
        }
        return super.isMoveRedundant(source, target);
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            FormMoveProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/uiDesigner/projectView/FormMoveProvider", "supportsLanguage"));
    }
}

