/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.SupportCode;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.DuplicateMnemonicInspection;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.properties.IntroStringProperty;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import javax.swing.Icon;

public class AssignMnemonicFix
extends QuickFix {
    public AssignMnemonicFix(GuiEditor editor, RadComponent component, String name) {
        super(editor, name, component);
    }

    @Override
    public void run() {
        IProperty textProperty = FormInspectionUtil.findProperty(this.myComponent, "text");
        StringDescriptor descriptor = (StringDescriptor)textProperty.getPropertyValue((IComponent)this.myComponent);
        String value = StringDescriptorManager.getInstance(this.myComponent.getModule()).resolve(this.myComponent, descriptor);
        String[] variants = this.fillMnemonicVariants(SupportCode.parseText((String)value).myText);
        String result = Messages.showEditableChooseDialog((String)UIDesignerBundle.message("inspection.missing.mnemonics.quickfix.prompt", new Object[0]), (String)UIDesignerBundle.message("inspection.missing.mnemonics.quickfix.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])variants, (String)variants[0], null);
        if (result != null) {
            if (!this.myEditor.ensureEditable()) {
                return;
            }
            FormInspectionUtil.updateStringPropertyValue(this.myEditor, this.myComponent, (IntroStringProperty)textProperty, descriptor, result);
        }
    }

    private String[] fillMnemonicVariants(String value) {
        char ch;
        int i;
        final StringBuffer usedMnemonics = new StringBuffer();
        RadContainer container = this.myComponent.getParent();
        if (container != null) {
            while (container.getParent() != null) {
                container = container.getParent();
            }
            FormEditingUtil.iterate(container, new FormEditingUtil.ComponentVisitor(){

                public boolean visit(IComponent component) {
                    SupportCode.TextWithMnemonic twm = DuplicateMnemonicInspection.getTextWithMnemonic(AssignMnemonicFix.this.myEditor.getModule(), component);
                    if (twm != null) {
                        usedMnemonics.append(twm.getMnemonicChar());
                    }
                    return true;
                }
            });
        }
        ArrayList<String> variants = new ArrayList<String>();
        for (i = 0; i < value.length(); ++i) {
            ch = value.charAt(i);
            if (i != 0 && !Character.isUpperCase(ch) && (i <= 0 || value.charAt(i - 1) != ' ') || !Character.isLetter(ch) || usedMnemonics.indexOf(StringUtil.toUpperCase((String)String.valueOf(ch))) >= 0) continue;
            variants.add(value.substring(0, i) + "&" + value.substring(i));
        }
        if (variants.size() == 0) {
            for (i = 0; i < value.length(); ++i) {
                ch = value.charAt(i);
                if (!Character.isLetter(ch) || usedMnemonics.indexOf(StringUtil.toUpperCase((String)String.valueOf(ch))) >= 0) continue;
                variants.add(value.substring(0, i) + "&" + value.substring(i));
            }
        }
        if (variants.size() == 0) {
            variants.add(value);
        }
        return ArrayUtilRt.toStringArray(variants);
    }
}

