/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtilBase;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.uiDesigner.binding.ReferenceInForm;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class ResourceBundleKeyReference
extends ReferenceInForm {
    private final String myBundleName;

    public ResourceBundleKeyReference(PsiPlainTextFile file, String bundleName, TextRange keyNameRange) {
        super(file, keyNameRange);
        this.myBundleName = bundleName;
    }

    public PsiElement resolve() {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)this.myFile);
        if (module == null) {
            return null;
        }
        PropertiesFile propertiesFile = PropertiesUtilBase.getPropertiesFile((String)this.myBundleName, (Module)module, null);
        if (propertiesFile == null) {
            return null;
        }
        IProperty property = propertiesFile.findPropertyByKey(this.getRangeText());
        return property == null ? null : property.getPsiElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ResourceBundleKeyReference.$$$reportNull$$$0(0);
        }
        if (!(element instanceof IProperty)) {
            throw new IncorrectOperationException();
        }
        this.updateRangeText(((IProperty)element).getUnescapedKey());
        return this.myFile;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ResourceBundleKeyReference.$$$reportNull$$$0(1);
        }
        if (!(element instanceof IProperty)) {
            return false;
        }
        IProperty property = (IProperty)element;
        String baseName = ResourceBundleManager.getInstance((Project)element.getProject()).getFullName(property.getPropertiesFile());
        return baseName != null && this.myBundleName.equals(baseName.replace('.', '/')) && this.getRangeText().equals(property.getUnescapedKey());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/uiDesigner/binding/ResourceBundleKeyReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

