/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyInspectorTable;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class ShowJavadocAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.ShowJavadocAction");

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowJavadocAction.$$$reportNull$$$0(0);
        }
        PropertyInspectorTable inspector = (PropertyInspectorTable)((Object)e.getData(PropertyInspectorTable.DATA_KEY));
        IntrospectedProperty introspectedProperty = inspector.getSelectedIntrospectedProperty();
        PsiClass aClass = inspector.getComponentClass();
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)aClass, (String)introspectedProperty.getName(), (boolean)false, (boolean)true);
        LOG.assertTrue(getter != null);
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)aClass, (String)introspectedProperty.getName(), (boolean)false, (boolean)true);
        LOG.assertTrue(setter != null);
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)aClass.getProject());
        DocumentationComponent component1 = new DocumentationComponent(documentationManager);
        DocumentationComponent component2 = new DocumentationComponent(documentationManager);
        Disposable disposable = Disposer.newDisposable();
        TabbedPaneWrapper tabbedPane = new TabbedPaneWrapper(disposable);
        tabbedPane.addTab(UIDesignerBundle.message("tab.getter", new Object[0]), (JComponent)component1);
        tabbedPane.addTab(UIDesignerBundle.message("tab.setter", new Object[0]), (JComponent)component2);
        documentationManager.fetchDocInfo((PsiElement)getter, component1);
        documentationManager.queueFetchDocInfo((PsiElement)setter, component2).doWhenProcessed(() -> {
            JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder(tabbedPane.getComponent(), (JComponent)component1).setDimensionServiceKey(aClass.getProject(), "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(UIDesignerBundle.message("property.javadoc.title", introspectedProperty.getName())).createPopup();
            component1.setHint(hint);
            component2.setHint(hint);
            Disposer.register((Disposable)hint, (Disposable)component1);
            Disposer.register((Disposable)hint, (Disposable)component2);
            Disposer.register((Disposable)hint, (Disposable)disposable);
            hint.show(new RelativePoint((Component)((Object)inspector), new Point(0, 0)));
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowJavadocAction.$$$reportNull$$$0(1);
        }
        PropertyInspectorTable inspector = (PropertyInspectorTable)((Object)e.getData(PropertyInspectorTable.DATA_KEY));
        e.getPresentation().setEnabled(inspector != null && inspector.getSelectedIntrospectedProperty() != null && inspector.getComponentClass() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uiDesigner/actions/ShowJavadocAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

