/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class PaletteListPopupStep
implements ListPopupStep<ComponentItem>,
SpeedSearchFilter<ComponentItem> {
    private final ArrayList<ComponentItem> myItems = new ArrayList();
    private final ComponentItem myInitialSelection;
    private final Processor<? super ComponentItem> myRunnable;
    private final String myTitle;
    private final Project myProject;
    private Runnable myFinalRunnable;

    PaletteListPopupStep(GuiEditor editor, ComponentItem initialSelection, Processor<? super ComponentItem> runnable, String title) {
        this.myInitialSelection = initialSelection;
        this.myRunnable = runnable;
        this.myProject = editor.getProject();
        Palette palette = Palette.getInstance(editor.getProject());
        for (GroupItem group : palette.getToolWindowGroups()) {
            Collections.addAll(this.myItems, group.getItems());
        }
        this.myTitle = title;
    }

    @NotNull
    public List<ComponentItem> getValues() {
        ArrayList<ComponentItem> arrayList = this.myItems;
        if (arrayList == null) {
            PaletteListPopupStep.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public boolean isSelectable(ComponentItem value) {
        return true;
    }

    public Icon getIconFor(ComponentItem aValue) {
        return aValue.getSmallIcon();
    }

    @NotNull
    public String getTextFor(ComponentItem value) {
        if (value.isAnyComponent()) {
            String string = UIDesignerBundle.message("palette.non.palette.component", new Object[0]);
            if (string == null) {
                PaletteListPopupStep.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = value.getClassShortName();
        if (string == null) {
            PaletteListPopupStep.$$$reportNull$$$0(2);
        }
        return string;
    }

    public ListSeparator getSeparatorAbove(ComponentItem value) {
        return null;
    }

    public int getDefaultOptionIndex() {
        int index;
        if (this.myInitialSelection != null && (index = this.myItems.indexOf(this.myInitialSelection)) >= 0) {
            return index;
        }
        return 0;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public PopupStep onChosen(ComponentItem selectedValue, boolean finalChoice) {
        this.myFinalRunnable = () -> this.myRunnable.process((Object)selectedValue);
        return PopupStep.FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    public boolean hasSubstep(ComponentItem selectedValue) {
        return false;
    }

    public void canceled() {
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<ComponentItem> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public SpeedSearchFilter<ComponentItem> getSpeedSearchFilter() {
        return this;
    }

    public String getIndexedString(ComponentItem value) {
        if (value.isAnyComponent()) {
            return "";
        }
        return value.getClassShortName();
    }

    public void hideComponentClass(String componentClassName) {
        for (ComponentItem item : this.myItems) {
            if (!item.getClassName().equals(componentClassName)) continue;
            this.myItems.remove(item);
            break;
        }
    }

    public void hideNonAtomic() {
        for (int i = this.myItems.size() - 1; i >= 0; --i) {
            ComponentItem item = this.myItems.get(i);
            if (InsertComponentProcessor.getRadComponentFactory(this.myProject, item.getClassName()) == null && item.getBoundForm() == null) continue;
            this.myItems.remove(i);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/uiDesigner/actions/PaletteListPopupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

