/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0004\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0096\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/utils/SmartSet;", "T", "Ljava/util/AbstractSet;", "()V", "data", "", "size", "", "getSize", "()I", "setSize", "(I)V", "add", "", "element", "(Ljava/lang/Object;)Z", "clear", "", "contains", "iterator", "", "ArrayIterator", "Companion", "SingletonIterator", "util.runtime"})
public final class SmartSet<T>
extends AbstractSet<T> {
    private Object data;
    private int size;
    public static final Companion Companion = new Companion(null);

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator iterator2;
        if (this.size() == 0) {
            iterator2 = Collections.emptySet().iterator();
        } else if (this.size() == 1) {
            iterator2 = new SingletonIterator<Object>(this.data);
        } else if (this.size() < 5) {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            iterator2 = new ArrayIterator<Object>((Object[])object);
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableSet<T>");
            }
            iterator2 = TypeIntrinsics.asMutableSet(object).iterator();
        }
        return iterator2;
    }

    @Override
    public boolean add(T element) {
        if (this.size() == 0) {
            this.data = element;
        } else if (this.size() == 1) {
            if (Intrinsics.areEqual(this.data, element)) {
                return false;
            }
            this.data = new Object[]{this.data, element};
        } else if (this.size() < 5) {
            Object[] objectArray;
            SmartSet smartSet;
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] arr = (Object[])object;
            if (ArraysKt.contains(arr, element)) {
                return false;
            }
            SmartSet smartSet2 = this;
            if (this.size() == 4) {
                Object[] objectArray2 = SetsKt.linkedSetOf(Arrays.copyOf(arr, arr.length));
                SmartSet smartSet3 = smartSet2;
                boolean bl = false;
                boolean bl2 = false;
                Object[] $this$apply = objectArray2;
                boolean bl3 = false;
                $this$apply.add(element);
                Object[] objectArray3 = objectArray2;
                smartSet = smartSet3;
                objectArray = objectArray3;
            } else {
                Object[] objectArray4 = arr;
                int n = this.size() + 1;
                SmartSet smartSet4 = smartSet2;
                boolean bl = false;
                Object[] objectArray5 = Arrays.copyOf(objectArray4, n);
                Intrinsics.checkExpressionValueIsNotNull(objectArray5, "java.util.Arrays.copyOf(this, newSize)");
                Object[] objectArray6 = objectArray5;
                objectArray4 = objectArray6;
                n = 0;
                bl = false;
                Object[] $this$apply = objectArray4;
                boolean bl4 = false;
                $this$apply[$this$apply.length - 1] = element;
                objectArray6 = objectArray4;
                smartSet = smartSet4;
                objectArray = objectArray6;
            }
            smartSet.data = objectArray;
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableSet<T>");
            }
            Set set = TypeIntrinsics.asMutableSet(object);
            if (!set.add(element)) {
                return false;
            }
        }
        SmartSet smartSet = this;
        int n = smartSet.size();
        smartSet.setSize(n + 1);
        return true;
    }

    @Override
    public void clear() {
        this.data = null;
        this.setSize(0);
    }

    @Override
    public boolean contains(Object element) {
        boolean bl;
        if (this.size() == 0) {
            bl = false;
        } else if (this.size() == 1) {
            bl = Intrinsics.areEqual(this.data, element);
        } else if (this.size() < 5) {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            bl = ArraysKt.contains((Object[])object, element);
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<T>");
            }
            bl = ((Set)object).contains(element);
        }
        return bl;
    }

    private SmartSet() {
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create(@NotNull Collection<? extends T> set) {
        return Companion.create(set);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\u000e\u0010\b\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/utils/SmartSet$SingletonIterator;", "T", "", "element", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "util.runtime"})
    private static final class SingletonIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private boolean hasNext;
        private final T element;

        @Override
        public T next() {
            if (!this.hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this.hasNext = false;
            return this.element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @NotNull
        public Void remove() {
            throw (Throwable)new UnsupportedOperationException();
        }

        public SingletonIterator(T element) {
            this.element = element;
            this.hasNext = true;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\tH\u0096\u0002J\u000e\u0010\n\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/utils/SmartSet$ArrayIterator;", "T", "", "array", "", "([Ljava/lang/Object;)V", "arrayIterator", "", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "util.runtime"})
    private static final class ArrayIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private final Iterator<T> arrayIterator;

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public T next() {
            return this.arrayIterator.next();
        }

        @NotNull
        public Void remove() {
            throw (Throwable)new UnsupportedOperationException();
        }

        public ArrayIterator(@NotNull T[] array) {
            Intrinsics.checkParameterIsNotNull(array, "array");
            this.arrayIterator = ArrayIteratorKt.iterator(array);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u0007H\u0007J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/utils/SmartSet$Companion;", "", "()V", "ARRAY_THRESHOLD", "", "create", "Lorg/jetbrains/kotlin/utils/SmartSet;", "T", "set", "", "util.runtime"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create() {
            return new SmartSet(null);
        }

        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create(@NotNull Collection<? extends T> set) {
            Intrinsics.checkParameterIsNotNull(set, "set");
            SmartSet smartSet = new SmartSet(null);
            boolean bl = false;
            boolean bl2 = false;
            SmartSet $this$apply = smartSet;
            boolean bl3 = false;
            $this$apply.addAll(set);
            return smartSet;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

