/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.FieldAccessor;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.PropertyAccessor;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.CollectionBean;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanBinding
extends NotNullDeserializeBinding {
    private static final Map<Class, List<MutableAccessor>> ourAccessorCache = ContainerUtil.createConcurrentSoftValueMap();
    private final String myTagName;
    protected Binding[] myBindings;
    protected final Class<?> myBeanClass;
    ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass, @Nullable MutableAccessor accessor) {
        if (beanClass == null) {
            BeanBinding.$$$reportNull$$$0(0);
        }
        super(accessor);
        this.compareByFields = ThreeState.UNSURE;
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public final synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        if (originalType == null) {
            BeanBinding.$$$reportNull$$$0(1);
        }
        if (serializer2 == null) {
            BeanBinding.$$$reportNull$$$0(2);
        }
        assert (this.myBindings == null);
        Property classAnnotation = this.myBeanClass.getAnnotation(Property.class);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new Binding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = BeanBinding.createBinding(accessors.get(i), serializer2, classAnnotation == null ? Property.Style.OPTION_TAG : classAnnotation.style());
            binding.init(originalType, serializer2);
            this.myBindings[i] = binding;
        }
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(8);
        }
        Object instance = ReflectionUtil.newInstance(this.myBeanClass);
        this.deserializeInto(instance, element);
        Object obj = instance;
        if (obj == null) {
            BeanBinding.$$$reportNull$$$0(9);
        }
        return obj;
    }

    public final void deserializeInto(@NotNull Object result2, @NotNull Element element) {
        if (result2 == null) {
            BeanBinding.$$$reportNull$$$0(16);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(17);
        }
        this.deserializeInto(result2, element, null);
    }

    public final void deserializeInto(@NotNull Object result2, @NotNull Element element, @Nullable Set<? super String> accessorNameTracker) {
        if (result2 == null) {
            BeanBinding.$$$reportNull$$$0(18);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(19);
        }
        block0: for (org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtil.isEmpty(attribute.getNamespaceURI())) continue;
            for (Binding binding : this.myBindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).myName.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result2, attribute.getValue());
                continue block0;
            }
        }
        MultiMap<Binding, Element> data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (Binding binding : this.myBindings) {
                if (content instanceof org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result2, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = MultiMap.createLinked();
                    }
                    data.putValue(binding, child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserializeUnsafe(result2, child);
                continue block2;
            }
        }
        for (Binding binding : this.myBindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat()) continue;
            ((AccessorBindingWrapper)binding).deserialize(result2, element);
        }
        if (data != null) {
            for (Binding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result2, (List)data.get(binding));
            }
        }
    }

    @Override
    public final boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(20);
        }
        return element.getName().equals(this.myTagName);
    }

    @NotNull
    private static String getTagName(@NotNull Class<?> aClass2) {
        int lastIndexOf2;
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(21);
        }
        for (Class<?> c = aClass2; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            String string = name;
            if (string == null) {
                BeanBinding.$$$reportNull$$$0(22);
            }
            return string;
        }
        String name = aClass2.getSimpleName();
        if (name.isEmpty()) {
            name = aClass2.getSuperclass().getSimpleName();
        }
        if ((lastIndexOf2 = name.lastIndexOf(36)) > 0 && name.length() > lastIndexOf2 + 1) {
            String string = name.substring(lastIndexOf2 + 1);
            if (string == null) {
                BeanBinding.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            BeanBinding.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    private static String getTagNameFromAnnotation(@NotNull Class<?> aClass2) {
        Tag tag;
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(25);
        }
        return (tag = aClass2.getAnnotation(Tag.class)) != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    public static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass2) {
        List<MutableAccessor> accessors;
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(26);
        }
        if ((accessors = ourAccessorCache.get(aClass2)) != null) {
            List<MutableAccessor> list2 = accessors;
            if (list2 == null) {
                BeanBinding.$$$reportNull$$$0(27);
            }
            return list2;
        }
        accessors = new ArrayList<MutableAccessor>();
        Map<Object, Object> nameToAccessors = aClass2 == Rectangle.class ? Collections.emptyMap() : BeanBinding.collectPropertyAccessors(aClass2, accessors);
        int propertyAccessorCount = accessors.size();
        BeanBinding.collectFieldAccessors(aClass2, accessors);
        block0: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = accessors.get(j).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!accessors.get(i).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block0;
            }
        }
        if (accessors.isEmpty() && !BeanBinding.isAssertBindings(aClass2)) {
            LOG.warn("no accessors for " + aClass2);
        }
        ourAccessorCache.put(aClass2, accessors);
        List<MutableAccessor> list3 = accessors;
        if (list3 == null) {
            BeanBinding.$$$reportNull$$$0(28);
        }
        return list3;
    }

    private static boolean isAssertBindings(@NotNull Class<?> aClass2) {
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(29);
        }
        do {
            Property property2;
            if ((property2 = aClass2.getAnnotation(Property.class)) == null || property2.assertIfNoBindings()) continue;
            return true;
        } while ((aClass2 = aClass2.getSuperclass()) != null);
        return false;
    }

    @NotNull
    private static Map<String, Couple<Method>> collectPropertyAccessors(@NotNull Class<?> aClass2, @NotNull List<? super MutableAccessor> accessors) {
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(30);
        }
        if (accessors == null) {
            BeanBinding.$$$reportNull$$$0(31);
        }
        TreeMap<String, Couple<Method>> candidates2 = new TreeMap<String, Couple<Method>>();
        for (Method method : aClass2.getMethods()) {
            NameAndIsSetter propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || propertyData.name.equals("class") || method.getParameterTypes().length != (propertyData.isSetter ? 1 : 0)) continue;
            Couple<Object> candidate2 = (Couple)candidates2.get(propertyData.name);
            if (candidate2 == null) {
                candidate2 = Couple.getEmpty();
            }
            if ((propertyData.isSetter ? (Method)candidate2.second : (Method)candidate2.first) != null) continue;
            candidate2 = Couple.of(propertyData.isSetter ? (Method)candidate2.first : method, propertyData.isSetter ? method : (Method)candidate2.second);
            candidates2.put(propertyData.name, candidate2);
        }
        Iterator iterator2 = candidates2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry candidate3 = iterator2.next();
            Couple methods2 = (Couple)candidate3.getValue();
            Method getter2 = (Method)methods2.first;
            Method setter2 = (Method)methods2.second;
            if (BeanBinding.isAcceptableProperty(getter2, setter2)) {
                accessors.add(new PropertyAccessor((String)candidate3.getKey(), getter2.getReturnType(), getter2, setter2));
                continue;
            }
            iterator2.remove();
        }
        TreeMap<String, Couple<Method>> treeMap = candidates2;
        if (treeMap == null) {
            BeanBinding.$$$reportNull$$$0(32);
        }
        return treeMap;
    }

    private static boolean isAcceptableProperty(@Nullable Method getter2, @Nullable Method setter2) {
        if (getter2 == null || getter2.getAnnotation(Transient.class) != null) {
            return false;
        }
        if (setter2 == null) {
            return (Collection.class.isAssignableFrom(getter2.getReturnType()) || Map.class.isAssignableFrom(getter2.getReturnType())) && BeanBinding.hasStoreAnnotations(getter2);
        }
        return setter2.getAnnotation(Transient.class) == null && getter2.getReturnType().equals(setter2.getParameterTypes()[0]);
    }

    private static boolean hasStoreAnnotations(@NotNull AccessibleObject object) {
        if (object == null) {
            BeanBinding.$$$reportNull$$$0(33);
        }
        return object.getAnnotation(OptionTag.class) != null || object.getAnnotation(Tag.class) != null || object.getAnnotation(Attribute.class) != null || object.getAnnotation(Property.class) != null || object.getAnnotation(Text.class) != null || object.getAnnotation(CollectionBean.class) != null || object.getAnnotation(MapAnnotation.class) != null || object.getAnnotation(XMap.class) != null || object.getAnnotation(XCollection.class) != null || object.getAnnotation(AbstractCollection.class) != null;
    }

    private static void collectFieldAccessors(@NotNull Class<?> aClass2, @NotNull List<? super MutableAccessor> accessors) {
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(34);
        }
        if (accessors == null) {
            BeanBinding.$$$reportNull$$$0(35);
        }
        Class<?> currentClass = aClass2;
        do {
            for (Field field2 : currentClass.getDeclaredFields()) {
                Class<?> fieldType;
                int modifiers2 = field2.getModifiers();
                if (Modifier.isStatic(modifiers2) || Modifier.isTransient(modifiers2) || !BeanBinding.hasStoreAnnotations(field2) && (!Modifier.isPublic(modifiers2) || Modifier.isFinal(modifiers2) && !Collection.class.isAssignableFrom(fieldType = field2.getType()) && !Map.class.isAssignableFrom(fieldType) || field2.getAnnotation(Transient.class) != null)) continue;
                accessors.add(new FieldAccessor(field2));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass.getAnnotation(Transient.class) == null);
    }

    @Nullable
    private static NameAndIsSetter getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            BeanBinding.$$$reportNull$$$0(36);
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2);
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3);
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            if (part.endsWith("$annotations")) {
                return null;
            }
            part = part.substring(0, suffixIndex);
        }
        return new NameAndIsSetter(Introspector.decapitalize(part), isSetter);
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static Binding createBinding(@NotNull MutableAccessor accessor, @NotNull Serializer serializer2, @NotNull Property.Style propertyStyle) {
        XMap xMap;
        Attribute attribute;
        if (accessor == null) {
            BeanBinding.$$$reportNull$$$0(37);
        }
        if (serializer2 == null) {
            BeanBinding.$$$reportNull$$$0(38);
        }
        if (propertyStyle == null) {
            BeanBinding.$$$reportNull$$$0(39);
        }
        if ((attribute = accessor.getAnnotation(Attribute.class)) != null) {
            AttributeBinding attributeBinding = new AttributeBinding(accessor, attribute);
            if (attributeBinding == null) {
                BeanBinding.$$$reportNull$$$0(40);
            }
            return attributeBinding;
        }
        Text text2 = accessor.getAnnotation(Text.class);
        if (text2 != null) {
            TextBinding textBinding = new TextBinding(accessor);
            if (textBinding == null) {
                BeanBinding.$$$reportNull$$$0(41);
            }
            return textBinding;
        }
        OptionTag optionTag = accessor.getAnnotation(OptionTag.class);
        if (optionTag != null && optionTag.converter() != Converter.class) {
            OptionTagBinding optionTagBinding = new OptionTagBinding(accessor, optionTag);
            if (optionTagBinding == null) {
                BeanBinding.$$$reportNull$$$0(42);
            }
            return optionTagBinding;
        }
        Binding binding = serializer2.getBinding(accessor);
        if (binding instanceof JDOMElementBinding) {
            Binding binding2 = binding;
            if (binding2 == null) {
                BeanBinding.$$$reportNull$$$0(43);
            }
            return binding2;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            TagBinding tagBinding = new TagBinding(accessor, tag);
            if (tagBinding == null) {
                BeanBinding.$$$reportNull$$$0(44);
            }
            return tagBinding;
        }
        if (binding instanceof CompactCollectionBinding) {
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding, false, Property.Style.OPTION_TAG);
            if (accessorBindingWrapper == null) {
                BeanBinding.$$$reportNull$$$0(45);
            }
            return accessorBindingWrapper;
        }
        boolean surroundWithTag = true;
        boolean inline = false;
        Property property2 = accessor.getAnnotation(Property.class);
        if (property2 != null) {
            surroundWithTag = property2.surroundWithTag();
            inline = property2.flat();
        }
        if (!surroundWithTag || inline) {
            if (inline && !(binding instanceof BeanBinding)) {
                throw new XmlSerializationException("inline supported only for BeanBinding: " + accessor);
            }
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding, inline, property2.style());
            if (accessorBindingWrapper == null) {
                BeanBinding.$$$reportNull$$$0(46);
            }
            return accessorBindingWrapper;
        }
        XCollection xCollection = accessor.getAnnotation(XCollection.class);
        if (!(xCollection == null || xCollection.propertyElementName().isEmpty() && xCollection.style() != XCollection.Style.v2)) {
            TagBinding tagBinding = new TagBinding(accessor, xCollection.propertyElementName());
            if (tagBinding == null) {
                BeanBinding.$$$reportNull$$$0(47);
            }
            return tagBinding;
        }
        if (optionTag == null && (xMap = accessor.getAnnotation(XMap.class)) != null) {
            TagBinding tagBinding = new TagBinding(accessor, xMap.propertyElementName());
            if (tagBinding == null) {
                BeanBinding.$$$reportNull$$$0(48);
            }
            return tagBinding;
        }
        if (propertyStyle == Property.Style.ATTRIBUTE) {
            AttributeBinding attributeBinding = new AttributeBinding(accessor, null);
            if (attributeBinding == null) {
                BeanBinding.$$$reportNull$$$0(49);
            }
            return attributeBinding;
        }
        OptionTagBinding optionTagBinding = new OptionTagBinding(accessor, optionTag);
        if (optionTagBinding == null) {
            BeanBinding.$$$reportNull$$$0(50);
        }
        return optionTagBinding;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 8: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorNameTracker";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weights";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeBindingWeights";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPropertyAccessors";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeInto";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializePropertyInto";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalByFields";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeBindingWeights";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sortBindings";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deserializeInto";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTagNameFromAnnotation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAssertBindings";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertyAccessors";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasStoreAnnotations";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldAccessors";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyData";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NameAndIsSetter {
        final String name;
        final boolean isSetter;

        private NameAndIsSetter(String name, boolean isSetter) {
            this.name = name;
            this.isSetter = isSetter;
        }
    }
}

