/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.KtPsiUtilKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0007*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/SuppressLintQuickFix;", "Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "id", "", "(Ljava/lang/String;)V", "lintId", "addArgumentToAnnotation", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "argument", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lorg/jetbrains/android/inspections/lint/AndroidQuickfixContexts$Context;", "getLintId", "intentionId", "getName", "isApplicable", "contextType", "Lorg/jetbrains/android/inspections/lint/AndroidQuickfixContexts$ContextType;", "isNewLineNeededForAnnotation", "Lorg/jetbrains/kotlin/psi/KtElement;", "isSuppressLintTarget", "Companion", "intellij.android.kotlin.idea"})
public final class SuppressLintQuickFix
implements AndroidLintQuickFix {
    private final String lintId;
    @NotNull
    private static final String INTENTION_NAME_PREFIX = "AndroidLint";
    @NotNull
    private static final String SUPPRESS_LINT_MESSAGE = "android.lint.fix.suppress.lint.api.annotation";
    @NotNull
    private static final FqName FQNAME_SUPPRESS_LINT;
    @Deprecated
    public static final Companion Companion;

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)startElement, (boolean)true, (Condition)((Condition)new Condition<PsiElement>(this){
            final /* synthetic */ SuppressLintQuickFix this$0;

            public final boolean value(PsiElement it) {
                PsiElement psiElement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
                return SuppressLintQuickFix.access$isSuppressLintTarget(this.this$0, psiElement);
            }
            {
                this.this$0 = suppressLintQuickFix;
            }
        }));
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"PsiTreeUtil.findFirstPar\u2026sLintTarget() } ?: return");
        PsiElement annotationContainer2 = psiElement;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(annotationContainer2)) {
            return;
        }
        String argument = '\"' + this.lintId + '\"';
        PsiElement psiElement2 = annotationContainer2;
        if (psiElement2 instanceof KtModifierListOwner) {
            ModifierListModifactorKt.addAnnotation((KtModifierListOwner)((KtModifierListOwner)annotationContainer2), (FqName)FQNAME_SUPPRESS_LINT, (String)argument, (String)(this.isNewLineNeededForAnnotation((KtElement)annotationContainer2) ? "\n" : " "), (Function1)((Function1)new Function1<KtAnnotationEntry, Boolean>(this, argument){
                final /* synthetic */ SuppressLintQuickFix this$0;
                final /* synthetic */ String $argument;

                public final boolean invoke(@NotNull KtAnnotationEntry entry) {
                    Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                    return SuppressLintQuickFix.access$addArgumentToAnnotation(this.this$0, entry, this.$argument);
                }
                {
                    this.this$0 = suppressLintQuickFix;
                    this.$argument = string;
                    super(1);
                }
            }));
        }
    }

    @NotNull
    public String getName() {
        String string = AndroidBundle.message((String)SUPPRESS_LINT_MESSAGE, (Object[])new Object[]{this.lintId});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"AndroidBundle.message(SU\u2026ESS_LINT_MESSAGE, lintId)");
        return string;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)contextType, (String)"contextType");
        return true;
    }

    private final boolean addArgumentToAnnotation(KtAnnotationEntry entry, String argument) {
        KtValueArgumentList args = entry.getValueArgumentList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)entry), (boolean)false, (int)2, null);
        KtValueArgumentList newArgList = psiFactory.createCallArguments('(' + argument + ')');
        if (args == null) {
            entry.addAfter((PsiElement)newArgList, entry.getLastChild());
        } else if (args.getArguments().isEmpty()) {
            args.replace((PsiElement)newArgList);
        } else {
            boolean bl;
            block8: {
                List list = args.getArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"args.arguments");
                Iterable $receiver$iv = list;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        if (!it.textMatches((CharSequence)argument)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                args.addArgument((KtValueArgument)newArgList.getArguments().get(0));
            }
        }
        return true;
    }

    private final String getLintId(String intentionId) {
        String string;
        if (StringsKt.startsWith$default((String)intentionId, (String)INTENTION_NAME_PREFIX, (boolean)false, (int)2, null)) {
            String string2 = intentionId;
            int n = INTENTION_NAME_PREFIX.length();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = intentionId;
        }
        return string;
    }

    private final boolean isNewLineNeededForAnnotation(@NotNull KtElement $receiver) {
        return !($receiver instanceof KtParameter) && !($receiver instanceof KtTypeParameter) && !($receiver instanceof KtPropertyAccessor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuppressLintTarget(@NotNull PsiElement $receiver) {
        if (!($receiver instanceof KtDeclaration)) return false;
        PsiElement psiElement = $receiver;
        if (!(psiElement instanceof KtProperty)) {
            psiElement = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement;
        if (!(ktProperty != null ? KtPsiUtilKt.hasBackingField(ktProperty) : true)) return false;
        if ($receiver instanceof KtFunctionLiteral) return false;
        if ($receiver instanceof KtDestructuringDeclaration) return false;
        return true;
    }

    public SuppressLintQuickFix(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.lintId = this.getLintId(id);
    }

    static {
        Companion = new Companion(null);
        INTENTION_NAME_PREFIX = INTENTION_NAME_PREFIX;
        SUPPRESS_LINT_MESSAGE = SUPPRESS_LINT_MESSAGE;
        FQNAME_SUPPRESS_LINT = new FqName("android.annotation.SuppressLint");
    }

    public static final /* synthetic */ boolean access$isSuppressLintTarget(SuppressLintQuickFix $this, @NotNull PsiElement $receiver) {
        return $this.isSuppressLintTarget($receiver);
    }

    public static final /* synthetic */ boolean access$addArgumentToAnnotation(SuppressLintQuickFix $this, @NotNull KtAnnotationEntry entry, @NotNull String argument) {
        return $this.addArgumentToAnnotation(entry, argument);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/SuppressLintQuickFix$Companion;", "", "()V", "FQNAME_SUPPRESS_LINT", "Lorg/jetbrains/kotlin/name/FqName;", "getFQNAME_SUPPRESS_LINT", "()Lorg/jetbrains/kotlin/name/FqName;", "INTENTION_NAME_PREFIX", "", "getINTENTION_NAME_PREFIX", "()Ljava/lang/String;", "SUPPRESS_LINT_MESSAGE", "getSUPPRESS_LINT_MESSAGE", "intellij.android.kotlin.idea"})
    private static final class Companion {
        @NotNull
        public final String getINTENTION_NAME_PREFIX() {
            return INTENTION_NAME_PREFIX;
        }

        @NotNull
        public final String getSUPPRESS_LINT_MESSAGE() {
            return SUPPRESS_LINT_MESSAGE;
        }

        @NotNull
        public final FqName getFQNAME_SUPPRESS_LINT() {
            return FQNAME_SUPPRESS_LINT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

