/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.inspection;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.jvm.checkers.DalvikIdentifierUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getIoFile", "Ljava/io/File;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getJunitTestPaths", "", "module", "Lcom/intellij/openapi/module/Module;", "JunitPaths", "intellij.android.kotlin.idea"})
public final class IllegalIdentifierInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return (PsiElementVisitor)new KtVisitorVoid(this, holder){
            final /* synthetic */ IllegalIdentifierInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element) {
                String text;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                ASTNode aSTNode = element.getNode();
                if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.IDENTIFIER) ^ true) {
                    return;
                }
                String string = text = element.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                if (!StringsKt.startsWith$default((CharSequence)string, (char)'`', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)text, (char)'`', (boolean)false, (int)2, null)) {
                    return;
                }
                String string2 = KtPsiUtil.unquoteIdentifier((String)text);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KtPsiUtil.unquoteIdentifier(text)");
                String unquotedName = string2;
                CharSequence charSequence = unquotedName;
                if (charSequence.length() == 0) {
                    return;
                }
                if (!DalvikIdentifierUtils.isValidDalvikIdentifier((String)unquotedName) && this.checkAndroidFacet(element)) {
                    if (this.isInUnitTests(element)) {
                        return;
                    }
                    this.$holder.registerProblem(element, "Identifier not allowed in Android projects", ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{(LocalQuickFix)new RenameIdentifierFix()});
                }
            }

            private final boolean isInUnitTests(@NotNull PsiElement $receiver) {
                File file;
                PsiFile psiFile = $receiver.getContainingFile();
                if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null) {
                    PsiFile psiFile2;
                    PsiFile it = psiFile2 = psiFile;
                    file = IllegalIdentifierInspection.access$getIoFile(this.this$0, (VirtualFile)it);
                } else {
                    file = null;
                }
                File containingFile = file;
                Module module = AndroidPsiUtils.getModuleSafely((PsiElement)$receiver);
                if (module != null && containingFile != null) {
                    boolean bl;
                    block8: {
                        JunitPaths junitPaths;
                        JunitPaths it;
                        ProjectRootModificationTracker projectRootModificationTracker = ProjectRootModificationTracker.getInstance((Project)module.getProject());
                        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootModificationTracker, (String)"ProjectRootModificationT\u2026tInstance(module.project)");
                        long currentGenerationId = projectRootModificationTracker.getModificationCount();
                        JunitPaths junitPaths2 = (JunitPaths)module.getUserData((Key)JunitPaths.Companion);
                        if (junitPaths2 == null || (junitPaths2 = (it = (junitPaths = junitPaths2)).getGenerationId() == currentGenerationId ? junitPaths : null) == null) {
                            it = junitPaths = new JunitPaths(IllegalIdentifierInspection.access$getJunitTestPaths(this.this$0, module), currentGenerationId);
                            module.putUserData((Key)JunitPaths.Companion, (Object)it);
                            junitPaths2 = junitPaths;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)junitPaths2, (String)"module.getUserData(Junit\u2026serData(JunitPaths, it) }");
                        JunitPaths junitTestPaths = junitPaths2;
                        Iterable $receiver$iv = junitTestPaths.getPaths();
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                File it2 = (File)element$iv;
                                if (!FilesKt.startsWith((File)containingFile, (File)it2)) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return true;
                    }
                }
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean checkAndroidFacet(PsiElement element) {
                if (AndroidUtilKt.getAndroidFacetForFile(element) != null) return true;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) return false;
                return true;
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getJunitTestPaths(Module module) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFacet, (String)"AndroidFacet.getInstance\u2026le) ?: return emptyList()");
        AndroidFacet androidFacet2 = androidFacet;
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get((AndroidFacet)androidFacet2);
        if (androidModuleModel == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)androidModuleModel, (String)"AndroidModuleModel.get(a\u2026et) ?: return emptyList()");
        AndroidModuleModel androidModuleModel2 = androidModuleModel;
        List list = androidModuleModel2.getTestSourceProviders("_unit_test_");
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"androidModuleModel.getTe\u2026iders(ARTIFACT_UNIT_TEST)");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SourceProvider it;
            SourceProvider sourceProvider = it = (SourceProvider)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceProvider, (String)"it");
            Iterable list$iv$iv = sourceProvider.getJavaDirectories();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final File getIoFile(VirtualFile virtualFile) {
        File file;
        File it;
        String string = virtualFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"virtualFile.path");
        String path = string;
        if (StringUtil.endsWithChar((CharSequence)path, (char)':') && path.length() == 2 && SystemInfo.isWindows) {
            path = path + "/";
        }
        return (it = (file = new File(path))).exists() ? file : null;
    }

    @Nullable
    public static final /* synthetic */ File access$getIoFile(IllegalIdentifierInspection $this, @NotNull VirtualFile virtualFile) {
        return $this.getIoFile(virtualFile);
    }

    @NotNull
    public static final /* synthetic */ List access$getJunitTestPaths(IllegalIdentifierInspection $this, @NotNull Module module) {
        return $this.getJunitTestPaths(module);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths;", "", "paths", "", "Ljava/io/File;", "generationId", "", "(Ljava/util/List;J)V", "getGenerationId", "()J", "getPaths", "()Ljava/util/List;", "Companion", "intellij.android.kotlin.idea"})
    private static final class JunitPaths {
        @NotNull
        private final List<File> paths;
        private final long generationId;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final List<File> getPaths() {
            return this.paths;
        }

        public final long getGenerationId() {
            return this.generationId;
        }

        public JunitPaths(@NotNull List<? extends File> paths, long generationId) {
            Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
            this.paths = paths;
            this.generationId = generationId;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths$Companion;", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths;", "()V", "intellij.android.kotlin.idea"})
        public static final class Companion
        extends Key<JunitPaths> {
            private Companion() {
                super("AndroidModuleJunitPaths");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

