/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.folding;

import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.folding.AndroidFoldingSettings;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.folding.ResourceFoldingBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\tH\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u000f*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u0007*\u00020\u001dH\u0002J'\u0010!\u001a\u0004\u0018\u00010\u000f*\u00020\"2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0082\u0010J\f\u0010'\u001a\u00020\u0004*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "()V", "isFoldingEnabled", "", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "formatArguments", "", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "formatString", "getAppResources", "Lcom/android/tools/idea/res/LocalResourceRepository;", "element", "getPlaceholderText", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "getAndroidResourceType", "Lcom/android/resources/ResourceType;", "getAndroidResourceValue", "Lorg/jetbrains/uast/UReferenceExpression;", "resources", "call", "getFoldingDescriptor", "getResourceValue", "Lcom/android/ide/common/resources/ResourceRepository;", "type", "name", "referenceConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "isFoldableGetResourceValueCall", "Companion", "intellij.android.kotlin.idea"})
public final class ResourceFoldingBuilder
extends FoldingBuilderEx {
    private final boolean isFoldingEnabled;
    private static final Pattern FORMAT;
    private static final int FOLD_MAX_LENGTH = 60;
    private static final boolean UNIT_TEST_MODE;
    private static final List<ResourceType> RESOURCE_TYPES;
    public static final Companion Companion;

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Function2<UElement, LocalResourceRepository, String> unwrapReferenceAndGetValue$ = new Function2<UElement, LocalResourceRepository, String>(this){
            final /* synthetic */ ResourceFoldingBuilder this$0;

            @Nullable
            public final String invoke(@NotNull UElement $receiver, @NotNull LocalResourceRepository resources) {
                String string;
                UElement uElement;
                while (true) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
                    uElement = $receiver;
                    if (!(uElement instanceof UQualifiedReferenceExpression)) break;
                    $receiver = (UElement)((UQualifiedReferenceExpression)$receiver).getSelector();
                }
                if (uElement instanceof UCallExpression) {
                    Object object = CollectionsKt.firstOrNull((List)((UCallExpression)$receiver).getValueArguments());
                    if (!(object instanceof UReferenceExpression)) {
                        object = null;
                    }
                    UReferenceExpression uReferenceExpression = (UReferenceExpression)object;
                    string = uReferenceExpression != null ? ResourceFoldingBuilder.access$getAndroidResourceValue(this.this$0, uReferenceExpression, resources, (UCallExpression)$receiver) : null;
                } else {
                    UElement uElement2 = $receiver;
                    if (!(uElement2 instanceof UReferenceExpression)) {
                        uElement2 = null;
                    }
                    UReferenceExpression uReferenceExpression = (UReferenceExpression)uElement2;
                    string = uReferenceExpression != null ? ResourceFoldingBuilder.getAndroidResourceValue$default(this.this$0, uReferenceExpression, resources, null, 2, null) : null;
                }
                return string;
            }
            {
                this.this$0 = resourceFoldingBuilder;
                super(2);
            }
        };
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"SourceTreeToPsiMap.treeE\u2026oPsi(node) ?: return null");
        PsiElement element = psiElement;
        LocalResourceRepository localResourceRepository = this.getAppResources(element);
        if (localResourceRepository == null) {
            return null;
        }
        LocalResourceRepository appResources = localResourceRepository;
        UastContext uastContext = (UastContext)ServiceManager.getService((Project)element.getProject(), UastContext.class);
        if (uastContext == null) {
            return null;
        }
        UastContext uastContext2 = uastContext;
        UElement uElement = uastContext2.convertElement(element, null, null);
        return uElement != null ? unwrapReferenceAndGetValue$.invoke(uElement, appResources) : null;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Collection $receiver$iv;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                if (!(root instanceof KtFile) || quick && !UNIT_TEST_MODE || !this.isFoldingEnabled) break block5;
                if (AndroidFacet.getInstance((PsiElement)root) != null) break block6;
            }
            return new FoldingDescriptor[0];
        }
        UElement file = UastContextKt.toUElement((PsiElement)root);
        ArrayList result = new ArrayList();
        UElement uElement = file;
        if (uElement != null) {
            uElement.accept((UastVisitor)new AbstractUastVisitor(this, result){
                final /* synthetic */ ResourceFoldingBuilder this$0;
                final /* synthetic */ ArrayList $result;

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    block0: {
                        FoldingDescriptor foldingDescriptor;
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        FoldingDescriptor foldingDescriptor2 = ResourceFoldingBuilder.access$getFoldingDescriptor(this.this$0, (UReferenceExpression)node);
                        if (foldingDescriptor2 == null) break block0;
                        FoldingDescriptor it = foldingDescriptor = foldingDescriptor2;
                        this.$result.add(it);
                    }
                    return super.visitSimpleNameReferenceExpression(node);
                }
                {
                    this.this$0 = $outer;
                    this.$result = $captured_local_variable$1;
                }
            });
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)result;
        FoldingDescriptor[] foldingDescriptorArray = thisCollection$iv.toArray(new FoldingDescriptor[0]);
        if (foldingDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return foldingDescriptorArray;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.isFoldingEnabled;
    }

    private final FoldingDescriptor getFoldingDescriptor(@NotNull UReferenceExpression $receiver) {
        UCallExpression getResourceValueCall;
        UCallExpression uCallExpression;
        UCallExpression it;
        PsiElement psiElement = $receiver.resolve();
        if (psiElement == null) {
            return null;
        }
        PsiElement resolved = psiElement;
        ResourceType resourceType = this.getAndroidResourceType(resolved);
        if (resourceType == null) {
            return null;
        }
        ResourceType resourceType2 = resourceType;
        if (!RESOURCE_TYPES.contains(resourceType2)) {
            return null;
        }
        getFoldingDescriptor.1 createFoldingDescriptor$ = getFoldingDescriptor.1.INSTANCE;
        UElement uElement = $receiver.getUastParent();
        if (!(uElement instanceof UQualifiedReferenceExpression)) {
            uElement = null;
        }
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)uElement;
        UReferenceExpression element = uQualifiedReferenceExpression != null ? (UReferenceExpression)uQualifiedReferenceExpression : $receiver;
        UElement uElement2 = element.getUastParent();
        if (!(uElement2 instanceof UCallExpression)) {
            uElement2 = null;
        }
        UCallExpression uCallExpression2 = (UCallExpression)uElement2;
        Object object = uCallExpression2 != null ? (this.isFoldableGetResourceValueCall(it = (uCallExpression = uCallExpression2)) ? uCallExpression : null) : (getResourceValueCall = null);
        if (getResourceValueCall != null) {
            UQualifiedReferenceExpression qualifiedCall;
            UElement uElement3 = getResourceValueCall.getUastParent();
            if (!(uElement3 instanceof UQualifiedReferenceExpression)) {
                uElement3 = null;
            }
            UQualifiedReferenceExpression uQualifiedReferenceExpression2 = qualifiedCall = (UQualifiedReferenceExpression)uElement3;
            if (Intrinsics.areEqual((Object)(uQualifiedReferenceExpression2 != null ? uQualifiedReferenceExpression2.getSelector() : null), (Object)getResourceValueCall)) {
                return createFoldingDescriptor$.invoke((UElement)qualifiedCall);
            }
            return createFoldingDescriptor$.invoke((UElement)getResourceValueCall);
        }
        return createFoldingDescriptor$.invoke((UElement)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFoldableGetResourceValueCall(@NotNull UCallExpression $receiver) {
        if (Intrinsics.areEqual((Object)$receiver.getMethodName(), (Object)"getString")) return true;
        if (Intrinsics.areEqual((Object)$receiver.getMethodName(), (Object)"getText")) return true;
        if (Intrinsics.areEqual((Object)$receiver.getMethodName(), (Object)"getInteger")) return true;
        String string = $receiver.getMethodName();
        if (string != null ? StringsKt.startsWith$default((String)string, (String)"getDimension", (boolean)false, (int)2, null) : false) return true;
        String string2 = $receiver.getMethodName();
        if (string2 == null) return false;
        boolean bl = StringsKt.startsWith$default((String)string2, (String)"getQuantityString", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    private final ResourceType getAndroidResourceType(@NotNull PsiElement $receiver) {
        PsiElement psiElement = $receiver.getParent();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return null;
        }
        PsiClass elementType = psiClass;
        PsiElement psiElement2 = elementType.getParent();
        if (!(psiElement2 instanceof PsiClass)) {
            psiElement2 = null;
        }
        PsiClass psiClass2 = (PsiClass)psiElement2;
        if (psiClass2 == null) {
            return null;
        }
        PsiClass elementPackage = psiClass2;
        if (Intrinsics.areEqual((Object)"R", (Object)elementPackage.getName()) ^ true) {
            return null;
        }
        if (Intrinsics.areEqual((Object)elementPackage.getQualifiedName(), (Object)"android.R") ^ true) {
            ResourceType resourceType;
            String string = elementType.getName();
            if (string != null) {
                String string2;
                String p1 = string2 = string;
                resourceType = ResourceType.fromClassName((String)p1);
            } else {
                resourceType = null;
            }
            return resourceType;
        }
        return null;
    }

    private final String getAndroidResourceValue(@NotNull UReferenceExpression $receiver, LocalResourceRepository resources, UCallExpression call) {
        String text;
        FolderConfiguration folderConfiguration;
        PsiElement psiElement = $receiver.resolve();
        if (psiElement == null || (psiElement = this.getAndroidResourceType(psiElement)) == null) {
            return null;
        }
        PsiElement resourceType = psiElement;
        FolderConfiguration $receiver2 = folderConfiguration = new FolderConfiguration();
        $receiver2.setLocaleQualifier(new LocaleQualifier("xx"));
        FolderConfiguration referenceConfig = folderConfiguration;
        String string = $receiver.getResolvedName();
        if (string == null) {
            return null;
        }
        String key = string;
        String string2 = this.getResourceValue((ResourceRepository)resources, (ResourceType)resourceType, key, referenceConfig);
        if (string2 == null) {
            return null;
        }
        String resourceValue = string2;
        String string3 = text = call != null ? this.formatArguments(call, resourceValue) : resourceValue;
        if (resourceType == ResourceType.STRING || resourceType == ResourceType.PLURALS) {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '\"';
            String string4 = StringUtil.shortenTextWithEllipsis((String)text, (int)58, (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringUtil.shortenTextWi\u2026, FOLD_MAX_LENGTH - 2, 0)");
            String string5 = string4;
            StringBuilder stringBuilder2 = stringBuilder;
            String string6 = String.valueOf(c) + string5;
            return stringBuilder2.append(string6).append('\"').toString();
        }
        if (text.length() <= 1) {
            return key + ": " + text;
        }
        return StringUtil.shortenTextWithEllipsis((String)text, (int)60, (int)0);
    }

    static /* synthetic */ String getAndroidResourceValue$default(ResourceFoldingBuilder resourceFoldingBuilder, UReferenceExpression uReferenceExpression, LocalResourceRepository localResourceRepository, UCallExpression uCallExpression, int n, Object object) {
        if ((n & 2) != 0) {
            uCallExpression = null;
        }
        return resourceFoldingBuilder.getAndroidResourceValue(uReferenceExpression, localResourceRepository, uCallExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final String getResourceValue(@NotNull ResourceRepository $receiver, ResourceType type, String name, FolderConfiguration referenceConfig) {
        Object object;
        while ((object = ResourceRepositoryUtil.getConfiguredValue((ResourceRepository)$receiver, (ResourceType)type, (String)name, (FolderConfiguration)referenceConfig)) != null && (object = object.getValue()) != null) {
            ResourceType referencedType;
            void referencedTypeName;
            Object object2;
            Object value = object;
            if (!StringsKt.startsWith$default((CharSequence)((CharSequence)value), (char)'@', (boolean)false, (int)2, null)) {
                return value;
            }
            Object object3 = value;
            int n = 1;
            Object object4 = object3;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object4).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            Object it = object3 = StringsKt.split$default((CharSequence)string, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
            Object object5 = it.size() == 2 ? object3 : null;
            if (object5 == null) {
                return value;
            }
            object3 = object2 = object5;
            String string2 = (String)object3.get(0);
            object3 = object2;
            String referencedName = (String)object3.get(1);
            if (ResourceType.fromXmlValue((String)referencedTypeName) == null) {
                return value;
            }
            name = referencedName;
            type = referencedType;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String formatArguments(UCallExpression callExpression, String formatString) {
        if (!StringsKt.contains$default((CharSequence)formatString, (char)'%', (boolean)false, (int)2, null)) {
            return formatString;
        }
        List args = callExpression.getValueArguments();
        if (args.isEmpty() || !((UExpression)CollectionsKt.first((List)args)).isPsiValid()) {
            return formatString;
        }
        Matcher matcher = FORMAT.matcher(formatString);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int start = 0;
        StringBuilder sb = new StringBuilder(2 * formatString.length());
        while (matcher.find(index)) {
            int number;
            int n;
            if (Intrinsics.areEqual((Object)"%", (Object)matcher.group(6))) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = formatString.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            index = matcher.end();
            String numberString = matcher.group(1);
            if (numberString != null) {
                String string = numberString;
                int n2 = 0;
                n = numberString.length() - 1;
                String string2 = string.substring(n2, n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                numberString = string2;
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number <= 0 || number >= args.size()) continue;
            UExpression argExpression = (UExpression)args.get(number);
            Object value = argExpression.evaluate();
            if (value == null) {
                value = ((UExpression)args.get(number)).asSourceString();
            }
            n = start;
            int n3 = matchStart;
            while (n < n3) {
                void i;
                sb.append(formatString.charAt((int)i));
                ++i;
            }
            sb.append("{");
            sb.append(value);
            sb.append('}');
            start = index;
        }
        int n = formatString.length();
        for (int i = start; i < n; ++i) {
            sb.append(formatString.charAt(i));
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final LocalResourceRepository getAppResources(PsiElement element) {
        Object object;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            Module module2;
            Module it = module2 = module;
            ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getOrCreateInstance((Module)it);
            object = resourceRepositoryManager != null ? resourceRepositoryManager.getAppResources(false) : null;
        } else {
            object = null;
        }
        return object;
    }

    public ResourceFoldingBuilder() {
        AndroidFoldingSettings androidFoldingSettings = AndroidFoldingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFoldingSettings, (String)"AndroidFoldingSettings.getInstance()");
        this.isFoldingEnabled = androidFoldingSettings.isCollapseAndroidStrings();
    }

    static {
        Companion = new Companion(null);
        FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        UNIT_TEST_MODE = application.isUnitTestMode();
        RESOURCE_TYPES = CollectionsKt.listOf((Object[])new ResourceType[]{ResourceType.STRING, ResourceType.DIMEN, ResourceType.INTEGER, ResourceType.PLURALS});
    }

    @Nullable
    public static final /* synthetic */ String access$getAndroidResourceValue(ResourceFoldingBuilder $this, @NotNull UReferenceExpression $receiver, @NotNull LocalResourceRepository resources, @Nullable UCallExpression call) {
        return $this.getAndroidResourceValue($receiver, resources, call);
    }

    @Nullable
    public static final /* synthetic */ FoldingDescriptor access$getFoldingDescriptor(ResourceFoldingBuilder $this, @NotNull UReferenceExpression $receiver) {
        return $this.getFoldingDescriptor($receiver);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder$Companion;", "", "()V", "FOLD_MAX_LENGTH", "", "FORMAT", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "RESOURCE_TYPES", "", "Lcom/android/resources/ResourceType;", "UNIT_TEST_MODE", "", "intellij.android.kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

