/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import android.os._Original_Build;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.commons.ClassRemapper;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

public class LayoutlibClassLoader
extends ClassLoader {
    private static Logger LOG = Logger.getInstance(LayoutlibClassLoader.class);

    LayoutlibClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            LayoutlibClassLoader.$$$reportNull$$$0(0);
        }
        super(parent);
        LayoutlibClassLoader.generate(_Original_Build.class, (className, classBytes) -> this.defineClass((String)className, (byte[])classBytes, 0, ((byte[])classBytes).length));
    }

    @NotNull
    private static String toBinaryClassName(@NotNull String name) {
        if (name == null) {
            LayoutlibClassLoader.$$$reportNull$$$0(1);
        }
        String string = name.replace('.', '/');
        if (string == null) {
            LayoutlibClassLoader.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String toClassName(@NotNull String name) {
        if (name == null) {
            LayoutlibClassLoader.$$$reportNull$$$0(3);
        }
        String string = name.replace('/', '.');
        if (string == null) {
            LayoutlibClassLoader.$$$reportNull$$$0(4);
        }
        return string;
    }

    @VisibleForTesting
    static void generate(@NotNull Class<?> originalBuildClass, @NotNull BiConsumer<String, byte[]> defineClass) {
        if (originalBuildClass == null) {
            LayoutlibClassLoader.$$$reportNull$$$0(5);
        }
        if (defineClass == null) {
            LayoutlibClassLoader.$$$reportNull$$$0(6);
        }
        ClassLoader loader = originalBuildClass.getClassLoader();
        String originalBuildClassName = originalBuildClass.getName();
        final String originalBuildBinaryClassName = LayoutlibClassLoader.toBinaryClassName(originalBuildClassName);
        final LinkedList<String> pendingClasses = new LinkedList<String>();
        pendingClasses.push(originalBuildClassName);
        Remapper remapper = new Remapper(){

            public String map(String typeName) {
                if (typeName.startsWith(originalBuildBinaryClassName)) {
                    return "android/os/Build" + StringUtil.trimStart((String)typeName, (String)originalBuildBinaryClassName);
                }
                return typeName;
            }
        };
        while (!pendingClasses.isEmpty()) {
            String name = (String)pendingClasses.pop();
            String newName = "android.os.Build" + StringUtil.trimStart((String)name, (String)originalBuildClassName);
            final String binaryName = LayoutlibClassLoader.toBinaryClassName(name);
            try {
                InputStream is = loader.getResourceAsStream(binaryName + ".class");
                Throwable throwable = null;
                try {
                    ClassWriter writer = new ClassWriter(0);
                    ClassReader reader = new ClassReader(is);
                    ClassRemapper classRemapper = new ClassRemapper((ClassVisitor)writer, remapper){

                        public void visitInnerClass(String name, String outerName, String innerName, int access) {
                            if (outerName != null && outerName.startsWith(binaryName)) {
                                pendingClasses.push(LayoutlibClassLoader.toClassName(name));
                            }
                            super.visitInnerClass(name, outerName, innerName, access);
                        }
                    };
                    reader.accept((ClassVisitor)classRemapper, 0);
                    defineClass.accept(newName, writer.toByteArray());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to define android.os.Build", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/layoutlib/LayoutlibClassLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalBuildClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defineClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/layoutlib/LayoutlibClassLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toBinaryClassName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toBinaryClassName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toClassName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

