/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.lang.JavaVersion;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.PathUtils;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.backwardRefs.JavaBackwardReferenceIndexWriter;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderExtension;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.ClassPostProcessor;
import org.jetbrains.jps.incremental.java.CustomOutputDataListener;
import org.jetbrains.jps.incremental.java.ExternalJavacOptionsProvider;
import org.jetbrains.jps.incremental.java.OutputFilesSink;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.javac.CompilationPaths;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.javac.JpsInfoDiagnostic;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;
import org.jetbrains.jps.javac.ast.api.JavacFileData;
import org.jetbrains.jps.javac.ast.api.JavacFileReferencesRegistrar;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.SharedThreadPool;

public class JavaBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.java.JavaBuilder");
    private static final String JAVA_EXTENSION = "java";
    public static final String BUILDER_NAME = "java";
    public static final Key<Boolean> IS_ENABLED = Key.create((String)"_java_compiler_enabled_");
    public static final FileFilter JAVA_SOURCES_FILTER = FileFilters.withExtension((String)"java");
    private static final int RETIRE_POLICY_VERSIONS_COUNT = 5;
    private static final Key<Boolean> PREFER_TARGET_JDK_COMPILER = GlobalContextKey.create("_prefer_target_jdk_javac_");
    private static final Key<JavaCompilingTool> COMPILING_TOOL = Key.create((String)"_java_compiling_tool_");
    private static final Key<ConcurrentMap<String, Collection<String>>> COMPILER_USAGE_STATISTICS = Key.create((String)"_java_compiler_usage_stats_");
    private static final List<String> COMPILABLE_EXTENSIONS = Collections.singletonList("java");
    private static final Set<String> FILTERED_OPTIONS = ContainerUtil.newHashSet((Object[])new String[]{"-target", "--release"});
    private static final Set<String> FILTERED_SINGLE_OPTIONS = ContainerUtil.newHashSet((Object[])new String[]{"-g", "-deprecation", "-nowarn", "-verbose", "-proc:none", "-proc:only", "-proceedOnError"});
    private static final List<ClassPostProcessor> ourClassProcessors = new ArrayList<ClassPostProcessor>();
    private static final Set<JpsModuleType<?>> ourCompilableModuleTypes = new HashSet();
    @Nullable
    private static final File ourDefaultRtJar;
    private final Executor myTaskRunner;
    private final Collection<JavacFileReferencesRegistrar> myRefRegistrars = new ArrayList<JavacFileReferencesRegistrar>();
    private static final Key<String> USER_DEFINED_BYTECODE_TARGET;
    private static final Key<Semaphore> COUNTER_KEY;

    public static void registerClassPostProcessor(ClassPostProcessor processor) {
        ourClassProcessors.add(processor);
    }

    public JavaBuilder(Executor tasksExecutor) {
        super(BuilderCategory.TRANSLATOR);
        this.myTaskRunner = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"JavaBuilder Pool", (Executor)tasksExecutor);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if ("java" == null) {
            JavaBuilder.$$$reportNull$$$0(0);
        }
        return "java";
    }

    @Override
    public void buildStarted(CompileContext context) {
        String compilerId = JavaBuilder.getUsedCompilerId(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Java compiler ID: " + compilerId);
        }
        JavaCompilingTool compilingTool = JavaBuilderUtil.findCompilingTool(compilerId);
        COMPILING_TOOL.set((UserDataHolder)context, (Object)compilingTool);
        COMPILER_USAGE_STATISTICS.set((UserDataHolder)context, new ConcurrentHashMap());
        JavaBackwardReferenceIndexWriter.initialize(context);
        for (JavacFileReferencesRegistrar registrar : JpsServiceManager.getInstance().getExtensions(JavacFileReferencesRegistrar.class)) {
            if (!registrar.isEnabled()) continue;
            registrar.initialize();
            this.myRefRegistrars.add(registrar);
        }
    }

    @Override
    public void chunkBuildStarted(final CompileContext context, final ModuleChunk chunk) {
        try {
            JavaBuilderUtil.markDirtyDependenciesForInitialRound(context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
                    if (processor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FSOperations.processFilesToRecompile(context, chunk, processor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/java/JavaBuilder$1", "processDirtyFiles"));
                }
            }, chunk);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void buildFinished(CompileContext context) {
        this.myRefRegistrars.clear();
        ConcurrentMap stats = (ConcurrentMap)COMPILER_USAGE_STATISTICS.get((UserDataHolder)context);
        if (stats.size() == 1) {
            Map.Entry entry = stats.entrySet().iterator().next();
            String compilerName = (String)entry.getKey();
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, compilerName + " was used to compile java sources"));
            LOG.info(compilerName + " was used to compile " + entry.getValue());
        } else {
            for (Map.Entry entry : stats.entrySet()) {
                String compilerName = (String)entry.getKey();
                Collection moduleNames = (Collection)entry.getValue();
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, moduleNames.size() == 1 ? compilerName + " was used to compile [" + (String)moduleNames.iterator().next() + "]" : compilerName + " was used to compile " + moduleNames.size() + " modules"));
                LOG.info(compilerName + " was used to compile " + moduleNames);
            }
        }
    }

    @Override
    public List<String> getCompilableFileExtensions() {
        return COMPILABLE_EXTENSIONS;
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        if (context == null) {
            JavaBuilder.$$$reportNull$$$0(1);
        }
        if (chunk == null) {
            JavaBuilder.$$$reportNull$$$0(2);
        }
        if (dirtyFilesHolder == null) {
            JavaBuilder.$$$reportNull$$$0(3);
        }
        if (outputConsumer == null) {
            JavaBuilder.$$$reportNull$$$0(4);
        }
        JavaCompilingTool compilingTool = (JavaCompilingTool)COMPILING_TOOL.get((UserDataHolder)context);
        if (!((Boolean)IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue() || compilingTool == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        return this.doBuild(context, chunk, dirtyFilesHolder, outputConsumer, compilingTool);
    }

    public ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer, @NotNull JavaCompilingTool compilingTool) throws ProjectBuildException, IOException {
        if (context == null) {
            JavaBuilder.$$$reportNull$$$0(5);
        }
        if (chunk == null) {
            JavaBuilder.$$$reportNull$$$0(6);
        }
        if (dirtyFilesHolder == null) {
            JavaBuilder.$$$reportNull$$$0(7);
        }
        if (outputConsumer == null) {
            JavaBuilder.$$$reportNull$$$0(8);
        }
        if (compilingTool == null) {
            JavaBuilder.$$$reportNull$$$0(9);
        }
        try {
            ProjectBuilderLogger logger;
            THashSet filesToCompile = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            dirtyFilesHolder.processDirtyFiles((arg_0, arg_1, arg_2) -> JavaBuilder.lambda$doBuild$0((Set)filesToCompile, arg_0, arg_1, arg_2));
            int javaModulesCount = 0;
            if ((!filesToCompile.isEmpty() || dirtyFilesHolder.hasRemovedFiles()) && JavaBuilder.getTargetPlatformLanguageVersion(chunk.representativeTarget().getModule()) >= 9) {
                for (ModuleBuildTarget target : chunk.getTargets()) {
                    if (JavaBuilderUtil.findModuleInfoFile(context, target) == null) continue;
                    ++javaModulesCount;
                }
            }
            if (JavaBuilderUtil.isCompileJavaIncrementally(context) && (logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled() && !filesToCompile.isEmpty()) {
                logger.logCompiledFiles((Collection<File>)filesToCompile, "java", "Compiling files:");
            }
            if (javaModulesCount > 1) {
                String prefix = "Cannot compile a module cycle with multiple module-info.java files: ";
                String message = chunk.getModules().stream().map(JpsNamedElement::getName).collect(Collectors.joining(", ", prefix, ""));
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, message));
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            return this.compile(context, chunk, dirtyFilesHolder, (Collection<? extends File>)filesToCompile, outputConsumer, compilingTool, javaModulesCount > 0);
        }
        catch (PersistentEnumeratorBase.CorruptedException | BuildDataCorruptedException | ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            if (message == null || message.trim().isEmpty()) {
                message = "Internal error: \n" + ExceptionUtil.getThrowableText((Throwable)e);
            }
            context.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, message));
            throw new StopBuildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleLevelBuilder.ExitCode compile(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, Collection<? extends File> files, ModuleLevelBuilder.OutputConsumer outputConsumer, JavaCompilingTool compilingTool, boolean hasModules) throws Exception {
        ModuleLevelBuilder.ExitCode exitCode;
        block18: {
            boolean hasSourcesToCompile;
            exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            boolean bl = hasSourcesToCompile = !files.isEmpty();
            if (!hasSourcesToCompile && !dirtyFilesHolder.hasRemovedFiles()) {
                return exitCode;
            }
            ProjectDescriptor pd = context.getProjectDescriptor();
            JavaBuilderUtil.ensureModuleHasJdk(chunk.representativeTarget().getModule(), context, "java");
            Collection<File> classpath = ProjectPaths.getCompilationClasspath(chunk, false);
            Collection<File> platformCp = ProjectPaths.getPlatformCompilationClasspath(chunk, false);
            OutputFilesSink outputSink = new OutputFilesSink(context, outputConsumer, JavaBuilderUtil.getDependenciesRegistrar(context), chunk.getPresentableShortName());
            Collection<File> filesWithErrors = null;
            try {
                if (!hasSourcesToCompile) break block18;
                exitCode = ModuleLevelBuilder.ExitCode.OK;
                HashSet<File> srcPath = new HashSet<File>();
                BuildRootIndex index = pd.getBuildRootIndex();
                for (ModuleBuildTarget target : chunk.getTargets()) {
                    for (JavaSourceRootDescriptor rd : index.getTempTargetRoots(target, context)) {
                        srcPath.add(rd.root);
                    }
                }
                DiagnosticSink diagnosticSink = new DiagnosticSink(context, Collections.unmodifiableCollection(this.myRefRegistrars));
                String chunkName = chunk.getName();
                context.processMessage(new ProgressMessage("Parsing java... [" + chunk.getPresentableShortName() + "]"));
                int filesCount = files.size();
                boolean compiledOk = true;
                if (filesCount > 0) {
                    LOG.info("Compiling " + filesCount + " java files; module: " + chunkName + (chunk.containsTests() ? " (tests)" : ""));
                    if (LOG.isDebugEnabled()) {
                        for (File file : files) {
                            LOG.debug("Compiling " + file.getPath());
                        }
                        LOG.debug(" classpath for " + chunkName + ":");
                        for (File file : classpath) {
                            LOG.debug("  " + file.getAbsolutePath());
                        }
                        LOG.debug(" platform classpath for " + chunkName + ":");
                        for (File file : platformCp) {
                            LOG.debug("  " + file.getAbsolutePath());
                        }
                    }
                    try {
                        compiledOk = this.compileJava(context, chunk, files, classpath, platformCp, srcPath, diagnosticSink, outputSink, compilingTool, hasModules);
                    }
                    finally {
                        filesWithErrors = diagnosticSink.getFilesWithErrors();
                    }
                }
                context.checkCanceled();
                if (!compiledOk && diagnosticSink.getErrorCount() == 0) {
                    diagnosticSink.report((Diagnostic<? extends JavaFileObject>)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, "Compilation failed: internal java compiler error"));
                }
                if (diagnosticSink.getErrorCount() > 0) {
                    diagnosticSink.report((Diagnostic<? extends JavaFileObject>)new JpsInfoDiagnostic("Errors occurred while compiling module '" + chunkName + "'"));
                }
                if (!((Boolean)Utils.PROCEED_ON_ERROR_KEY.get((UserDataHolder)context, (Object)Boolean.FALSE)).booleanValue() && diagnosticSink.getErrorCount() > 0) {
                    throw new StopBuildException("Compilation failed: errors: " + diagnosticSink.getErrorCount() + "; warnings: " + diagnosticSink.getWarningCount());
                }
            }
            finally {
                JavaBuilderUtil.registerFilesToCompile(context, files);
                if (filesWithErrors != null) {
                    JavaBuilderUtil.registerFilesWithErrors(context, filesWithErrors);
                }
                JavaBuilderUtil.registerSuccessfullyCompiled(context, outputSink.getSuccessfullyCompiled());
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileJava(CompileContext context, ModuleChunk chunk, Collection<? extends File> files, Collection<? extends File> originalClassPath, Collection<? extends File> originalPlatformCp, Collection<? extends File> sourcePath, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool, boolean hasModules) {
        Semaphore counter = new Semaphore();
        COUNTER_KEY.set((UserDataHolder)context, (Object)counter);
        Set<JpsModule> modules = chunk.getModules();
        ProcessorConfigProfile profile = null;
        if (modules.size() == 1) {
            JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getCompilerConfiguration(context.getProjectDescriptor().getProject());
            assert (compilerConfig != null);
            profile = compilerConfig.getAnnotationProcessingProfile(modules.iterator().next());
        } else {
            String message = JavaBuilder.validateCycle(context, chunk);
            if (message != null) {
                diagnosticSink.report((Diagnostic)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, message));
                return false;
            }
        }
        Map<File, Set<File>> outs = JavaBuilder.buildOutputDirectoriesMap(context, chunk);
        try {
            boolean rc;
            Collection<? extends File> platformCp;
            int targetLanguageLevel = JavaBuilder.getTargetPlatformLanguageVersion(chunk.representativeTarget().getModule());
            boolean shouldForkJavac = JavaBuilder.shouldForkCompilerProcess(context, chunk, targetLanguageLevel);
            Pair<String, Integer> forkSdk = null;
            if (shouldForkJavac && (forkSdk = JavaBuilder.getForkedJavacSdk(chunk, targetLanguageLevel)) == null) {
                String text = "Cannot start javac process for " + chunk.getName() + ": unknown JDK home path.\nPlease check project configuration.";
                diagnosticSink.report((Diagnostic)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, text));
                boolean bl = false;
                return bl;
            }
            int compilerSdkVersion = forkSdk == null ? JavaVersion.current().feature : (Integer)forkSdk.getSecond();
            Pair<List<String>, List<String>> vm_compilerOptions = JavaBuilder.getCompilationOptions(compilerSdkVersion, context, chunk, profile, hasModules, compilingTool);
            List vmOptions = (List)vm_compilerOptions.first;
            List options = (List)vm_compilerOptions.second;
            if (LOG.isDebugEnabled()) {
                String mode = shouldForkJavac ? "fork" : "in-process";
                LOG.debug("Compiling chunk [" + chunk.getName() + "] with options: \"" + StringUtil.join((Collection)options, (String)" ") + "\", mode=" + mode);
            }
            if ((platformCp = JavaBuilder.calcEffectivePlatformCp(originalPlatformCp, options, compilingTool)) == null) {
                String text = "Compact compilation profile was requested, but target platform for module \"" + chunk.getName() + "\" differs from javac's platform (" + System.getProperty("java.version") + ")\nCompilation profiles are not supported for such configuration";
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, text));
                boolean bl = false;
                return bl;
            }
            List classPath = originalClassPath;
            Collection<Object> modulePath = Collections.emptyList();
            Collection<Object> upgradeModulePath = Collections.emptyList();
            if (hasModules) {
                modulePath = ProjectPaths.getCompilationModulePath(chunk, false);
                classPath = Collections.emptyList();
                upgradeModulePath = platformCp;
                platformCp = Collections.emptyList();
            }
            if (!platformCp.isEmpty() && JavaBuilder.getChunkSdkVersion(chunk) >= 9) {
                classPath = JBIterable.from(platformCp).append(classPath).toList();
                platformCp = Collections.emptyList();
            }
            ClassProcessingConsumer classesConsumer = new ClassProcessingConsumer(context, outputSink);
            if (!shouldForkJavac) {
                JavaBuilder.updateCompilerUsageStatistics(context, compilingTool.getDescription(), chunk);
                rc = JavacMain.compile((Collection)options, files, (Collection)classPath, platformCp, modulePath, upgradeModulePath, sourcePath, outs, (DiagnosticOutputConsumer)diagnosticSink, (OutputFileConsumer)classesConsumer, (CanceledStatus)context.getCancelStatus(), (JavaCompilingTool)compilingTool);
            } else {
                JavaBuilder.updateCompilerUsageStatistics(context, "javac " + forkSdk.getSecond(), chunk);
                ExternalJavacManager server = JavaBuilder.ensureJavacServerStarted(context);
                CompilationPaths paths = CompilationPaths.create(platformCp, classPath, upgradeModulePath, modulePath, sourcePath);
                rc = server.forkJavac((String)forkSdk.getFirst(), Utils.suggestForkedCompilerHeapSize(), vmOptions, options, paths, files, outs, diagnosticSink, classesConsumer, compilingTool, context.getCancelStatus(), false).get();
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            counter.waitFor();
        }
    }

    private static void updateCompilerUsageStatistics(CompileContext context, String compilerName, ModuleChunk chunk) {
        Collection prev;
        ConcurrentMap map = (ConcurrentMap)COMPILER_USAGE_STATISTICS.get((UserDataHolder)context);
        Collection<String> names = (Set<String>)map.get(compilerName);
        if (names == null && (prev = (Collection)map.putIfAbsent(compilerName, names = Collections.synchronizedSet(new HashSet()))) != null) {
            names = prev;
        }
        for (JpsModule module : chunk.getModules()) {
            names.add(module.getName());
        }
    }

    @Nullable
    public static String validateCycle(CompileContext context, ModuleChunk chunk) {
        JpsJavaExtensionService javaExt = JpsJavaExtensionService.getInstance();
        JpsJavaCompilerConfiguration compilerConfig = javaExt.getCompilerConfiguration(context.getProjectDescriptor().getProject());
        assert (compilerConfig != null);
        Set<JpsModule> modules = chunk.getModules();
        Pair pair = null;
        for (JpsModule module : modules) {
            LanguageLevel moduleLevel = javaExt.getLanguageLevel(module);
            if (pair == null) {
                pair = Pair.pair((Object)module.getName(), (Object)moduleLevel);
                continue;
            }
            if (Comparing.equal((Object)pair.getSecond(), (Object)moduleLevel)) continue;
            return "Modules " + (String)pair.getFirst() + " and " + module.getName() + " must have the same language level because of cyclic dependencies between them";
        }
        JpsJavaCompilerOptions compilerOptions = compilerConfig.getCurrentCompilerOptions();
        Map overrideMap = compilerOptions.ADDITIONAL_OPTIONS_OVERRIDE;
        if (!overrideMap.isEmpty()) {
            Pair overridden = null;
            for (JpsModule module : modules) {
                String opts = (String)overrideMap.get(module.getName());
                if (!StringUtil.isEmptyOrSpaces((String)opts)) {
                    Set<String> parsed = JavaBuilder.parseOptions(opts);
                    if (overridden == null) {
                        overridden = Pair.pair((Object)module.getName(), parsed);
                        continue;
                    }
                    if (((Set)overridden.second).equals(parsed)) continue;
                    return "Modules " + (String)overridden.first + " and " + module.getName() + " must have the same 'additional command line parameters' specified because of cyclic dependencies between them";
                }
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.WARNING, "Some modules with cyclic dependencies [" + chunk.getName() + "] have 'additional command line parameters' overridden in project settings.\nThese compilation options were applied to all modules in the cycle."));
            }
        }
        for (JpsModule module : modules) {
            ProcessorConfigProfile prof = compilerConfig.getAnnotationProcessingProfile(module);
            if (!prof.isEnabled()) continue;
            return "Annotation processing is not supported for module cycles. Please ensure that all modules from cycle [" + chunk.getName() + "] are excluded from annotation processing";
        }
        return null;
    }

    private static Set<String> parseOptions(String str) {
        SmartHashSet result = new SmartHashSet();
        StringTokenizer t = new StringTokenizer(str, " \n\t", false);
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    private static boolean shouldUseReleaseOption(JpsJavaCompilerConfiguration config, int compilerVersion, int chunkSdkVersion, int targetPlatformVersion) {
        if (!config.useReleaseOption()) {
            return false;
        }
        if (compilerVersion >= 9 && chunkSdkVersion > 0 && targetPlatformVersion > 0) {
            if (chunkSdkVersion < 9) {
                return false;
            }
            return compilerVersion != targetPlatformVersion;
        }
        return false;
    }

    private static boolean shouldForkCompilerProcess(CompileContext context, ModuleChunk chunk, int chunkLanguageLevel) {
        Integer chunkSdkVersion;
        Pair<JpsSdk<JpsDummyElement>, Integer> sdkVersionPair;
        if (!JavaBuilder.isJavac((JavaCompilingTool)COMPILING_TOOL.get((UserDataHolder)context))) {
            return false;
        }
        int compilerSdkVersion = JavaVersion.current().feature;
        if (JavaBuilder.preferTargetJdkCompiler(context) && (sdkVersionPair = JavaBuilder.getAssociatedSdk(chunk)) != null && (chunkSdkVersion = (Integer)sdkVersionPair.second) != compilerSdkVersion && chunkSdkVersion >= 6) {
            return true;
        }
        if (compilerSdkVersion < 9 || chunkLanguageLevel <= 0) {
            return false;
        }
        return chunkLanguageLevel < 6 || Math.abs(compilerSdkVersion - chunkLanguageLevel) > 5;
    }

    private static boolean isJavac(JavaCompilingTool compilingTool) {
        return compilingTool != null && (compilingTool.getId() == "Javac" || compilingTool.getId() == "compAPI");
    }

    private static boolean preferTargetJdkCompiler(CompileContext context) {
        Boolean val = (Boolean)PREFER_TARGET_JDK_COMPILER.get((UserDataHolder)context);
        if (val == null) {
            JpsProject project = context.getProjectDescriptor().getProject();
            JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
            val = config != null ? config.getCompilerOptions((String)"Javac").PREFER_TARGET_JDK_COMPILER : Boolean.TRUE;
            PREFER_TARGET_JDK_COMPILER.set((UserDataHolder)context, (Object)val);
        }
        return val;
    }

    @Nullable
    private static Collection<? extends File> calcEffectivePlatformCp(Collection<? extends File> platformCp, List<String> options, JavaCompilingTool compilingTool) {
        if (ourDefaultRtJar == null || !JavaBuilder.isJavac(compilingTool)) {
            return platformCp;
        }
        boolean profileFeatureRequested = false;
        for (String option : options) {
            if (!"-profile".equalsIgnoreCase(option)) continue;
            profileFeatureRequested = true;
            break;
        }
        if (!profileFeatureRequested) {
            return platformCp;
        }
        boolean isTargetPlatformSameAsBuildRuntime = false;
        for (File file : platformCp) {
            if (!FileUtil.filesEqual((File)file, (File)ourDefaultRtJar)) continue;
            isTargetPlatformSameAsBuildRuntime = true;
            break;
        }
        if (!isTargetPlatformSameAsBuildRuntime) {
            return null;
        }
        return Collections.emptyList();
    }

    private void submitAsyncTask(CompileContext context, Runnable taskRunnable) {
        Semaphore counter = (Semaphore)COUNTER_KEY.get((UserDataHolder)context);
        assert (counter != null);
        counter.down();
        this.myTaskRunner.execute(() -> {
            try {
                taskRunnable.run();
            }
            catch (Throwable e) {
                context.processMessage(new CompilerMessage("java", e));
            }
            finally {
                counter.up();
            }
        });
    }

    @NotNull
    private static synchronized ExternalJavacManager ensureJavacServerStarted(@NotNull CompileContext context) {
        ExternalJavacManager server;
        if (context == null) {
            JavaBuilder.$$$reportNull$$$0(10);
        }
        if ((server = (ExternalJavacManager)((Object)ExternalJavacManager.KEY.get(context))) != null) {
            ExternalJavacManager externalJavacManager = server;
            if (externalJavacManager == null) {
                JavaBuilder.$$$reportNull$$$0(11);
            }
            return externalJavacManager;
        }
        int listenPort = JavaBuilder.findFreePort();
        server = new ExternalJavacManager(Utils.getSystemRoot(), (Executor)SharedThreadPool.getInstance()){

            @Override
            protected ExternalJavacManager.ExternalJavacProcessHandler createProcessHandler(UUID processId, @NotNull Process process, @NotNull String commandLine, boolean keepProcessAlive) {
                if (process == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (commandLine == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new ExternalJavacManager.ExternalJavacProcessHandler(processId, process, commandLine, keepProcessAlive){

                    @NotNull
                    public Future<?> executeTask(@NotNull Runnable task) {
                        if (task == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Future future = SharedThreadPool.getInstance().submit(task);
                        if (future == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return future;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "task";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/jps/incremental/java/JavaBuilder$2$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/jps/incremental/java/JavaBuilder$2$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "executeTask";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "executeTask";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "process";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "commandLine";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/jps/incremental/java/JavaBuilder$2";
                objectArray[2] = "createProcessHandler";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        server.start(listenPort);
        ExternalJavacManager.KEY.set(context, (Object)server);
        ExternalJavacManager externalJavacManager = server;
        if (externalJavacManager == null) {
            JavaBuilder.$$$reportNull$$$0(12);
        }
        return externalJavacManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        ServerSocket serverSocket;
        int n;
        ServerSocket serverSocket2 = new ServerSocket(0);
        try {
            n = serverSocket2.getLocalPort();
            serverSocket = serverSocket2;
        }
        catch (Throwable throwable) {
            try {
                ServerSocket serverSocket3 = serverSocket2;
                synchronized (serverSocket3) {
                    try {
                        serverSocket2.wait(1L);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                serverSocket2.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return 7878;
            }
        }
        synchronized (serverSocket) {
            try {
                serverSocket2.wait(1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        serverSocket2.close();
        return n;
    }

    private static Pair<List<String>, List<String>> getCompilationOptions(int compilerSdkVersion, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile, boolean withModules, @NotNull JavaCompilingTool compilingTool) {
        if (compilingTool == null) {
            JavaBuilder.$$$reportNull$$$0(13);
        }
        ArrayList<String> compilationOptions = new ArrayList<String>();
        ArrayList<String> vmOptions = new ArrayList<String>();
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerOptions compilerOptions = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project).getCurrentCompilerOptions();
        if (compilerOptions.DEBUGGING_INFO) {
            compilationOptions.add("-g");
        }
        if (compilerOptions.DEPRECATION) {
            compilationOptions.add("-deprecation");
        }
        if (compilerOptions.GENERATE_NO_WARNINGS) {
            compilationOptions.add("-nowarn");
        }
        if (compilerOptions instanceof EclipseCompilerOptions) {
            EclipseCompilerOptions eclipseOptions = (EclipseCompilerOptions)compilerOptions;
            if (eclipseOptions.PROCEED_ON_ERROR) {
                Utils.PROCEED_ON_ERROR_KEY.set((UserDataHolder)context, (Object)Boolean.TRUE);
                compilationOptions.add("-proceedOnError");
            }
        }
        String customArgs = compilerOptions.ADDITIONAL_OPTIONS_STRING;
        Map overrideMap = compilerOptions.ADDITIONAL_OPTIONS_OVERRIDE;
        if (!overrideMap.isEmpty()) {
            for (JpsModule m : chunk.getModules()) {
                String overridden = (String)overrideMap.get(m.getName());
                if (overridden == null) continue;
                customArgs = overridden;
                break;
            }
        }
        if (customArgs != null) {
            BiConsumer<List, String> appender = List::add;
            JpsModule module = chunk.representativeTarget().getModule();
            File baseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
            if (baseDirectory != null) {
                String moduleDirPath = FileUtil.toCanonicalPath((String)baseDirectory.getAbsolutePath());
                appender = (strings, option) -> strings.add(StringUtil.replace((String)option, (String)"$MODULE_DIR$", (String)moduleDirPath));
            }
            boolean skip = false;
            boolean targetOptionFound = false;
            for (String userOption : ParametersListUtil.parse((String)customArgs)) {
                if (FILTERED_OPTIONS.contains(userOption)) {
                    skip = true;
                    targetOptionFound = "-target".equals(userOption);
                    continue;
                }
                if (skip) {
                    skip = false;
                    if (!targetOptionFound) continue;
                    targetOptionFound = false;
                    USER_DEFINED_BYTECODE_TARGET.set((UserDataHolder)context, (Object)userOption);
                    continue;
                }
                if (FILTERED_SINGLE_OPTIONS.contains(userOption)) continue;
                if (userOption.startsWith("-J-")) {
                    vmOptions.add(userOption.substring("-J".length()));
                    continue;
                }
                appender.accept(compilationOptions, userOption);
            }
        }
        for (ExternalJavacOptionsProvider extension : JpsServiceManager.getInstance().getExtensions(ExternalJavacOptionsProvider.class)) {
            vmOptions.addAll(extension.getOptions(compilingTool));
        }
        JavaBuilder.addCompilationOptions(compilerSdkVersion, compilationOptions, context, chunk, profile, withModules);
        return Pair.pair(vmOptions, compilationOptions);
    }

    public static void addCompilationOptions(List<? super String> options, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile) {
        JavaBuilder.addCompilationOptions(JavaVersion.current().feature, options, context, chunk, profile, false);
    }

    private static void addCompilationOptions(int compilerSdkVersion, List<? super String> options, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile, boolean withModules) {
        File srcOutput;
        LanguageLevel level;
        if (!options.contains("-encoding")) {
            CompilerEncodingConfiguration config = context.getProjectDescriptor().getEncodingConfiguration();
            String encoding = config.getPreferredModuleChunkEncoding(chunk);
            if (config.getAllModuleChunkEncodings(chunk).size() > 1) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("Multiple encodings set for module chunk ").append(chunk.getName());
                if (encoding != null) {
                    msgBuilder.append("\n\"").append(encoding).append("\" will be used by compiler");
                }
                context.processMessage(new CompilerMessage("java", BuildMessage.Kind.INFO, msgBuilder.toString()));
            }
            if (!StringUtil.isEmpty((String)encoding)) {
                options.add("-encoding");
                options.add(encoding);
            }
        }
        JavaBuilder.addCrossCompilationOptions(compilerSdkVersion, options, context, chunk);
        if (!options.contains("--enable-preview") && (level = JpsJavaExtensionService.getInstance().getLanguageLevel(chunk.representativeTarget().getModule())) != null && level.isPreview()) {
            options.add("--enable-preview");
        }
        if (JavaBuilder.addAnnotationProcessingOptions(options, (AnnotationProcessingConfiguration)profile, withModules) && (srcOutput = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(chunk.getModules().iterator().next(), chunk.containsTests(), profile)) != null) {
            FileUtil.createDirectory((File)srcOutput);
            options.add("-s");
            options.add(srcOutput.getPath());
        }
    }

    public static boolean addAnnotationProcessingOptions(List<? super String> options, @Nullable AnnotationProcessingConfiguration profile, boolean withModules) {
        Set processors;
        if (profile == null || !profile.isEnabled()) {
            options.add("-proc:none");
            return false;
        }
        if (!profile.isObtainProcessorsFromClasspath()) {
            String processorsPath = profile.getProcessorPath();
            options.add(withModules ? "--processor-module-path" : "-processorpath");
            options.add(FileUtil.toSystemDependentName((String)processorsPath.trim()));
        }
        if (!(processors = profile.getProcessors()).isEmpty()) {
            options.add("-processor");
            options.add(StringUtil.join((Collection)processors, (String)","));
        }
        for (Map.Entry optionEntry : profile.getProcessorOptions().entrySet()) {
            options.add("-A" + (String)optionEntry.getKey() + "=" + (String)optionEntry.getValue());
        }
        return true;
    }

    @NotNull
    public static String getUsedCompilerId(CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
        String string = config == null ? "Javac" : config.getJavaCompilerId();
        if (string == null) {
            JavaBuilder.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static void addCrossCompilationOptions(int compilerSdkVersion, List<? super String> options, CompileContext context, ModuleChunk chunk) {
        int bytecodeTarget;
        JpsJavaCompilerConfiguration compilerConfiguration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(context.getProjectDescriptor().getProject());
        int languageLevel = JavaBuilder.getLanguageLevel(chunk.representativeTarget().getModule());
        int chunkSdkVersion = JavaBuilder.getChunkSdkVersion(chunk);
        if (JavaBuilder.shouldUseReleaseOption(compilerConfiguration, compilerSdkVersion, chunkSdkVersion, bytecodeTarget = JavaBuilder.getModuleBytecodeTarget(context, chunk, compilerConfiguration, languageLevel))) {
            options.add("--release");
            options.add(JavaBuilder.complianceOption(bytecodeTarget));
            return;
        }
        if (languageLevel > 0) {
            options.add("-source");
            options.add(JavaBuilder.complianceOption(languageLevel));
        }
        if (bytecodeTarget > 0) {
            if (chunkSdkVersion > 0 && compilerSdkVersion > chunkSdkVersion && compilerSdkVersion >= bytecodeTarget && bytecodeTarget > chunkSdkVersion) {
                bytecodeTarget = chunkSdkVersion;
            }
        } else if (chunkSdkVersion > 0 && compilerSdkVersion > chunkSdkVersion) {
            bytecodeTarget = chunkSdkVersion;
        }
        if (bytecodeTarget > 0) {
            options.add("-target");
            options.add(JavaBuilder.complianceOption(bytecodeTarget));
        }
    }

    public static int getModuleBytecodeTarget(CompileContext context, ModuleChunk chunk, JpsJavaCompilerConfiguration compilerConfiguration) {
        return JavaBuilder.getModuleBytecodeTarget(context, chunk, compilerConfiguration, JavaBuilder.getLanguageLevel(chunk.representativeTarget().getModule()));
    }

    private static int getModuleBytecodeTarget(CompileContext context, ModuleChunk chunk, JpsJavaCompilerConfiguration compilerConfiguration, int languageLevel) {
        int bytecodeTarget = 0;
        for (JpsModule module : chunk.getModules()) {
            int moduleTarget = JpsJavaSdkType.parseVersion((String)compilerConfiguration.getByteCodeTargetLevel(module.getName()));
            if (moduleTarget <= 0 || bytecodeTarget != 0 && moduleTarget >= bytecodeTarget) continue;
            bytecodeTarget = moduleTarget;
        }
        if (bytecodeTarget == 0) {
            if (languageLevel > 0) {
                bytecodeTarget = languageLevel;
            } else {
                String value = (String)USER_DEFINED_BYTECODE_TARGET.get((UserDataHolder)context);
                if (value != null) {
                    bytecodeTarget = JpsJavaSdkType.parseVersion((String)value);
                }
            }
        }
        return bytecodeTarget;
    }

    private static String complianceOption(int major) {
        return JpsJavaSdkType.complianceOption((JavaVersion)JavaVersion.compose((int)major));
    }

    private static int getLanguageLevel(@NotNull JpsModule module) {
        LanguageLevel level;
        if (module == null) {
            JavaBuilder.$$$reportNull$$$0(15);
        }
        return (level = JpsJavaExtensionService.getInstance().getLanguageLevel(module)) != null ? level.toJavaVersion().feature : 0;
    }

    private static int getTargetPlatformLanguageVersion(@NotNull JpsModule module) {
        int level;
        if (module == null) {
            JavaBuilder.$$$reportNull$$$0(16);
        }
        if ((level = JavaBuilder.getLanguageLevel(module)) > 0) {
            return level;
        }
        JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
        if (sdk != null) {
            return JpsJavaSdkType.getJavaVersion((JpsSdk)sdk);
        }
        return 0;
    }

    private static int getChunkSdkVersion(ModuleChunk chunk) {
        int chunkSdkVersion = -1;
        for (JpsModule module : chunk.getModules()) {
            int moduleSdkVersion;
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
            if (sdk == null || (moduleSdkVersion = JpsJavaSdkType.getJavaVersion((JpsSdk)sdk)) == 0 || chunkSdkVersion >= 0 && chunkSdkVersion <= moduleSdkVersion) continue;
            chunkSdkVersion = moduleSdkVersion;
        }
        return chunkSdkVersion;
    }

    @Nullable
    private static Pair<String, Integer> getForkedJavacSdk(ModuleChunk chunk, int targetLanguageLevel) {
        int sdkVersion;
        Pair<JpsSdk<JpsDummyElement>, Integer> sdkVersionPair = JavaBuilder.getAssociatedSdk(chunk);
        if (sdkVersionPair != null && (sdkVersion = ((Integer)sdkVersionPair.second).intValue()) >= 6 && (sdkVersion < 9 || Math.abs(sdkVersion - targetLanguageLevel) <= 5)) {
            return Pair.pair((Object)((JpsSdk)sdkVersionPair.first).getHomePath(), (Object)sdkVersion);
        }
        String fallbackJdkHome = System.getProperty("jps.fallback.jdk.home", null);
        if (fallbackJdkHome == null) {
            LOG.info("Fallback JDK is not specified. (See jps.fallback.jdk.home option)");
            return null;
        }
        String fallbackJdkVersion = System.getProperty("jps.fallback.jdk.version", null);
        if (fallbackJdkVersion == null) {
            LOG.info("Fallback JDK version is not specified. (See jps.fallback.jdk.version option)");
            return null;
        }
        int fallbackVersion = JpsJavaSdkType.parseVersion((String)fallbackJdkVersion);
        if (fallbackVersion < 6) {
            LOG.info("Version string for fallback JDK is '" + fallbackJdkVersion + "' (recognized as version '" + fallbackVersion + "'). At least version 6 is required.");
            return null;
        }
        return Pair.pair((Object)fallbackJdkHome, (Object)fallbackVersion);
    }

    @Nullable
    private static Pair<JpsSdk<JpsDummyElement>, Integer> getAssociatedSdk(ModuleChunk chunk) {
        JpsSdk sdk = chunk.representativeTarget().getModule().getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
        return sdk != null ? Pair.pair((Object)sdk, (Object)JpsJavaSdkType.getJavaVersion((JpsSdk)sdk)) : null;
    }

    @Override
    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        JavaBuilderUtil.cleanupChunkResources(context);
    }

    private static Map<File, Set<File>> buildOutputDirectoriesMap(CompileContext context, ModuleChunk chunk) {
        THashMap map = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File outputDir = target.getOutputDir();
            if (outputDir == null) continue;
            THashSet roots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (JavaSourceRootDescriptor descriptor : context.getProjectDescriptor().getBuildRootIndex().getTargetRoots(target, context)) {
                roots.add(descriptor.root);
            }
            map.put(outputDir, roots);
        }
        return map;
    }

    @Override
    public long getExpectedBuildTime() {
        return 100L;
    }

    private static /* synthetic */ boolean lambda$doBuild$0(Set filesToCompile, ModuleBuildTarget target, File file, JavaSourceRootDescriptor descriptor) throws IOException {
        if (JAVA_SOURCES_FILTER.accept(file) && ourCompilableModuleTypes.contains(target.getModule().getModuleType())) {
            filesToCompile.add(file);
        }
        return true;
    }

    static {
        for (JavaBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(JavaBuilderExtension.class)) {
            ourCompilableModuleTypes.addAll(extension.getCompilableModuleTypes());
        }
        File rtJar = null;
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("sun.boot.class.path", ""), File.pathSeparator, false);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            if (!"rt.jar".equals(file.getName())) continue;
            rtJar = file;
            break;
        }
        ourDefaultRtJar = rtJar;
        USER_DEFINED_BYTECODE_TARGET = Key.create((String)"_user_defined_bytecode_target_");
        COUNTER_KEY = Key.create((String)"_async_task_counter_");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/java/JavaBuilder";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyFilesHolder";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilingTool";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/java/JavaBuilder";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureJavacServerStarted";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedCompilerId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureJavacServerStarted";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCompilationOptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPlatformLanguageVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ClassProcessingConsumer
    implements OutputFileConsumer {
        private final CompileContext myContext;
        private final OutputFileConsumer myDelegateOutputFileSink;

        private ClassProcessingConsumer(CompileContext context, OutputFileConsumer sink) {
            this.myContext = context;
            this.myDelegateOutputFileSink = sink != null ? sink : fileObject -> {
                throw new RuntimeException("Output sink for compiler was not specified");
            };
        }

        public void save(@NotNull OutputFileObject fileObject) {
            if (fileObject == null) {
                ClassProcessingConsumer.$$$reportNull$$$0(0);
            }
            try {
                BinaryContent content = fileObject.getContent();
                File file = fileObject.getFile();
                if (content != null) {
                    content.saveToFile(file);
                } else {
                    this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.WARNING, "Missing content for file " + file.getPath()));
                }
            }
            catch (IOException e) {
                this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, e.getMessage()));
            }
            JavaBuilder.this.submitAsyncTask(this.myContext, () -> {
                try {
                    for (ClassPostProcessor processor : ourClassProcessors) {
                        processor.process(this.myContext, fileObject);
                    }
                }
                finally {
                    this.myDelegateOutputFileSink.save(fileObject);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "org/jetbrains/jps/incremental/java/JavaBuilder$ClassProcessingConsumer", "save"));
        }
    }

    private static class DiagnosticSink
    implements DiagnosticOutputConsumer {
        private final CompileContext myContext;
        private volatile int myErrorCount;
        private volatile int myWarningCount;
        private final Set<File> myFilesWithErrors;
        @NotNull
        private final Collection<? extends JavacFileReferencesRegistrar> myRegistrars;

        private DiagnosticSink(CompileContext context, @NotNull Collection<? extends JavacFileReferencesRegistrar> refRegistrars) {
            if (refRegistrars == null) {
                DiagnosticSink.$$$reportNull$$$0(0);
            }
            this.myFilesWithErrors = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            this.myContext = context;
            this.myRegistrars = refRegistrars;
        }

        public void javaFileLoaded(File file) {
        }

        public void registerJavacFileData(JavacFileData data) {
            for (JavacFileReferencesRegistrar javacFileReferencesRegistrar : this.myRegistrars) {
                javacFileReferencesRegistrar.registerFile(this.myContext, data.getFilePath(), (TObjectIntHashMap<? extends JavacRef>)(javacFileReferencesRegistrar.onlyImports() ? data.getImportRefs() : data.getRefs()), data.getDefs(), data.getCasts(), data.getImplicitToStringRefs());
            }
        }

        public void customOutputData(String pluginId, String dataName, byte[] data) {
            if ("ast.reference.collector".equals(pluginId) && "JavacFileData".equals(dataName)) {
                this.registerJavacFileData(JavacFileData.fromBytes((byte[])data));
            } else {
                for (CustomOutputDataListener listener : JpsServiceManager.getInstance().getExtensions(CustomOutputDataListener.class)) {
                    if (!pluginId.equals(listener.getId())) continue;
                    listener.processData(this.myContext, dataName, data);
                    return;
                }
            }
        }

        public void outputLineAvailable(String line) {
            if (!StringUtil.isEmpty((String)line)) {
                if (line.startsWith("JAVAC_PROCESS[STDOUT]")) {
                    System.out.println(line);
                } else if (line.startsWith("JAVAC_PROCESS[STDERR]")) {
                    System.err.println(line);
                } else if (line.contains("java.lang.OutOfMemoryError")) {
                    this.myContext.processMessage(new CompilerMessage("java", BuildMessage.Kind.ERROR, "OutOfMemoryError: insufficient memory"));
                    ++this.myErrorCount;
                } else {
                    BuildMessage.Kind kind = DiagnosticSink.getKindByMessageText(line);
                    if (kind == BuildMessage.Kind.ERROR) {
                        ++this.myErrorCount;
                    } else if (kind == BuildMessage.Kind.WARNING) {
                        ++this.myWarningCount;
                    }
                    this.myContext.processMessage(new CompilerMessage("java", kind, line));
                }
            }
        }

        private static BuildMessage.Kind getKindByMessageText(String line) {
            String lowercasedLine = StringUtil.toLowerCase((String)line);
            if (lowercasedLine.contains("error") || lowercasedLine.contains("requires target release")) {
                return BuildMessage.Kind.ERROR;
            }
            return BuildMessage.Kind.INFO;
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            String srcPath;
            BuildMessage.Kind kind;
            switch (diagnostic.getKind()) {
                case ERROR: {
                    kind = BuildMessage.Kind.ERROR;
                    ++this.myErrorCount;
                    break;
                }
                case MANDATORY_WARNING: 
                case WARNING: {
                    kind = BuildMessage.Kind.WARNING;
                    ++this.myWarningCount;
                    break;
                }
                case NOTE: {
                    kind = BuildMessage.Kind.INFO;
                    break;
                }
                case OTHER: {
                    kind = diagnostic instanceof JpsInfoDiagnostic ? BuildMessage.Kind.JPS_INFO : BuildMessage.Kind.OTHER;
                    break;
                }
                default: {
                    kind = BuildMessage.Kind.OTHER;
                }
            }
            File sourceFile = null;
            try {
                JavaFileObject source = diagnostic.getSource();
                sourceFile = source != null ? PathUtils.convertToFile((URI)source.toUri()) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
            if (sourceFile != null) {
                if (kind == BuildMessage.Kind.ERROR) {
                    this.myFilesWithErrors.add(sourceFile);
                }
                srcPath = FileUtil.toSystemIndependentName((String)sourceFile.getPath());
            } else {
                srcPath = null;
            }
            String message = diagnostic.getMessage(Locale.US);
            if (Utils.IS_TEST_MODE) {
                LOG.info(message);
            }
            CompilerMessage compilerMsg = new CompilerMessage("java", kind, message, srcPath, diagnostic.getStartPosition(), diagnostic.getEndPosition(), diagnostic.getPosition(), diagnostic.getLineNumber(), diagnostic.getColumnNumber());
            if (LOG.isDebugEnabled()) {
                LOG.debug(compilerMsg.toString());
            }
            this.myContext.processMessage(compilerMsg);
        }

        int getErrorCount() {
            return this.myErrorCount;
        }

        int getWarningCount() {
            return this.myWarningCount;
        }

        @NotNull
        Collection<File> getFilesWithErrors() {
            Set<File> set = this.myFilesWithErrors;
            if (set == null) {
                DiagnosticSink.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refRegistrars";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/incremental/java/JavaBuilder$DiagnosticSink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/incremental/java/JavaBuilder$DiagnosticSink";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesWithErrors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

