/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacFileReferencesRegistrar;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public class ImportReferencesRegistrar
implements JavacFileReferencesRegistrar {
    @Override
    public void initialize() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean onlyImports() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerFile(CompileContext context, String filePath, TObjectIntHashMap<? extends JavacRef> refs, Collection<? extends JavacDef> defs, Collection<? extends JavacTypeCast> casts, Collection<? extends JavacRef> implicitToString) {
        void var11_13;
        if (refs.isEmpty() || defs.isEmpty()) {
            return;
        }
        HashSet<String> classImports = new HashSet<String>();
        HashSet<String> staticImports = new HashSet<String>();
        Object[] objectArray = refs.keys();
        int n = objectArray.length;
        boolean bl = false;
        while (var11_13 < n) {
            Object key = objectArray[var11_13];
            JavacRef ref = (JavacRef)key;
            if (ref instanceof JavacRef.JavacClass) {
                classImports.add(ref.getName());
                JavacRef.ImportProperties props = ref.getImportProperties();
                if (props != null && props.isStatic() && props.isOnDemand()) {
                    staticImports.add(ref.getName() + ".*");
                }
            } else if (ref instanceof JavacRef.JavacField || ref instanceof JavacRef.JavacMethod) {
                staticImports.add(ref.getOwnerName() + "." + ref.getName());
            }
            ++var11_13;
        }
        ArrayList<String> definedClasses = new ArrayList<String>();
        for (JavacDef javacDef : defs) {
            JavacRef element;
            if (!(javacDef instanceof JavacDef.JavacClassDef) || !((element = javacDef.getDefinedElement()) instanceof JavacRef.JavacClass)) continue;
            definedClasses.add(element.getName());
        }
        if (!(definedClasses.isEmpty() || classImports.isEmpty() && staticImports.isEmpty())) {
            Callbacks.Backend deps = JavaBuilderUtil.getDependenciesRegistrar(context);
            for (String aClass : definedClasses) {
                deps.registerImports(aClass, classImports, staticImports);
            }
        }
    }
}

