/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class CompilerReferenceIndex<Input> {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceIndex.class);
    private static final String FILE_ENUM_TAB = "file.path.enum.tab";
    private static final String NAME_ENUM_TAB = "name.tab";
    private static final String VERSION_FILE = "version";
    private final ConcurrentMap<IndexId<?, ?>, InvertedIndex<?, ?, Input>> myIndices;
    private final NameEnumerator myNameEnumerator;
    private final PersistentStringEnumerator myFilePathEnumerator;
    private final File myBuildDir;
    private final File myIndicesDir;
    private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameEnumerator nameEnumerator = CompilerReferenceIndex.this.myNameEnumerator;
            synchronized (nameEnumerator) {
                if (!CompilerReferenceIndex.this.myNameEnumerator.isClosed()) {
                    CompilerReferenceIndex.this.myNameEnumerator.force();
                }
            }
            nameEnumerator = CompilerReferenceIndex.this.myFilePathEnumerator;
            synchronized (nameEnumerator) {
                if (!CompilerReferenceIndex.this.myFilePathEnumerator.isClosed()) {
                    CompilerReferenceIndex.this.myFilePathEnumerator.force();
                }
            }
        }
    });
    private volatile Throwable myRebuildRequestCause;

    public CompilerReferenceIndex(Collection<? extends IndexExtension<?, ?, ? super Input>> indices, File buildDir, boolean readOnly, int version) {
        this.myBuildDir = buildDir;
        this.myIndicesDir = CompilerReferenceIndex.getIndexDir(buildDir);
        if (!this.myIndicesDir.exists() && !this.myIndicesDir.mkdirs()) {
            throw new RuntimeException("Can't create dir: " + buildDir.getAbsolutePath());
        }
        try {
            if (CompilerReferenceIndex.versionDiffers(buildDir, version)) {
                this.saveVersion(buildDir, version);
            }
            this.myFilePathEnumerator = new PersistentStringEnumerator(new File(this.myIndicesDir, FILE_ENUM_TAB)){

                public int enumerate(String value) throws IOException {
                    return super.enumerate(SystemInfo.isFileSystemCaseSensitive ? value : StringUtil.toLowerCase((String)value));
                }
            };
            this.myIndices = new ConcurrentHashMap();
            for (IndexExtension<?, ?, Input> indexExtension : indices) {
                this.myIndices.put((IndexId<?, ?>)indexExtension.getName(), (InvertedIndex<?, ?, Input>)new CompilerMapReduceIndex(indexExtension, this.myIndicesDir, readOnly));
            }
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                for (IndexId id : this.myIndices.keySet()) {
                    System.err.println("Leaked javac compiler index \"" + id.getName() + "\"");
                }
            });
            this.myNameEnumerator = new NameEnumerator(new File(this.myIndicesDir, NAME_ENUM_TAB));
        }
        catch (IOException e) {
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir, e);
            throw new BuildDataCorruptedException(e);
        }
    }

    public Collection<InvertedIndex<?, ?, Input>> getIndices() {
        return this.myIndices.values();
    }

    public <K, V> InvertedIndex<K, V, Input> get(IndexId<K, V> key) {
        return (InvertedIndex)this.myIndices.get(key);
    }

    @NotNull
    public NameEnumerator getByteSeqEum() {
        NameEnumerator nameEnumerator = this.myNameEnumerator;
        if (nameEnumerator == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(0);
        }
        return nameEnumerator;
    }

    @NotNull
    public PersistentStringEnumerator getFilePathEnumerator() {
        PersistentStringEnumerator persistentStringEnumerator = this.myFilePathEnumerator;
        if (persistentStringEnumerator == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(1);
        }
        return persistentStringEnumerator;
    }

    public void close() {
        this.myLowMemoryWatcher.stop();
        CommonProcessors.FindFirstProcessor<Exception> exceptionProc = new CommonProcessors.FindFirstProcessor<Exception>(){

            public boolean process(Exception e) {
                LOG.error((Throwable)e);
                return super.process((Object)e);
            }
        };
        CompilerReferenceIndex.close((Closeable)this.myFilePathEnumerator, (Processor<? super Exception>)exceptionProc);
        CompilerReferenceIndex.close((Closeable)((Object)this.myNameEnumerator), (Processor<? super Exception>)exceptionProc);
        Iterator iterator = this.myIndices.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry index = iterator.next();
            CompilerReferenceIndex.close((InvertedIndex)index.getValue(), (CommonProcessors.FindFirstProcessor<? super Exception>)exceptionProc);
            iterator.remove();
        }
        Exception exception = (Exception)exceptionProc.getFoundValue();
        if (exception != null) {
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir, exception);
            if (this.myRebuildRequestCause == null) {
                throw new RuntimeException(exception);
            }
            return;
        }
        if (this.myRebuildRequestCause != null) {
            CompilerReferenceIndex.removeIndexFiles(this.myBuildDir, this.myRebuildRequestCause);
        }
    }

    public static void removeIndexFiles(File buildDir) {
        CompilerReferenceIndex.removeIndexFiles(buildDir, null);
    }

    public static void removeIndexFiles(File buildDir, Throwable cause) {
        File indexDir = CompilerReferenceIndex.getIndexDir(buildDir);
        if (indexDir.exists()) {
            FileUtil.delete((File)indexDir);
            LOG.info("backward reference index deleted", cause != null ? cause : new Exception());
        }
    }

    private static File getIndexDir(@NotNull File buildDir) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(2);
        }
        return new File(buildDir, "backward-refs");
    }

    public static boolean exists(@NotNull File buildDir) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(3);
        }
        return CompilerReferenceIndex.getIndexDir(buildDir).exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean versionDiffers(@NotNull File buildDir, int expectedVersion) {
        File versionFile;
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(4);
        }
        if (!(versionFile = new File(CompilerReferenceIndex.getIndexDir(buildDir), VERSION_FILE)).exists()) {
            LOG.info("backward reference index version doesn't exist");
            return true;
        }
        try (DataInputStream is = new DataInputStream(new FileInputStream(versionFile));){
            boolean isDiffer;
            int currentIndexVersion = is.readInt();
            boolean bl = isDiffer = currentIndexVersion != expectedVersion;
            if (isDiffer) {
                LOG.info("backward reference index version differ, expected = " + expectedVersion + ", current = " + currentIndexVersion);
            }
            boolean bl2 = isDiffer;
            return bl2;
        }
        catch (IOException e) {
            LOG.info("backward reference index version differ due to: " + e.getClass());
            return true;
        }
    }

    public void saveVersion(@NotNull File buildDir, int version) {
        if (buildDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(5);
        }
        File versionFile = new File(CompilerReferenceIndex.getIndexDir(buildDir), VERSION_FILE);
        FileUtil.createIfDoesntExist((File)versionFile);
        try (DataOutputStream os = new DataOutputStream(new FileOutputStream(versionFile));){
            os.writeInt(version);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
            throw new BuildDataCorruptedException(ex);
        }
    }

    public Throwable getRebuildRequestCause() {
        return this.myRebuildRequestCause;
    }

    public File getIndicesDir() {
        return this.myIndicesDir;
    }

    public void setRebuildRequestCause(Throwable e) {
        this.myRebuildRequestCause = e;
        LOG.error(e);
    }

    private static void close(InvertedIndex<?, ?, ?> index, CommonProcessors.FindFirstProcessor<? super Exception> exceptionProcessor) {
        try {
            index.dispose();
        }
        catch (Exception e) {
            exceptionProcessor.process((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Closeable closeable, Processor<? super Exception> exceptionProcessor) {
        Closeable closeable2 = closeable;
        synchronized (closeable2) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                exceptionProcessor.process((Object)new BuildDataCorruptedException(e));
            }
            catch (Exception e) {
                exceptionProcessor.process((Object)e);
            }
        }
    }

    private static <Key, Value> IndexStorage<Key, Value> createIndexStorage(@NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, @NotNull IndexId<Key, Value> indexId, @NotNull File indexDir, boolean readOnly) throws IOException {
        if (keyDescriptor == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(6);
        }
        if (valueExternalizer == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(7);
        }
        if (indexId == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(8);
        }
        if (indexDir == null) {
            CompilerReferenceIndex.$$$reportNull$$$0(9);
        }
        return new MapIndexStorage<Key, Value>(new File(indexDir, indexId.getName()), keyDescriptor, valueExternalizer, 16384, false, true, readOnly){

            public void checkCanceled() {
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/backwardRefs/index/CompilerReferenceIndex";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteSeqEum";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathEnumerator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/CompilerReferenceIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "versionDiffers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveVersion";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createIndexStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class CompilerMapReduceIndex<Key, Value>
    extends MapReduceIndex<Key, Value, Input> {
        CompilerMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, File indexDir, boolean readOnly) throws IOException {
            if (extension == null) {
                CompilerMapReduceIndex.$$$reportNull$$$0(0);
            }
            if (indexDir == null) {
                CompilerMapReduceIndex.$$$reportNull$$$0(1);
            }
            super(extension, CompilerReferenceIndex.createIndexStorage(extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getName(), indexDir, readOnly), (ForwardIndex)(readOnly ? null : new PersistentMapBasedForwardIndex(new File(indexDir, extension.getName().getName() + ".inputs"))), (ForwardIndexAccessor)(readOnly ? null : new KeyCollectionForwardIndexAccessor(extension)));
        }

        public void checkCanceled() {
        }

        protected void requestRebuild(@NotNull Throwable e) {
            if (e == null) {
                CompilerMapReduceIndex.$$$reportNull$$$0(2);
            }
            CompilerReferenceIndex.this.setRebuildRequestCause(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexDir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/CompilerReferenceIndex$CompilerMapReduceIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestRebuild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

