/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public interface CompilerRef
extends RW.Savable {
    public static final CompilerRef[] EMPTY_ARRAY = new CompilerRef[0];
    public static final byte CLASS_MARKER = 0;
    public static final byte METHOD_MARKER = 1;
    public static final byte FIELD_MARKER = 2;
    public static final byte FUN_EXPR_MARKER = 3;
    public static final byte ANONYMOUS_CLASS_MARKER = 4;

    public CompilerRef override(int var1);

    public static class JavaCompilerFunExprDef
    implements CompilerFunExprDef {
        private final int myId;

        public JavaCompilerFunExprDef(int id) {
            this.myId = id;
        }

        @Override
        public int getId() {
            return this.myId;
        }

        @Override
        public CompilerRef override(int newOwner) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(3);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getId());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaCompilerFunExprDef funExprDef = (JavaCompilerFunExprDef)o;
            return this.myId == funExprDef.myId;
        }

        public int hashCode() {
            return this.myId;
        }
    }

    public static class JavaCompilerClassRef
    implements CompilerClassHierarchyElementDef {
        private final int myName;

        public JavaCompilerClassRef(int name) {
            this.myName = name;
        }

        @Override
        public int getName() {
            return this.myName;
        }

        @Override
        public CompilerRef override(int newOwner) {
            return new JavaCompilerClassRef(newOwner);
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(0);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getName());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaCompilerClassRef classRef = (JavaCompilerClassRef)o;
            return this.myName == classRef.myName;
        }

        public int hashCode() {
            return this.myName;
        }
    }

    public static class JavaCompilerAnonymousClassRef
    implements CompilerAnonymousClassDef {
        private final int myName;

        public JavaCompilerAnonymousClassRef(int name) {
            this.myName = name;
        }

        @Override
        public CompilerRef override(int newOwner) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getName() {
            return this.myName;
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(4);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getName());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaCompilerAnonymousClassRef ref = (JavaCompilerAnonymousClassRef)o;
            return this.myName == ref.myName;
        }

        public int hashCode() {
            return this.myName;
        }
    }

    public static class JavaCompilerFieldRef
    implements CompilerMember {
        private final int myOwner;
        private final int myName;

        public JavaCompilerFieldRef(int owner, int name) {
            this.myOwner = owner;
            this.myName = name;
        }

        @Override
        public int getName() {
            return this.myName;
        }

        @Override
        public CompilerRef override(int newOwner) {
            return new JavaCompilerFieldRef(newOwner, this.myName);
        }

        @Override
        @NotNull
        public CompilerClassHierarchyElementDef getOwner() {
            JavaCompilerClassRef javaCompilerClassRef = new JavaCompilerClassRef(this.myOwner);
            if (javaCompilerClassRef == null) {
                JavaCompilerFieldRef.$$$reportNull$$$0(0);
            }
            return javaCompilerClassRef;
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(2);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOwner);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getName());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaCompilerFieldRef fieldRef = (JavaCompilerFieldRef)o;
            if (this.myOwner != fieldRef.myOwner) {
                return false;
            }
            return this.myName == fieldRef.myName;
        }

        public int hashCode() {
            return this.myName + 31 * this.myOwner;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/CompilerRef$JavaCompilerFieldRef", "getOwner"));
        }
    }

    public static class JavaCompilerMethodRef
    implements CompilerMember {
        private final int myOwner;
        private final int myName;
        private final int myParameterCount;

        public JavaCompilerMethodRef(int owner, int name, int parameterCount) {
            this.myOwner = owner;
            this.myName = name;
            this.myParameterCount = parameterCount;
        }

        @Override
        public int getName() {
            return this.myName;
        }

        @Override
        public CompilerRef override(int newOwner) {
            return new JavaCompilerMethodRef(newOwner, this.myName, this.myParameterCount);
        }

        public int getParameterCount() {
            return this.myParameterCount;
        }

        @Override
        @NotNull
        public CompilerClassHierarchyElementDef getOwner() {
            JavaCompilerClassRef javaCompilerClassRef = new JavaCompilerClassRef(this.myOwner);
            if (javaCompilerClassRef == null) {
                JavaCompilerMethodRef.$$$reportNull$$$0(0);
            }
            return javaCompilerClassRef;
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(1);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOwner);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getName());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.getParameterCount());
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaCompilerMethodRef methodRef = (JavaCompilerMethodRef)o;
            if (this.myOwner != methodRef.myOwner) {
                return false;
            }
            if (this.myName != methodRef.myName) {
                return false;
            }
            return this.myParameterCount == methodRef.myParameterCount;
        }

        public int hashCode() {
            int result = this.myName;
            result = 31 * result + this.myParameterCount;
            result = 31 * result + this.myOwner;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/CompilerRef$JavaCompilerMethodRef", "getOwner"));
        }
    }

    public static interface CompilerMember
    extends NamedCompilerRef {
        @NotNull
        public CompilerClassHierarchyElementDef getOwner();
    }

    public static interface CompilerFunExprDef
    extends CompilerRef {
        public int getId();
    }

    public static interface CompilerAnonymousClassDef
    extends CompilerClassHierarchyElementDef {
    }

    public static interface CompilerClassHierarchyElementDef
    extends NamedCompilerRef {
        public static final CompilerClassHierarchyElementDef[] EMPTY_ARRAY = new CompilerClassHierarchyElementDef[0];
    }

    public static interface NamedCompilerRef
    extends CompilerRef {
        public static final NamedCompilerRef[] EMPTY_ARRAY = new NamedCompilerRef[0];

        public int getName();
    }
}

