/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "anonymizeGradleVersion", "", "version", "Lorg/gradle/util/GradleVersion;", "getGroupId", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.gradle.common"})
public final class GradleSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.gradle.state";
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings gradleSettings2 = gradleSettings;
        Collection collection = gradleSettings2.getLinkedProjectsSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"gradleSettings.linkedProjectsSettings");
        Collection projectsSettings = collection;
        if (projectsSettings.isEmpty()) {
            return SetsKt.emptySet();
        }
        boolean bl = false;
        Set usages = new LinkedHashSet();
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasGradleProject", (boolean)true));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"offlineWork", (boolean)gradleSettings2.isOfflineWork()));
        CharSequence charSequence = gradleSettings2.getServiceDirectoryPath();
        String string = "hasCustomServiceDirectoryPath";
        Set set = usages;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        set.add(MetricEventFactoryKt.newBooleanMetric((String)string, (!bl4 ? 1 : 0) != 0));
        charSequence = gradleSettings2.getGradleVmOptions();
        string = "hasCustomGradleVmOptions";
        set = usages;
        bl2 = false;
        bl3 = false;
        bl4 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        set.add(MetricEventFactoryKt.newBooleanMetric((String)string, (!bl4 ? 1 : 0) != 0));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"showSelectiveImportDialogOnInitialImport", (boolean)gradleSettings2.showSelectiveImportDialogOnInitialImport()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"storeProjectFilesExternally", (boolean)gradleSettings2.getStoreProjectFilesExternally()));
        Iterator iterator = gradleSettings2.getLinkedProjectsSettings().iterator();
        while (iterator.hasNext()) {
            GradleVersion gradleVersion;
            GradleProjectSettings setting;
            GradleProjectSettings gradleProjectSettings = setting = (GradleProjectSettings)((Object)iterator.next());
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleProjectSettings), (String)"setting");
            String projectPath = gradleProjectSettings.getExternalProjectPath();
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"isUseQualifiedModuleNames", (boolean)setting.isUseQualifiedModuleNames()));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"createModulePerSourceSet", (boolean)setting.isResolveModulePerSourceSet()));
            usages.add(MetricEventFactoryKt.newMetric((String)"distributionType", (Enum)setting.getDistributionType()));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"isCompositeBuilds", (setting.getCompositeBuild() != null ? 1 : 0) != 0));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"disableWrapperSourceDistributionNotification", (boolean)setting.isDisableWrapperSourceDistributionNotification()));
            usages.add(ExternalSystemUsagesCollector.Companion.getJRETypeUsage("gradleJvmType", setting.getGradleJvm()));
            usages.add(ExternalSystemUsagesCollector.Companion.getJREVersionUsage(project, "gradleJvmVersion", setting.getGradleJvm()));
            Intrinsics.checkExpressionValueIsNotNull((Object)setting.resolveGradleVersion(), (String)"setting.resolveGradleVersion()");
            if (gradleVersion.isSnapshot()) {
                StringBuilder stringBuilder = new StringBuilder();
                GradleVersion gradleVersion2 = gradleVersion.getBaseVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion2, (String)"gradleVersion.baseVersion");
                usages.add(MetricEventFactoryKt.newMetric((String)"gradleVersion", (String)stringBuilder.append(this.anonymizeGradleVersion(gradleVersion2)).append(".SNAPSHOT").toString()));
            } else {
                usages.add(MetricEventFactoryKt.newMetric((String)"gradleVersion", (String)this.anonymizeGradleVersion(gradleVersion)));
            }
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"delegateBuildRun", (boolean)GradleProjectSettings.isDelegatedBuildEnabled(project, projectPath)));
            usages.add(MetricEventFactoryKt.newMetric((String)"preferredTestRunner", (Enum)GradleProjectSettings.getTestRunner(project, projectPath)));
        }
        return usages;
    }

    private final String anonymizeGradleVersion(GradleVersion version) {
        Object object = Version.parseVersion((String)version.getVersion());
        if (object == null || (object = object.toCompactString()) == null) {
            object = "unknown";
        }
        return object;
    }
}

