/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.startup;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u00012\u00020\u0002:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleUnlinkedProjectProcessor;", "Lcom/intellij/openapi/startup/StartupActivity;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.gradle.common"})
public final class GradleUnlinkedProjectProcessor
implements StartupActivity,
DumbAware {
    private static final String SHOW_UNLINKED_GRADLE_POPUP = "show.inlinked.gradle.project.popup";
    public static final Companion Companion = new Companion(null);

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (GradleUnlinkedProjectProcessor.Companion.isEnabledNotifications(project)) {
            GradleUnlinkedProjectProcessor.Companion.showNotification(project);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleUnlinkedProjectProcessor$Companion;", "", "()V", "SHOW_UNLINKED_GRADLE_POPUP", "", "disableNotifications", "", "project", "Lcom/intellij/openapi/project/Project;", "enableNotifications", "isEnabledNotifications", "", "showNotification", "intellij.gradle.common"})
    public static final class Companion {
        private final void showNotification(Project project) {
            GradleSettings gradleSettings = GradleSettings.getInstance(project);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
            if (!gradleSettings.getLinkedProjectsSettings().isEmpty()) {
                return;
            }
            if ((Boolean)project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE) {
                return;
            }
            String string = project.getBasePath();
            if (string == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.basePath ?: return");
            String externalProjectPath = string;
            String gradleGroovyDslFile = externalProjectPath + "/" + "build.gradle";
            String kotlinDslGradleFile = externalProjectPath + "/" + "build.gradle.kts";
            if (FileUtil.findFirstThatExist((String[])new String[]{gradleGroovyDslFile, kotlinDslGradleFile}) == null) {
                return;
            }
            Object[] objectArray = new Object[1];
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            objectArray[0] = applicationNamesInfo.getFullProductName();
            Notification notification2 = GradleNotification.NOTIFICATION_GROUP.createNotification(GradleBundle.message("gradle.notifications.unlinked.project.found.title", objectArray), NotificationType.INFORMATION);
            Intrinsics.checkExpressionValueIsNotNull((Object)notification2, (String)"GradleNotification.NOTIF\u2026ficationType.INFORMATION)");
            Notification notification3 = notification2;
            notification3.addAction((AnAction)NotificationAction.createSimple((String)GradleBundle.message("gradle.notifications.unlinked.project.found.import", new Object[0]), (Runnable)new Runnable(notification3, externalProjectPath, project){
                final /* synthetic */ Notification $notification;
                final /* synthetic */ String $externalProjectPath;
                final /* synthetic */ Project $project;

                public final void run() {
                    this.$notification.expire();
                    GradleProjectImportUtil.importProject(this.$externalProjectPath, this.$project);
                }
                {
                    this.$notification = notification2;
                    this.$externalProjectPath = string;
                    this.$project = project;
                }
            }));
            notification3.addAction((AnAction)NotificationAction.createSimple((String)GradleBundle.message("gradle.notifications.unlinked.project.found.skip", new Object[0]), (Runnable)new Runnable(notification3, project){
                final /* synthetic */ Notification $notification;
                final /* synthetic */ Project $project;

                public final void run() {
                    this.$notification.expire();
                    org.jetbrains.plugins.gradle.startup.GradleUnlinkedProjectProcessor$Companion.access$disableNotifications(GradleUnlinkedProjectProcessor.Companion, this.$project);
                }
                {
                    this.$notification = notification2;
                    this.$project = project;
                }
            }));
            notification3.setContextHelpAction((AnAction)new DumbAwareAction("Help", GradleBundle.message("gradle.notifications.unlinked.project.found.help", new Object[0]), null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                }
            });
            notification3.notify(project);
        }

        private final boolean isEnabledNotifications(Project project) {
            return PropertiesComponent.getInstance((Project)project).getBoolean(GradleUnlinkedProjectProcessor.SHOW_UNLINKED_GRADLE_POPUP, true);
        }

        private final void disableNotifications(Project project) {
            PropertiesComponent.getInstance((Project)project).setValue(GradleUnlinkedProjectProcessor.SHOW_UNLINKED_GRADLE_POPUP, false, true);
        }

        public final void enableNotifications(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            PropertiesComponent.getInstance((Project)project).setValue(GradleUnlinkedProjectProcessor.SHOW_UNLINKED_GRADLE_POPUP, true, false);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$disableNotifications(Companion $this, Project project) {
            $this.disableNotifications(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

