/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

public class GradleProjectSettings
extends ExternalProjectSettings {
    public static final boolean DEFAULT_DELEGATE = true;
    public static final TestRunner DEFAULT_TEST_RUNNER = TestRunner.GRADLE;
    @Nullable
    private String myGradleHome;
    @Nullable
    private String myGradleJvm = "#USE_PROJECT_JDK";
    @Nullable
    private DistributionType distributionType;
    private boolean disableWrapperSourceDistributionNotification;
    private boolean resolveModulePerSourceSet = ExternalSystemApiUtil.isJavaCompatibleIde();
    private boolean resolveExternalAnnotations;
    @Nullable
    private CompositeBuild myCompositeBuild;
    @Nullable
    private Boolean delegatedBuild;
    @Nullable
    private TestRunner testRunner;

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    public void setGradleHome(@Nullable String gradleHome) {
        this.myGradleHome = gradleHome;
    }

    @Nullable
    public String getGradleJvm() {
        return this.myGradleJvm;
    }

    public void setGradleJvm(@Nullable String gradleJvm) {
        this.myGradleJvm = gradleJvm;
    }

    @Nullable
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(@Nullable DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public boolean isDisableWrapperSourceDistributionNotification() {
        return this.disableWrapperSourceDistributionNotification;
    }

    public void setDisableWrapperSourceDistributionNotification(boolean disableWrapperSourceDistributionNotification) {
        this.disableWrapperSourceDistributionNotification = disableWrapperSourceDistributionNotification;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean useIdeModulePerSourceSet) {
        this.resolveModulePerSourceSet = useIdeModulePerSourceSet;
    }

    public boolean isResolveExternalAnnotations() {
        return this.resolveExternalAnnotations;
    }

    public void setResolveExternalAnnotations(boolean resolveExternalAnnotations) {
        this.resolveExternalAnnotations = resolveExternalAnnotations;
    }

    @OptionTag(tag="compositeConfiguration", nameAttribute="")
    @Nullable
    public CompositeBuild getCompositeBuild() {
        return this.myCompositeBuild;
    }

    public void setCompositeBuild(@Nullable CompositeBuild compositeBuild) {
        this.myCompositeBuild = compositeBuild;
    }

    @NotNull
    public GradleProjectSettings clone() {
        GradleProjectSettings result = new GradleProjectSettings();
        this.copyTo(result);
        result.myGradleHome = this.myGradleHome;
        result.myGradleJvm = this.myGradleJvm;
        result.distributionType = this.distributionType;
        result.disableWrapperSourceDistributionNotification = this.disableWrapperSourceDistributionNotification;
        result.resolveModulePerSourceSet = this.resolveModulePerSourceSet;
        result.resolveExternalAnnotations = this.resolveExternalAnnotations;
        result.myCompositeBuild = this.myCompositeBuild != null ? this.myCompositeBuild.copy() : null;
        result.delegatedBuild = this.delegatedBuild;
        result.testRunner = this.testRunner;
        GradleProjectSettings gradleProjectSettings = result;
        if (gradleProjectSettings == null) {
            GradleProjectSettings.$$$reportNull$$$0(0);
        }
        return gradleProjectSettings;
    }

    @Deprecated
    public ThreeState getStoreProjectFilesExternally() {
        return ThreeState.UNSURE;
    }

    @Deprecated
    public void setStoreProjectFilesExternally(@NotNull ThreeState value) {
        if (value == null) {
            GradleProjectSettings.$$$reportNull$$$0(1);
        }
    }

    @Transient
    public boolean getDelegatedBuild() {
        return (Boolean)ObjectUtils.notNull((Object)this.delegatedBuild, (Object)true);
    }

    public void setDelegatedBuild(@NotNull Boolean state) {
        if (state == null) {
            GradleProjectSettings.$$$reportNull$$$0(2);
        }
        this.delegatedBuild = state;
    }

    @OptionTag(value="delegatedBuild")
    @Nullable
    public Boolean getDirectDelegatedBuild() {
        return this.delegatedBuild;
    }

    public void setDirectDelegatedBuild(@Nullable Boolean state) {
        this.delegatedBuild = state;
    }

    public static boolean isDelegatedBuildEnabled(@NotNull Project project, @Nullable String gradleProjectPath) {
        GradleProjectSettings projectSettings;
        if (project == null) {
            GradleProjectSettings.$$$reportNull$$$0(3);
        }
        GradleProjectSettings gradleProjectSettings = projectSettings = gradleProjectPath == null ? null : (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(gradleProjectPath);
        if (projectSettings == null) {
            return false;
        }
        return projectSettings.getDelegatedBuild();
    }

    public static boolean isDelegatedBuildEnabled(@NotNull Module module) {
        if (module == null) {
            GradleProjectSettings.$$$reportNull$$$0(4);
        }
        return GradleProjectSettings.isDelegatedBuildEnabled(module.getProject(), ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
    }

    @Transient
    @NotNull
    public TestRunner getTestRunner() {
        TestRunner testRunner = (TestRunner)((Object)ObjectUtils.notNull((Object)((Object)this.testRunner), (Object)((Object)DEFAULT_TEST_RUNNER)));
        if (testRunner == null) {
            GradleProjectSettings.$$$reportNull$$$0(5);
        }
        return testRunner;
    }

    public void setTestRunner(@NotNull TestRunner testRunner) {
        if (testRunner == null) {
            GradleProjectSettings.$$$reportNull$$$0(6);
        }
        this.testRunner = testRunner;
    }

    @OptionTag(value="testRunner")
    @Nullable
    public TestRunner getDirectTestRunner() {
        return this.testRunner;
    }

    public void setDirectTestRunner(@Nullable TestRunner testRunner) {
        this.testRunner = testRunner;
    }

    @NotNull
    public static TestRunner getTestRunner(@NotNull Project project, @Nullable String gradleProjectPath) {
        GradleProjectSettings projectSettings;
        if (project == null) {
            GradleProjectSettings.$$$reportNull$$$0(7);
        }
        GradleProjectSettings gradleProjectSettings = projectSettings = gradleProjectPath == null ? null : (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(gradleProjectPath);
        if (projectSettings == null) {
            TestRunner testRunner = TestRunner.PLATFORM;
            if (testRunner == null) {
                GradleProjectSettings.$$$reportNull$$$0(8);
            }
            return testRunner;
        }
        TestRunner testRunner = projectSettings.getTestRunner();
        if (testRunner == null) {
            GradleProjectSettings.$$$reportNull$$$0(9);
        }
        return testRunner;
    }

    @NotNull
    public static TestRunner getTestRunner(@NotNull Module module) {
        if (module == null) {
            GradleProjectSettings.$$$reportNull$$$0(10);
        }
        TestRunner testRunner = GradleProjectSettings.getTestRunner(module.getProject(), ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
        if (testRunner == null) {
            GradleProjectSettings.$$$reportNull$$$0(11);
        }
        return testRunner;
    }

    @NotNull
    public GradleVersion resolveGradleVersion() {
        GradleVersion version = GradleInstallationManager.getGradleVersion(this);
        GradleVersion gradleVersion = Optional.ofNullable(version).orElseGet(GradleVersion::current);
        if (gradleVersion == null) {
            GradleProjectSettings.$$$reportNull$$$0(12);
        }
        return gradleVersion;
    }

    public GradleProjectSettings withQualifiedModuleNames() {
        this.setUseQualifiedModuleNames(true);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunner";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setStoreProjectFilesExternally";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDelegatedBuild";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDelegatedBuildEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTestRunner";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestRunner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="compositeBuild")
    public static class CompositeBuild {
        @Nullable
        private CompositeDefinitionSource myCompositeDefinitionSource;
        private List<BuildParticipant> myCompositeParticipants = new SmartList();

        @Attribute
        @Nullable
        public CompositeDefinitionSource getCompositeDefinitionSource() {
            return this.myCompositeDefinitionSource;
        }

        public void setCompositeDefinitionSource(@Nullable CompositeDefinitionSource compositeDefinitionSource) {
            this.myCompositeDefinitionSource = compositeDefinitionSource;
        }

        @XCollection(propertyElementName="builds", elementName="build")
        @NotNull
        public List<BuildParticipant> getCompositeParticipants() {
            List<BuildParticipant> list = this.myCompositeParticipants;
            if (list == null) {
                CompositeBuild.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void setCompositeParticipants(List<? extends BuildParticipant> compositeParticipants) {
            this.myCompositeParticipants = compositeParticipants == null ? new SmartList() : new ArrayList<BuildParticipant>(compositeParticipants);
        }

        @NotNull
        public CompositeBuild copy() {
            CompositeBuild result = new CompositeBuild();
            result.myCompositeParticipants = new ArrayList<BuildParticipant>();
            for (BuildParticipant participant : this.myCompositeParticipants) {
                result.myCompositeParticipants.add(participant.copy());
            }
            result.myCompositeDefinitionSource = this.myCompositeDefinitionSource;
            CompositeBuild compositeBuild = result;
            if (compositeBuild == null) {
                CompositeBuild.$$$reportNull$$$0(1);
            }
            return compositeBuild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings$CompositeBuild";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompositeParticipants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

