/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

public class GradleBuildParticipant
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String myProjectPath;
    private final Map<File, ModuleData> moduleArtifactMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)new TObjectHashingStrategy<File>(){

        public int computeHashCode(File file) {
            return ExternalSystemUtil.fileHashCode((File)file);
        }

        public boolean equals(File o1, File o2) {
            return ExternalSystemUtil.filesEqual((File)o1, (File)o2);
        }
    });
    private final Map<String, ModuleData> moduleNameMap = new HashMap<String, ModuleData>();

    public GradleBuildParticipant(String projectPath) {
        this.myProjectPath = projectPath;
    }

    public String getProjectPath() {
        return this.myProjectPath;
    }

    public void addModule(ModuleData moduleData) {
        List artifacts = moduleData.getArtifacts();
        if (!artifacts.isEmpty()) {
            for (File artifact : artifacts) {
                this.moduleArtifactMap.put(artifact, moduleData);
            }
        }
        this.moduleNameMap.put(moduleData.getExternalName(), moduleData);
        if (moduleData instanceof GradleSourceSetData) {
            String mainModuleName = StringUtil.trimEnd((String)moduleData.getExternalName(), (String)":main");
            this.moduleNameMap.put(mainModuleName, moduleData);
        }
    }

    @Nullable
    public ModuleData findModuleDataByArtifacts(Collection<? extends File> artifacts) {
        File artifact;
        ModuleData moduleData = null;
        Iterator<? extends File> iterator = artifacts.iterator();
        while (iterator.hasNext() && (moduleData = this.moduleArtifactMap.get(artifact = iterator.next())) == null) {
        }
        return moduleData;
    }

    @Nullable
    public ModuleData findModuleDataByName(String moduleName) {
        return this.moduleNameMap.get(moduleName);
    }
}

