/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.google.gson.GsonBuilder;
import com.intellij.build.SyncViewManager;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.BaseExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.Task;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleTaskManager
extends BaseExternalSystemTaskManager<GradleExecutionSettings> {
    public static final Key<String> INIT_SCRIPT_KEY = Key.create((String)"INIT_SCRIPT_KEY");
    public static final Key<String> INIT_SCRIPT_PREFIX_KEY = Key.create((String)"INIT_SCRIPT_PREFIX_KEY");
    private static final Logger LOG = Logger.getInstance(GradleTaskManager.class);
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = ContainerUtil.newConcurrentMap();

    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(0);
        }
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            GradleTaskManager.$$$reportNull$$$0(3);
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, taskNames, projectPath, settings, jvmParametersSetup, listener)) continue;
                return;
            }
        }
        GradleExecutionSettings effectiveSettings = settings == null ? new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false) : settings;
        ForkedDebuggerConfiguration forkedDebuggerSetup = ForkedDebuggerConfiguration.parse((String)jvmParametersSetup);
        if (forkedDebuggerSetup != null && this.isGradleScriptDebug(settings)) {
            effectiveSettings.withVmOption(forkedDebuggerSetup.getJvmAgentSetup(this.isJdk9orLater(effectiveSettings.getJavaHome())));
        }
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        this.myCancellationMap.put(id, cancellationTokenSource);
        Function f = connection -> {
            try {
                GradleTaskManager.appendInitScriptArgument(taskNames, jvmParametersSetup, effectiveSettings);
                try {
                    for (GradleBuildParticipant buildParticipant : effectiveSettings.getExecutionWorkspace().getBuildParticipants()) {
                        effectiveSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
                    }
                    List args = ContainerUtil.newSmartList();
                    Iterator iterator = effectiveSettings.getArguments().iterator();
                    while (iterator.hasNext()) {
                        String arg = (String)iterator.next();
                        if (!"--args".equals(arg) || !iterator.hasNext()) continue;
                        args.add("--args");
                        args.add(iterator.next());
                    }
                    String[] tasksArray = !args.isEmpty() ? (String[])taskNames.stream().flatMap(task -> ContainerUtil.concat(Collections.singletonList(task), (List)args).stream()).toArray(String[]::new) : ArrayUtilRt.toStringArray((Collection)taskNames);
                    BuildLauncher launcher = this.myHelper.getBuildLauncher(id, (ProjectConnection)connection, effectiveSettings, listener);
                    launcher.forTasks(tasksArray);
                    launcher.withCancellationToken(cancellationTokenSource.token());
                    launcher.run();
                }
                finally {
                    this.myCancellationMap.remove(id);
                }
                return null;
            }
            catch (RuntimeException e) {
                LOG.debug("Gradle build launcher error", (Throwable)e);
                BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener, cancellationTokenSource);
                GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(effectiveSettings);
                throw projectResolverChain.getUserFriendlyError(buildEnvironment, e, projectPath, null);
            }
        };
        if (effectiveSettings.getDistributionType() == DistributionType.WRAPPED) {
            this.myHelper.ensureInstalledWrapper(id, GradleUtil.determineRootProject(projectPath), effectiveSettings, listener, cancellationTokenSource.token());
        }
        this.myHelper.execute(projectPath, effectiveSettings, id, listener, cancellationTokenSource, f);
    }

    protected boolean isGradleScriptDebug(@Nullable GradleExecutionSettings settings) {
        return Optional.ofNullable(settings).map(s -> (Boolean)s.getUserData(GradleRunConfiguration.DEBUG_FLAG_KEY)).orElse(false);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource;
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            GradleTaskManager.$$$reportNull$$$0(5);
        }
        if ((cancellationTokenSource = this.myCancellationMap.get(id)) != null) {
            cancellationTokenSource.cancel();
            return true;
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener)) continue;
                return true;
            }
        }
        return false;
    }

    public static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull GradleExecutionSettings effectiveSettings) {
        String initScript;
        GradleProjectResolverExtension projectResolverChain;
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(6);
        }
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(7);
        }
        ArrayList initScripts = new ArrayList();
        for (GradleProjectResolverExtension resolverExtension = projectResolverChain = GradleProjectResolver.createProjectResolverChain(effectiveSettings); resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
            String resolverClassName = resolverExtension.getClass().getName();
            Consumer initScriptConsumer = script -> {
                if (StringUtil.isNotEmpty((String)script)) {
                    ContainerUtil.addAllNotNull((Collection)initScripts, (Object[])new String[]{"//-- Generated by " + resolverClassName, script, "//"});
                }
            };
            boolean isTestExecution = Boolean.TRUE == effectiveSettings.getUserData(GradleConstants.RUN_TASK_AS_TEST);
            resolverExtension.enhanceTaskProcessing(taskNames, jvmParametersSetup, (Consumer<String>)initScriptConsumer, isTestExecution);
        }
        if (!initScripts.isEmpty()) {
            try {
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join(initScripts, (String)SystemProperties.getLineSeparator()), "ijresolvers");
                effectiveSettings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
            }
            catch (IOException e) {
                ExternalSystemException systemException = new ExternalSystemException((Throwable)e);
                systemException.initCause((Throwable)e);
                throw systemException;
            }
        }
        if (StringUtil.isNotEmpty((String)(initScript = (String)effectiveSettings.getUserData(INIT_SCRIPT_KEY)))) {
            try {
                String initScriptPrefix = (String)effectiveSettings.getUserData(INIT_SCRIPT_PREFIX_KEY);
                initScriptPrefix = StringUtil.isEmpty((String)initScriptPrefix) ? "ijmiscinit" : FileUtil.sanitizeFileName((String)initScriptPrefix);
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(initScript, initScriptPrefix);
                effectiveSettings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
            }
            catch (IOException e) {
                ExternalSystemException externalSystemException = new ExternalSystemException((Throwable)e);
                externalSystemException.initCause((Throwable)e);
                throw externalSystemException;
            }
        }
    }

    public static void runCustomTask(@NotNull Project project, @NotNull String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath, @Nullable String taskConfiguration, @Nullable TaskCallback callback) {
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(8);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(9);
        }
        if (taskClass == null) {
            GradleTaskManager.$$$reportNull$$$0(10);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(11);
        }
        if (gradlePath == null) {
            GradleTaskManager.$$$reportNull$$$0(12);
        }
        GradleTaskManager.runCustomTask(project, executionName, taskClass, projectPath, gradlePath, taskConfiguration, ProgressExecutionMode.IN_BACKGROUND_ASYNC, callback);
    }

    public static void runCustomTask(@NotNull Project project, @NotNull String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback) {
        if (project == null) {
            GradleTaskManager.$$$reportNull$$$0(13);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(14);
        }
        if (taskClass == null) {
            GradleTaskManager.$$$reportNull$$$0(15);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(16);
        }
        if (gradlePath == null) {
            GradleTaskManager.$$$reportNull$$$0(17);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(18);
        }
        String taskName = taskClass.getSimpleName();
        String paths = GradleExecutionHelper.getToolingExtensionsJarPaths(ContainerUtil.set((Object[])new Class[]{taskClass, GsonBuilder.class}));
        String initScript = "initscript {\n  dependencies {\n    classpath files(" + paths + ")\n  }\n}\nallprojects {\n  afterEvaluate { project ->\n    if(project.path == '" + gradlePath + "') {\n        project.tasks.create(name: '" + taskName + "', overwrite: true, type: " + taskClass.getName() + ") {\n" + StringUtil.notNullize((String)taskConfiguration) + "\n        }\n    }\n  }\n}\n";
        UserDataHolderBase userData = new UserDataHolderBase();
        userData.putUserData(INIT_SCRIPT_KEY, (Object)initScript);
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, SyncViewManager.class);
        String gradleVmOptions = GradleSettings.getInstance(project).getGradleVmOptions();
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExecutionName(executionName);
        settings.setExternalProjectPath(projectPath);
        String taskPrefix = gradlePath.endsWith(":") ? gradlePath : gradlePath + ':';
        settings.setTaskNames(Collections.singletonList(taskPrefix + taskName));
        settings.setVmOptions(gradleVmOptions);
        settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)DefaultRunExecutor.EXECUTOR_ID, (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)callback, (ProgressExecutionMode)progressExecutionMode, (boolean)false, (UserDataHolderBase)userData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 2: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveSettings";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionName";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskClass";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutionMode";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/task/GradleTaskManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTasks";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "appendInitScriptArgument";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "runCustomTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

