/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.open.GradleJdk;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.service.project.open.SettingsContext;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.startup.GradleUnlinkedProjectProcessor;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleLog;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0002\u001a\u0012\u0010\f\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u001a$\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0007\u001a*\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u001a\n\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002\u001a$\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u0011*\u00020$H\u0002\u001a\u000e\u0010%\u001a\u0004\u0018\u00010\u0011*\u00020$H\u0002\u001a\u000e\u0010&\u001a\u0004\u0018\u00010\u0011*\u00020$H\u0002\u001a\u000e\u0010'\u001a\u0004\u0018\u00010\u0011*\u00020$H\u0002\u001a\u000e\u0010(\u001a\u0004\u0018\u00010\u0011*\u00020$H\u0002\u001a(\u0010)\u001a\u00020\u0001*\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020*H\u0002\u00a8\u0006+"}, d2={"attachGradleProjectAndRefresh", "", "settings", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "canImportProjectFrom", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canOpenPlatformProject", "projectDirectory", "closePreviousProject", "projectToClose", "createProject", "findExternalProjectDirectory", "focusOnOpenedSameProject", "", "importProject", "isChildExistsUsingIo", "parent", "name", "isGradleProjectFile", "openPlatformProject", "forceOpenInNewFrame", "openProject", "projectFile", "setupGradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "projectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "suggestGradleHome", "suggestGradleJvm", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getAndAddExternalJdkReference", "Lorg/jetbrains/plugins/gradle/service/project/open/SettingsContext;", "getGradleJdkReference", "getJavaHomeJdkReference", "getMostRecentJdkReference", "getProjectJdkReference", "setupGradleProjectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "intellij.gradle.common"})
@JvmName(name="GradleProjectImportUtil")
public final class GradleProjectImportUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isGradleProjectFile(VirtualFile file) {
        if (file.isDirectory()) return false;
        Intrinsics.checkExpressionValueIsNotNull((Object)GradleConstants.BUILD_FILE_EXTENSIONS, (String)"GradleConstants.BUILD_FILE_EXTENSIONS");
        String[] $this$any$iv = GradleConstants.BUILD_FILE_EXTENSIONS;
        boolean $i$f$any = false;
        String[] stringArray = $this$any$iv;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element$iv;
            String it = element$iv = stringArray[n2];
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            String string2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            if (StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean canImportProjectFrom(@NotNull VirtualFile file) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            if (!file.isDirectory()) {
                return GradleProjectImportUtil.isGradleProjectFile(file);
            }
            VirtualFile[] virtualFileArray = file.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"file.children");
            VirtualFile[] $this$any$iv = virtualFileArray;
            boolean $i$f$any = false;
            VirtualFile[] virtualFileArray2 = $this$any$iv;
            int n = virtualFileArray2.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile p1 = element$iv = virtualFileArray2[i];
                boolean bl2 = false;
                if (!GradleProjectImportUtil.isGradleProjectFile(p1)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @ApiStatus.Experimental
    @Nullable
    public static final Project openProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        if (!GradleProjectImportUtil.canImportProjectFrom(projectFile)) {
            return null;
        }
        VirtualFile projectDirectory = GradleProjectImportUtil.findExternalProjectDirectory(projectFile);
        String string = projectDirectory.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectDirectory.path");
        if (GradleProjectImportUtil.focusOnOpenedSameProject(string)) {
            return null;
        }
        if (GradleProjectImportUtil.canOpenPlatformProject(projectDirectory)) {
            return GradleProjectImportUtil.openPlatformProject(projectDirectory, projectToClose, forceOpenInNewFrame);
        }
        Project project = GradleProjectImportUtil.createProject(projectDirectory);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        String string2 = projectDirectory.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"projectDirectory.path");
        GradleProjectImportUtil.importProject(string2, project2);
        if (!forceOpenInNewFrame) {
            GradleProjectImportUtil.closePreviousProject(projectToClose);
        }
        ProjectManagerEx.getInstanceEx().openProject(project2);
        return project2;
    }

    @ApiStatus.Experimental
    public static final void importProject(@NotNull String projectDirectory, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleLog.LOG.info("Import project at " + projectDirectory);
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        Sdk projectSdk = projectRootManager.getProjectSdk();
        GradleProjectSettings gradleProjectSettings = new GradleProjectSettings();
        GradleProjectImportUtil.setupGradleSettings(gradleProjectSettings, projectDirectory, project, projectSdk);
        GradleProjectImportUtil.attachGradleProjectAndRefresh(gradleProjectSettings, project);
        ProjectUtil.updateLastProjectLocation((String)projectDirectory);
        project.save();
    }

    private static final boolean canOpenPlatformProject(VirtualFile projectDirectory) {
        if (!PlatformProjectOpenProcessor.getInstance().canOpenProject(projectDirectory)) {
            return false;
        }
        if (GradleProjectImportUtil.isChildExistsUsingIo(projectDirectory, ".idea")) {
            return true;
        }
        return GradleProjectImportUtil.isChildExistsUsingIo(projectDirectory, projectDirectory.getName() + ".ipr");
    }

    private static final boolean isChildExistsUsingIo(VirtualFile parent, String name) {
        boolean bl;
        try {
            Path path = Paths.get(FileUtil.toSystemDependentName((String)parent.getPath()), name);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(FileUtil.toSys\u2026tName(parent.path), name)");
            bl = PathKt.exists((Path)path);
        }
        catch (InvalidPathException e) {
            bl = false;
        }
        return bl;
    }

    private static final boolean focusOnOpenedSameProject(String projectDirectory) {
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        for (Project project : projectManager.getOpenProjects()) {
            if (!ProjectUtil.isSameProject((String)projectDirectory, (Project)project)) continue;
            ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
            return true;
        }
        return false;
    }

    private static final Project openPlatformProject(VirtualFile projectDirectory, Project projectToClose, boolean forceOpenInNewFrame) {
        Project project;
        PlatformProjectOpenProcessor openProcessor = PlatformProjectOpenProcessor.getInstance();
        Project project2 = openProcessor.doOpenProject(projectDirectory, projectToClose, forceOpenInNewFrame);
        if (project2 != null) {
            Project project3 = project2;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project3;
            boolean bl3 = false;
            Project project4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"it");
            GradleUnlinkedProjectProcessor.Companion.enableNotifications(project4);
            project = project3;
        } else {
            project = null;
        }
        return project;
    }

    public static final void attachGradleProjectAndRefresh(@NotNull ExternalProjectSettings settings, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String externalProjectPath = settings.getExternalProjectPath();
        ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                DumbService.getInstance((Project)this.$project).runWhenSmart(new Runnable(this){
                    final /* synthetic */ attachGradleProjectAndRefresh.1 this$0;

                    public final void run() {
                        ExternalSystemUtil.ensureToolWindowInitialized((Project)this.this$0.$project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = project;
            }
        });
        ExternalProjectsManagerImpl.disableProjectWatcherAutoUpdate((Project)project);
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject(settings);
        ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)externalProjectPath, (boolean)true, (ProgressExecutionMode)ProgressExecutionMode.MODAL_SYNC);
        ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)externalProjectPath, (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    private static final void closePreviousProject(Project projectToClose) {
        int exitCode;
        Project[] openProjects;
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] projectArray2 = openProjects = projectArray;
        boolean bl = false;
        Project[] projectArray3 = projectArray2;
        boolean bl2 = false;
        if (!(projectArray3.length == 0) && (exitCode = ProjectUtil.confirmOpenNewProject((boolean)true)) == 1) {
            Project project = projectToClose;
            if (project == null) {
                project = openProjects[openProjects.length - 1];
            }
            ProjectUtil.closeAndDispose((Project)project);
        }
    }

    private static final VirtualFile findExternalProjectDirectory(VirtualFile file) {
        if (!file.isDirectory()) {
            VirtualFile virtualFile = file.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file.parent");
            return virtualFile;
        }
        return file;
    }

    private static final Project createProject(VirtualFile projectDirectory) {
        Project project;
        block0: {
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            Project project2 = project = projectManager.createProject(projectDirectory.getName(), projectDirectory.getPath());
            if (project2 == null) break block0;
            project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
        }
        return project;
    }

    public static final void setupGradleSettings(@NotNull GradleProjectSettings settings, @NotNull String projectDirectory, @NotNull Project project, @Nullable Sdk projectSdk) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)settings), (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleProjectImportUtil.setupGradleSettings(gradleSettings);
        GradleProjectImportUtil.setupGradleProjectSettings(settings, projectDirectory, project, projectSdk);
    }

    public static /* synthetic */ void setupGradleSettings$default(GradleProjectSettings gradleProjectSettings, String string, Project project, Sdk sdk, int n, Object object) {
        if ((n & 8) != 0) {
            sdk = null;
        }
        GradleProjectImportUtil.setupGradleSettings(gradleProjectSettings, string, project, sdk);
    }

    private static final void setupGradleSettings(@NotNull GradleSettings $this$setupGradleSettings) {
        boolean bl;
        String string = GradleEnvironment.Headless.GRADLE_VM_OPTIONS;
        if (string == null) {
            string = $this$setupGradleSettings.getGradleVmOptions();
        }
        $this$setupGradleSettings.setGradleVmOptions(string);
        GradleSettings gradleSettings = $this$setupGradleSettings;
        String string2 = GradleEnvironment.Headless.GRADLE_OFFLINE;
        if (string2 != null) {
            String string3 = string2;
            GradleSettings gradleSettings2 = gradleSettings;
            boolean bl2 = false;
            boolean bl3 = Boolean.parseBoolean(string3);
            gradleSettings = gradleSettings2;
            bl = bl3;
        } else {
            bl = $this$setupGradleSettings.isOfflineWork();
        }
        gradleSettings.setOfflineWork(bl);
        String string4 = GradleEnvironment.Headless.GRADLE_SERVICE_DIRECTORY;
        if (string4 == null) {
            string4 = $this$setupGradleSettings.getServiceDirectoryPath();
        }
        $this$setupGradleSettings.setServiceDirectoryPath(string4);
        if (ExternalSystemUtil.isNewProject((Project)$this$setupGradleSettings.getProject()) && $this$setupGradleSettings.getLinkedProjectsSettings().isEmpty()) {
            $this$setupGradleSettings.setStoreProjectFilesExternally(true);
        }
    }

    private static final void setupGradleProjectSettings(@NotNull GradleProjectSettings $this$setupGradleProjectSettings, String projectDirectory, Project project, Sdk projectSdk) {
        Object object;
        GradleProjectSettings gradleProjectSettings;
        block5: {
            block4: {
                $this$setupGradleProjectSettings.setExternalProjectPath(projectDirectory);
                $this$setupGradleProjectSettings.setUseAutoImport(false);
                $this$setupGradleProjectSettings.setUseQualifiedModuleNames(true);
                gradleProjectSettings = $this$setupGradleProjectSettings;
                object = GradleEnvironment.Headless.GRADLE_DISTRIBUTION_TYPE;
                if (object == null) break block4;
                String string = object;
                GradleProjectSettings gradleProjectSettings2 = gradleProjectSettings;
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string;
                boolean bl3 = false;
                DistributionType distributionType = DistributionType.valueOf(p1);
                gradleProjectSettings = gradleProjectSettings2;
                object = distributionType;
                if (object != null) break block5;
            }
            object = DistributionType.DEFAULT_WRAPPED;
        }
        gradleProjectSettings.setDistributionType((DistributionType)((Object)object));
        String string = GradleEnvironment.Headless.GRADLE_HOME;
        if (string == null) {
            string = GradleProjectImportUtil.suggestGradleHome();
        }
        $this$setupGradleProjectSettings.setGradleHome(string);
        GradleVersion gradleVersion = $this$setupGradleProjectSettings.resolveGradleVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"resolveGradleVersion()");
        $this$setupGradleProjectSettings.setGradleJvm(GradleProjectImportUtil.suggestGradleJvm(project, projectSdk, gradleVersion));
    }

    static /* synthetic */ void setupGradleProjectSettings$default(GradleProjectSettings gradleProjectSettings, String string, Project project, Sdk sdk, int n, Object object) {
        if ((n & 4) != 0) {
            sdk = null;
        }
        GradleProjectImportUtil.setupGradleProjectSettings(gradleProjectSettings, string, project, sdk);
    }

    private static final String suggestGradleHome() {
        GradleInstallationManager installationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        String lastUsedGradleHome = StringKt.nullize$default((String)GradleUtil.getLastUsedGradleHome(), (boolean)false, (int)1, null);
        if (lastUsedGradleHome != null) {
            return lastUsedGradleHome;
        }
        GradleInstallationManager gradleInstallationManager = installationManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleInstallationManager, (String)"installationManager");
        File file = gradleInstallationManager.getAutodetectedGradleHome();
        if (file == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"installationManager.auto\u2026GradleHome ?: return null");
        File gradleHome = file;
        return FileUtil.toCanonicalPath((String)gradleHome.getPath());
    }

    private static final String suggestGradleJvm(Project project, Sdk projectSdk, GradleVersion gradleVersion) {
        String string;
        String string2;
        String string3;
        SettingsContext settingsContext = new SettingsContext(project, projectSdk, gradleVersion);
        boolean bl = false;
        boolean bl2 = false;
        SettingsContext $this$with = settingsContext;
        boolean bl3 = false;
        String string4 = GradleProjectImportUtil.getGradleJdkReference($this$with);
        if (string4 == null) {
            string4 = string3 = GradleProjectImportUtil.getProjectJdkReference($this$with);
        }
        if (string4 == null) {
            string3 = string2 = GradleProjectImportUtil.getMostRecentJdkReference($this$with);
        }
        if (string3 == null) {
            string2 = string = GradleProjectImportUtil.getJavaHomeJdkReference($this$with);
        }
        if (string2 == null) {
            string = GradleProjectImportUtil.getAndAddExternalJdkReference($this$with);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getGradleJdkReference(@NotNull SettingsContext $this$getGradleJdkReference) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)$this$getGradleJdkReference.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractExternalSystemSettings, (String)"ExternalSystemApiUtil.ge\u2026tings(project, SYSTEM_ID)");
        AbstractExternalSystemSettings settings = abstractExternalSystemSettings;
        Collection collection = settings.getLinkedProjectsSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"settings.getLinkedProjectsSettings()");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GradleProjectSettings)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GradleProjectSettings it = (GradleProjectSettings)((Object)element$iv$iv);
            boolean bl2 = false;
            if (it.getGradleJvm() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final String getJavaHomeJdkReference(@NotNull SettingsContext $this$getJavaHomeJdkReference) {
        String string = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME");
        if (string == null) {
            return null;
        }
        String javaHome = string;
        GradleJdk gradleJdk = GradleJdk.Companion.valueOf(javaHome);
        if (gradleJdk == null) {
            return null;
        }
        GradleJdk jdk = gradleJdk;
        if (!jdk.isSupported($this$getJavaHomeJdkReference.getGradleVersion())) {
            return null;
        }
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        String string2 = simpleJavaSdkType.suggestSdkName(null, javaHome);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"simpleJavaSdkType.suggestSdkName(null, javaHome)");
        String sdkName = string2;
        simpleJavaSdkType.createJdk(sdkName, javaHome);
        return "#JAVA_HOME";
    }

    private static final String getProjectJdkReference(@NotNull SettingsContext $this$getProjectJdkReference) {
        Object object;
        block6: {
            block5: {
                Sdk projectSdk;
                Sdk sdk = $this$getProjectJdkReference.getProjectSdk();
                if (sdk == null) {
                    ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)$this$getProjectJdkReference.getProject());
                    Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                    sdk = projectRootManager.getProjectSdk();
                }
                if ((object = (projectSdk = sdk)) == null) break block5;
                Sdk sdk2 = object;
                GradleJdk.Companion companion = GradleJdk.Companion;
                boolean bl = false;
                boolean bl2 = false;
                Sdk p1 = sdk2;
                boolean bl3 = false;
                object = companion.valueOf(p1);
                if (object != null) break block6;
            }
            return null;
        }
        Object projectJdk = object;
        if (!((GradleJdk)projectJdk).isSupported($this$getProjectJdkReference.getGradleVersion())) {
            return null;
        }
        return "#USE_PROJECT_JDK";
    }

    /*
     * WARNING - void declaration
     */
    private static final String getMostRecentJdkReference(@NotNull SettingsContext $this$getMostRecentJdkReference) {
        GradleJdk jdk;
        Object v3;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
        SdkType javaSdkType = sdkType;
        List list = projectJdkTable.getSdksOfType((SdkTypeId)javaSdkType);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"projectJdkTable.getSdksOfType(javaSdkType)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GradleJdk gradleJdk;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Sdk it = (Sdk)element$iv$iv;
            boolean bl2 = false;
            Sdk sdk = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"it");
            if (GradleJdk.Companion.valueOf(sdk) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            GradleJdk it$iv$iv = gradleJdk;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GradleJdk it = (GradleJdk)element$iv$iv;
            boolean bl = false;
            if (!it.isSupported($this$getMostRecentJdkReference.getGradleVersion())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxBy$iv = (List)destination$iv$iv;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            GradleJdk it = (GradleJdk)maxElem$iv;
            boolean bl = false;
            Comparable maxValue$iv = (Comparable)it.getVersion();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                GradleJdk it2 = (GradleJdk)e$iv;
                $i$a$-maxBy-GradleProjectImportUtil$getMostRecentJdkReference$jdk$3 = false;
                Comparable v$iv = (Comparable)it2.getVersion();
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v3 = maxElem$iv;
        }
        GradleJdk gradleJdk = jdk = (GradleJdk)v3;
        return gradleJdk != null ? gradleJdk.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getAndAddExternalJdkReference(@NotNull SettingsContext $this$getAndAddExternalJdkReference) {
        Object v2;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Collection collection = ExternalSystemJdkUtil.suggestJdkHomePaths();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ExternalSystemJdkUtil.suggestJdkHomePaths()");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GradleJdk gradleJdk;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            if (GradleJdk.Companion.valueOf(string) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            GradleJdk it$iv$iv = gradleJdk;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GradleJdk it = (GradleJdk)element$iv$iv;
            boolean bl = false;
            if (!it.isSupported($this$getAndAddExternalJdkReference.getGradleVersion())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxBy$iv = (List)destination$iv$iv;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            GradleJdk it = (GradleJdk)maxElem$iv;
            boolean bl = false;
            Comparable maxValue$iv = (Comparable)it.getVersion();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                GradleJdk it2 = (GradleJdk)e$iv;
                $i$a$-maxBy-GradleProjectImportUtil$getAndAddExternalJdkReference$jdk$3 = false;
                Comparable v$iv = (Comparable)it2.getVersion();
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v2 = maxElem$iv;
        }
        GradleJdk jdk = v2;
        if (jdk == null) {
            return null;
        }
        Sdk sdk = ExternalSystemJdkUtil.addJdk((String)jdk.getHomePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"ExternalSystemJdkUtil.addJdk(jdk.homePath)");
        return sdk.getName();
    }
}

