/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClassSetProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.BaseGradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.BuildActionRunner;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleBuildSrcProjectsResolver;
import org.jetbrains.plugins.gradle.service.project.GradleImportCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.LibraryDataNodeSubstitutor;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.TracedProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolver.class);
    @NotNull
    private final GradleExecutionHelper myHelper;
    private final GradleLibraryNamesMixer myLibraryNamesMixer;
    private final MultiMap<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap;
    public static final Key<Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>>> RESOLVED_SOURCE_SETS = Key.create((String)"resolvedSourceSets");
    public static final Key<Map<String, Pair<String, ExternalSystemSourceType>>> MODULES_OUTPUTS = Key.create((String)"moduleOutputsMap");
    public static final Key<MultiMap<ExternalSystemSourceType, String>> GRADLE_OUTPUTS = Key.create((String)"gradleOutputs");
    public static final Key<Map<String, String>> CONFIGURATION_ARTIFACTS = Key.create((String)"gradleArtifactsMap");
    private static final Key<File> GRADLE_HOME_DIR = Key.create((String)"gradleHomeDir");

    public GradleProjectResolver() {
        this(new GradleExecutionHelper());
    }

    public GradleProjectResolver(@NotNull GradleExecutionHelper helper) {
        if (helper == null) {
            GradleProjectResolver.$$$reportNull$$$0(0);
        }
        this.myLibraryNamesMixer = new GradleLibraryNamesMixer();
        this.myCancellationMap = MultiMap.create();
        this.myHelper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId syncTaskId, @NotNull String projectPath, boolean isPreviewMode, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (syncTaskId == null) {
            GradleProjectResolver.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            GradleProjectResolver.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            GradleProjectResolver.$$$reportNull$$$0(3);
        }
        if (isPreviewMode) {
            String projectName = new File(projectPath).getName();
            ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectPath, projectPath);
            DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
            String ideProjectPath = settings == null ? null : settings.getIdeProjectPath();
            String mainModuleFileDirectoryPath = ideProjectPath == null ? projectPath : ideProjectPath;
            projectDataNode.createChild(ProjectKeys.MODULE, (Object)new ModuleData(projectName, GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), projectName, mainModuleFileDirectoryPath, projectPath)).createChild(ProjectKeys.CONTENT_ROOT, (Object)new ContentRootData(GradleConstants.SYSTEM_ID, projectPath));
            return projectDataNode;
        }
        DefaultProjectResolverContext resolverContext = new DefaultProjectResolverContext(syncTaskId, projectPath, settings, listener, false);
        CancellationTokenSource cancellationTokenSource = resolverContext.getCancellationTokenSource();
        this.myCancellationMap.putValue((Object)resolverContext.getExternalSystemTaskId(), (Object)cancellationTokenSource);
        try {
            if (settings != null) {
                this.myHelper.ensureInstalledWrapper(syncTaskId, projectPath, settings, listener, cancellationTokenSource.token());
            }
            GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(settings);
            DataNode<ProjectData> projectDataNode = this.myHelper.execute(projectPath, settings, syncTaskId, listener, cancellationTokenSource, this.getProjectDataFunction(resolverContext, projectResolverChain, false));
            File gradleUserHome = (File)resolverContext.getUserData(GRADLE_HOME_DIR);
            new GradleBuildSrcProjectsResolver(this, resolverContext, gradleUserHome, settings, listener, syncTaskId, projectResolverChain).discoverAndAppendTo(projectDataNode);
            DataNode<ProjectData> dataNode = projectDataNode;
            return dataNode;
        }
        finally {
            this.myCancellationMap.remove((Object)resolverContext.getExternalSystemTaskId(), (Object)cancellationTokenSource);
        }
    }

    @NotNull
    Function<ProjectConnection, DataNode<ProjectData>> getProjectDataFunction(DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
        ProjectConnectionDataNodeFunction projectConnectionDataNodeFunction = new ProjectConnectionDataNodeFunction(resolverContext, projectResolverChain, isBuildSrcProject);
        if (projectConnectionDataNodeFunction == null) {
            GradleProjectResolver.$$$reportNull$$$0(4);
        }
        return projectConnectionDataNodeFunction;
    }

    @NotNull
    GradleExecutionHelper getHelper() {
        GradleExecutionHelper gradleExecutionHelper = this.myHelper;
        if (gradleExecutionHelper == null) {
            GradleProjectResolver.$$$reportNull$$$0(5);
        }
        return gradleExecutionHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (id == null) {
            GradleProjectResolver.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            GradleProjectResolver.$$$reportNull$$$0(7);
        }
        MultiMap<ExternalSystemTaskId, CancellationTokenSource> multiMap = this.myCancellationMap;
        synchronized (multiMap) {
            for (CancellationTokenSource cancellationTokenSource : this.myCancellationMap.get((Object)id)) {
                cancellationTokenSource.cancel();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DataNode<ProjectData> doResolveProjectInfo(@NotNull DefaultProjectResolverContext resolverCtx, @NotNull GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) throws IllegalArgumentException, IllegalStateException {
        IdeaModule ideaModule;
        DataNode moduleDataNode;
        ProjectImportAction.AllModels allModels;
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(8);
        }
        if (projectResolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(9);
        }
        PerformanceTrace performanceTrace = new PerformanceTrace();
        TracedProjectResolverExtension tracedResolverChain = new TracedProjectResolverExtension(projectResolverChain, performanceTrace);
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(resolverCtx);
        GradleVersion gradleVersion = null;
        boolean isCompositeBuildsSupported = false;
        if (buildEnvironment != null) {
            gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
            isCompositeBuildsSupported = gradleVersion.compareTo(GradleVersion.version((String)"3.1")) >= 0;
            resolverCtx.setBuildEnvironment(buildEnvironment);
        }
        boolean useCustomSerialization = Registry.is((String)"gradle.tooling.custom.serializer", (boolean)true);
        ProjectImportAction projectImportAction = new ProjectImportAction(resolverCtx.isPreviewMode(), isCompositeBuildsSupported, useCustomSerialization);
        GradleExecutionSettings executionSettings = resolverCtx.getSettings();
        if (executionSettings == null) {
            executionSettings = new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false);
        }
        executionSettings.withArgument("-Didea.sync.active=true");
        if (resolverCtx.isPreviewMode()) {
            executionSettings.withArgument("-Didea.isPreviewMode=true");
            Set previewLightWeightToolingModels = ContainerUtil.set((Object[])new Class[]{ExternalProjectPreview.class, GradleBuild.class});
            projectImportAction.addProjectImportModelProvider((ProjectImportModelProvider)new ClassSetProjectImportModelProvider((Collection)previewLightWeightToolingModels));
        }
        if (resolverCtx.isResolveModulePerSourceSet()) {
            executionSettings.withArgument("-Didea.resolveSourceSetDependencies=true");
        }
        if (!isBuildSrcProject) {
            for (GradleBuildParticipant buildParticipant : executionSettings.getExecutionWorkspace().getBuildParticipants()) {
                executionSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
        }
        HashSet<Class> toolingExtensionClasses = new HashSet<Class>();
        GradleImportCustomizer importCustomizer = GradleImportCustomizer.get();
        boolean requiresTaskInitialization = false;
        for (GradleProjectResolverExtension resolverExtension = tracedResolverChain; resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
            Object projectsLoadedModelProvider;
            resolverExtension.setProjectResolverContext(resolverCtx);
            resolverExtension.preImportCheck();
            projectImportAction.addTargetTypes(resolverExtension.getTargetTypes());
            if (!resolverCtx.isPreviewMode()) {
                try {
                    ProjectImportModelProvider modelProvider = resolverExtension.getModelProvider();
                    if (modelProvider != null) {
                        projectImportAction.addProjectImportModelProvider(modelProvider);
                    }
                    if ((projectsLoadedModelProvider = resolverExtension.getProjectsLoadedModelProvider()) != null) {
                        projectImportAction.addProjectImportModelProvider((ProjectImportModelProvider)projectsLoadedModelProvider, true);
                    }
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
            }
            if (importCustomizer == null || importCustomizer.useExtraJvmArgs()) {
                ParametersList parametersList = new ParametersList();
                projectsLoadedModelProvider = resolverExtension.getExtraJvmArgs().iterator();
                while (projectsLoadedModelProvider.hasNext()) {
                    Pair jvmArg = (Pair)projectsLoadedModelProvider.next();
                    parametersList.addProperty((String)jvmArg.first, (String)jvmArg.second);
                }
                executionSettings.withVmOptions(parametersList.getParameters());
            }
            executionSettings.withArguments(resolverExtension.getExtraCommandLineArgs());
            try {
                toolingExtensionClasses.addAll(resolverExtension.getToolingExtensionsClasses());
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
            try {
                requiresTaskInitialization |= resolverExtension.requiresTaskRunning();
                continue;
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
        File initScript = GradleExecutionHelper.generateInitScript(isBuildSrcProject, toolingExtensionClasses);
        if (initScript != null) {
            executionSettings.withArguments(new String[]{"--init-script", initScript.getAbsolutePath()});
        }
        BuildActionRunner buildActionRunner = new BuildActionRunner(resolverCtx, projectImportAction, requiresTaskInitialization, executionSettings, this.myHelper);
        resolverCtx.checkCancelled();
        long startTime = System.currentTimeMillis();
        try {
            allModels = buildActionRunner.fetchModels(models -> {
                for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
                    resolver.projectsLoaded((ModelsHolder<BuildModel, ProjectModel>)models);
                }
            }, exception -> {
                for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
                    resolver.buildFinished((GradleConnectionException)exception);
                }
            });
            performanceTrace.addTrace(allModels.getPerformanceTrace());
        }
        catch (Throwable throwable) {
            long timeInMs = System.currentTimeMillis() - startTime;
            performanceTrace.logPerformance("Gradle data obtained", timeInMs);
            LOG.debug(String.format("Gradle data obtained in %d ms", timeInMs));
            throw throwable;
        }
        long timeInMs = System.currentTimeMillis() - startTime;
        performanceTrace.logPerformance("Gradle data obtained", timeInMs);
        LOG.debug(String.format("Gradle data obtained in %d ms", timeInMs));
        resolverCtx.checkCancelled();
        if (useCustomSerialization) {
            allModels.initToolingSerializer();
        }
        allModels.setBuildEnvironment(buildEnvironment);
        long startDataConversionTime = System.currentTimeMillis();
        GradleProjectResolver.extractExternalProjectModels(allModels, resolverCtx, useCustomSerialization);
        ProjectData projectData = tracedResolverChain.createProject();
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        DataNode performanceTraceNode = new DataNode(PerformanceTrace.TRACE_NODE_KEY, (Object)performanceTrace, projectDataNode);
        projectDataNode.addChild(performanceTraceNode);
        IdeaProject ideaProject = resolverCtx.getModels().getIdeaProject();
        tracedResolverChain.populateProjectExtraModels(ideaProject, (DataNode<ProjectData>)projectDataNode);
        DomainObjectSet gradleModules = ideaProject.getModules();
        if (gradleModules == null || gradleModules.isEmpty()) {
            throw new IllegalStateException("No modules found for the target project: " + ideaProject);
        }
        Collection<IdeaModule> includedModules = GradleProjectResolver.exposeCompositeBuild(allModels, resolverCtx, (DataNode<ProjectData>)projectDataNode);
        HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap = new HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>>();
        HashMap sourceSetsMap = new HashMap();
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, sourceSetsMap);
        THashMap moduleOutputsMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        projectDataNode.putUserData(MODULES_OUTPUTS, (Object)moduleOutputsMap);
        THashMap artifactsMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        projectDataNode.putUserData(CONFIGURATION_ARTIFACTS, (Object)artifactsMap);
        for (Object gradleModule : ContainerUtil.concat((Iterable[])new Iterable[]{gradleModules, includedModules})) {
            String moduleName;
            if (gradleModule == null) continue;
            resolverCtx.checkCancelled();
            if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
                LOG.info(String.format("Importing module data: %s", gradleModule));
            }
            if ((moduleName = gradleModule.getName()) == null) {
                throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
            }
            moduleDataNode = tracedResolverChain.createModule((IdeaModule)gradleModule, (DataNode<ProjectData>)projectDataNode);
            String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, (IdeaModule)gradleModule);
            if (moduleMap.containsKey(mainModuleId)) {
                throw new IllegalStateException("Duplicate modules names detected: " + gradleModule);
            }
            moduleMap.put(mainModuleId, (Pair<DataNode<ModuleData>, IdeaModule>)Pair.create((Object)moduleDataNode, (Object)gradleModule));
        }
        executionSettings.getExecutionWorkspace().setModuleIdIndex(moduleMap);
        File gradleHomeDir = null;
        for (Pair pair : moduleMap.values()) {
            BuildScriptClasspathModel buildScriptClasspathModel;
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            if (gradleHomeDir == null && (buildScriptClasspathModel = resolverCtx.getExtraProject(ideaModule, BuildScriptClasspathModel.class)) != null) {
                gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
            }
            tracedResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            tracedResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            if (!isBuildSrcProject) {
                tracedResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            }
            List modules = ContainerUtil.newSmartList();
            modules.add(moduleDataNode);
            modules.addAll(ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY));
            ExternalSystemSourceType[] sourceTypes = new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.RESOURCE, ExternalSystemSourceType.TEST, ExternalSystemSourceType.TEST_RESOURCE};
            for (DataNode module : modules) {
                ModuleData moduleData = (ModuleData)module.getData();
                for (ExternalSystemSourceType sourceType : sourceTypes) {
                    String path = moduleData.getCompileOutputPath(sourceType);
                    if (path == null) continue;
                    moduleOutputsMap.put(path, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                }
                if (!(moduleData instanceof GradleSourceSetData)) continue;
                for (File artifactFile : moduleData.getArtifacts()) {
                    artifactsMap.put(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getAbsolutePath()), moduleData.getId());
                }
            }
        }
        resolverCtx.putUserData(GRADLE_HOME_DIR, gradleHomeDir);
        for (Pair pair : moduleMap.values()) {
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            tracedResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            tracedResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
        }
        GradleProjectResolver.mergeSourceSetContentRoots(moduleMap, resolverCtx);
        if (resolverCtx.isResolveModulePerSourceSet()) {
            GradleProjectResolver.mergeLibraryAndModuleDependencyData((DataNode<ProjectData>)projectDataNode, resolverCtx.getGradleUserHome(), gradleHomeDir, gradleVersion);
        }
        for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
            if (!(resolver instanceof AbstractProjectResolverExtension)) continue;
            ((AbstractProjectResolverExtension)resolver).onResolveEnd((DataNode<ProjectData>)projectDataNode);
        }
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, null);
        projectDataNode.putUserData(MODULES_OUTPUTS, null);
        projectDataNode.putUserData(CONFIGURATION_ARTIFACTS, null);
        Collection libraries = ExternalSystemApiUtil.getChildren((DataNode)projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        long timeConversionInMs = System.currentTimeMillis() - startDataConversionTime;
        performanceTrace.logPerformance("Gradle project data processed", timeConversionInMs);
        LOG.debug(String.format("Project data resolved in %d ms", timeConversionInMs));
        DataNode dataNode = projectDataNode;
        if (dataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(10);
        }
        return dataNode;
    }

    @NotNull
    private static Collection<IdeaModule> exposeCompositeBuild(ProjectImportAction.AllModels allModels, DefaultProjectResolverContext resolverCtx, DataNode<ProjectData> projectDataNode) {
        if (resolverCtx.getSettings() != null && !resolverCtx.getSettings().getExecutionWorkspace().getBuildParticipants().isEmpty()) {
            List<IdeaModule> list = Collections.emptyList();
            if (list == null) {
                GradleProjectResolver.$$$reportNull$$$0(11);
            }
            return list;
        }
        SmartList gradleIncludedModules = new SmartList();
        List includedBuilds = allModels.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            ProjectData projectData = (ProjectData)projectDataNode.getData();
            CompositeBuildData compositeBuildData = new CompositeBuildData(projectData.getLinkedExternalProjectPath());
            for (IdeaProject project : includedBuilds) {
                if (project.getModules().isEmpty()) continue;
                String rootProjectName = project.getName();
                BuildParticipant buildParticipant = new BuildParticipant();
                gradleIncludedModules.addAll(project.getModules());
                GradleProject gradleProject = ((IdeaModule)project.getModules().getAt(0)).getGradleProject();
                String projectPath = null;
                do {
                    try {
                        projectPath = ExternalSystemApiUtil.toCanonicalPath((String)gradleProject.getProjectDirectory().getCanonicalPath());
                    }
                    catch (IOException e) {
                        LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
                    }
                } while ((gradleProject = gradleProject.getParent()) != null);
                if (projectPath == null) continue;
                buildParticipant.setRootProjectName(rootProjectName);
                buildParticipant.setRootPath(projectPath);
                for (IdeaModule module : project.getModules()) {
                    try {
                        String modulePath = ExternalSystemApiUtil.toCanonicalPath((String)module.getGradleProject().getProjectDirectory().getCanonicalPath());
                        buildParticipant.getProjects().add(modulePath);
                    }
                    catch (IOException e) {
                        LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
                    }
                }
                compositeBuildData.getCompositeParticipants().add(buildParticipant);
            }
            projectDataNode.createChild(CompositeBuildData.KEY, (Object)compositeBuildData);
        }
        SmartList smartList = gradleIncludedModules;
        if (smartList == null) {
            GradleProjectResolver.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    private static void mergeLibraryAndModuleDependencyData(@NotNull DataNode<ProjectData> projectDataNode, @NotNull File gradleUserHomeDir, @Nullable File gradleHomeDir, @Nullable GradleVersion gradleVersion) {
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(13);
        }
        if (gradleUserHomeDir == null) {
            GradleProjectResolver.$$$reportNull$$$0(14);
        }
        Map sourceSetMap = (Map)projectDataNode.getUserData(RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map moduleOutputsMap = (Map)projectDataNode.getUserData(MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        Map artifactsMap = (Map)projectDataNode.getUserData(CONFIGURATION_ARTIFACTS);
        assert (artifactsMap != null);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
        LibraryDataNodeSubstitutor librarySubstitutor = new LibraryDataNodeSubstitutor(gradleUserHomeDir, gradleHomeDir, gradleVersion, sourceSetMap, moduleOutputsMap, artifactsMap);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            librarySubstitutor.run((DataNode<LibraryDependencyData>)libraryDependencyDataNode);
        }
    }

    private static void extractExternalProjectModels(@NotNull ProjectImportAction.AllModels models, @NotNull ProjectResolverContext resolverCtx, boolean useCustomSerialization) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(15);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(16);
        }
        resolverCtx.setModels(models);
        Class modelClazz = resolverCtx.isPreviewMode() ? ExternalProjectPreview.class : ExternalProject.class;
        ExternalProject externalRootProject = (ExternalProject)models.getModel(modelClazz);
        if (externalRootProject == null) {
            return;
        }
        DefaultExternalProject wrappedExternalRootProject = useCustomSerialization ? (DefaultExternalProject)externalRootProject : new DefaultExternalProject(externalRootProject);
        models.addModel((Object)wrappedExternalRootProject, ExternalProject.class);
        Map<String, DefaultExternalProject> externalProjectsMap = GradleProjectResolver.createExternalProjectsMap(null, wrappedExternalRootProject);
        DomainObjectSet gradleModules = models.getIdeaProject().getModules();
        if (gradleModules != null && !gradleModules.isEmpty()) {
            for (IdeaModule ideaModule : gradleModules) {
                ExternalProject externalProject = (ExternalProject)externalProjectsMap.get(GradleProjectResolverUtil.getModuleId(resolverCtx, ideaModule));
                if (externalProject == null) continue;
                models.addModel((Object)externalProject, ExternalProject.class, (ProjectModel)ideaModule.getGradleProject());
            }
        }
        for (IdeaProject project : models.getIncludedBuilds()) {
            DomainObjectSet ideaModules = project.getModules();
            if (ideaModules.isEmpty()) continue;
            GradleProject gradleProject = ((IdeaModule)ideaModules.getAt(0)).getGradleProject();
            while (gradleProject.getParent() != null) {
                gradleProject = gradleProject.getParent();
            }
            ExternalProject externalIncludedRootProject = (ExternalProject)models.getModel((ProjectModel)gradleProject, modelClazz);
            if (externalIncludedRootProject == null) continue;
            DefaultExternalProject wrappedExternalIncludedRootProject = useCustomSerialization ? (DefaultExternalProject)externalIncludedRootProject : new DefaultExternalProject(externalIncludedRootProject);
            wrappedExternalRootProject.getChildProjects().put(wrappedExternalIncludedRootProject.getName(), wrappedExternalIncludedRootProject);
            String compositePrefix = project.getName();
            Map<String, DefaultExternalProject> externalIncludedProjectsMap = GradleProjectResolver.createExternalProjectsMap(compositePrefix, wrappedExternalIncludedRootProject);
            for (IdeaModule ideaModule : ideaModules) {
                ExternalProject externalProject = (ExternalProject)externalIncludedProjectsMap.get(GradleProjectResolverUtil.getModuleId(resolverCtx, ideaModule));
                if (externalProject == null) continue;
                models.addModel((Object)externalProject, ExternalProject.class, (ProjectModel)ideaModule.getGradleProject());
            }
        }
    }

    @NotNull
    private static Map<String, DefaultExternalProject> createExternalProjectsMap(@Nullable String compositePrefix, @Nullable DefaultExternalProject rootExternalProject) {
        DefaultExternalProject externalProject;
        THashMap externalProjectMap = new THashMap();
        if (rootExternalProject == null) {
            THashMap tHashMap = externalProjectMap;
            if (tHashMap == null) {
                GradleProjectResolver.$$$reportNull$$$0(17);
            }
            return tHashMap;
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(rootExternalProject);
        while ((externalProject = (DefaultExternalProject)queue.pollFirst()) != null) {
            String moduleId;
            queue.addAll(externalProject.getChildProjects().values());
            String moduleName = externalProject.getName();
            String qName = externalProject.getQName();
            String string = moduleId = StringUtil.isEmpty((String)qName) || ":".equals(qName) ? moduleName : qName;
            if (compositePrefix != null && externalProject != rootExternalProject) {
                moduleId = compositePrefix + moduleId;
            }
            externalProjectMap.put(moduleId, externalProject);
        }
        THashMap tHashMap = externalProjectMap;
        if (tHashMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(18);
        }
        return tHashMap;
    }

    private static void mergeSourceSetContentRoots(@NotNull Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap, @NotNull ProjectResolverContext resolverCtx) {
        DataNode moduleNode;
        if (moduleMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(19);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(20);
        }
        Factory counterFactory = () -> new Counter();
        HashMap<String, Counter> weightMap = new HashMap<String, Counter>();
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                    ((Counter)ContainerUtil.getOrCreate(weightMap, (Object)file.getPath(), (Factory)counterFactory)).increment();
                }
            }
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                HashSet<String> set = new HashSet<String>();
                for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)sourceSetNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                    for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                        set.add(file.getPath());
                    }
                }
                for (String path : set) {
                    ((Counter)ContainerUtil.getOrCreate(weightMap, (Object)path, (Factory)counterFactory)).increment();
                }
            }
        }
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            ExternalProject externalProject = resolverCtx.getExtraProject((IdeaModule)pair.second, ExternalProject.class);
            if (externalProject == null) continue;
            if (resolverCtx.isResolveModulePerSourceSet()) {
                for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                    GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)sourceSetNode);
                }
                continue;
            }
            GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)moduleNode);
        }
    }

    private static void mergeModuleContentRoots(@NotNull Map<String, Counter> weightMap, @NotNull ExternalProject externalProject, @NotNull DataNode<? extends ModuleData> moduleNode) {
        if (weightMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(21);
        }
        if (externalProject == null) {
            GradleProjectResolver.$$$reportNull$$$0(22);
        }
        if (moduleNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(23);
        }
        File buildDir = externalProject.getBuildDir();
        MultiMap sourceSetRoots = MultiMap.create();
        Collection contentRootNodes = ExternalSystemApiUtil.findAll(moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootNodes.size() <= 1) {
            return;
        }
        for (DataNode contentRootNode : contentRootNodes) {
            File root = new File(((ContentRootData)contentRootNode.getData()).getRootPath());
            if (FileUtil.isAncestor((File)buildDir, (File)root, (boolean)true)) continue;
            while (weightMap.containsKey(root.getParent()) && weightMap.get((Object)root.getParent()).count <= 1) {
                root = root.getParentFile();
            }
            ContentRootData mergedContentRoot = null;
            String rootPath = ExternalSystemApiUtil.toCanonicalPath((String)root.getAbsolutePath());
            HashSet paths = new HashSet(sourceSetRoots.keySet());
            for (String path : paths) {
                if (FileUtil.isAncestor((String)rootPath, (String)path, (boolean)true)) {
                    Collection values = sourceSetRoots.remove((Object)path);
                    if (values != null) {
                        sourceSetRoots.putValues((Object)rootPath, values);
                    }
                } else if (FileUtil.isAncestor((String)path, (String)rootPath, (boolean)false)) {
                    Collection contentRoots = sourceSetRoots.get((Object)path);
                    for (ContentRootData rootData : contentRoots) {
                        if (!StringUtil.equals((CharSequence)rootData.getRootPath(), (CharSequence)path)) continue;
                        mergedContentRoot = rootData;
                        break;
                    }
                    if (mergedContentRoot != null) break;
                    mergedContentRoot = (ContentRootData)contentRoots.iterator().next();
                    break;
                }
                if (sourceSetRoots.size() != 1) continue;
                break;
            }
            if (mergedContentRoot == null) {
                mergedContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, root.getAbsolutePath());
                sourceSetRoots.putValue((Object)mergedContentRoot.getRootPath(), (Object)mergedContentRoot);
            }
            for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                ContentRootData rootData;
                rootData = ((ContentRootData)contentRootNode.getData()).getPaths(externalSystemSourceType).iterator();
                while (rootData.hasNext()) {
                    ContentRootData.SourceRoot sourceRoot = (ContentRootData.SourceRoot)rootData.next();
                    mergedContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                }
            }
            contentRootNode.clear(true);
        }
        for (Map.Entry entry : sourceSetRoots.entrySet()) {
            String rootPath = (String)entry.getKey();
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, rootPath);
            for (ContentRootData rootData : (Collection)entry.getValue()) {
                for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                    Collection roots = rootData.getPaths(externalSystemSourceType);
                    for (ContentRootData.SourceRoot sourceRoot : roots) {
                        ideContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                    }
                }
            }
            moduleNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    @NotNull
    public static GradleProjectResolverExtension createProjectResolverChain(@Nullable GradleExecutionSettings settings) {
        if (settings != null) {
            GradleProjectResolverExtension firstResolver;
            List<ClassHolder<? extends GradleProjectResolverExtension>> extensionClasses = settings.getResolverExtensions();
            if (extensionClasses.isEmpty()) {
                extensionClasses.add(ClassHolder.from(BaseGradleProjectResolverExtension.class));
            }
            ArrayDeque<GradleProjectResolverExtension> extensions = new ArrayDeque<GradleProjectResolverExtension>();
            for (ClassHolder<? extends GradleProjectResolverExtension> holder : extensionClasses) {
                GradleProjectResolverExtension extension;
                try {
                    extension = holder.getTargetClass().newInstance();
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(String.format("Can't instantiate project resolve extension for class '%s'", holder.getTargetClassName()), e);
                }
                GradleProjectResolverExtension previous = (GradleProjectResolverExtension)extensions.peekLast();
                if (previous != null) {
                    previous.setNext(extension);
                    if (previous.getNext() != extension) {
                        throw new AssertionError((Object)("Illegal next resolver got, current resolver class is " + previous.getClass().getName()));
                    }
                }
                extensions.add(extension);
            }
            GradleProjectResolverExtension resolverExtension = firstResolver = (GradleProjectResolverExtension)extensions.peekFirst();
            assert (resolverExtension != null);
            while (resolverExtension.getNext() != null) {
                resolverExtension = resolverExtension.getNext();
            }
            if (!(resolverExtension instanceof BaseGradleProjectResolverExtension)) {
                throw new AssertionError((Object)("Illegal last resolver got of class " + resolverExtension.getClass().getName()));
            }
            final BaseProjectImportErrorHandler baseErrorHandler = new BaseProjectImportErrorHandler();
            AbstractProjectResolverExtension chainWrapper = new AbstractProjectResolverExtension(){

                @Override
                @NotNull
                public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
                    if (error == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (projectPath == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ExternalSystemException friendlyError = super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
                    ExternalSystemException externalSystemException = baseErrorHandler.checkErrorsWithoutQuickFixes(buildEnvironment, error, projectPath, buildFilePath, friendlyError);
                    if (externalSystemException == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return externalSystemException;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "projectPath";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getUserFriendlyError";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getUserFriendlyError";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            chainWrapper.setNext(firstResolver);
            AbstractProjectResolverExtension abstractProjectResolverExtension = chainWrapper;
            if (abstractProjectResolverExtension == null) {
                GradleProjectResolver.$$$reportNull$$$0(24);
            }
            return abstractProjectResolverExtension;
        }
        BaseGradleProjectResolverExtension baseGradleProjectResolverExtension = new BaseGradleProjectResolverExtension();
        if (baseGradleProjectResolverExtension == null) {
            GradleProjectResolver.$$$reportNull$$$0(25);
        }
        return baseGradleProjectResolverExtension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncTaskId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverChain";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleUserHomeDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMap";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weightMap";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDataFunction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProjectInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "exposeCompositeBuild";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createExternalProjectsMap";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectResolverChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectInfo";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProjectInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mergeLibraryAndModuleDependencyData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractExternalProjectModels";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mergeSourceSetContentRoots";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mergeModuleContentRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProjectConnectionDataNodeFunction
    implements Function<ProjectConnection, DataNode<ProjectData>> {
        @NotNull
        private final GradleProjectResolverExtension myProjectResolverChain;
        private final boolean myIsBuildSrcProject;
        private final DefaultProjectResolverContext myResolverContext;

        private ProjectConnectionDataNodeFunction(@NotNull DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
            if (resolverContext == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(0);
            }
            if (projectResolverChain == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(1);
            }
            this.myResolverContext = resolverContext;
            this.myProjectResolverChain = projectResolverChain;
            this.myIsBuildSrcProject = isBuildSrcProject;
        }

        public DataNode<ProjectData> fun(ProjectConnection connection) {
            try {
                GradleProjectResolver.this.myCancellationMap.putValue((Object)this.myResolverContext.getExternalSystemTaskId(), (Object)this.myResolverContext.getCancellationTokenSource());
                this.myResolverContext.setConnection(connection);
                DataNode dataNode = GradleProjectResolver.this.doResolveProjectInfo(this.myResolverContext, this.myProjectResolverChain, this.myIsBuildSrcProject);
                return dataNode;
            }
            catch (RuntimeException e) {
                LOG.info("Gradle project resolve error", (Throwable)e);
                throw this.myProjectResolverChain.getUserFriendlyError(this.myResolverContext.getBuildEnvironment(), e, this.myResolverContext.getProjectPath(), null);
            }
            finally {
                GradleProjectResolver.this.myCancellationMap.remove((Object)this.myResolverContext.getExternalSystemTaskId(), (Object)this.myResolverContext.getCancellationTokenSource());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolverContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectResolverChain";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Counter {
        int count;

        private Counter() {
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }
}

