/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueChecker;
import com.intellij.build.issue.BuildIssueData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class BaseProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    private static final Logger LOG = Logger.getInstance(BaseProjectImportErrorHandler.class);

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        GradleExecutionErrorHandler executionErrorHandler;
        ExternalSystemException exception;
        if (error == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(1);
        }
        if (!(exception = this.doGetUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath, executionErrorHandler = new GradleExecutionErrorHandler(error, projectPath, buildFilePath))).isCauseInitialized()) {
            exception.initCause((Throwable)ObjectUtils.notNull((Object)executionErrorHandler.getRootCause(), (Object)error));
        }
        ExternalSystemException externalSystemException = exception;
        if (externalSystemException == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(2);
        }
        return externalSystemException;
    }

    @ApiStatus.Experimental
    ExternalSystemException checkErrorsWithoutQuickFixes(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath, @NotNull ExternalSystemException e) {
        if (error == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(3);
        }
        if (projectPath == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(4);
        }
        if (e == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(5);
        }
        if (e.getQuickFixes().length > 0 || e instanceof BuildIssueException) {
            return e;
        }
        return this.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
    }

    private ExternalSystemException doGetUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath, @NotNull GradleExecutionErrorHandler executionErrorHandler) {
        String errMessage;
        Throwable errorCause;
        String msg;
        ExternalSystemException friendlyError;
        if (error == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(6);
        }
        if (projectPath == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(7);
        }
        if (executionErrorHandler == null) {
            BaseProjectImportErrorHandler.$$$reportNull$$$0(8);
        }
        if ((friendlyError = executionErrorHandler.getUserFriendlyError()) != null) {
            return friendlyError;
        }
        LOG.debug(String.format("Failed to run Gradle project at '%1$s'", projectPath), error);
        if (error instanceof ProcessCanceledException) {
            return new ExternalSystemException("Project build was cancelled");
        }
        Throwable rootCause = executionErrorHandler.getRootCause();
        String location = executionErrorHandler.getLocation();
        if (location == null && !StringUtil.isEmpty((String)buildFilePath)) {
            location = String.format("Build file: '%1$s'", buildFilePath);
        }
        GradleIssueData issueData = new GradleIssueData(projectPath, error, buildEnvironment, null);
        List<GradleIssueChecker> knownIssuesCheckList = GradleIssueChecker.getKnownIssuesCheckList();
        for (BuildIssueChecker buildIssueChecker : knownIssuesCheckList) {
            BuildIssue buildIssue = buildIssueChecker.check((BuildIssueData)issueData);
            if (buildIssue == null) continue;
            return new BuildIssueException(buildIssue);
        }
        if (rootCause instanceof UnsupportedVersionException) {
            String msg2 = "You are using unsupported version of Gradle.";
            msg2 = msg2 + "\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            return this.createUserFriendlyError(msg2, null, new String[0]);
        }
        String rootCauseMessage = rootCause.getMessage();
        if (rootCause.getClass().getName().equals(CommandLineArgumentException.class.getName()) && StringUtil.contains((CharSequence)rootCauseMessage, (CharSequence)"Unknown command-line option '--include-build'")) {
            String string = String.format("Gradle composite build support available for Gradle 3.1 or better version (<a href=\"%s\">Fix Gradle settings</a>)", "open_gradle_settings");
            return this.createUserFriendlyError(string, location, "open_gradle_settings");
        }
        String string = rootCause.toString();
        if (StringUtil.startsWith((CharSequence)string, (CharSequence)"org.gradle.api.internal.MissingMethodException")) {
            String method = this.parseMissingMethod(string);
            String msg4 = "Build script error, unsupported Gradle DSL method found: '" + method + "'!";
            msg4 = msg4 + "\n\nPossible causes could be:  ";
            msg4 = msg4 + String.format("%s  - you are using Gradle version where the method is absent (<a href=\"%s\">Fix Gradle settings</a>)", Character.valueOf('\n'), "open_gradle_settings");
            msg4 = msg4 + String.format("%s  - or there is a mistake in a build script (<a href=\"%s\">Goto source</a>)", Character.valueOf('\n'), "goto_source");
            return this.createUserFriendlyError(msg4, location, "open_gradle_settings", "goto_source");
        }
        if (rootCause instanceof OutOfMemoryError) {
            msg = "Out of memory";
            if (rootCauseMessage != null && !rootCauseMessage.isEmpty()) {
                msg = msg + ": " + rootCauseMessage;
            }
            if (msg.endsWith("Java heap space")) {
                msg = msg + ". Configure Gradle memory settings using '-Xmx' JVM option (e.g. '-Xmx2048m'.)";
            } else if (!msg.endsWith(".")) {
                msg = msg + ".";
            }
            msg = msg + "\n\nPlease fix the project's Gradle settings.";
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if (rootCause instanceof ClassNotFoundException) {
            msg = String.format("Unable to load class '%1$s'.", rootCauseMessage) + "\n\n" + "This is an unexpected error. Please file a bug containing the idea.log file.";
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if (rootCause instanceof UnknownHostException) {
            msg = String.format("Unknown host '%1$s'.", rootCauseMessage) + "\n\n" + "Please ensure the host name is correct. " + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if (rootCause instanceof ConnectException && (msg = rootCauseMessage) != null && msg.contains("timed out")) {
            msg = msg + (msg.endsWith(".") ? " " : ". ");
            msg = msg + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if (rootCause instanceof FileNotFoundException && (errorCause = error.getCause()) instanceof IllegalArgumentException && GradleExecutionErrorHandler.DOWNLOAD_GRADLE_DISTIBUTION_ERROR_PATTERN.matcher(errorCause.getMessage()).matches()) {
            return this.createUserFriendlyError(errorCause.getMessage(), null, new String[0]);
        }
        if (rootCause instanceof RuntimeException && (msg = rootCauseMessage) != null && GradleExecutionErrorHandler.UNSUPPORTED_GRADLE_VERSION_ERROR_PATTERN.matcher(msg).matches()) {
            if (!msg.endsWith(".")) {
                msg = msg + ".";
            }
            msg = msg + "\n\nPlease fix the project's Gradle settings.";
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if (rootCauseMessage == null || ApplicationManager.getApplication().isUnitTestMode()) {
            StringWriter writer = new StringWriter();
            if (rootCauseMessage != null) {
                writer.write(rootCauseMessage + "\n");
            }
            rootCause.printStackTrace(new PrintWriter(writer));
            errMessage = writer.toString();
        } else {
            errMessage = rootCauseMessage;
        }
        return this.createUserFriendlyError(errMessage, location, new String[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFriendlyError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyError";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkErrorsWithoutQuickFixes";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doGetUserFriendlyError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

