/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.amazon.ion.IonType;
import com.google.gson.GsonBuilder;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerConfiguration;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMapImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THash;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClassSetProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.IntelliJProjectSettings;
import org.jetbrains.plugins.gradle.model.IntelliJSettings;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestsModel;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.builder.ModelBuildScriptClasspathBuilderImpl;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=0x7FFFFFFF)
public class BaseGradleProjectResolverExtension
implements GradleProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(BaseGradleProjectResolverExtension.class);
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private ProjectResolverContext resolverCtx;
    @NotNull
    private final BaseProjectImportErrorHandler myErrorHandler = new BaseProjectImportErrorHandler();

    @Override
    public void setProjectResolverContext(@NotNull ProjectResolverContext projectResolverContext) {
        if (projectResolverContext == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(0);
        }
        this.resolverCtx = projectResolverContext;
    }

    @Override
    public void setNext(@NotNull GradleProjectResolverExtension next) {
        if (next == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(1);
        }
    }

    @Override
    @Nullable
    public GradleProjectResolverExtension getNext() {
        return null;
    }

    @Override
    @NotNull
    public ProjectData createProject() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        ExternalProject externalProject = this.resolverCtx.getExtraProject(ExternalProject.class);
        String projectName = externalProject != null ? externalProject.getName() : this.resolverCtx.getModels().getIdeaProject().getName();
        ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectDirPath, projectDirPath);
        if (projectData == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(2);
        }
        return projectData;
    }

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        IntelliJSettings intellijSettings;
        ExternalProject externalProject;
        if (gradleProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(3);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(4);
        }
        if ((externalProject = this.resolverCtx.getExtraProject(ExternalProject.class)) != null) {
            ideProject.createChild(ExternalProjectDataCache.KEY, (Object)externalProject);
            ((ProjectData)ideProject.getData()).setDescription(externalProject.getDescription());
        }
        if ((intellijSettings = (IntelliJSettings)this.resolverCtx.getExtraProject(IntelliJProjectSettings.class)) != null) {
            ideProject.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
    }

    @Override
    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(5);
        }
        if (projectDataNode == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(6);
        }
        DataNode<ModuleData> mainModuleNode = GradleProjectResolverUtil.createMainModule(this.resolverCtx, gradleModule, projectDataNode);
        ModuleData mainModuleData = (ModuleData)mainModuleNode.getData();
        String mainModuleConfigPath = mainModuleData.getLinkedExternalProjectPath();
        String mainModuleFileDirectoryPath = mainModuleData.getModuleFileDirectoryPath();
        String jdkName = BaseGradleProjectResolverExtension.getJdkName(gradleModule);
        String[] moduleGroup = null;
        if (!this.resolverCtx.isUseQualifiedModuleNames()) {
            moduleGroup = this.getIdeModuleGroup(mainModuleData.getInternalName(), gradleModule);
            mainModuleData.setIdeModuleGroup(moduleGroup);
        }
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (this.resolverCtx.isResolveModulePerSourceSet() && externalProject != null) {
            for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
                String moduleId = GradleProjectResolverUtil.getModuleId(this.resolverCtx, gradleModule, sourceSet);
                String moduleExternalName = gradleModule.getName() + ":" + sourceSet.getName();
                String moduleInternalName = GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, sourceSet.getName(), this.resolverCtx);
                GradleSourceSetData sourceSetData = new GradleSourceSetData(moduleId, moduleExternalName, moduleInternalName, mainModuleFileDirectoryPath, mainModuleConfigPath);
                sourceSetData.setGroup(externalProject.getGroup());
                if ("main".equals(sourceSet.getName())) {
                    sourceSetData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
                }
                sourceSetData.setVersion(externalProject.getVersion());
                sourceSetData.setIdeModuleGroup(moduleGroup);
                sourceSetData.setSourceCompatibility(sourceSet.getSourceCompatibility());
                sourceSetData.setTargetCompatibility(sourceSet.getTargetCompatibility());
                sourceSetData.setSdkName(jdkName);
                THashSet artifacts = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY);
                if ("main".equals(sourceSet.getName())) {
                    Set defaultArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("default");
                    if (defaultArtifacts != null) {
                        artifacts.addAll(defaultArtifacts);
                    }
                } else if ("test".equals(sourceSet.getName())) {
                    sourceSetData.setProductionModuleId(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, "main", this.resolverCtx));
                    Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                    if (testsArtifacts != null) {
                        artifacts.addAll(testsArtifacts);
                    }
                }
                artifacts.addAll(sourceSet.getArtifacts());
                for (ExternalSourceDirectorySet directorySet : sourceSet.getSources().values()) {
                    artifacts.addAll(directorySet.getGradleOutputDirs());
                }
                sourceSetData.setArtifacts(new ArrayList(artifacts));
                DataNode sourceSetDataNode = mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)sourceSetData);
                Map sourceSetMap = (Map)projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
                assert (sourceSetMap != null);
                sourceSetMap.put(moduleId, Pair.create((Object)sourceSetDataNode, (Object)sourceSet));
            }
        } else {
            try {
                IdeaJavaLanguageSettings languageSettings = gradleModule.getJavaLanguageSettings();
                if (languageSettings != null) {
                    if (languageSettings.getLanguageLevel() != null) {
                        mainModuleData.setSourceCompatibility(languageSettings.getLanguageLevel().toString());
                    }
                    if (languageSettings.getTargetBytecodeVersion() != null) {
                        mainModuleData.setTargetCompatibility(languageSettings.getTargetBytecodeVersion().toString());
                    }
                }
                mainModuleData.setSdkName(jdkName);
            }
            catch (UnsupportedMethodException languageSettings) {
                // empty catch block
            }
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        if (StringUtil.equals((CharSequence)mainModuleData.getLinkedExternalProjectPath(), (CharSequence)projectData.getLinkedExternalProjectPath())) {
            projectData.setGroup(mainModuleData.getGroup());
            projectData.setVersion(mainModuleData.getVersion());
        }
        DataNode<ModuleData> dataNode = mainModuleNode;
        if (dataNode == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(7);
        }
        return dataNode;
    }

    @NotNull
    protected String[] getIdeModuleGroup(String moduleName, IdeaModule gradleModule) {
        String[] moduleGroup;
        String[] stringArray;
        boolean isRootModule;
        String gradlePath = gradleModule.getGradleProject().getPath();
        String rootName = gradleModule.getProject().getName();
        boolean bl = isRootModule = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath);
        if (isRootModule) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = moduleName;
        } else {
            stringArray = moduleGroup = (rootName + gradlePath).split(":");
        }
        if (moduleGroup == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(8);
        }
        return moduleGroup;
    }

    @Nullable
    private static String getJdkName(@NotNull IdeaModule gradleModule) {
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(9);
        }
        try {
            return gradleModule.getJdkName();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectImportAction.AllModels models;
        ExternalTestsModel externalTestsModel;
        IntelliJSettings intellijSettings;
        GradleExtensions gradleExtensions;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(10);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(11);
        }
        if ((gradleExtensions = this.resolverCtx.getExtraProject(gradleModule, GradleExtensions.class)) != null) {
            boolean useCustomSerialization = Registry.is((String)"gradle.tooling.custom.serializer", (boolean)true);
            DefaultGradleExtensions extensions = useCustomSerialization ? (DefaultGradleExtensions)gradleExtensions : new DefaultGradleExtensions(gradleExtensions);
            ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
            if (externalProject != null) {
                extensions.addTasks(externalProject.getTasks().values());
            }
            ideModule.createChild(GradleExtensionsDataService.KEY, (Object)extensions);
        }
        if ((intellijSettings = this.resolverCtx.getExtraProject(gradleModule, IntelliJSettings.class)) != null) {
            ideModule.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
        if ((externalTestsModel = (ExternalTestsModel)(models = this.resolverCtx.getModels()).getModel((ProjectModel)gradleModule, ExternalTestsModel.class)) != null) {
            for (ExternalTestSourceMapping testSourceMapping : externalTestsModel.getTestSourceMappings()) {
                String testName = testSourceMapping.getTestName();
                String testTaskName = testSourceMapping.getTestTaskPath();
                String cleanTestTaskName = testSourceMapping.getCleanTestTaskPath();
                Set sourceFolders = testSourceMapping.getSourceFolders();
                TestData testData = new TestData(GradleConstants.SYSTEM_ID, testName, testTaskName, cleanTestTaskName, sourceFolders);
                ideModule.createChild(ProjectKeys.TEST, (Object)testData);
            }
        }
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ExternalProject externalProject;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(12);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(13);
        }
        if ((externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null) {
            this.addExternalProjectContentRoots(gradleModule, ideModule, externalProject);
        } else if (this.resolverCtx.isResolveModulePerSourceSet()) {
            LOG.error("External Project model is missing for module-per-sourceSet import mode. Please, check import log for error messages.");
        }
        PathPrefixTreeMapImpl contentRootIndex = new PathPrefixTreeMapImpl();
        for (Object contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            contentRootIndex.set(contentRootData.getRootPath(), (Object)contentRootData);
        }
        DomainObjectSet contentRoots = gradleModule.getContentRoots();
        if (contentRoots == null) {
            return;
        }
        for (IdeaContentRoot gradleContentRoot : contentRoots) {
            Set excluded;
            File rootDirectory;
            if (gradleContentRoot == null || (rootDirectory = gradleContentRoot.getRootDirectory()) == null) continue;
            boolean oldGradle = false;
            String contentRootPath = FileUtil.toCanonicalPath((String)rootDirectory.getAbsolutePath());
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, contentRootPath);
            contentRootIndex.set(contentRootPath, (Object)ideContentRoot);
            if (!this.resolverCtx.isResolveModulePerSourceSet()) {
                List testResourceDirectories;
                List resourceDirectories;
                List testDirectories;
                List sourceDirectories;
                block15: {
                    sourceDirectories = gradleContentRoot.getSourceDirectories().getAll();
                    testDirectories = gradleContentRoot.getTestDirectories().getAll();
                    resourceDirectories = Collections.emptyList();
                    testResourceDirectories = Collections.emptyList();
                    try {
                        Set<File> notResourceDirs = BaseGradleProjectResolverExtension.collectExplicitNonResourceDirectories(externalProject);
                        resourceDirectories = gradleContentRoot.getResourceDirectories().getAll();
                        BaseGradleProjectResolverExtension.removeDuplicateResources(sourceDirectories, resourceDirectories, notResourceDirs);
                        testResourceDirectories = gradleContentRoot.getTestResourceDirectories().getAll();
                        BaseGradleProjectResolverExtension.removeDuplicateResources(testDirectories, testResourceDirectories, notResourceDirs);
                    }
                    catch (UnsupportedMethodException e) {
                        oldGradle = true;
                        LOG.debug(e.getMessage());
                        if (externalProject != null) break block15;
                        BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getSourceDirectories());
                        BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getTestDirectories());
                    }
                }
                if (!oldGradle) {
                    BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, sourceDirectories);
                    BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, testDirectories);
                    BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.RESOURCE, resourceDirectories);
                    BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST_RESOURCE, testResourceDirectories);
                }
            }
            if ((excluded = gradleContentRoot.getExcludeDirectories()) == null) continue;
            for (File file : excluded) {
                ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, file.getAbsolutePath());
            }
        }
        LinkedHashSet<String> existsContentRoots = new LinkedHashSet<String>();
        for (DataNode contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            existsContentRoots.add(contentRootData.getRootPath());
        }
        for (ContentRootData ideContentRoot : contentRootIndex.getValues()) {
            if (existsContentRoots.contains(ideContentRoot.getRootPath())) continue;
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    private void addExternalProjectContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull ExternalProject externalProject) {
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(14);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(15);
        }
        if (externalProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(16);
        }
        BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

            @Override
            public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                if (dataNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (sourceSet == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                    ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                    ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                    for (File file : sourceDirectorySet.getSrcDirs()) {
                        ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, file.getAbsolutePath());
                        ideContentRoot.storePath(sourceType, file.getAbsolutePath());
                        dataNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceSet";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void removeDuplicateResources(@NotNull List<? extends IdeaSourceDirectory> sourceDirectories, @NotNull List<? extends IdeaSourceDirectory> resourceDirectories, @NotNull Set<File> notResourceDirs) {
        if (sourceDirectories == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(17);
        }
        if (resourceDirectories == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(18);
        }
        if (notResourceDirs == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(19);
        }
        resourceDirectories.removeIf(ideaSourceDirectory -> notResourceDirs.contains(ideaSourceDirectory.getDirectory()));
        BaseGradleProjectResolverExtension.removeAll(sourceDirectories, resourceDirectories);
    }

    @NotNull
    private static Set<File> collectExplicitNonResourceDirectories(@Nullable ExternalProject externalProject) {
        if (externalProject == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(20);
            }
            return set;
        }
        Set set = (Set)externalProject.getSourceSets().values().stream().flatMap(ss -> ss.getSources().entrySet().stream().filter(e -> !((IExternalSystemSourceType)e.getKey()).isResource()).flatMap(e -> ((ExternalSourceDirectorySet)e.getValue()).getSrcDirs().stream())).collect(Collectors.toCollection(() -> ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY)));
        if (set == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(21);
        }
        return set;
    }

    private static void removeAll(List<? extends IdeaSourceDirectory> list, List<? extends IdeaSourceDirectory> toRemove) {
        Set files = toRemove.stream().map(o -> o.getDirectory()).collect(Collectors.toSet());
        list.removeIf(o -> files.contains(o.getDirectory()));
    }

    private static void processSourceSets(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> ideModule, @NotNull SourceSetsProcessor processor) {
        if (resolverCtx == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(22);
        }
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(23);
        }
        if (externalProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(24);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(26);
        }
        HashMap<String, DataNode> sourceSetsMap = new HashMap<String, DataNode>();
        for (DataNode dataNode : ExternalSystemApiUtil.findAll(ideModule, GradleSourceSetData.KEY)) {
            sourceSetsMap.put(((GradleSourceSetData)((Object)dataNode.getData())).getId(), dataNode);
        }
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            DataNode moduleDataNode;
            if (sourceSet == null || sourceSet.getSources().isEmpty()) continue;
            String moduleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule, sourceSet);
            DataNode dataNode = moduleDataNode = sourceSetsMap.isEmpty() ? ideModule : (DataNode)sourceSetsMap.get(moduleId);
            if (moduleDataNode == null) continue;
            processor.process((DataNode<? extends ModuleData>)moduleDataNode, sourceSet);
        }
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        boolean inheritOutputDirs;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(27);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(28);
        }
        ModuleData moduleData = (ModuleData)ideModule.getData();
        moduleData.useExternalCompilerOutput(this.resolverCtx.isDelegatedBuild());
        File ideaOutDir = new File(moduleData.getLinkedExternalProjectPath(), "out");
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (this.resolverCtx.isResolveModulePerSourceSet() && externalProject != null) {
            DataNode projectDataNode = ideModule.getDataNode(ProjectKeys.PROJECT);
            assert (projectDataNode != null);
            final Map moduleOutputsMap = (Map)projectDataNode.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
            assert (moduleOutputsMap != null);
            final HashSet outputDirs = new HashSet();
            BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    MultiMap gradleOutputMap;
                    if (dataNode == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (sourceSet == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((gradleOutputMap = (MultiMap)dataNode.getUserData(GradleProjectResolver.GRADLE_OUTPUTS)) == null) {
                        gradleOutputMap = MultiMap.create();
                        dataNode.putUserData(GradleProjectResolver.GRADLE_OUTPUTS, (Object)gradleOutputMap);
                    }
                    ModuleData moduleData = (ModuleData)dataNode.getData();
                    moduleData.useExternalCompilerOutput(BaseGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild());
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        File ideOutputDir = BaseGradleProjectResolverExtension.getIdeOutputDir(sourceDirectorySet);
                        File gradleOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(sourceDirectorySet);
                        File outputDir = BaseGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild() ? gradleOutputDir : ideOutputDir;
                        moduleData.setCompileOutputPath(sourceType, ideOutputDir == null ? null : ideOutputDir.getAbsolutePath());
                        moduleData.setExternalCompilerOutputPath(sourceType, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                        moduleData.setInheritProjectCompileOutputPath(sourceDirectorySet.isCompilerOutputPathInherited());
                        if (outputDir == null) continue;
                        outputDirs.add(outputDir.getPath());
                        for (File file : sourceDirectorySet.getGradleOutputDirs()) {
                            String gradleOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)file.getAbsolutePath());
                            gradleOutputMap.putValue((Object)sourceType, (Object)gradleOutputPath);
                            if (file.getPath().equals(outputDir.getPath())) continue;
                            moduleOutputsMap.put(gradleOutputPath, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataNode";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceSet";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$2";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (outputDirs.stream().anyMatch(path -> FileUtil.isAncestor((File)ideaOutDir, (File)new File((String)path), (boolean)false))) {
                BaseGradleProjectResolverExtension.excludeOutDir(ideModule, ideaOutDir);
            }
            return;
        }
        IdeaCompilerOutput moduleCompilerOutput = gradleModule.getCompilerOutput();
        boolean bl = inheritOutputDirs = moduleCompilerOutput != null && moduleCompilerOutput.getInheritOutputDirs();
        if (moduleCompilerOutput != null) {
            File outputDir = moduleCompilerOutput.getOutputDir();
            if (outputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getAbsolutePath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, new File(ideaOutDir, "production/classes").getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, new File(ideaOutDir, "production/resources").getAbsolutePath());
                if (externalProject != null) {
                    File gradleOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.SOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                    File gradleResourceOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getAbsolutePath());
                }
            }
            File testOutputDir = moduleCompilerOutput.getTestOutputDir();
            if (testOutputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getAbsolutePath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, new File(ideaOutDir, "test/classes").getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, new File(ideaOutDir, "test/resources").getAbsolutePath());
                if (externalProject != null) {
                    File gradleOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                    File gradleResourceOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST_RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getAbsolutePath());
                }
            }
            if (!(this.resolverCtx.isDelegatedBuild() || inheritOutputDirs || outputDir != null && testOutputDir != null)) {
                BaseGradleProjectResolverExtension.excludeOutDir(ideModule, ideaOutDir);
            }
        }
        moduleData.setInheritProjectCompileOutputPath(inheritOutputDirs);
    }

    @Nullable
    private static File getGradleOutputDir(@NotNull ExternalProject externalProject, @NotNull String sourceSetName, @NotNull ExternalSystemSourceType sourceType) {
        ExternalSourceSet sourceSet;
        if (externalProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(29);
        }
        if (sourceSetName == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(30);
        }
        if (sourceType == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(31);
        }
        if ((sourceSet = (ExternalSourceSet)externalProject.getSourceSets().get(sourceSetName)) == null) {
            return null;
        }
        return BaseGradleProjectResolverExtension.getGradleOutputDir((ExternalSourceDirectorySet)sourceSet.getSources().get(sourceType));
    }

    @Nullable
    private static File getIdeOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getOutputDir();
    }

    @Nullable
    private static File getGradleOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getGradleOutputDirs().stream().findFirst().orElse(null);
    }

    private static void excludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        ContentRootData excludedContentRootData;
        DataNode contentRootDataDataNode;
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(32);
        }
        if ((contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) == null || !FileUtil.isAncestor((File)new File(((ContentRootData)contentRootDataDataNode.getData()).getRootPath()), (File)ideaOutDir, (boolean)false)) {
            excludedContentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, ideaOutDir.getAbsolutePath());
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)excludedContentRootData);
        } else {
            excludedContentRootData = (ContentRootData)contentRootDataDataNode.getData();
        }
        excludedContentRootData.storePath(ExternalSystemSourceType.EXCLUDED, ideaOutDir.getAbsolutePath());
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, final @NotNull DataNode<ProjectData> ideProject) {
        ExternalSystemTaskId taskId;
        Project project;
        List dependencies;
        ExternalProject externalProject;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(33);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(34);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(35);
        }
        if ((externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null) {
            final Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
            final Map artifactsMap = (Map)ideProject.getUserData(GradleProjectResolver.CONFIGURATION_ARTIFACTS);
            assert (artifactsMap != null);
            if (this.resolverCtx.isResolveModulePerSourceSet()) {
                assert (sourceSetMap != null);
                BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                    @Override
                    public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                        if (dataNode == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (sourceSet == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        GradleProjectResolverUtil.buildDependencies(BaseGradleProjectResolverExtension.this.resolverCtx, sourceSetMap, artifactsMap, dataNode, sourceSet.getDependencies(), (DataNode<ProjectData>)ideProject);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "dataNode";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "sourceSet";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension$3";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                return;
            }
        }
        if ((dependencies = gradleModule.getDependencies().getAll()) == null) {
            return;
        }
        ArrayList<String> orphanModules = new ArrayList<String>();
        HashMap<String, ModuleData> modulesIndex = new HashMap<String, ModuleData>();
        for (DataNode dataNode : ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectKeys.MODULE)) {
            modulesIndex.put(((ModuleData)dataNode.getData()).getExternalName(), (ModuleData)dataNode.getData());
        }
        for (int i = 0; i < dependencies.size(); ++i) {
            ModuleDependencyData d;
            IdeaDependency dependency = (IdeaDependency)dependencies.get(i);
            if (dependency == null) continue;
            DependencyScope scope = BaseGradleProjectResolverExtension.parseScope(dependency.getScope());
            if (dependency instanceof IdeaModuleDependency) {
                d = BaseGradleProjectResolverExtension.buildDependency(this.resolverCtx, ideModule, (IdeaModuleDependency)dependency, modulesIndex);
                d.setExported(dependency.getExported());
                if (scope != null) {
                    d.setScope(scope);
                }
                d.setOrder(i);
                ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)d);
                ModuleData targetModule = (ModuleData)d.getTarget();
                if (!targetModule.getId().isEmpty() || !targetModule.getLinkedExternalProjectPath().isEmpty()) continue;
                orphanModules.add(targetModule.getExternalName());
                continue;
            }
            if (!(dependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            d = this.buildDependency(gradleModule, ideModule, (IdeaSingleEntryLibraryDependency)dependency, ideProject);
            d.setExported(dependency.getExported());
            if (scope != null) {
                d.setScope(scope);
            }
            d.setOrder(i);
            ideModule.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)d);
        }
        if (!orphanModules.isEmpty() && (project = (taskId = this.resolverCtx.getExternalSystemTaskId()).findProject()) != null) {
            String msg = "Can't find the following module" + (orphanModules.size() > 1 ? "s" : "") + ": " + StringUtil.join(orphanModules, (String)", ") + "\nIt can be caused by composite build configuration inside your *.gradle scripts with Gradle version older than 3.3.\nTry Gradle 3.3 or better or enable 'Create separate module per source set' option";
            NotificationData notification2 = new NotificationData("Gradle project structure problems", msg, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(taskId.getProjectSystemId(), notification2);
        }
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        boolean isFlatProject;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(36);
        }
        if (ideModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(37);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(38);
        }
        ArrayList<TaskData> tasks = new ArrayList<TaskData>();
        String moduleConfigPath = ((ModuleData)ideModule.getData()).getLinkedExternalProjectPath();
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        String rootProjectPath = ((ProjectData)ideProject.getData()).getLinkedExternalProjectPath();
        try {
            GradleBuild build = this.resolverCtx.getExtraProject(gradleModule, GradleBuild.class);
            if (build != null) {
                rootProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)build.getRootProject().getProjectDirectory().getCanonicalPath());
            }
        }
        catch (IOException e) {
            LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
        }
        boolean bl = isFlatProject = !FileUtil.isAncestor((String)rootProjectPath, (String)moduleConfigPath, (boolean)false);
        if (externalProject != null) {
            for (ExternalTask task : externalProject.getTasks().values()) {
                String taskName = isFlatProject ? task.getQName() : task.getName();
                String taskGroup = task.getGroup();
                if (taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
                String taskPath = isFlatProject ? rootProjectPath : moduleConfigPath;
                TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, taskPath, task.getDescription());
                taskData.setGroup(taskGroup);
                taskData.setType(task.getType());
                taskData.setTest(task.isTest());
                ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
                taskData.setInherited(StringUtil.equals((CharSequence)task.getName(), (CharSequence)task.getQName()));
                tasks.add(taskData);
            }
            ArrayList<TaskData> arrayList = tasks;
            if (arrayList == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(39);
            }
            return arrayList;
        }
        for (GradleTask task : gradleModule.getGradleProject().getTasks()) {
            String taskName = task.getName();
            String taskGroup = BaseGradleProjectResolverExtension.getTaskGroup(task);
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task.getDescription());
            taskData.setGroup(taskGroup);
            ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
            tasks.add(taskData);
        }
        ArrayList<TaskData> arrayList = tasks;
        if (arrayList == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @Nullable
    private static String getTaskGroup(GradleTask task) {
        String taskGroup;
        try {
            taskGroup = task.getGroup();
        }
        catch (UnsupportedMethodException e) {
            taskGroup = null;
        }
        return taskGroup;
    }

    @Override
    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set result = ContainerUtil.set((Object[])new Class[]{GradleBuild.class, ModuleExtendedModel.class});
        result.add(BuildScriptClasspathModel.class);
        result.add(GradleExtensions.class);
        result.add(ExternalProject.class);
        result.add(ExternalTestsModel.class);
        result.add(IntelliJProjectSettings.class);
        result.add(IntelliJSettings.class);
        Set set = result;
        if (set == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(41);
        }
        return set;
    }

    @Override
    @NotNull
    public ProjectImportModelProvider getModelProvider() {
        ClassSetProjectImportModelProvider classSetProjectImportModelProvider = new ClassSetProjectImportModelProvider(this.getExtraProjectModelClasses());
        if (classSetProjectImportModelProvider == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(42);
        }
        return classSetProjectImportModelProvider;
    }

    @Override
    @NotNull
    public Set<Class> getToolingExtensionsClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{ExternalSystemSourceType.class, ProjectImportAction.class, ModelBuildScriptClasspathBuilderImpl.class, Multimap.class, GsonBuilder.class, ShortTypeHandling.class, THash.class, IonType.class, SystemInfoRt.class});
        if (set == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(43);
        }
        return set;
    }

    @Override
    public Set<Class> getTargetTypes() {
        return ContainerUtil.set((Object[])new Class[]{ExternalProjectDependency.class, ExternalLibraryDependency.class, FileCollectionDependency.class, UnresolvedExternalDependency.class});
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            List hosts;
            ArrayList<Pair<String, String>> extraJvmArgs = new ArrayList<Pair<String, String>>();
            HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
            if (!StringUtil.isEmpty((String)httpConfigurable.PROXY_EXCEPTIONS) && !(hosts = StringUtil.split((String)httpConfigurable.PROXY_EXCEPTIONS, (String)",")).isEmpty()) {
                String nonProxyHosts = StringUtil.join((Collection)hosts, (Function)StringUtil.TRIMMER, (String)"|");
                extraJvmArgs.add((Pair<String, String>)Pair.pair((Object)"http.nonProxyHosts", (Object)nonProxyHosts));
                extraJvmArgs.add((Pair<String, String>)Pair.pair((Object)"https.nonProxyHosts", (Object)nonProxyHosts));
            }
            if (httpConfigurable.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)httpConfigurable.getProxyLogin())) {
                extraJvmArgs.add(Pair.pair((Object)"http.proxyUser", (Object)httpConfigurable.getProxyLogin()));
                extraJvmArgs.add((Pair<String, String>)Pair.pair((Object)"https.proxyUser", (Object)httpConfigurable.getProxyLogin()));
                String plainProxyPassword = httpConfigurable.getPlainProxyPassword();
                extraJvmArgs.add((Pair<String, String>)Pair.pair((Object)"http.proxyPassword", (Object)plainProxyPassword));
                extraJvmArgs.add((Pair<String, String>)Pair.pair((Object)"https.proxyPassword", (Object)plainProxyPassword));
            }
            extraJvmArgs.addAll(httpConfigurable.getJvmProperties(false, null));
            ArrayList<Pair<String, String>> arrayList = extraJvmArgs;
            if (arrayList == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(44);
            }
            return arrayList;
        }
        List<Pair<String, String>> list = Collections.emptyList();
        if (list == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(45);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getExtraCommandLineArgs() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(46);
        }
        return list;
    }

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        if (error == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(47);
        }
        if (projectPath == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(48);
        }
        ExternalSystemException externalSystemException = this.myErrorHandler.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
        if (externalSystemException == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(49);
        }
        return externalSystemException;
    }

    @Override
    public void preImportCheck() {
    }

    @Override
    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull Consumer<String> initScriptConsumer) {
        if (taskNames == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(50);
        }
        if (initScriptConsumer == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(51);
        }
        if (!StringUtil.isEmpty((String)jvmParametersSetup)) {
            ForkedDebuggerConfiguration forkedDebuggerSetup = ForkedDebuggerConfiguration.parse((String)jvmParametersSetup);
            if (forkedDebuggerSetup != null) {
                this.setupDebugForAllJvmForkedTasks(initScriptConsumer, forkedDebuggerSetup.getForkSocketPort());
            } else {
                String names = "[\"" + StringUtil.join(taskNames, (String)"\", \"") + "\"]";
                String jvmArgs = Arrays.stream(ParametersListUtil.parseToArray((String)jvmParametersSetup)).map(s -> '\'' + s.trim().replace("\\", "\\\\") + '\'').collect(Collectors.joining(" << "));
                String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task instanceof JavaForkOptions && (" + names + ".contains(task.name) || " + names + ".contains(task.path))) {", "        def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib:jdwp') && !it?.startsWith('-Xrunjdwp')}", "        jvmArgs << " + jvmArgs, "        task.jvmArgs = jvmArgs", "    }}"};
                String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
                initScriptConsumer.consume((Object)script);
            }
        }
        String testEventListenerDefinition = this.loadTestEventListenerDefinition();
        initScriptConsumer.consume((Object)testEventListenerDefinition);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadTestEventListenerDefinition() {
        try (InputStream stream = this.getClass().getResourceAsStream("/org/jetbrains/plugins/gradle/IJTestLogger.groovy");){
            String string = StreamUtil.readText((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return "";
        }
    }

    public void setupDebugForAllJvmForkedTasks(@NotNull Consumer<? super String> initScriptConsumer, int debugPort) {
        if (initScriptConsumer == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(52);
        }
        String esRtJarPath = PathUtil.getCanonicalPath((String)PathManager.getJarPathForClass(ExternalSystemSourceType.class));
        String[] lines = new String[]{"initscript {", "  dependencies {", "    classpath files(\"" + esRtJarPath + "\")", "  }", "}", "gradle.taskGraph.beforeTask { Task task ->", " if (task instanceof org.gradle.api.tasks.testing.Test) {", "  task.maxParallelForks = 1", "  task.forkEvery = 0", " }", " if (task instanceof JavaForkOptions) {", "  def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib:jdwp') && !it?.startsWith('-Xrunjdwp')}", "  jvmArgs << com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerHelper.setupDebugger(task.path, " + debugPort + ")", "  task.jvmArgs = jvmArgs", " }", "}", "gradle.taskGraph.afterTask { Task task ->", "    if (task instanceof JavaForkOptions) {", "        com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerHelper.processFinished(task.path, " + debugPort + ")", "    }", "}"};
        String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
        initScriptConsumer.consume((Object)script);
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
        if (parameters == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(53);
        }
    }

    private static void populateContentRoot(@NotNull PathPrefixTreeMap<ContentRootData> contentRootIndex, @NotNull ExternalSystemSourceType type, @Nullable Iterable<? extends IdeaSourceDirectory> dirs) throws IllegalArgumentException {
        if (contentRootIndex == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(54);
        }
        if (type == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(55);
        }
        if (dirs == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : dirs) {
            ExternalSystemSourceType dirSourceType = type;
            try {
                if (ideaSourceDirectory.isGenerated() && !dirSourceType.isGenerated()) {
                    ExternalSystemSourceType generatedType = ExternalSystemSourceType.from((boolean)dirSourceType.isTest(), (boolean)ideaSourceDirectory.isGenerated(), (boolean)dirSourceType.isResource(), (boolean)dirSourceType.isExcluded());
                    dirSourceType = generatedType != null ? generatedType : dirSourceType;
                }
            }
            catch (UnsupportedMethodException e) {
                LOG.warn(e.getMessage());
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            catch (Throwable e) {
                LOG.debug(e);
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            String path = FileUtil.toCanonicalPath((String)ideaSourceDirectory.getDirectory().getAbsolutePath());
            if (contentRootIndex.getAllAncestorKeys(path).isEmpty()) {
                ContentRootData contentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, path);
                contentRootIndex.set(path, (Object)contentRootData);
            }
            List ancestors = contentRootIndex.getAllAncestorKeys(path);
            String contentRootPath = (String)ancestors.get(ancestors.size() - 1);
            ContentRootData contentRoot = (ContentRootData)contentRootIndex.get(contentRootPath);
            assert (contentRoot != null);
            contentRoot.storePath(dirSourceType, path);
        }
    }

    private static void printToolingProxyDiagnosticInfo(@Nullable Object obj) {
        if (!LOG.isDebugEnabled() || obj == null) {
            return;
        }
        LOG.debug(String.format("obj: %s", obj));
        Class<?> aClass = obj.getClass();
        LOG.debug(String.format("obj class: %s", aClass));
        LOG.debug(String.format("classloader: %s", aClass.getClassLoader()));
        for (Method m : aClass.getDeclaredMethods()) {
            LOG.debug(String.format("obj m: %s", m));
        }
        if (obj instanceof Proxy) {
            try {
                Field hField = ReflectionUtil.findField(obj.getClass(), null, (String)"h");
                hField.setAccessible(true);
                Object h = hField.get(obj);
                Field delegateField = ReflectionUtil.findField(h.getClass(), null, (String)"delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(h);
                LOG.debug(String.format("delegate: %s", delegate));
                LOG.debug(String.format("delegate class: %s", delegate.getClass()));
                LOG.debug(String.format("delegate classloader: %s", delegate.getClass().getClassLoader()));
                for (Method m : delegate.getClass().getDeclaredMethods()) {
                    LOG.debug(String.format("delegate m: %s", m));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @Nullable
    private static DependencyScope parseScope(@Nullable IdeaDependencyScope scope) {
        if (scope == null) {
            return null;
        }
        String scopeAsString = scope.getScope();
        if (scopeAsString == null) {
            return null;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scopeAsString.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return null;
    }

    @NotNull
    private static ModuleDependencyData buildDependency(@NotNull ProjectResolverContext resolverContext, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaModuleDependency dependency, @NotNull Map<String, ModuleData> registeredModulesIndex) throws IllegalStateException {
        ModuleData moduleData;
        ModuleData moduleData2;
        IdeaModule dependencyModule;
        GradleVersion projectGradleVersion;
        if (resolverContext == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(56);
        }
        if (ownerModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(57);
        }
        if (dependency == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(58);
        }
        if (registeredModulesIndex == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(59);
        }
        GradleExecutionSettings gradleExecutionSettings = resolverContext.getSettings();
        String projectGradleVersionString = resolverContext.getProjectGradleVersion();
        if (gradleExecutionSettings != null && projectGradleVersionString != null && (projectGradleVersion = GradleVersion.version((String)projectGradleVersionString)).compareTo(GradleVersion.version((String)"4.0")) < 0 && (dependencyModule = BaseGradleProjectResolverExtension.getDependencyModuleByReflection(dependency)) != null && (moduleData2 = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByModule(resolverContext, dependencyModule)) != null) {
            ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData2);
            if (moduleDependencyData == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(60);
            }
            return moduleDependencyData;
        }
        String moduleName = dependency.getTargetModuleName();
        if (gradleExecutionSettings != null && (moduleData = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByGradleModuleName(moduleName)) != null) {
            ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData);
            if (moduleDependencyData == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(61);
            }
            return moduleDependencyData;
        }
        ModuleData registeredModuleData = registeredModulesIndex.get(moduleName);
        if (registeredModuleData != null) {
            ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ownerModule.getData(), registeredModuleData);
            if (moduleDependencyData == null) {
                BaseGradleProjectResolverExtension.$$$reportNull$$$0(62);
            }
            return moduleDependencyData;
        }
        throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: no module with such name (%s) is found. Registered modules: %s", dependency, moduleName, registeredModulesIndex.keySet()));
    }

    @Nullable
    private static IdeaModule getDependencyModuleByReflection(@NotNull IdeaModuleDependency dependency) {
        Method getDependencyModule;
        if (dependency == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(63);
        }
        if ((getDependencyModule = ReflectionUtil.getMethod(dependency.getClass(), (String)"getDependencyModule", (Class[])new Class[0])) != null) {
            try {
                Object result = getDependencyModule.invoke((Object)dependency, new Object[0]);
                return (IdeaModule)result;
            }
            catch (IllegalAccessException e) {
                LOG.info("Failed to get dependency module for [" + dependency + "]", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.info("Failed to get dependency module for [" + dependency + "]", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private LibraryDependencyData buildDependency(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaSingleEntryLibraryDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        String libraryName;
        LibraryLevel level;
        File binaryPath;
        if (gradleModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(64);
        }
        if (ownerModule == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(65);
        }
        if (dependency == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(66);
        }
        if (ideProject == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(67);
        }
        if ((binaryPath = dependency.getFile()) == null) {
            throw new IllegalStateException(String.format("Can't parse external library dependency '%s'. Reason: it doesn't specify path to the binaries", dependency));
        }
        GradleModuleVersion moduleVersion = dependency.getGradleModuleVersion();
        boolean unresolved = binaryPath.getName().startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
        if (moduleVersion == null) {
            if (binaryPath.isFile()) {
                boolean isModuleLocalLibrary = false;
                try {
                    isModuleLocalLibrary = FileUtil.isAncestor((File)gradleModule.getGradleProject().getProjectDirectory(), (File)binaryPath, (boolean)false);
                }
                catch (UnsupportedMethodException unsupportedMethodException) {
                    // empty catch block
                }
                level = isModuleLocalLibrary ? LibraryLevel.MODULE : LibraryLevel.PROJECT;
                libraryName = this.chooseName(binaryPath, level, ideProject);
            } else {
                level = LibraryLevel.MODULE;
                libraryName = "";
            }
            if (unresolved) {
                int dependencyNameIndex;
                libraryName = binaryPath.getName().substring(UNRESOLVED_DEPENDENCY_PREFIX.length());
                int i = libraryName.indexOf(32);
                if (i >= 0) {
                    i = CharArrayUtil.shiftForward((CharSequence)libraryName, (int)(i + 1), (String)" ");
                }
                if (i >= 0 && i < libraryName.length() && (i = libraryName.indexOf(32, dependencyNameIndex = i)) > 0) {
                    libraryName = String.format("%s-%s", libraryName.substring(dependencyNameIndex, i), libraryName.substring(i + 1));
                }
            }
        } else {
            level = LibraryLevel.PROJECT;
            libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            if (binaryPath.isFile()) {
                String libraryFileName = FileUtilRt.getNameWithoutExtension((String)binaryPath.getName());
                String mavenLibraryFileName = String.format("%s-%s", moduleVersion.getName(), moduleVersion.getVersion());
                if (!mavenLibraryFileName.equals(libraryFileName)) {
                    Pattern pattern = Pattern.compile(moduleVersion.getName() + "-" + moduleVersion.getVersion() + "-(.*)");
                    Matcher matcher = pattern.matcher(libraryFileName);
                    if (matcher.matches()) {
                        String classifier = matcher.group(1);
                        libraryName = libraryName + ":" + classifier;
                    } else {
                        String artifactId = StringUtil.trimEnd((String)StringUtil.trimEnd((String)libraryFileName, (String)moduleVersion.getVersion()), (String)"-");
                        libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), artifactId, moduleVersion.getVersion());
                    }
                }
            }
        }
        if (StringUtil.isNotEmpty((String)libraryName) && !FileUtilRt.extensionEquals((String)binaryPath.getName(), (String)"jar")) {
            libraryName = libraryName + ":" + FileUtilRt.getExtension((String)binaryPath.getName());
        }
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, unresolved);
        if (moduleVersion != null) {
            library.setGroup(moduleVersion.getGroup());
            library.setArtifactId(moduleVersion.getName());
            library.setVersion(moduleVersion.getVersion());
        }
        if (!unresolved) {
            library.addPath(LibraryPathType.BINARY, binaryPath.getAbsolutePath());
        }
        File sourcePath = dependency.getSource();
        if (!unresolved && sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getAbsolutePath());
        }
        if (!unresolved && sourcePath == null) {
            GradleProjectResolverUtil.attachGradleSdkSources(gradleModule, binaryPath, library, this.resolverCtx);
            if (this.resolverCtx instanceof DefaultProjectResolverContext) {
                GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(((DefaultProjectResolverContext)this.resolverCtx).getGradleUserHome(), library);
            }
        }
        File javadocPath = dependency.getJavadoc();
        if (!unresolved && javadocPath != null) {
            library.addPath(LibraryPathType.DOC, javadocPath.getAbsolutePath());
        }
        if (level == LibraryLevel.PROJECT && !GradleProjectResolverUtil.linkProjectLibrary(this.resolverCtx, ideProject, library)) {
            level = LibraryLevel.MODULE;
        }
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData((ModuleData)ownerModule.getData(), library, level);
        if (libraryDependencyData == null) {
            BaseGradleProjectResolverExtension.$$$reportNull$$$0(68);
        }
        return libraryDependencyData;
    }

    private String chooseName(File path, LibraryLevel level, DataNode<ProjectData> ideProject) {
        String candidateName;
        DataNode libraryData;
        String fileName = FileUtilRt.getNameWithoutExtension((String)path.getName());
        if (level == LibraryLevel.MODULE) {
            return fileName;
        }
        int count = 0;
        while ((libraryData = ExternalSystemApiUtil.find(ideProject, (Key)ProjectKeys.LIBRARY, arg_0 -> BaseGradleProjectResolverExtension.lambda$chooseName$9(candidateName = fileName + (count == 0 ? "" : "_" + count), arg_0))) != null) {
            if (((LibraryData)libraryData.getData()).getPaths(LibraryPathType.BINARY).contains(FileUtil.toSystemIndependentName((String)path.getAbsolutePath()))) {
                return candidateName;
            }
            ++count;
        }
        return candidateName;
    }

    private static /* synthetic */ boolean lambda$chooseName$9(String candidateName, DataNode node) {
        return ((LibraryData)node.getData()).getExternalName().equals(candidateName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 60: 
            case 61: 
            case 62: 
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 60: 
            case 61: 
            case 62: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 60: 
            case 61: 
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 4: 
            case 35: 
            case 38: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 23: 
            case 27: 
            case 33: 
            case 36: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 25: 
            case 28: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 16: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDirectories";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectories";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notResourceDirs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptConsumer";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootIndex";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 57: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 58: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredModulesIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/BaseGradleProjectResolverExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeModuleGroup";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExplicitNonResourceDirectories";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "populateModuleTasks";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelProvider";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsClasses";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraJvmArgs";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraCommandLineArgs";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFriendlyError";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setProjectResolverContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNext";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 60: 
            case 61: 
            case 62: 
            case 68: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJdkName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleContentRoots";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addExternalProjectContentRoots";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicateResources";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processSourceSets";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleCompileOutputSettings";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getGradleOutputDir";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "excludeOutDir";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleDependencies";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleTasks";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyError";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "enhanceTaskProcessing";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setupDebugForAllJvmForkedTasks";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "enhanceRemoteProcessing";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "populateContentRoot";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "buildDependency";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyModuleByReflection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 60: 
            case 61: 
            case 62: 
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface SourceSetsProcessor {
        public void process(@NotNull DataNode<? extends ModuleData> var1, @NotNull ExternalSourceSet var2);
    }
}

