/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleIdeManager;
import org.jetbrains.plugins.gradle.service.execution.GradleDebugSettingsEditor;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunConfiguration
extends ExternalSystemRunConfiguration
implements SMRunnerConsolePropertiesProvider {
    public static final String DEBUG_FLAG_NAME = "GradleScriptDebugEnabled";
    public static final Key<Boolean> DEBUG_FLAG_KEY = Key.create((String)"DEBUG_GRADLE_SCRIPT");
    private boolean isScriptDebugEnabled = true;

    public GradleRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(GradleConstants.SYSTEM_ID, project, factory, name);
    }

    public boolean isScriptDebugEnabled() {
        return this.isScriptDebugEnabled;
    }

    public void setScriptDebugEnabled(boolean scriptDebugEnabled) {
        this.isScriptDebugEnabled = scriptDebugEnabled;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            GradleRunConfiguration.$$$reportNull$$$0(1);
        }
        this.putUserData(DEBUG_FLAG_KEY, this.isScriptDebugEnabled);
        return super.getState(executor, env);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GradleRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        Element child = element.getChild(DEBUG_FLAG_NAME);
        if (child != null) {
            this.isScriptDebugEnabled = Boolean.valueOf(child.getText());
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GradleRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        Element child = new Element(DEBUG_FLAG_NAME);
        child.setText(String.valueOf(this.isScriptDebugEnabled));
        element.addContent(child);
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditor editor = super.getConfigurationEditor();
        if (editor instanceof SettingsEditorGroup) {
            SettingsEditorGroup group = (SettingsEditorGroup)editor;
            group.addEditor(GradleBundle.message("gradle.settings.title.debug", new Object[0]), (SettingsEditor)new GradleDebugSettingsEditor());
        }
        SettingsEditor settingsEditor = editor;
        if (settingsEditor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(4);
        }
        return settingsEditor;
    }

    public SMTRunnerConsoleProperties createTestConsoleProperties(Executor executor) {
        return GradleIdeManager.getInstance().createTestConsoleProperties(this.getProject(), executor, (RunConfiguration)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

