/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/issue/GradleDaemonStartupIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleDaemonStartupIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Path commonGradleProperties;
        File gradleUserHomeDir;
        Path projectGradleProperties;
        Intrinsics.checkParameterIsNotNull((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String rootCauseText = rootCause.toString();
        if (!StringsKt.startsWith$default((String)rootCauseText, (String)"org.gradle.api.GradleException: Unable to start the daemon process.", (boolean)false, (int)2, null)) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)rootCauseText, (CharSequence)"FAILURE: Build failed with an exception.", (boolean)false, (int)2, null)) {
            return null;
        }
        StringBuilder quickFixDescription = new StringBuilder();
        ArrayList<Object> quickFixes = new ArrayList<Object>();
        Path path = projectGradleProperties = Paths.get(issueData.getProjectPath(), "gradle.properties");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"projectGradleProperties");
        if (PathKt.isFile((Path)path)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(projectGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(" - <a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in project root directory\n");
            quickFixes.add(openFileQuickFix);
        }
        File file = gradleUserHomeDir = new BuildLayoutParameters().getGradleUserHomeDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"gradleUserHomeDir");
        Path path2 = commonGradleProperties = Paths.get(file.getPath(), "gradle.properties");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"commonGradleProperties");
        if (PathKt.isFile((Path)path2)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(commonGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(" - <a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in in GRADLE_USER_HOME directory\n");
            quickFixes.add(openFileQuickFix);
        }
        GradleSystemSettings gradleSystemSettings = GradleSystemSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleSystemSettings, (String)"GradleSystemSettings.getInstance()");
        String gradleVmOptions = gradleSystemSettings.getGradleVmOptions();
        CharSequence charSequence = gradleVmOptions;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix()) ^ true) {
            GradleSettingsQuickFix gradleSettingsFix2 = new GradleSettingsQuickFix(issueData.getProjectPath(), true, new BiPredicate<GradleProjectSettings, GradleProjectSettings>(gradleVmOptions){
                final /* synthetic */ String $gradleVmOptions;

                public final boolean test(@NotNull GradleProjectSettings $noName_0, @NotNull GradleProjectSettings $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$noName_0), (String)"<anonymous parameter 0>");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$noName_1), (String)"<anonymous parameter 1>");
                    GradleSystemSettings gradleSystemSettings = GradleSystemSettings.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleSystemSettings, (String)"GradleSystemSettings.getInstance()");
                    return Intrinsics.areEqual((Object)this.$gradleVmOptions, (Object)gradleSystemSettings.getGradleVmOptions()) ^ true;
                }
                {
                    this.$gradleVmOptions = string;
                }
            }, GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
            quickFixes.add(gradleSettingsFix2);
            quickFixDescription.append(" - <a href=\"" + gradleSettingsFix2.getId() + "\">IDE Gradle VM options</a> \n");
        }
        StringBuilder issueDescription = new StringBuilder(rootCause.getMessage());
        CharSequence charSequence2 = quickFixDescription;
        bl2 = false;
        if (charSequence2.length() > 0) {
            issueDescription.append("\n-----------------------\n");
            issueDescription.append("Check the JVM arguments defined for the gradle process in:\n");
            issueDescription.append((CharSequence)quickFixDescription);
        }
        return new BuildIssue(issueDescription, quickFixes){
            @NotNull
            private final String description;
            @NotNull
            private final ArrayList<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ StringBuilder $issueDescription;
            final /* synthetic */ ArrayList $quickFixes;

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public ArrayList<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }
            {
                this.$issueDescription = $captured_local_variable$0;
                this.$quickFixes = $captured_local_variable$1;
                String string = $captured_local_variable$0.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $captured_local_variable$1;
            }
        };
    }
}

