/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.DaemonStopClient;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.Stop;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonAction;

public class DaemonStopAction
extends DaemonAction {
    public DaemonStopAction(String serviceDirectoryPath) {
        super(serviceDirectoryPath);
    }

    public void run(DaemonClientFactory daemonClientFactory) {
        ServiceRegistry daemonServices = this.getDaemonServices(daemonClientFactory);
        DaemonStopClient stopClient = (DaemonStopClient)daemonServices.get(DaemonStopClient.class);
        stopClient.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(DaemonClientFactory daemonClientFactory, List<byte[]> tokens) {
        OutputEventListener outputEventListener = new OutputEventListener(){

            public void onOutput(OutputEvent event) {
            }
        };
        BuildLayoutParameters layout = new BuildLayoutParameters();
        DaemonParameters daemonParameters = DaemonStopAction.getDaemonParameters(layout);
        ServiceRegistry daemonServices = daemonClientFactory.createStopDaemonServices(outputEventListener, daemonParameters);
        DaemonRegistry daemonRegistry = (DaemonRegistry)daemonServices.get(DaemonRegistry.class);
        DaemonConnector daemonConnector = (DaemonConnector)daemonServices.get(DaemonConnector.class);
        IdGenerator idGenerator = (IdGenerator)daemonServices.get(IdGenerator.class);
        ArrayList list = new ArrayList(daemonRegistry.getAll());
        block3: for (byte[] token : tokens) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DaemonInfo info = (DaemonInfo)iterator.next();
                if (!Arrays.equals(info.getToken(), token)) continue;
                iterator.remove();
                DaemonClientConnection connection = daemonConnector.maybeConnect((DaemonConnectDetails)info);
                if (connection == null) continue block3;
                try {
                    Stop stopCommand = DaemonStopAction.createCommand(Stop.class, idGenerator.generateId(), token);
                    connection.dispatch((Message)stopCommand);
                    continue block3;
                }
                finally {
                    connection.stop();
                    continue block3;
                }
            }
        }
    }
}

