/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.gradle.api.internal.file.DefaultFileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public abstract class DaemonAction {
    private final String myServiceDirectoryPath;

    public DaemonAction(String serviceDirectoryPath) {
        this.myServiceDirectoryPath = serviceDirectoryPath;
    }

    protected ServiceRegistry getDaemonServices(DaemonClientFactory daemonClientFactory) {
        BuildLayoutParameters layout = new BuildLayoutParameters();
        if (this.myServiceDirectoryPath != null && !this.myServiceDirectoryPath.isEmpty()) {
            layout.setGradleUserHomeDir(new File(this.myServiceDirectoryPath));
        }
        DaemonParameters daemonParameters = DaemonAction.getDaemonParameters(layout);
        return daemonClientFactory.createStopDaemonServices(new OutputEventListener(){

            public void onOutput(OutputEvent event) {
            }
        }, daemonParameters);
    }

    @NotNull
    protected static DaemonParameters getDaemonParameters(BuildLayoutParameters layout) {
        DaemonParameters daemonParameters;
        boolean isGradle5Dot3OrNewer;
        boolean bl = isGradle5Dot3OrNewer = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"5.3")) >= 0;
        if (!isGradle5Dot3OrNewer) {
            daemonParameters = new DaemonParameters(layout);
        } else {
            try {
                daemonParameters = (DaemonParameters)DaemonParameters.class.getConstructor(BuildLayoutParameters.class, FileCollectionFactory.class).newInstance(layout, new DefaultFileCollectionFactory());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Cannot create DaemonParameters by reflection, gradle version " + GradleVersion.current(), e);
            }
        }
        DaemonParameters daemonParameters2 = daemonParameters;
        if (daemonParameters2 == null) {
            DaemonAction.$$$reportNull$$$0(0);
        }
        return daemonParameters2;
    }

    @NotNull
    protected static <T> T createCommand(Class<T> commandClass, Object id, byte[] token) {
        Object obj;
        try {
            obj = commandClass.getConstructors()[0].newInstance(id, token);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (obj == null) {
            DaemonAction.$$$reportNull$$$0(1);
        }
        return (T)obj;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/gradle/internal/daemon/DaemonAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDaemonParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

