/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Executor;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FindSymbolParameters;
import groovyjarjarcommonscli.Option;
import icons.GradleIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.action.GradleExecuteTaskAction;
import org.jetbrains.plugins.gradle.execution.GradleCommandLineTaskOptionsProvider;
import org.jetbrains.plugins.gradle.execution.RunAnythingGradleItem;
import org.jetbrains.plugins.gradle.execution.TaskOption;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunAnythingProvider
extends RunAnythingProviderBase<String> {
    public static final String HELP_COMMAND = "gradle";

    @NotNull
    public RunAnythingItem getMainListItem(@NotNull DataContext dataContext, @NotNull String value) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if (value == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(1);
        }
        RunAnythingGradleItem runAnythingGradleItem = new RunAnythingGradleItem(this.getCommand(value), this.getIcon(value));
        if (runAnythingGradleItem == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(2);
        }
        return runAnythingGradleItem;
    }

    @Nullable
    public String getHelpGroupTitle() {
        return "Gradle";
    }

    @Nullable
    public String findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(4);
        }
        return pattern.startsWith(this.getHelpCommand()) ? this.getCommand(pattern) : null;
    }

    @NotNull
    public Collection<String> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        CommandLineInfo commandLine;
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(6);
        }
        if ((commandLine = this.parseCommandLine(pattern)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        this.appendProjectsVariants(result, dataContext, commandLine.prefix);
        if (!result.isEmpty()) {
            List list = result;
            if (list == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        GradleRunAnythingProvider.processTaskOptionsVariants(dataContext, commandLine, (Processor<String>)((Processor)it -> result.add(commandLine.prefix + it)));
        if (!result.isEmpty()) {
            List list = result;
            if (list == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        GradleRunAnythingProvider.processTaskClassArgumentsVariants(dataContext, commandLine, (Processor<String>)((Processor)it -> result.add(commandLine.prefix + it)));
        if (!result.isEmpty()) {
            List list = result;
            if (list == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        GradleRunAnythingProvider.appendArgumentsVariants(result, commandLine.prefix, commandLine.toComplete);
        if (!result.isEmpty()) {
            List list = result;
            if (list == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        this.appendTasksVariants(result, commandLine.prefix, dataContext);
        List list = result;
        if (list == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private CommandLineInfo parseCommandLine(@NotNull String commandLine) {
        String helpCommand;
        if (commandLine == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(13);
        }
        if ((helpCommand = this.getHelpCommand()).startsWith(commandLine)) {
            commandLine = helpCommand;
        } else if (!commandLine.startsWith(helpCommand)) {
            return null;
        }
        String prefix = StringUtil.notNullize((String)StringUtil.substringBeforeLast((String)commandLine, (String)" "), (String)helpCommand).trim() + ' ';
        String toComplete = StringUtil.notNullize((String)StringUtil.substringAfterLast((String)commandLine, (String)" "));
        List commands = ContainerUtil.filter((Object[])prefix.trim().split(" "), it -> !it.isEmpty());
        if (commands.isEmpty()) {
            return null;
        }
        if (!((String)commands.get(0)).equals(helpCommand)) {
            return null;
        }
        String externalProjectName = commands.size() > 1 ? (String)commands.get(1) : "";
        return new CommandLineInfo(prefix, toComplete, externalProjectName, commands.subList(1, commands.size()));
    }

    private void appendProjectsVariants(@NotNull List<? super String> result, @NotNull DataContext dataContext, @NotNull String prefix) {
        if (result == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(14);
        }
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(15);
        }
        if (prefix == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(16);
        }
        if (!prefix.trim().equals(this.getHelpCommand())) {
            return;
        }
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Collection projectsSettings = GradleSettings.getInstance(project).getLinkedProjectsSettings();
        if (projectsSettings.size() <= 1) {
            return;
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        projectsSettings.stream().map(setting -> dataManager.getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath())).filter(projectInfo -> projectInfo != null && projectInfo.getExternalProjectStructure() != null).map(projectInfo -> (ProjectData)projectInfo.getExternalProjectStructure().getData()).forEach(data -> result.add(prefix + data.getExternalName()));
    }

    private void appendTasksVariants(@NotNull List<? super String> result, @NotNull String prefix, @NotNull DataContext dataContext) {
        String commandLine;
        Project project;
        ProjectData projectData;
        if (result == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(17);
        }
        if (prefix == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(18);
        }
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(19);
        }
        if ((projectData = GradleRunAnythingProvider.getProjectData(project = RunAnythingUtil.fetchProject((DataContext)dataContext), commandLine = StringUtil.trimStart((String)prefix, (String)this.getHelpCommand()).trim())) == null) {
            return;
        }
        MultiMap<String, TaskData> tasks = GradleRunAnythingProvider.fetchTasks(dataContext).get(projectData);
        if (tasks == null) {
            return;
        }
        for (Map.Entry entry : tasks.entrySet()) {
            for (TaskData taskData : (Collection)entry.getValue()) {
                String taskName = taskData.getName();
                String taskFqn = (String)entry.getKey() + taskName;
                result.add(prefix + taskFqn);
            }
        }
    }

    private static void appendArgumentsVariants(@NotNull List<? super String> result, @NotNull String prefix, @NotNull String toComplete) {
        if (result == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(20);
        }
        if (prefix == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(21);
        }
        if (toComplete == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(22);
        }
        if (!toComplete.startsWith("-")) {
            return;
        }
        boolean isLongOpt = toComplete.startsWith("--");
        prefix = prefix + (isLongOpt ? "--" : "-");
        for (Object option : GradleCommandLineOptionsProvider.getSupportedOptions().getOptions()) {
            String opt;
            if (!(option instanceof Option) || !StringUtil.isNotEmpty((String)(opt = isLongOpt ? ((Option)option).getLongOpt() : ((Option)option).getOpt()))) continue;
            result.add(prefix + opt);
        }
    }

    private static void processTaskOptionsVariants(@NotNull DataContext dataContext, @NotNull CommandLineInfo commandLineInfo, @NotNull Processor<String> processor) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(23);
        }
        if (commandLineInfo == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(25);
        }
        if (commandLineInfo.commands.isEmpty()) {
            return;
        }
        String task = commandLineInfo.commands.get(commandLineInfo.commands.size() - 1);
        List<TaskOption> options = GradleRunAnythingProvider.getTaskOptions(dataContext, commandLineInfo.externalProjectName, task);
        options.forEach(it -> processor.process((Object)it.getName()));
    }

    private static void processTaskClassArgumentsVariants(@NotNull DataContext dataContext, @NotNull CommandLineInfo commandLineInfo, @NotNull Processor<String> processor) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(26);
        }
        if (commandLineInfo == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(27);
        }
        if (processor == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(28);
        }
        if (commandLineInfo.commands.size() < 2) {
            return;
        }
        String task = commandLineInfo.commands.get(commandLineInfo.commands.size() - 2);
        String optionName = commandLineInfo.commands.get(commandLineInfo.commands.size() - 1);
        List<TaskOption> options = GradleRunAnythingProvider.getTaskOptions(dataContext, commandLineInfo.externalProjectName, task);
        TaskOption option = (TaskOption)ContainerUtil.find(options, it -> optionName.equals(it.getName()));
        if (option == null) {
            return;
        }
        if (!option.getArgumentTypes().contains((Object)TaskOption.ArgumentType.CLASS)) {
            return;
        }
        String toComplete = commandLineInfo.toComplete;
        String callChain = toComplete.isEmpty() || !toComplete.contains(".") ? "*" : StringUtil.substringBeforeLast((String)toComplete, (String)".");
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        GotoClassModel2 model = new GotoClassModel2(project);
        model.processNames(it -> processor.process((Object)(callChain + "." + it)), FindSymbolParameters.simple((Project)project, (boolean)false));
    }

    private static List<TaskOption> getTaskOptions(@NotNull DataContext dataContext, @NotNull String externalProjectName, @NotNull String task) {
        Project project;
        ProjectData projectData;
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(29);
        }
        if (externalProjectName == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(30);
        }
        if (task == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(31);
        }
        if ((projectData = GradleRunAnythingProvider.getProjectData(project = RunAnythingUtil.fetchProject((DataContext)dataContext), externalProjectName)) == null) {
            return Collections.emptyList();
        }
        MultiMap<String, TaskData> tasks = GradleRunAnythingProvider.fetchTasks(dataContext).get(projectData);
        if (tasks == null) {
            return Collections.emptyList();
        }
        GradleCommandLineTaskOptionsProvider provider = new GradleCommandLineTaskOptionsProvider();
        for (Map.Entry entry : tasks.entrySet()) {
            for (TaskData taskData : (Collection)entry.getValue()) {
                String taskName = taskData.getName();
                String taskFqn = (String)entry.getKey() + taskName;
                if (!taskFqn.equals(task)) continue;
                return provider.getTaskOptions(taskData);
            }
        }
        return Collections.emptyList();
    }

    public void execute(@NotNull DataContext dataContext, @NotNull String value) {
        String commandLine;
        Project project;
        ProjectData projectData;
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(32);
        }
        if (value == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(33);
        }
        if ((projectData = GradleRunAnythingProvider.getProjectData(project = RunAnythingUtil.fetchProject((DataContext)dataContext), commandLine = StringUtil.trimStart((String)value, (String)this.getHelpCommand()).trim())) == null) {
            return;
        }
        commandLine = StringUtil.trimStart((String)commandLine, (String)projectData.getExternalName());
        Executor executor = (Executor)RunAnythingAction.EXECUTOR_KEY.getData(dataContext);
        GradleExecuteTaskAction.runGradle(project, executor, projectData.getLinkedExternalProjectPath(), commandLine);
    }

    @Nullable
    private static ProjectData getProjectData(@NotNull Project project, @NotNull String commandLine) {
        Collection projectsSettings;
        if (project == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(34);
        }
        if (commandLine == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(35);
        }
        if ((projectsSettings = GradleSettings.getInstance(project).getLinkedProjectsSettings()).isEmpty()) {
            return null;
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        return projectsSettings.stream().map(setting -> dataManager.getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath())).filter(projectInfo -> projectInfo != null && projectInfo.getExternalProjectStructure() != null).map(projectInfo -> (ProjectData)projectInfo.getExternalProjectStructure().getData()).filter(projectData -> projectsSettings.size() == 1 || StringUtil.startsWith((CharSequence)commandLine, (CharSequence)projectData.getExternalName())).findFirst().orElse(null);
    }

    @NotNull
    public String getCommand(@NotNull String value) {
        if (value == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(36);
        }
        String string = value;
        if (string == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Nullable
    public Icon getIcon(@NotNull String value) {
        if (value == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(38);
        }
        return GradleIcons.Gradle;
    }

    @Nullable
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(39);
        }
        String placeholder = this.getHelpCommandPlaceholder(dataContext);
        String commandPrefix = this.getHelpCommand();
        return new RunAnythingHelpItem(placeholder, commandPrefix, this.getHelpDescription(), this.getHelpIcon());
    }

    @NotNull
    public String getCompletionGroupTitle() {
        if ("Gradle tasks" == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(40);
        }
        return "Gradle tasks";
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        String string = this.getHelpCommandPlaceholder(null);
        if (string == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public String getHelpCommandPlaceholder(@Nullable DataContext dataContext) {
        Project project;
        if (dataContext != null && GradleSettings.getInstance(project = RunAnythingUtil.fetchProject((DataContext)dataContext)).getLinkedProjectsSettings().size() > 1) {
            if ("gradle <rootProjectName> <taskName...> <--option-name...>" == null) {
                GradleRunAnythingProvider.$$$reportNull$$$0(42);
            }
            return "gradle <rootProjectName> <taskName...> <--option-name...>";
        }
        if ("gradle <taskName...> <--option-name...>" == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(43);
        }
        return "gradle <taskName...> <--option-name...>";
    }

    @NotNull
    public String getHelpCommand() {
        if (HELP_COMMAND == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(44);
        }
        return HELP_COMMAND;
    }

    public Icon getHelpIcon() {
        return GradleIcons.Gradle;
    }

    private static Map<ProjectData, MultiMap<String, TaskData>> fetchTasks(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(45);
        }
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(GradleRunAnythingProvider.getTasksMap(project), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)}));
    }

    @NotNull
    private static Map<ProjectData, MultiMap<String, TaskData>> getTasksMap(Project project) {
        LinkedHashMap<ProjectData, MultiMap<String, TaskData>> tasks = new LinkedHashMap<ProjectData, MultiMap<String, TaskData>>();
        for (GradleProjectSettings setting : GradleSettings.getInstance(project).getLinkedProjectsSettings()) {
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) continue;
            MultiMap projectTasks = MultiMap.createOrderedSet();
            for (DataNode moduleDataNode : ExternalSystemApiUtil.getChildren((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE)) {
                String gradlePath = GradleProjectResolverUtil.getGradlePath((ModuleData)moduleDataNode.getData());
                for (DataNode node : ExternalSystemApiUtil.getChildren((DataNode)moduleDataNode, (Key)ProjectKeys.TASK)) {
                    TaskData taskData = (TaskData)node.getData();
                    String taskName = taskData.getName();
                    if (!StringUtil.isNotEmpty((String)taskName)) continue;
                    String taskPathPrefix = ":".equals(gradlePath) || taskName.startsWith(gradlePath) ? "" : gradlePath + ':';
                    projectTasks.putValue((Object)taskPathPrefix, (Object)taskData);
                }
            }
            tasks.put((ProjectData)projectData.getExternalProjectStructure().getData(), (MultiMap<String, TaskData>)projectTasks);
        }
        LinkedHashMap<ProjectData, MultiMap<String, TaskData>> linkedHashMap = tasks;
        if (linkedHashMap == null) {
            GradleRunAnythingProvider.$$$reportNull$$$0(46);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 33: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleRunAnythingProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 13: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toComplete";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineInfo";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleRunAnythingProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainListItem";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommandPlaceholder";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommand";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMainListItem";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandLine";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendProjectsVariants";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendTasksVariants";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentsVariants";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processTaskOptionsVariants";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processTaskClassArgumentsVariants";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTaskOptions";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getProjectData";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getHelpItem";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fetchTasks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommandLineInfo {
        final String prefix;
        final String toComplete;
        final String externalProjectName;
        final List<String> commands;

        private CommandLineInfo(String prefix, String toComplete, String externalProjectName, List<String> commands) {
            this.prefix = prefix;
            this.toComplete = toComplete;
            this.externalProjectName = externalProjectName;
            this.commands = commands;
        }
    }
}

