/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.List;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.run.XsltRunConfigType;
import org.intellij.lang.xpath.xslt.run.XsltRunConfiguration;
import org.jetbrains.annotations.NotNull;

public class XsltConfigurationProducer
extends RuntimeConfigurationProducer {
    public XsltConfigurationProducer() {
        super((ConfigurationType)XsltRunConfigType.getInstance());
    }

    public PsiElement getSourceElement() {
        return this.restoreSourceElement();
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        XmlFile file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)location.getPsiElement(), XmlFile.class, (boolean)false);
        if (file != null && file.isPhysical() && XsltSupport.isXsltFile((PsiFile)file)) {
            this.storeSourceElement((PsiElement)file);
            Project project = file.getProject();
            RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).createConfiguration(file.getName(), this.getConfigurationFactory());
            ((XsltRunConfiguration)settings.getConfiguration()).initFromFile(file);
            return settings;
        }
        return null;
    }

    public int compareTo(Object o) {
        return -1;
    }

    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<? extends RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        XmlFile file;
        if (existingConfigurations == null) {
            XsltConfigurationProducer.$$$reportNull$$$0(0);
        }
        if ((file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)location.getPsiElement(), XmlFile.class, (boolean)false)) != null && file.isPhysical() && XsltSupport.isXsltFile((PsiFile)file)) {
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : existingConfigurations) {
                RunConfiguration configuration = runnerAndConfigurationSettings.getConfiguration();
                if (!(configuration instanceof XsltRunConfiguration) || !file.getVirtualFile().getPath().replace('/', File.separatorChar).equals(((XsltRunConfiguration)configuration).getXsltFile())) continue;
                return runnerAndConfigurationSettings;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingConfigurations", "org/intellij/lang/xpath/xslt/run/XsltConfigurationProducer", "findExistingByElement"));
    }
}

