/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.completion.NamespaceLookup;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.lang.xpath.xslt.impl.references.PrefixReference;
import org.intellij.lang.xpath.xslt.impl.references.SimpleAttributeReference;
import org.intellij.lang.xpath.xslt.psi.impl.ImplicitModeElement;
import org.intellij.lang.xpath.xslt.util.MatchTemplateMatcher;
import org.intellij.lang.xpath.xslt.util.QNameUtil;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ModeReference
extends SimpleAttributeReference
implements PsiPolyVariantReference,
EmptyResolveMessageProvider {
    private final boolean myIsDeclaration;
    private final ImplicitModeElement myImplicitModeElement;

    ModeReference(XmlAttribute attribute, boolean isDeclaration) {
        super(attribute);
        String value;
        PsiFile file;
        this.myIsDeclaration = isDeclaration ? true : ((file = attribute.getContainingFile()) != null && XsltSupport.getXsltLanguageLevel(file) == XsltChecker.LanguageLevel.V2 ? "#current".equals(value = attribute.getValue()) || "#default".equals(value) : false);
        this.myImplicitModeElement = new ImplicitModeElement(attribute);
    }

    @Override
    @NotNull
    protected TextRange getTextRange() {
        TextRange textRange = this.myImplicitModeElement.getModeRange();
        if (textRange == null) {
            ModeReference.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @NotNull
    public Object[] getVariants() {
        PsiFile containingFile = this.myAttribute.getContainingFile();
        if (containingFile instanceof XmlFile && XsltSupport.isXsltFile(containingFile)) {
            ArrayList l = new ArrayList();
            if (!this.myImplicitModeElement.hasPrefix()) {
                Object[] prefixes = ModeReference.getPrefixCompletions(this.myAttribute);
                ContainerUtil.addAll(l, (Object[])prefixes);
            }
            if (this.myImplicitModeElement.getQName() != null) {
                Object[] modes = ResolveUtil.collect(this.getMatcher().variantMatcher());
                ContainerUtil.addAll(l, (Object[])modes);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(l);
            if (objectArray == null) {
                ModeReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            ModeReference.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return this.myIsDeclaration;
    }

    @Override
    @Nullable
    public PsiElement resolveImpl() {
        if (this.myIsDeclaration) {
            return this.myImplicitModeElement;
        }
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile containingFile = this.myAttribute.getContainingFile();
        if (containingFile instanceof XmlFile && XsltSupport.isXsltFile(containingFile) && this.myImplicitModeElement.getQName() != null) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])ResolveUtil.collect(this.getMatcher()));
            if (resolveResultArray == null) {
                ModeReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            ModeReference.$$$reportNull$$$0(4);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    private MyModeMatcher getMatcher() {
        return new MyModeMatcher((XmlElement)this.myAttribute, this.myImplicitModeElement.getQName());
    }

    public static PsiReference[] create(XmlAttribute attribute, boolean isDeclaration) {
        String value = attribute.getValue();
        if (value == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (value.trim().indexOf(32) != -1) {
            return PsiReference.EMPTY_ARRAY;
        }
        return ModeReference.createImpl(attribute, isDeclaration, value);
    }

    private static PsiReference[] createImpl(XmlAttribute attribute, boolean isDeclaration, String value) {
        int p = value.indexOf(58);
        if (p == -1) {
            return new PsiReference[]{new ModeReference(attribute, isDeclaration)};
        }
        if (p == value.length() - 1) {
            return new PsiReference[]{new MyPrefixReference(attribute)};
        }
        return new PsiReference[]{new MyPrefixReference(attribute), new ModeReference(attribute, isDeclaration)};
    }

    static Object[] getPrefixCompletions(XmlAttribute attribute) {
        MyModeMatcher matcher = new MyModeMatcher((XmlElement)attribute, QNameUtil.ANY);
        PsiElement[] modes = ResolveUtil.collect(matcher);
        Collection<String> prefixes = XsltNamespaceContext.getPrefixes((XmlElement)attribute);
        HashSet<NamespaceLookup> lookups = new HashSet<NamespaceLookup>(prefixes.size());
        for (PsiElement mode : modes) {
            String prefix;
            QName qName = ((ImplicitModeElement)mode).getQName();
            if (qName == null || !prefixes.contains(prefix = qName.getPrefix())) continue;
            lookups.add(new NamespaceLookup(prefix));
        }
        return ArrayUtil.toObjectArray(lookups);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        QName qName = this.myImplicitModeElement.getQName();
        if (qName != null && qName != QNameUtil.UNRESOLVED) {
            String string = "Undefined mode '" + qName.toString() + "'";
            if (string == null) {
                ModeReference.$$$reportNull$$$0(5);
            }
            return string;
        }
        if ("Undefined mode ''{0}''" == null) {
            ModeReference.$$$reportNull$$$0(6);
        }
        return "Undefined mode ''{0}''";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/xslt/impl/references/ModeReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyPrefixReference
    extends PrefixReference
    implements LocalQuickFixProvider {
        MyPrefixReference(XmlAttribute attribute) {
            super(attribute);
        }

        @Nullable
        public LocalQuickFix[] getQuickFixes() {
            return LocalQuickFix.EMPTY_ARRAY;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ModeReference.getPrefixCompletions(this.myAttribute);
            if (objectArray == null) {
                MyPrefixReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/ModeReference$MyPrefixReference", "getVariants"));
        }
    }

    private static class MyModeMatcher
    extends MatchTemplateMatcher {
        MyModeMatcher(XmlDocument document, QName mode) {
            super(document, mode);
        }

        MyModeMatcher(XmlElement element, QName mode) {
            super(XsltCodeInsightUtil.getDocument(element), mode);
        }

        @Override
        protected PsiElement transform(XmlTag element) {
            return new ImplicitModeElement(element.getAttribute("mode", null));
        }

        @Override
        public boolean matches(XmlTag element) {
            String s = element.getAttributeValue("mode");
            return this.myMode != null && s != null && s.indexOf("IntellijIdeaRulezzz") == -1 && super.matches(element);
        }

        @Override
        protected ResolveUtil.Matcher changeDocument(XmlDocument document) {
            return new MyModeMatcher(document, this.myMode);
        }

        @Override
        public ResolveUtil.Matcher variantMatcher() {
            return new MyModeMatcher(this.myDocument, this.myMode != null ? QNameUtil.createAnyLocalName(this.myMode.getNamespaceURI()) : null);
        }
    }
}

