/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumDataDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltSymbolIndex
extends FileBasedIndexExtension<String, Kind> {
    @NonNls
    public static final ID<String, Kind> NAME = ID.create((String)"XsltSymbolIndex");

    @NotNull
    public ID<String, Kind> getName() {
        ID<String, Kind> iD = NAME;
        if (iD == null) {
            XsltSymbolIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Kind, FileContent> getIndexer() {
        DataIndexer<String, Kind, FileContent> dataIndexer = new DataIndexer<String, Kind, FileContent>(){

            @NotNull
            public Map<String, Kind> map(@NotNull FileContent inputData) {
                CharSequence inputDataContentAsText;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CharArrayUtil.indexOf((CharSequence)(inputDataContentAsText = inputData.getContentAsText()), (CharSequence)"http://www.w3.org/1999/XSL/Transform", (int)0) == -1) {
                    Map<String, Kind> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                final HashMap<String, Kind> map = new HashMap<String, Kind>();
                NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)new NanoXmlBuilder(){
                    NanoXmlBuilder attributeHandler;
                    int depth;

                    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                        if (this.attributeHandler != null) {
                            this.attributeHandler.addAttribute(key, nsPrefix, nsURI, value, type);
                        }
                    }

                    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
                        this.attributeHandler = null;
                        if (this.depth == 1 && "http://www.w3.org/1999/XSL/Transform".equals(nsURI)) {
                            if ("template".equals(name)) {
                                this.attributeHandler = new MyAttributeHandler(map, Kind.TEMPLATE);
                            } else if ("variable".equals(name)) {
                                this.attributeHandler = new MyAttributeHandler(map, Kind.VARIABLE);
                            } else if ("param".equals(name)) {
                                this.attributeHandler = new MyAttributeHandler(map, Kind.PARAM);
                            }
                        }
                        ++this.depth;
                    }

                    public void endElement(String name, String nsPrefix, String nsURI) {
                        this.attributeHandler = null;
                        --this.depth;
                    }
                });
                HashMap<String, Kind> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/XsltSymbolIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/XsltSymbolIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            XsltSymbolIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<Kind> getValueExternalizer() {
        EnumDataDescriptor enumDataDescriptor = new EnumDataDescriptor(Kind.class);
        if (enumDataDescriptor == null) {
            XsltSymbolIndex.$$$reportNull$$$0(2);
        }
        return enumDataDescriptor;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            XsltSymbolIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !(file.getFileSystem() instanceof JarFileSystem);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/xpath/xslt/impl/XsltSymbolIndex$2", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            XsltSymbolIndex.$$$reportNull$$$0(4);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/xslt/impl/XsltSymbolIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyAttributeHandler
    implements NanoXmlBuilder {
        private final Map<String, Kind> myMap;
        private final Kind myKind;

        MyAttributeHandler(Map<String, Kind> map, Kind k) {
            this.myMap = map;
            this.myKind = k;
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
            if (key.equals("name") && (nsURI == null || nsURI.length() == 0) && value != null && this.myMap.put(value, this.myKind) != null) {
                this.myMap.put(value, Kind.ANYTHING);
            }
        }
    }

    static enum Kind {
        PARAM(XsltParameter.class),
        VARIABLE(XsltVariable.class),
        TEMPLATE(XsltTemplate.class),
        ANYTHING(null);

        final Class<? extends XsltElement> myClazz;

        private Kind(Class<? extends XsltElement> clazz) {
            this.myClazz = clazz;
        }

        @Nullable
        public XsltElement wrap(XmlTag tag) {
            Class<? extends XsltElement> clazz;
            if (this.myClazz != null) {
                if (!StringUtil.toLowerCase((String)this.name()).equals(tag.getLocalName())) {
                    return null;
                }
                clazz = this.myClazz;
            } else {
                try {
                    clazz = Kind.valueOf((String)StringUtil.toUpperCase((String)tag.getLocalName())).myClazz;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            return XsltElementFactory.getInstance().wrapElement(tag, clazz);
        }
    }
}

